/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.FSItemAttribByTimeVersionField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.FSItemAttribByTimeVersionOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.FSItemAttribByTimeVersionSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Financial Statement Item Attribute Assignment
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>FSItemAttribByTimeVersionType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class FSItemAttribByTimeVersion extends VdmEntity<FSItemAttribByTimeVersion>
{

    /**
     * Selector for all available fields of FSItemAttribByTimeVersion.
     *
     */
    public final static FSItemAttribByTimeVersionSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts</b>
     * </p>
     *
     * @return Consolidation Chart of Accounts
     */
    @Key
    @SerializedName( "ConsolidationChartOfAccounts" )
    @JsonProperty( "ConsolidationChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "ConsolidationChartOfAccounts" )
    private String consolidationChartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationChartOfAccounts</b> field to query operations.
     *
     */
    public final static FSItemAttribByTimeVersionField<String> CONSOLIDATION_CHART_OF_ACCOUNTS =
        new FSItemAttribByTimeVersionField<String>("ConsolidationChartOfAccounts");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts_Text</b>
     * </p>
     *
     * @return Consolidation Chart of Accounts Description
     */
    @SerializedName( "ConsolidationChartOfAccounts_Text" )
    @JsonProperty( "ConsolidationChartOfAccounts_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationChartOfAccounts_Text" )
    private String consolidationChartOfAccounts_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationChartOfAccounts_Text</b> field to query
     * operations.
     *
     */
    public final static FSItemAttribByTimeVersionField<String> CONSOLIDATION_CHART_OF_ACCOUNTS_TEXT =
        new FSItemAttribByTimeVersionField<String>("ConsolidationChartOfAccounts_Text");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItem</b>
     * </p>
     *
     * @return Financial Statement Item
     */
    @Key
    @SerializedName( "FinancialStatementItem" )
    @JsonProperty( "FinancialStatementItem" )
    @Nullable
    @ODataField( odataName = "FinancialStatementItem" )
    private String financialStatementItem;
    /**
     * Use with available fluent helpers to apply the <b>FinancialStatementItem</b> field to query operations.
     *
     */
    public final static FSItemAttribByTimeVersionField<String> FINANCIAL_STATEMENT_ITEM =
        new FSItemAttribByTimeVersionField<String>("FinancialStatementItem");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItem_Text</b>
     * </p>
     *
     * @return Financial Statement Item Medium Description
     */
    @SerializedName( "FinancialStatementItem_Text" )
    @JsonProperty( "FinancialStatementItem_Text" )
    @Nullable
    @ODataField( odataName = "FinancialStatementItem_Text" )
    private String financialStatementItem_Text;
    /**
     * Use with available fluent helpers to apply the <b>FinancialStatementItem_Text</b> field to query operations.
     *
     */
    public final static FSItemAttribByTimeVersionField<String> FINANCIAL_STATEMENT_ITEM_TEXT =
        new FSItemAttribByTimeVersionField<String>("FinancialStatementItem_Text");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationVersion</b>
     * </p>
     *
     * @return Consolidation Version
     */
    @Key
    @SerializedName( "ConsolidationVersion" )
    @JsonProperty( "ConsolidationVersion" )
    @Nullable
    @ODataField( odataName = "ConsolidationVersion" )
    private String consolidationVersion;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationVersion</b> field to query operations.
     *
     */
    public final static FSItemAttribByTimeVersionField<String> CONSOLIDATION_VERSION =
        new FSItemAttribByTimeVersionField<String>("ConsolidationVersion");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationVersion_Text</b>
     * </p>
     *
     * @return Consolidation Version Description
     */
    @SerializedName( "ConsolidationVersion_Text" )
    @JsonProperty( "ConsolidationVersion_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationVersion_Text" )
    private String consolidationVersion_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationVersion_Text</b> field to query operations.
     *
     */
    public final static FSItemAttribByTimeVersionField<String> CONSOLIDATION_VERSION_TEXT =
        new FSItemAttribByTimeVersionField<String>("ConsolidationVersion_Text");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>FromFiscalYearPeriod</b>
     * </p>
     *
     * @return Start of Assignment
     */
    @Key
    @SerializedName( "FromFiscalYearPeriod" )
    @JsonProperty( "FromFiscalYearPeriod" )
    @Nullable
    @ODataField( odataName = "FromFiscalYearPeriod" )
    private String fromFiscalYearPeriod;
    /**
     * Use with available fluent helpers to apply the <b>FromFiscalYearPeriod</b> field to query operations.
     *
     */
    public final static FSItemAttribByTimeVersionField<String> FROM_FISCAL_YEAR_PERIOD =
        new FSItemAttribByTimeVersionField<String>("FromFiscalYearPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>ToFiscalYearPeriod</b>
     * </p>
     *
     * @return End of Assignment
     */
    @SerializedName( "ToFiscalYearPeriod" )
    @JsonProperty( "ToFiscalYearPeriod" )
    @Nullable
    @ODataField( odataName = "ToFiscalYearPeriod" )
    private String toFiscalYearPeriod;
    /**
     * Use with available fluent helpers to apply the <b>ToFiscalYearPeriod</b> field to query operations.
     *
     */
    public final static FSItemAttribByTimeVersionField<String> TO_FISCAL_YEAR_PERIOD =
        new FSItemAttribByTimeVersionField<String>("ToFiscalYearPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItemRole</b>
     * </p>
     *
     * @return Financial Statement Item Role
     */
    @SerializedName( "FinancialStatementItemRole" )
    @JsonProperty( "FinancialStatementItemRole" )
    @Nullable
    @ODataField( odataName = "FinancialStatementItemRole" )
    private String financialStatementItemRole;
    /**
     * Use with available fluent helpers to apply the <b>FinancialStatementItemRole</b> field to query operations.
     *
     */
    public final static FSItemAttribByTimeVersionField<String> FINANCIAL_STATEMENT_ITEM_ROLE =
        new FSItemAttribByTimeVersionField<String>("FinancialStatementItemRole");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemRoleText</b>
     * </p>
     *
     * @return Financial Statement Item Role Description
     */
    @SerializedName( "FSItemRoleText" )
    @JsonProperty( "FSItemRoleText" )
    @Nullable
    @ODataField( odataName = "FSItemRoleText" )
    private String fSItemRoleText;
    /**
     * Use with available fluent helpers to apply the <b>FSItemRoleText</b> field to query operations.
     *
     */
    public final static FSItemAttribByTimeVersionField<String> FS_ITEM_ROLE_TEXT =
        new FSItemAttribByTimeVersionField<String>("FSItemRoleText");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemDataCollection</b>
     * </p>
     *
     * @return Data Collection Selection Attribute
     */
    @SerializedName( "FSItemDataCollection" )
    @JsonProperty( "FSItemDataCollection" )
    @Nullable
    @ODataField( odataName = "FSItemDataCollection" )
    private String fSItemDataCollection;
    /**
     * Use with available fluent helpers to apply the <b>FSItemDataCollection</b> field to query operations.
     *
     */
    public final static FSItemAttribByTimeVersionField<String> FS_ITEM_DATA_COLLECTION =
        new FSItemAttribByTimeVersionField<String>("FSItemDataCollection");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemDataCollectionText</b>
     * </p>
     *
     * @return Data Collection Selection Attribute Description
     */
    @SerializedName( "FSItemDataCollectionText" )
    @JsonProperty( "FSItemDataCollectionText" )
    @Nullable
    @ODataField( odataName = "FSItemDataCollectionText" )
    private String fSItemDataCollectionText;
    /**
     * Use with available fluent helpers to apply the <b>FSItemDataCollectionText</b> field to query operations.
     *
     */
    public final static FSItemAttribByTimeVersionField<String> FS_ITEM_DATA_COLLECTION_TEXT =
        new FSItemAttribByTimeVersionField<String>("FSItemDataCollectionText");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemCurrencyTranslation</b>
     * </p>
     *
     * @return Currency Translation Selection Attribute
     */
    @SerializedName( "FSItemCurrencyTranslation" )
    @JsonProperty( "FSItemCurrencyTranslation" )
    @Nullable
    @ODataField( odataName = "FSItemCurrencyTranslation" )
    private String fSItemCurrencyTranslation;
    /**
     * Use with available fluent helpers to apply the <b>FSItemCurrencyTranslation</b> field to query operations.
     *
     */
    public final static FSItemAttribByTimeVersionField<String> FS_ITEM_CURRENCY_TRANSLATION =
        new FSItemAttribByTimeVersionField<String>("FSItemCurrencyTranslation");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemCurrencyTranslationText</b>
     * </p>
     *
     * @return Currency Translation Selection Attribute Description
     */
    @SerializedName( "FSItemCurrencyTranslationText" )
    @JsonProperty( "FSItemCurrencyTranslationText" )
    @Nullable
    @ODataField( odataName = "FSItemCurrencyTranslationText" )
    private String fSItemCurrencyTranslationText;
    /**
     * Use with available fluent helpers to apply the <b>FSItemCurrencyTranslationText</b> field to query operations.
     *
     */
    public final static FSItemAttribByTimeVersionField<String> FS_ITEM_CURRENCY_TRANSLATION_TEXT =
        new FSItemAttribByTimeVersionField<String>("FSItemCurrencyTranslationText");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemElimination</b>
     * </p>
     *
     * @return Elimination Selection Attribute
     */
    @SerializedName( "FSItemElimination" )
    @JsonProperty( "FSItemElimination" )
    @Nullable
    @ODataField( odataName = "FSItemElimination" )
    private String fSItemElimination;
    /**
     * Use with available fluent helpers to apply the <b>FSItemElimination</b> field to query operations.
     *
     */
    public final static FSItemAttribByTimeVersionField<String> FS_ITEM_ELIMINATION =
        new FSItemAttribByTimeVersionField<String>("FSItemElimination");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemEliminationText</b>
     * </p>
     *
     * @return Elimination Selection Attribute Description
     */
    @SerializedName( "FSItemEliminationText" )
    @JsonProperty( "FSItemEliminationText" )
    @Nullable
    @ODataField( odataName = "FSItemEliminationText" )
    private String fSItemEliminationText;
    /**
     * Use with available fluent helpers to apply the <b>FSItemEliminationText</b> field to query operations.
     *
     */
    public final static FSItemAttribByTimeVersionField<String> FS_ITEM_ELIMINATION_TEXT =
        new FSItemAttribByTimeVersionField<String>("FSItemEliminationText");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemCashFlow</b>
     * </p>
     *
     * @return Cash Flow Selection Attribute
     */
    @SerializedName( "FSItemCashFlow" )
    @JsonProperty( "FSItemCashFlow" )
    @Nullable
    @ODataField( odataName = "FSItemCashFlow" )
    private String fSItemCashFlow;
    /**
     * Use with available fluent helpers to apply the <b>FSItemCashFlow</b> field to query operations.
     *
     */
    public final static FSItemAttribByTimeVersionField<String> FS_ITEM_CASH_FLOW =
        new FSItemAttribByTimeVersionField<String>("FSItemCashFlow");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemCashFlowText</b>
     * </p>
     *
     * @return Cash Flow Selection Attribute Description
     */
    @SerializedName( "FSItemCashFlowText" )
    @JsonProperty( "FSItemCashFlowText" )
    @Nullable
    @ODataField( odataName = "FSItemCashFlowText" )
    private String fSItemCashFlowText;
    /**
     * Use with available fluent helpers to apply the <b>FSItemCashFlowText</b> field to query operations.
     *
     */
    public final static FSItemAttribByTimeVersionField<String> FS_ITEM_CASH_FLOW_TEXT =
        new FSItemAttribByTimeVersionField<String>("FSItemCashFlowText");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemScope</b>
     * </p>
     *
     * @return Scope Selection Attribute
     */
    @SerializedName( "FSItemScope" )
    @JsonProperty( "FSItemScope" )
    @Nullable
    @ODataField( odataName = "FSItemScope" )
    private String fSItemScope;
    /**
     * Use with available fluent helpers to apply the <b>FSItemScope</b> field to query operations.
     *
     */
    public final static FSItemAttribByTimeVersionField<String> FS_ITEM_SCOPE =
        new FSItemAttribByTimeVersionField<String>("FSItemScope");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemScopeText</b>
     * </p>
     *
     * @return Scope Selection Attribute Description
     */
    @SerializedName( "FSItemScopeText" )
    @JsonProperty( "FSItemScopeText" )
    @Nullable
    @ODataField( odataName = "FSItemScopeText" )
    private String fSItemScopeText;
    /**
     * Use with available fluent helpers to apply the <b>FSItemScopeText</b> field to query operations.
     *
     */
    public final static FSItemAttribByTimeVersionField<String> FS_ITEM_SCOPE_TEXT =
        new FSItemAttribByTimeVersionField<String>("FSItemScopeText");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemCustomerSpecific</b>
     * </p>
     *
     * @return Other Selection Attribute
     */
    @SerializedName( "FSItemCustomerSpecific" )
    @JsonProperty( "FSItemCustomerSpecific" )
    @Nullable
    @ODataField( odataName = "FSItemCustomerSpecific" )
    private String fSItemCustomerSpecific;
    /**
     * Use with available fluent helpers to apply the <b>FSItemCustomerSpecific</b> field to query operations.
     *
     */
    public final static FSItemAttribByTimeVersionField<String> FS_ITEM_CUSTOMER_SPECIFIC =
        new FSItemAttribByTimeVersionField<String>("FSItemCustomerSpecific");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemCustomerSpecificText</b>
     * </p>
     *
     * @return Other Selection Attribute Description
     */
    @SerializedName( "FSItemCustomerSpecificText" )
    @JsonProperty( "FSItemCustomerSpecificText" )
    @Nullable
    @ODataField( odataName = "FSItemCustomerSpecificText" )
    private String fSItemCustomerSpecificText;
    /**
     * Use with available fluent helpers to apply the <b>FSItemCustomerSpecificText</b> field to query operations.
     *
     */
    public final static FSItemAttribByTimeVersionField<String> FS_ITEM_CUSTOMER_SPECIFIC_TEXT =
        new FSItemAttribByTimeVersionField<String>("FSItemCustomerSpecificText");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EliminationTargetFSItem</b>
     * </p>
     *
     * @return Elimination Target Attribute
     */
    @SerializedName( "EliminationTargetFSItem" )
    @JsonProperty( "EliminationTargetFSItem" )
    @Nullable
    @ODataField( odataName = "EliminationTargetFSItem" )
    private String eliminationTargetFSItem;
    /**
     * Use with available fluent helpers to apply the <b>EliminationTargetFSItem</b> field to query operations.
     *
     */
    public final static FSItemAttribByTimeVersionField<String> ELIMINATION_TARGET_FS_ITEM =
        new FSItemAttribByTimeVersionField<String>("EliminationTargetFSItem");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>EliminationTargetFSItemText</b>
     * </p>
     *
     * @return Elimination Target Attribute Description
     */
    @SerializedName( "EliminationTargetFSItemText" )
    @JsonProperty( "EliminationTargetFSItemText" )
    @Nullable
    @ODataField( odataName = "EliminationTargetFSItemText" )
    private String eliminationTargetFSItemText;
    /**
     * Use with available fluent helpers to apply the <b>EliminationTargetFSItemText</b> field to query operations.
     *
     */
    public final static FSItemAttribByTimeVersionField<String> ELIMINATION_TARGET_FS_ITEM_TEXT =
        new FSItemAttribByTimeVersionField<String>("EliminationTargetFSItemText");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>NCITargetFSItem</b>
     * </p>
     *
     * @return Non-Controlling Interest Target Attribute
     */
    @SerializedName( "NCITargetFSItem" )
    @JsonProperty( "NCITargetFSItem" )
    @Nullable
    @ODataField( odataName = "NCITargetFSItem" )
    private String nCITargetFSItem;
    /**
     * Use with available fluent helpers to apply the <b>NCITargetFSItem</b> field to query operations.
     *
     */
    public final static FSItemAttribByTimeVersionField<String> NCI_TARGET_FS_ITEM =
        new FSItemAttribByTimeVersionField<String>("NCITargetFSItem");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>NCITargetFSItemText</b>
     * </p>
     *
     * @return Non-Controlling Interest Target Attribute Description
     */
    @SerializedName( "NCITargetFSItemText" )
    @JsonProperty( "NCITargetFSItemText" )
    @Nullable
    @ODataField( odataName = "NCITargetFSItemText" )
    private String nCITargetFSItemText;
    /**
     * Use with available fluent helpers to apply the <b>NCITargetFSItemText</b> field to query operations.
     *
     */
    public final static FSItemAttribByTimeVersionField<String> NCI_TARGET_FS_ITEM_TEXT =
        new FSItemAttribByTimeVersionField<String>("NCITargetFSItemText");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PlanningTargetFSItem</b>
     * </p>
     *
     * @return Planning Target Attribute
     */
    @SerializedName( "PlanningTargetFSItem" )
    @JsonProperty( "PlanningTargetFSItem" )
    @Nullable
    @ODataField( odataName = "PlanningTargetFSItem" )
    private String planningTargetFSItem;
    /**
     * Use with available fluent helpers to apply the <b>PlanningTargetFSItem</b> field to query operations.
     *
     */
    public final static FSItemAttribByTimeVersionField<String> PLANNING_TARGET_FS_ITEM =
        new FSItemAttribByTimeVersionField<String>("PlanningTargetFSItem");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>PlanningTargetFSItemText</b>
     * </p>
     *
     * @return Planning Target Attribute Description
     */
    @SerializedName( "PlanningTargetFSItemText" )
    @JsonProperty( "PlanningTargetFSItemText" )
    @Nullable
    @ODataField( odataName = "PlanningTargetFSItemText" )
    private String planningTargetFSItemText;
    /**
     * Use with available fluent helpers to apply the <b>PlanningTargetFSItemText</b> field to query operations.
     *
     */
    public final static FSItemAttribByTimeVersionField<String> PLANNING_TARGET_FS_ITEM_TEXT =
        new FSItemAttribByTimeVersionField<String>("PlanningTargetFSItemText");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnOffsettingTargetFSItem</b>
     * </p>
     *
     * @return Offsetting Target Attribute
     */
    @SerializedName( "CnsldtnOffsettingTargetFSItem" )
    @JsonProperty( "CnsldtnOffsettingTargetFSItem" )
    @Nullable
    @ODataField( odataName = "CnsldtnOffsettingTargetFSItem" )
    private String cnsldtnOffsettingTargetFSItem;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnOffsettingTargetFSItem</b> field to query operations.
     *
     */
    public final static FSItemAttribByTimeVersionField<String> CNSLDTN_OFFSETTING_TARGET_FS_ITEM =
        new FSItemAttribByTimeVersionField<String>("CnsldtnOffsettingTargetFSItem");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnOffstgTargetFSItemText</b>
     * </p>
     *
     * @return Offsetting Target Attribute Description
     */
    @SerializedName( "CnsldtnOffstgTargetFSItemText" )
    @JsonProperty( "CnsldtnOffstgTargetFSItemText" )
    @Nullable
    @ODataField( odataName = "CnsldtnOffstgTargetFSItemText" )
    private String cnsldtnOffstgTargetFSItemText;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnOffstgTargetFSItemText</b> field to query operations.
     *
     */
    public final static FSItemAttribByTimeVersionField<String> CNSLDTN_OFFSTG_TARGET_FS_ITEM_TEXT =
        new FSItemAttribByTimeVersionField<String>("CnsldtnOffstgTargetFSItemText");
    /**
     * Navigation property <b>to_CnsldtnFSItem</b> for <b>FSItemAttribByTimeVersion</b> to single
     * <b>FinancialStatementItem_2</b>.
     *
     */
    @SerializedName( "to_CnsldtnFSItem" )
    @JsonProperty( "to_CnsldtnFSItem" )
    @ODataField( odataName = "to_CnsldtnFSItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private FinancialStatementItem_2 toCnsldtnFSItem;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnFSItem</b> navigation property to query operations.
     *
     */
    public final static FSItemAttribByTimeVersionOneToOneLink<FinancialStatementItem_2> TO_CNSLDTN_FS_ITEM =
        new FSItemAttribByTimeVersionOneToOneLink<FinancialStatementItem_2>("to_CnsldtnFSItem");

    @Nonnull
    @Override
    public Class<FSItemAttribByTimeVersion> getType()
    {
        return FSItemAttribByTimeVersion.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts</b>
     * </p>
     *
     * @param consolidationChartOfAccounts
     *            Consolidation Chart of Accounts
     */
    public void setConsolidationChartOfAccounts( @Nullable final String consolidationChartOfAccounts )
    {
        rememberChangedField("ConsolidationChartOfAccounts", this.consolidationChartOfAccounts);
        this.consolidationChartOfAccounts = consolidationChartOfAccounts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts_Text</b>
     * </p>
     *
     * @param consolidationChartOfAccounts_Text
     *            Consolidation Chart of Accounts Description
     */
    public void setConsolidationChartOfAccounts_Text( @Nullable final String consolidationChartOfAccounts_Text )
    {
        rememberChangedField("ConsolidationChartOfAccounts_Text", this.consolidationChartOfAccounts_Text);
        this.consolidationChartOfAccounts_Text = consolidationChartOfAccounts_Text;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItem</b>
     * </p>
     *
     * @param financialStatementItem
     *            Financial Statement Item
     */
    public void setFinancialStatementItem( @Nullable final String financialStatementItem )
    {
        rememberChangedField("FinancialStatementItem", this.financialStatementItem);
        this.financialStatementItem = financialStatementItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItem_Text</b>
     * </p>
     *
     * @param financialStatementItem_Text
     *            Financial Statement Item Medium Description
     */
    public void setFinancialStatementItem_Text( @Nullable final String financialStatementItem_Text )
    {
        rememberChangedField("FinancialStatementItem_Text", this.financialStatementItem_Text);
        this.financialStatementItem_Text = financialStatementItem_Text;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationVersion</b>
     * </p>
     *
     * @param consolidationVersion
     *            Consolidation Version
     */
    public void setConsolidationVersion( @Nullable final String consolidationVersion )
    {
        rememberChangedField("ConsolidationVersion", this.consolidationVersion);
        this.consolidationVersion = consolidationVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationVersion_Text</b>
     * </p>
     *
     * @param consolidationVersion_Text
     *            Consolidation Version Description
     */
    public void setConsolidationVersion_Text( @Nullable final String consolidationVersion_Text )
    {
        rememberChangedField("ConsolidationVersion_Text", this.consolidationVersion_Text);
        this.consolidationVersion_Text = consolidationVersion_Text;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>FromFiscalYearPeriod</b>
     * </p>
     *
     * @param fromFiscalYearPeriod
     *            Start of Assignment
     */
    public void setFromFiscalYearPeriod( @Nullable final String fromFiscalYearPeriod )
    {
        rememberChangedField("FromFiscalYearPeriod", this.fromFiscalYearPeriod);
        this.fromFiscalYearPeriod = fromFiscalYearPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>ToFiscalYearPeriod</b>
     * </p>
     *
     * @param toFiscalYearPeriod
     *            End of Assignment
     */
    public void setToFiscalYearPeriod( @Nullable final String toFiscalYearPeriod )
    {
        rememberChangedField("ToFiscalYearPeriod", this.toFiscalYearPeriod);
        this.toFiscalYearPeriod = toFiscalYearPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItemRole</b>
     * </p>
     *
     * @param financialStatementItemRole
     *            Financial Statement Item Role
     */
    public void setFinancialStatementItemRole( @Nullable final String financialStatementItemRole )
    {
        rememberChangedField("FinancialStatementItemRole", this.financialStatementItemRole);
        this.financialStatementItemRole = financialStatementItemRole;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemRoleText</b>
     * </p>
     *
     * @param fSItemRoleText
     *            Financial Statement Item Role Description
     */
    public void setFSItemRoleText( @Nullable final String fSItemRoleText )
    {
        rememberChangedField("FSItemRoleText", this.fSItemRoleText);
        this.fSItemRoleText = fSItemRoleText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemDataCollection</b>
     * </p>
     *
     * @param fSItemDataCollection
     *            Data Collection Selection Attribute
     */
    public void setFSItemDataCollection( @Nullable final String fSItemDataCollection )
    {
        rememberChangedField("FSItemDataCollection", this.fSItemDataCollection);
        this.fSItemDataCollection = fSItemDataCollection;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemDataCollectionText</b>
     * </p>
     *
     * @param fSItemDataCollectionText
     *            Data Collection Selection Attribute Description
     */
    public void setFSItemDataCollectionText( @Nullable final String fSItemDataCollectionText )
    {
        rememberChangedField("FSItemDataCollectionText", this.fSItemDataCollectionText);
        this.fSItemDataCollectionText = fSItemDataCollectionText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemCurrencyTranslation</b>
     * </p>
     *
     * @param fSItemCurrencyTranslation
     *            Currency Translation Selection Attribute
     */
    public void setFSItemCurrencyTranslation( @Nullable final String fSItemCurrencyTranslation )
    {
        rememberChangedField("FSItemCurrencyTranslation", this.fSItemCurrencyTranslation);
        this.fSItemCurrencyTranslation = fSItemCurrencyTranslation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemCurrencyTranslationText</b>
     * </p>
     *
     * @param fSItemCurrencyTranslationText
     *            Currency Translation Selection Attribute Description
     */
    public void setFSItemCurrencyTranslationText( @Nullable final String fSItemCurrencyTranslationText )
    {
        rememberChangedField("FSItemCurrencyTranslationText", this.fSItemCurrencyTranslationText);
        this.fSItemCurrencyTranslationText = fSItemCurrencyTranslationText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemElimination</b>
     * </p>
     *
     * @param fSItemElimination
     *            Elimination Selection Attribute
     */
    public void setFSItemElimination( @Nullable final String fSItemElimination )
    {
        rememberChangedField("FSItemElimination", this.fSItemElimination);
        this.fSItemElimination = fSItemElimination;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemEliminationText</b>
     * </p>
     *
     * @param fSItemEliminationText
     *            Elimination Selection Attribute Description
     */
    public void setFSItemEliminationText( @Nullable final String fSItemEliminationText )
    {
        rememberChangedField("FSItemEliminationText", this.fSItemEliminationText);
        this.fSItemEliminationText = fSItemEliminationText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemCashFlow</b>
     * </p>
     *
     * @param fSItemCashFlow
     *            Cash Flow Selection Attribute
     */
    public void setFSItemCashFlow( @Nullable final String fSItemCashFlow )
    {
        rememberChangedField("FSItemCashFlow", this.fSItemCashFlow);
        this.fSItemCashFlow = fSItemCashFlow;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemCashFlowText</b>
     * </p>
     *
     * @param fSItemCashFlowText
     *            Cash Flow Selection Attribute Description
     */
    public void setFSItemCashFlowText( @Nullable final String fSItemCashFlowText )
    {
        rememberChangedField("FSItemCashFlowText", this.fSItemCashFlowText);
        this.fSItemCashFlowText = fSItemCashFlowText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemScope</b>
     * </p>
     *
     * @param fSItemScope
     *            Scope Selection Attribute
     */
    public void setFSItemScope( @Nullable final String fSItemScope )
    {
        rememberChangedField("FSItemScope", this.fSItemScope);
        this.fSItemScope = fSItemScope;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemScopeText</b>
     * </p>
     *
     * @param fSItemScopeText
     *            Scope Selection Attribute Description
     */
    public void setFSItemScopeText( @Nullable final String fSItemScopeText )
    {
        rememberChangedField("FSItemScopeText", this.fSItemScopeText);
        this.fSItemScopeText = fSItemScopeText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemCustomerSpecific</b>
     * </p>
     *
     * @param fSItemCustomerSpecific
     *            Other Selection Attribute
     */
    public void setFSItemCustomerSpecific( @Nullable final String fSItemCustomerSpecific )
    {
        rememberChangedField("FSItemCustomerSpecific", this.fSItemCustomerSpecific);
        this.fSItemCustomerSpecific = fSItemCustomerSpecific;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemCustomerSpecificText</b>
     * </p>
     *
     * @param fSItemCustomerSpecificText
     *            Other Selection Attribute Description
     */
    public void setFSItemCustomerSpecificText( @Nullable final String fSItemCustomerSpecificText )
    {
        rememberChangedField("FSItemCustomerSpecificText", this.fSItemCustomerSpecificText);
        this.fSItemCustomerSpecificText = fSItemCustomerSpecificText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EliminationTargetFSItem</b>
     * </p>
     *
     * @param eliminationTargetFSItem
     *            Elimination Target Attribute
     */
    public void setEliminationTargetFSItem( @Nullable final String eliminationTargetFSItem )
    {
        rememberChangedField("EliminationTargetFSItem", this.eliminationTargetFSItem);
        this.eliminationTargetFSItem = eliminationTargetFSItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>EliminationTargetFSItemText</b>
     * </p>
     *
     * @param eliminationTargetFSItemText
     *            Elimination Target Attribute Description
     */
    public void setEliminationTargetFSItemText( @Nullable final String eliminationTargetFSItemText )
    {
        rememberChangedField("EliminationTargetFSItemText", this.eliminationTargetFSItemText);
        this.eliminationTargetFSItemText = eliminationTargetFSItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>NCITargetFSItem</b>
     * </p>
     *
     * @param nCITargetFSItem
     *            Non-Controlling Interest Target Attribute
     */
    public void setNCITargetFSItem( @Nullable final String nCITargetFSItem )
    {
        rememberChangedField("NCITargetFSItem", this.nCITargetFSItem);
        this.nCITargetFSItem = nCITargetFSItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>NCITargetFSItemText</b>
     * </p>
     *
     * @param nCITargetFSItemText
     *            Non-Controlling Interest Target Attribute Description
     */
    public void setNCITargetFSItemText( @Nullable final String nCITargetFSItemText )
    {
        rememberChangedField("NCITargetFSItemText", this.nCITargetFSItemText);
        this.nCITargetFSItemText = nCITargetFSItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PlanningTargetFSItem</b>
     * </p>
     *
     * @param planningTargetFSItem
     *            Planning Target Attribute
     */
    public void setPlanningTargetFSItem( @Nullable final String planningTargetFSItem )
    {
        rememberChangedField("PlanningTargetFSItem", this.planningTargetFSItem);
        this.planningTargetFSItem = planningTargetFSItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>PlanningTargetFSItemText</b>
     * </p>
     *
     * @param planningTargetFSItemText
     *            Planning Target Attribute Description
     */
    public void setPlanningTargetFSItemText( @Nullable final String planningTargetFSItemText )
    {
        rememberChangedField("PlanningTargetFSItemText", this.planningTargetFSItemText);
        this.planningTargetFSItemText = planningTargetFSItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnOffsettingTargetFSItem</b>
     * </p>
     *
     * @param cnsldtnOffsettingTargetFSItem
     *            Offsetting Target Attribute
     */
    public void setCnsldtnOffsettingTargetFSItem( @Nullable final String cnsldtnOffsettingTargetFSItem )
    {
        rememberChangedField("CnsldtnOffsettingTargetFSItem", this.cnsldtnOffsettingTargetFSItem);
        this.cnsldtnOffsettingTargetFSItem = cnsldtnOffsettingTargetFSItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnOffstgTargetFSItemText</b>
     * </p>
     *
     * @param cnsldtnOffstgTargetFSItemText
     *            Offsetting Target Attribute Description
     */
    public void setCnsldtnOffstgTargetFSItemText( @Nullable final String cnsldtnOffstgTargetFSItemText )
    {
        rememberChangedField("CnsldtnOffstgTargetFSItemText", this.cnsldtnOffstgTargetFSItemText);
        this.cnsldtnOffstgTargetFSItemText = cnsldtnOffstgTargetFSItemText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "FSItemAttribByTimeVersion";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConsolidationChartOfAccounts", getConsolidationChartOfAccounts());
        result.put("FinancialStatementItem", getFinancialStatementItem());
        result.put("ConsolidationVersion", getConsolidationVersion());
        result.put("FromFiscalYearPeriod", getFromFiscalYearPeriod());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConsolidationChartOfAccounts", getConsolidationChartOfAccounts());
        values.put("ConsolidationChartOfAccounts_Text", getConsolidationChartOfAccounts_Text());
        values.put("FinancialStatementItem", getFinancialStatementItem());
        values.put("FinancialStatementItem_Text", getFinancialStatementItem_Text());
        values.put("ConsolidationVersion", getConsolidationVersion());
        values.put("ConsolidationVersion_Text", getConsolidationVersion_Text());
        values.put("FromFiscalYearPeriod", getFromFiscalYearPeriod());
        values.put("ToFiscalYearPeriod", getToFiscalYearPeriod());
        values.put("FinancialStatementItemRole", getFinancialStatementItemRole());
        values.put("FSItemRoleText", getFSItemRoleText());
        values.put("FSItemDataCollection", getFSItemDataCollection());
        values.put("FSItemDataCollectionText", getFSItemDataCollectionText());
        values.put("FSItemCurrencyTranslation", getFSItemCurrencyTranslation());
        values.put("FSItemCurrencyTranslationText", getFSItemCurrencyTranslationText());
        values.put("FSItemElimination", getFSItemElimination());
        values.put("FSItemEliminationText", getFSItemEliminationText());
        values.put("FSItemCashFlow", getFSItemCashFlow());
        values.put("FSItemCashFlowText", getFSItemCashFlowText());
        values.put("FSItemScope", getFSItemScope());
        values.put("FSItemScopeText", getFSItemScopeText());
        values.put("FSItemCustomerSpecific", getFSItemCustomerSpecific());
        values.put("FSItemCustomerSpecificText", getFSItemCustomerSpecificText());
        values.put("EliminationTargetFSItem", getEliminationTargetFSItem());
        values.put("EliminationTargetFSItemText", getEliminationTargetFSItemText());
        values.put("NCITargetFSItem", getNCITargetFSItem());
        values.put("NCITargetFSItemText", getNCITargetFSItemText());
        values.put("PlanningTargetFSItem", getPlanningTargetFSItem());
        values.put("PlanningTargetFSItemText", getPlanningTargetFSItemText());
        values.put("CnsldtnOffsettingTargetFSItem", getCnsldtnOffsettingTargetFSItem());
        values.put("CnsldtnOffstgTargetFSItemText", getCnsldtnOffstgTargetFSItemText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConsolidationChartOfAccounts") ) {
                final Object value = values.remove("ConsolidationChartOfAccounts");
                if( (value == null) || (!value.equals(getConsolidationChartOfAccounts())) ) {
                    setConsolidationChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("ConsolidationChartOfAccounts_Text") ) {
                final Object value = values.remove("ConsolidationChartOfAccounts_Text");
                if( (value == null) || (!value.equals(getConsolidationChartOfAccounts_Text())) ) {
                    setConsolidationChartOfAccounts_Text(((String) value));
                }
            }
            if( values.containsKey("FinancialStatementItem") ) {
                final Object value = values.remove("FinancialStatementItem");
                if( (value == null) || (!value.equals(getFinancialStatementItem())) ) {
                    setFinancialStatementItem(((String) value));
                }
            }
            if( values.containsKey("FinancialStatementItem_Text") ) {
                final Object value = values.remove("FinancialStatementItem_Text");
                if( (value == null) || (!value.equals(getFinancialStatementItem_Text())) ) {
                    setFinancialStatementItem_Text(((String) value));
                }
            }
            if( values.containsKey("ConsolidationVersion") ) {
                final Object value = values.remove("ConsolidationVersion");
                if( (value == null) || (!value.equals(getConsolidationVersion())) ) {
                    setConsolidationVersion(((String) value));
                }
            }
            if( values.containsKey("ConsolidationVersion_Text") ) {
                final Object value = values.remove("ConsolidationVersion_Text");
                if( (value == null) || (!value.equals(getConsolidationVersion_Text())) ) {
                    setConsolidationVersion_Text(((String) value));
                }
            }
            if( values.containsKey("FromFiscalYearPeriod") ) {
                final Object value = values.remove("FromFiscalYearPeriod");
                if( (value == null) || (!value.equals(getFromFiscalYearPeriod())) ) {
                    setFromFiscalYearPeriod(((String) value));
                }
            }
            if( values.containsKey("ToFiscalYearPeriod") ) {
                final Object value = values.remove("ToFiscalYearPeriod");
                if( (value == null) || (!value.equals(getToFiscalYearPeriod())) ) {
                    setToFiscalYearPeriod(((String) value));
                }
            }
            if( values.containsKey("FinancialStatementItemRole") ) {
                final Object value = values.remove("FinancialStatementItemRole");
                if( (value == null) || (!value.equals(getFinancialStatementItemRole())) ) {
                    setFinancialStatementItemRole(((String) value));
                }
            }
            if( values.containsKey("FSItemRoleText") ) {
                final Object value = values.remove("FSItemRoleText");
                if( (value == null) || (!value.equals(getFSItemRoleText())) ) {
                    setFSItemRoleText(((String) value));
                }
            }
            if( values.containsKey("FSItemDataCollection") ) {
                final Object value = values.remove("FSItemDataCollection");
                if( (value == null) || (!value.equals(getFSItemDataCollection())) ) {
                    setFSItemDataCollection(((String) value));
                }
            }
            if( values.containsKey("FSItemDataCollectionText") ) {
                final Object value = values.remove("FSItemDataCollectionText");
                if( (value == null) || (!value.equals(getFSItemDataCollectionText())) ) {
                    setFSItemDataCollectionText(((String) value));
                }
            }
            if( values.containsKey("FSItemCurrencyTranslation") ) {
                final Object value = values.remove("FSItemCurrencyTranslation");
                if( (value == null) || (!value.equals(getFSItemCurrencyTranslation())) ) {
                    setFSItemCurrencyTranslation(((String) value));
                }
            }
            if( values.containsKey("FSItemCurrencyTranslationText") ) {
                final Object value = values.remove("FSItemCurrencyTranslationText");
                if( (value == null) || (!value.equals(getFSItemCurrencyTranslationText())) ) {
                    setFSItemCurrencyTranslationText(((String) value));
                }
            }
            if( values.containsKey("FSItemElimination") ) {
                final Object value = values.remove("FSItemElimination");
                if( (value == null) || (!value.equals(getFSItemElimination())) ) {
                    setFSItemElimination(((String) value));
                }
            }
            if( values.containsKey("FSItemEliminationText") ) {
                final Object value = values.remove("FSItemEliminationText");
                if( (value == null) || (!value.equals(getFSItemEliminationText())) ) {
                    setFSItemEliminationText(((String) value));
                }
            }
            if( values.containsKey("FSItemCashFlow") ) {
                final Object value = values.remove("FSItemCashFlow");
                if( (value == null) || (!value.equals(getFSItemCashFlow())) ) {
                    setFSItemCashFlow(((String) value));
                }
            }
            if( values.containsKey("FSItemCashFlowText") ) {
                final Object value = values.remove("FSItemCashFlowText");
                if( (value == null) || (!value.equals(getFSItemCashFlowText())) ) {
                    setFSItemCashFlowText(((String) value));
                }
            }
            if( values.containsKey("FSItemScope") ) {
                final Object value = values.remove("FSItemScope");
                if( (value == null) || (!value.equals(getFSItemScope())) ) {
                    setFSItemScope(((String) value));
                }
            }
            if( values.containsKey("FSItemScopeText") ) {
                final Object value = values.remove("FSItemScopeText");
                if( (value == null) || (!value.equals(getFSItemScopeText())) ) {
                    setFSItemScopeText(((String) value));
                }
            }
            if( values.containsKey("FSItemCustomerSpecific") ) {
                final Object value = values.remove("FSItemCustomerSpecific");
                if( (value == null) || (!value.equals(getFSItemCustomerSpecific())) ) {
                    setFSItemCustomerSpecific(((String) value));
                }
            }
            if( values.containsKey("FSItemCustomerSpecificText") ) {
                final Object value = values.remove("FSItemCustomerSpecificText");
                if( (value == null) || (!value.equals(getFSItemCustomerSpecificText())) ) {
                    setFSItemCustomerSpecificText(((String) value));
                }
            }
            if( values.containsKey("EliminationTargetFSItem") ) {
                final Object value = values.remove("EliminationTargetFSItem");
                if( (value == null) || (!value.equals(getEliminationTargetFSItem())) ) {
                    setEliminationTargetFSItem(((String) value));
                }
            }
            if( values.containsKey("EliminationTargetFSItemText") ) {
                final Object value = values.remove("EliminationTargetFSItemText");
                if( (value == null) || (!value.equals(getEliminationTargetFSItemText())) ) {
                    setEliminationTargetFSItemText(((String) value));
                }
            }
            if( values.containsKey("NCITargetFSItem") ) {
                final Object value = values.remove("NCITargetFSItem");
                if( (value == null) || (!value.equals(getNCITargetFSItem())) ) {
                    setNCITargetFSItem(((String) value));
                }
            }
            if( values.containsKey("NCITargetFSItemText") ) {
                final Object value = values.remove("NCITargetFSItemText");
                if( (value == null) || (!value.equals(getNCITargetFSItemText())) ) {
                    setNCITargetFSItemText(((String) value));
                }
            }
            if( values.containsKey("PlanningTargetFSItem") ) {
                final Object value = values.remove("PlanningTargetFSItem");
                if( (value == null) || (!value.equals(getPlanningTargetFSItem())) ) {
                    setPlanningTargetFSItem(((String) value));
                }
            }
            if( values.containsKey("PlanningTargetFSItemText") ) {
                final Object value = values.remove("PlanningTargetFSItemText");
                if( (value == null) || (!value.equals(getPlanningTargetFSItemText())) ) {
                    setPlanningTargetFSItemText(((String) value));
                }
            }
            if( values.containsKey("CnsldtnOffsettingTargetFSItem") ) {
                final Object value = values.remove("CnsldtnOffsettingTargetFSItem");
                if( (value == null) || (!value.equals(getCnsldtnOffsettingTargetFSItem())) ) {
                    setCnsldtnOffsettingTargetFSItem(((String) value));
                }
            }
            if( values.containsKey("CnsldtnOffstgTargetFSItemText") ) {
                final Object value = values.remove("CnsldtnOffstgTargetFSItemText");
                if( (value == null) || (!value.equals(getCnsldtnOffstgTargetFSItemText())) ) {
                    setCnsldtnOffstgTargetFSItemText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnFSItem") ) {
                final Object value = (values).remove("to_CnsldtnFSItem");
                if( value instanceof Map ) {
                    if( toCnsldtnFSItem == null ) {
                        toCnsldtnFSItem = new FinancialStatementItem_2();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnFSItem.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> FSItemAttribByTimeVersionField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new FSItemAttribByTimeVersionField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FSItemAttribByTimeVersionField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FSItemAttribByTimeVersionField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnFSItem != null ) {
            (values).put("to_CnsldtnFSItem", toCnsldtnFSItem);
        }
        return values;
    }

    /**
     * Fetches the <b>FinancialStatementItem_2</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CnsldtnFSItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>FinancialStatementItem_2</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public FinancialStatementItem_2 fetchCnsldtnFSItem()
    {
        return fetchFieldAsSingle("to_CnsldtnFSItem", FinancialStatementItem_2.class);
    }

    /**
     * Retrieval of associated <b>FinancialStatementItem_2</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItem</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItem</b> of a queried <b>FSItemAttribByTimeVersion</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>FinancialStatementItem_2</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public FinancialStatementItem_2 getCnsldtnFSItemOrFetch()
    {
        if( toCnsldtnFSItem == null ) {
            toCnsldtnFSItem = fetchCnsldtnFSItem();
        }
        return toCnsldtnFSItem;
    }

    /**
     * Retrieval of associated <b>FinancialStatementItem_2</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItem</b>.
     * <p>
     * If the navigation property for an entity <b>FSItemAttribByTimeVersion</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnFSItem</b> is already loaded, the result will
     *         contain the <b>FinancialStatementItem_2</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<FinancialStatementItem_2> getCnsldtnFSItemIfPresent()
    {
        return Option.of(toCnsldtnFSItem);
    }

    /**
     * Overwrites the associated <b>FinancialStatementItem_2</b> entity for the loaded navigation property
     * <b>to_CnsldtnFSItem</b>.
     *
     * @param value
     *            New <b>FinancialStatementItem_2</b> entity.
     */
    public void setCnsldtnFSItem( final FinancialStatementItem_2 value )
    {
        toCnsldtnFSItem = value;
    }

    /**
     * Helper class to allow for fluent creation of FSItemAttribByTimeVersion instances.
     *
     */
    public final static class FSItemAttribByTimeVersionBuilder
    {

        private FinancialStatementItem_2 toCnsldtnFSItem;

        private FSItemAttribByTimeVersion.FSItemAttribByTimeVersionBuilder toCnsldtnFSItem(
            final FinancialStatementItem_2 value )
        {
            toCnsldtnFSItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnFSItem</b> for <b>FSItemAttribByTimeVersion</b> to single
         * <b>FinancialStatementItem_2</b>.
         *
         * @param value
         *            The FinancialStatementItem_2 to build this FSItemAttribByTimeVersion with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FSItemAttribByTimeVersion.FSItemAttribByTimeVersionBuilder cnsldtnFSItem(
            final FinancialStatementItem_2 value )
        {
            return toCnsldtnFSItem(value);
        }

    }

}
