/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.FSItemAttribByTimeVersionSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemAttribByTimeVersion
 * FSItemAttribByTimeVersion} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class FSItemAttribByTimeVersionByKeyFluentHelper
    extends
    FluentHelperByKey<FSItemAttribByTimeVersionByKeyFluentHelper, FSItemAttribByTimeVersion, FSItemAttribByTimeVersionSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemAttribByTimeVersion
     * FSItemAttribByTimeVersion} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code FSItemAttribByTimeVersion}
     * @param financialStatementItem
     *            Financial Statement Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code FSItemAttribByTimeVersion}
     * @param fromFiscalYearPeriod
     *            Start of Assignment
     *            <p>
     *            Constraints: Not nullable, Maximum length: 7
     *            </p>
     * @param consolidationVersion
     *            Consolidation Version
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param consolidationChartOfAccounts
     *            Consolidation Chart of Accounts
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     */
    public FSItemAttribByTimeVersionByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String consolidationChartOfAccounts,
        final String financialStatementItem,
        final String consolidationVersion,
        final String fromFiscalYearPeriod )
    {
        super(servicePath, entityCollection);
        this.key.put("ConsolidationChartOfAccounts", consolidationChartOfAccounts);
        this.key.put("FinancialStatementItem", financialStatementItem);
        this.key.put("ConsolidationVersion", consolidationVersion);
        this.key.put("FromFiscalYearPeriod", fromFiscalYearPeriod);
    }

    @Override
    @Nonnull
    protected Class<FSItemAttribByTimeVersion> getEntityClass()
    {
        return FSItemAttribByTimeVersion.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
