/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.FSItemSelectionAttribField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.FSItemSelectionAttribLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.FSItemSelectionAttribSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Selection Attribute
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>FSItemSelectionAttribType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class FSItemSelectionAttrib extends VdmEntity<FSItemSelectionAttrib>
{

    /**
     * Selector for all available fields of FSItemSelectionAttrib.
     *
     */
    public final static FSItemSelectionAttribSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemAttributeName</b>
     * </p>
     *
     * @return Financial Statement Item Selection Attribute
     */
    @Key
    @SerializedName( "FSItemAttributeName" )
    @JsonProperty( "FSItemAttributeName" )
    @Nullable
    @ODataField( odataName = "FSItemAttributeName" )
    private String fSItemAttributeName;
    /**
     * Use with available fluent helpers to apply the <b>FSItemAttributeName</b> field to query operations.
     *
     */
    public final static FSItemSelectionAttribField<String> FS_ITEM_ATTRIBUTE_NAME =
        new FSItemSelectionAttribField<String>("FSItemAttributeName");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemAttributeName_Text</b>
     * </p>
     *
     * @return Financial Statement Item Selection Attribute Description
     */
    @SerializedName( "FSItemAttributeName_Text" )
    @JsonProperty( "FSItemAttributeName_Text" )
    @Nullable
    @ODataField( odataName = "FSItemAttributeName_Text" )
    private String fSItemAttributeName_Text;
    /**
     * Use with available fluent helpers to apply the <b>FSItemAttributeName_Text</b> field to query operations.
     *
     */
    public final static FSItemSelectionAttribField<String> FS_ITEM_ATTRIBUTE_NAME_TEXT =
        new FSItemSelectionAttribField<String>("FSItemAttributeName_Text");
    /**
     * Navigation property <b>to_CnsldtnFSItemSelAttribT</b> for <b>FSItemSelectionAttrib</b> to multiple
     * <b>FSItemSelectionAttribText</b>.
     *
     */
    @SerializedName( "to_CnsldtnFSItemSelAttribT" )
    @JsonProperty( "to_CnsldtnFSItemSelAttribT" )
    @ODataField( odataName = "to_CnsldtnFSItemSelAttribT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<FSItemSelectionAttribText> toCnsldtnFSItemSelAttribT;
    /**
     * Navigation property <b>to_CnsldtnFSItemSelAttribVal</b> for <b>FSItemSelectionAttrib</b> to multiple
     * <b>FSItemSelectionAttribVal</b>.
     *
     */
    @SerializedName( "to_CnsldtnFSItemSelAttribVal" )
    @JsonProperty( "to_CnsldtnFSItemSelAttribVal" )
    @ODataField( odataName = "to_CnsldtnFSItemSelAttribVal" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<FSItemSelectionAttribVal> toCnsldtnFSItemSelAttribVal;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnFSItemSelAttribT</b> navigation property to query
     * operations.
     *
     */
    public final static FSItemSelectionAttribLink<FSItemSelectionAttribText> TO_CNSLDTN_FS_ITEM_SEL_ATTRIB_T =
        new FSItemSelectionAttribLink<FSItemSelectionAttribText>("to_CnsldtnFSItemSelAttribT");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnFSItemSelAttribVal</b> navigation property to query
     * operations.
     *
     */
    public final static FSItemSelectionAttribLink<FSItemSelectionAttribVal> TO_CNSLDTN_FS_ITEM_SEL_ATTRIB_VAL =
        new FSItemSelectionAttribLink<FSItemSelectionAttribVal>("to_CnsldtnFSItemSelAttribVal");

    @Nonnull
    @Override
    public Class<FSItemSelectionAttrib> getType()
    {
        return FSItemSelectionAttrib.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemAttributeName</b>
     * </p>
     *
     * @param fSItemAttributeName
     *            Financial Statement Item Selection Attribute
     */
    public void setFSItemAttributeName( @Nullable final String fSItemAttributeName )
    {
        rememberChangedField("FSItemAttributeName", this.fSItemAttributeName);
        this.fSItemAttributeName = fSItemAttributeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemAttributeName_Text</b>
     * </p>
     *
     * @param fSItemAttributeName_Text
     *            Financial Statement Item Selection Attribute Description
     */
    public void setFSItemAttributeName_Text( @Nullable final String fSItemAttributeName_Text )
    {
        rememberChangedField("FSItemAttributeName_Text", this.fSItemAttributeName_Text);
        this.fSItemAttributeName_Text = fSItemAttributeName_Text;
    }

    @Override
    protected String getEntityCollection()
    {
        return "FSItemSelectionAttrib";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("FSItemAttributeName", getFSItemAttributeName());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("FSItemAttributeName", getFSItemAttributeName());
        values.put("FSItemAttributeName_Text", getFSItemAttributeName_Text());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("FSItemAttributeName") ) {
                final Object value = values.remove("FSItemAttributeName");
                if( (value == null) || (!value.equals(getFSItemAttributeName())) ) {
                    setFSItemAttributeName(((String) value));
                }
            }
            if( values.containsKey("FSItemAttributeName_Text") ) {
                final Object value = values.remove("FSItemAttributeName_Text");
                if( (value == null) || (!value.equals(getFSItemAttributeName_Text())) ) {
                    setFSItemAttributeName_Text(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnFSItemSelAttribT") ) {
                final Object value = (values).remove("to_CnsldtnFSItemSelAttribT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnFSItemSelAttribT == null ) {
                        toCnsldtnFSItemSelAttribT = Lists.newArrayList();
                    } else {
                        toCnsldtnFSItemSelAttribT = Lists.newArrayList(toCnsldtnFSItemSelAttribT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        FSItemSelectionAttribText entity;
                        if( toCnsldtnFSItemSelAttribT.size() > i ) {
                            entity = toCnsldtnFSItemSelAttribT.get(i);
                        } else {
                            entity = new FSItemSelectionAttribText();
                            toCnsldtnFSItemSelAttribT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CnsldtnFSItemSelAttribVal") ) {
                final Object value = (values).remove("to_CnsldtnFSItemSelAttribVal");
                if( value instanceof Iterable ) {
                    if( toCnsldtnFSItemSelAttribVal == null ) {
                        toCnsldtnFSItemSelAttribVal = Lists.newArrayList();
                    } else {
                        toCnsldtnFSItemSelAttribVal = Lists.newArrayList(toCnsldtnFSItemSelAttribVal);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        FSItemSelectionAttribVal entity;
                        if( toCnsldtnFSItemSelAttribVal.size() > i ) {
                            entity = toCnsldtnFSItemSelAttribVal.get(i);
                        } else {
                            entity = new FSItemSelectionAttribVal();
                            toCnsldtnFSItemSelAttribVal.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> FSItemSelectionAttribField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new FSItemSelectionAttribField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FSItemSelectionAttribField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FSItemSelectionAttribField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnFSItemSelAttribT != null ) {
            (values).put("to_CnsldtnFSItemSelAttribT", toCnsldtnFSItemSelAttribT);
        }
        if( toCnsldtnFSItemSelAttribVal != null ) {
            (values).put("to_CnsldtnFSItemSelAttribVal", toCnsldtnFSItemSelAttribVal);
        }
        return values;
    }

    /**
     * Fetches the <b>FSItemSelectionAttribText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CnsldtnFSItemSelAttribT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>FSItemSelectionAttribText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<FSItemSelectionAttribText> fetchCnsldtnFSItemSelAttribT()
    {
        return fetchFieldAsList("to_CnsldtnFSItemSelAttribT", FSItemSelectionAttribText.class);
    }

    /**
     * Retrieval of associated <b>FSItemSelectionAttribText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItemSelAttribT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItemSelAttribT</b> of a queried <b>FSItemSelectionAttrib</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>FSItemSelectionAttribText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<FSItemSelectionAttribText> getCnsldtnFSItemSelAttribTOrFetch()
    {
        if( toCnsldtnFSItemSelAttribT == null ) {
            toCnsldtnFSItemSelAttribT = fetchCnsldtnFSItemSelAttribT();
        }
        return toCnsldtnFSItemSelAttribT;
    }

    /**
     * Retrieval of associated <b>FSItemSelectionAttribText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItemSelAttribT</b>.
     * <p>
     * If the navigation property for an entity <b>FSItemSelectionAttrib</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnFSItemSelAttribT</b> is already loaded, the
     *         result will contain the <b>FSItemSelectionAttribText</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<FSItemSelectionAttribText>> getCnsldtnFSItemSelAttribTIfPresent()
    {
        return Option.of(toCnsldtnFSItemSelAttribT);
    }

    /**
     * Overwrites the list of associated <b>FSItemSelectionAttribText</b> entities for the loaded navigation property
     * <b>to_CnsldtnFSItemSelAttribT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItemSelAttribT</b> of a queried <b>FSItemSelectionAttrib</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>FSItemSelectionAttribText</b> entities.
     */
    public void setCnsldtnFSItemSelAttribT( @Nonnull final List<FSItemSelectionAttribText> value )
    {
        if( toCnsldtnFSItemSelAttribT == null ) {
            toCnsldtnFSItemSelAttribT = Lists.newArrayList();
        }
        toCnsldtnFSItemSelAttribT.clear();
        toCnsldtnFSItemSelAttribT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>FSItemSelectionAttribText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItemSelAttribT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItemSelAttribT</b> of a queried <b>FSItemSelectionAttrib</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>FSItemSelectionAttribText</b> entities.
     */
    public void addCnsldtnFSItemSelAttribT( FSItemSelectionAttribText... entity )
    {
        if( toCnsldtnFSItemSelAttribT == null ) {
            toCnsldtnFSItemSelAttribT = Lists.newArrayList();
        }
        toCnsldtnFSItemSelAttribT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>FSItemSelectionAttribVal</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CnsldtnFSItemSelAttribVal</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>FSItemSelectionAttribVal</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<FSItemSelectionAttribVal> fetchCnsldtnFSItemSelAttribVal()
    {
        return fetchFieldAsList("to_CnsldtnFSItemSelAttribVal", FSItemSelectionAttribVal.class);
    }

    /**
     * Retrieval of associated <b>FSItemSelectionAttribVal</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItemSelAttribVal</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItemSelAttribVal</b> of a queried <b>FSItemSelectionAttrib</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>FSItemSelectionAttribVal</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<FSItemSelectionAttribVal> getCnsldtnFSItemSelAttribValOrFetch()
    {
        if( toCnsldtnFSItemSelAttribVal == null ) {
            toCnsldtnFSItemSelAttribVal = fetchCnsldtnFSItemSelAttribVal();
        }
        return toCnsldtnFSItemSelAttribVal;
    }

    /**
     * Retrieval of associated <b>FSItemSelectionAttribVal</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItemSelAttribVal</b>.
     * <p>
     * If the navigation property for an entity <b>FSItemSelectionAttrib</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnFSItemSelAttribVal</b> is already loaded, the
     *         result will contain the <b>FSItemSelectionAttribVal</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<FSItemSelectionAttribVal>> getCnsldtnFSItemSelAttribValIfPresent()
    {
        return Option.of(toCnsldtnFSItemSelAttribVal);
    }

    /**
     * Overwrites the list of associated <b>FSItemSelectionAttribVal</b> entities for the loaded navigation property
     * <b>to_CnsldtnFSItemSelAttribVal</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItemSelAttribVal</b> of a queried <b>FSItemSelectionAttrib</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>FSItemSelectionAttribVal</b> entities.
     */
    public void setCnsldtnFSItemSelAttribVal( @Nonnull final List<FSItemSelectionAttribVal> value )
    {
        if( toCnsldtnFSItemSelAttribVal == null ) {
            toCnsldtnFSItemSelAttribVal = Lists.newArrayList();
        }
        toCnsldtnFSItemSelAttribVal.clear();
        toCnsldtnFSItemSelAttribVal.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>FSItemSelectionAttribVal</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItemSelAttribVal</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItemSelAttribVal</b> of a queried <b>FSItemSelectionAttrib</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>FSItemSelectionAttribVal</b> entities.
     */
    public void addCnsldtnFSItemSelAttribVal( FSItemSelectionAttribVal... entity )
    {
        if( toCnsldtnFSItemSelAttribVal == null ) {
            toCnsldtnFSItemSelAttribVal = Lists.newArrayList();
        }
        toCnsldtnFSItemSelAttribVal.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of FSItemSelectionAttrib instances.
     *
     */
    public final static class FSItemSelectionAttribBuilder
    {

        private List<FSItemSelectionAttribText> toCnsldtnFSItemSelAttribT = Lists.newArrayList();
        private List<FSItemSelectionAttribVal> toCnsldtnFSItemSelAttribVal = Lists.newArrayList();

        private FSItemSelectionAttrib.FSItemSelectionAttribBuilder toCnsldtnFSItemSelAttribT(
            final List<FSItemSelectionAttribText> value )
        {
            toCnsldtnFSItemSelAttribT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnFSItemSelAttribT</b> for <b>FSItemSelectionAttrib</b> to multiple
         * <b>FSItemSelectionAttribText</b>.
         *
         * @param value
         *            The FSItemSelectionAttribTexts to build this FSItemSelectionAttrib with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FSItemSelectionAttrib.FSItemSelectionAttribBuilder cnsldtnFSItemSelAttribT(
            FSItemSelectionAttribText... value )
        {
            return toCnsldtnFSItemSelAttribT(Lists.newArrayList(value));
        }

        private FSItemSelectionAttrib.FSItemSelectionAttribBuilder toCnsldtnFSItemSelAttribVal(
            final List<FSItemSelectionAttribVal> value )
        {
            toCnsldtnFSItemSelAttribVal.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnFSItemSelAttribVal</b> for <b>FSItemSelectionAttrib</b> to multiple
         * <b>FSItemSelectionAttribVal</b>.
         *
         * @param value
         *            The FSItemSelectionAttribVals to build this FSItemSelectionAttrib with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FSItemSelectionAttrib.FSItemSelectionAttribBuilder cnsldtnFSItemSelAttribVal(
            FSItemSelectionAttribVal... value )
        {
            return toCnsldtnFSItemSelAttribVal(Lists.newArrayList(value));
        }

    }

}
