/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.FSItemSelectionAttribTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.FSItemSelectionAttribTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.FSItemSelectionAttribTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Selection Attribute - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>FSItemSelectionAttribTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class FSItemSelectionAttribText extends VdmEntity<FSItemSelectionAttribText>
{

    /**
     * Selector for all available fields of FSItemSelectionAttribText.
     *
     */
    public final static FSItemSelectionAttribTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static FSItemSelectionAttribTextField<String> LANGUAGE =
        new FSItemSelectionAttribTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemAttributeName</b>
     * </p>
     *
     * @return Financial Statement Item Selection Attribute
     */
    @Key
    @SerializedName( "FSItemAttributeName" )
    @JsonProperty( "FSItemAttributeName" )
    @Nullable
    @ODataField( odataName = "FSItemAttributeName" )
    private String fSItemAttributeName;
    /**
     * Use with available fluent helpers to apply the <b>FSItemAttributeName</b> field to query operations.
     *
     */
    public final static FSItemSelectionAttribTextField<String> FS_ITEM_ATTRIBUTE_NAME =
        new FSItemSelectionAttribTextField<String>("FSItemAttributeName");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemAttributeText</b>
     * </p>
     *
     * @return Financial Statement Item Selection Attribute Description
     */
    @SerializedName( "FSItemAttributeText" )
    @JsonProperty( "FSItemAttributeText" )
    @Nullable
    @ODataField( odataName = "FSItemAttributeText" )
    private String fSItemAttributeText;
    /**
     * Use with available fluent helpers to apply the <b>FSItemAttributeText</b> field to query operations.
     *
     */
    public final static FSItemSelectionAttribTextField<String> FS_ITEM_ATTRIBUTE_TEXT =
        new FSItemSelectionAttribTextField<String>("FSItemAttributeText");
    /**
     * Navigation property <b>to_CnsldtnFSItemSelAttrib</b> for <b>FSItemSelectionAttribText</b> to single
     * <b>FSItemSelectionAttrib</b>.
     *
     */
    @SerializedName( "to_CnsldtnFSItemSelAttrib" )
    @JsonProperty( "to_CnsldtnFSItemSelAttrib" )
    @ODataField( odataName = "to_CnsldtnFSItemSelAttrib" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private FSItemSelectionAttrib toCnsldtnFSItemSelAttrib;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnFSItemSelAttrib</b> navigation property to query
     * operations.
     *
     */
    public final static FSItemSelectionAttribTextOneToOneLink<FSItemSelectionAttrib> TO_CNSLDTN_FS_ITEM_SEL_ATTRIB =
        new FSItemSelectionAttribTextOneToOneLink<FSItemSelectionAttrib>("to_CnsldtnFSItemSelAttrib");

    @Nonnull
    @Override
    public Class<FSItemSelectionAttribText> getType()
    {
        return FSItemSelectionAttribText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemAttributeName</b>
     * </p>
     *
     * @param fSItemAttributeName
     *            Financial Statement Item Selection Attribute
     */
    public void setFSItemAttributeName( @Nullable final String fSItemAttributeName )
    {
        rememberChangedField("FSItemAttributeName", this.fSItemAttributeName);
        this.fSItemAttributeName = fSItemAttributeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemAttributeText</b>
     * </p>
     *
     * @param fSItemAttributeText
     *            Financial Statement Item Selection Attribute Description
     */
    public void setFSItemAttributeText( @Nullable final String fSItemAttributeText )
    {
        rememberChangedField("FSItemAttributeText", this.fSItemAttributeText);
        this.fSItemAttributeText = fSItemAttributeText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "FSItemSelectionAttribText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("FSItemAttributeName", getFSItemAttributeName());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("FSItemAttributeName", getFSItemAttributeName());
        values.put("FSItemAttributeText", getFSItemAttributeText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("FSItemAttributeName") ) {
                final Object value = values.remove("FSItemAttributeName");
                if( (value == null) || (!value.equals(getFSItemAttributeName())) ) {
                    setFSItemAttributeName(((String) value));
                }
            }
            if( values.containsKey("FSItemAttributeText") ) {
                final Object value = values.remove("FSItemAttributeText");
                if( (value == null) || (!value.equals(getFSItemAttributeText())) ) {
                    setFSItemAttributeText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnFSItemSelAttrib") ) {
                final Object value = (values).remove("to_CnsldtnFSItemSelAttrib");
                if( value instanceof Map ) {
                    if( toCnsldtnFSItemSelAttrib == null ) {
                        toCnsldtnFSItemSelAttrib = new FSItemSelectionAttrib();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnFSItemSelAttrib.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> FSItemSelectionAttribTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new FSItemSelectionAttribTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FSItemSelectionAttribTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FSItemSelectionAttribTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnFSItemSelAttrib != null ) {
            (values).put("to_CnsldtnFSItemSelAttrib", toCnsldtnFSItemSelAttrib);
        }
        return values;
    }

    /**
     * Fetches the <b>FSItemSelectionAttrib</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnFSItemSelAttrib</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>FSItemSelectionAttrib</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public FSItemSelectionAttrib fetchCnsldtnFSItemSelAttrib()
    {
        return fetchFieldAsSingle("to_CnsldtnFSItemSelAttrib", FSItemSelectionAttrib.class);
    }

    /**
     * Retrieval of associated <b>FSItemSelectionAttrib</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItemSelAttrib</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItemSelAttrib</b> of a queried <b>FSItemSelectionAttribText</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>FSItemSelectionAttrib</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public FSItemSelectionAttrib getCnsldtnFSItemSelAttribOrFetch()
    {
        if( toCnsldtnFSItemSelAttrib == null ) {
            toCnsldtnFSItemSelAttrib = fetchCnsldtnFSItemSelAttrib();
        }
        return toCnsldtnFSItemSelAttrib;
    }

    /**
     * Retrieval of associated <b>FSItemSelectionAttrib</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItemSelAttrib</b>.
     * <p>
     * If the navigation property for an entity <b>FSItemSelectionAttribText</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnFSItemSelAttrib</b> is already loaded, the result
     *         will contain the <b>FSItemSelectionAttrib</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<FSItemSelectionAttrib> getCnsldtnFSItemSelAttribIfPresent()
    {
        return Option.of(toCnsldtnFSItemSelAttrib);
    }

    /**
     * Overwrites the associated <b>FSItemSelectionAttrib</b> entity for the loaded navigation property
     * <b>to_CnsldtnFSItemSelAttrib</b>.
     *
     * @param value
     *            New <b>FSItemSelectionAttrib</b> entity.
     */
    public void setCnsldtnFSItemSelAttrib( final FSItemSelectionAttrib value )
    {
        toCnsldtnFSItemSelAttrib = value;
    }

    /**
     * Helper class to allow for fluent creation of FSItemSelectionAttribText instances.
     *
     */
    public final static class FSItemSelectionAttribTextBuilder
    {

        private FSItemSelectionAttrib toCnsldtnFSItemSelAttrib;

        private FSItemSelectionAttribText.FSItemSelectionAttribTextBuilder toCnsldtnFSItemSelAttrib(
            final FSItemSelectionAttrib value )
        {
            toCnsldtnFSItemSelAttrib = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnFSItemSelAttrib</b> for <b>FSItemSelectionAttribText</b> to single
         * <b>FSItemSelectionAttrib</b>.
         *
         * @param value
         *            The FSItemSelectionAttrib to build this FSItemSelectionAttribText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FSItemSelectionAttribText.FSItemSelectionAttribTextBuilder cnsldtnFSItemSelAttrib(
            final FSItemSelectionAttrib value )
        {
            return toCnsldtnFSItemSelAttrib(value);
        }

    }

}
