/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.FSItemSelectionAttribValField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.FSItemSelectionAttribValLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.FSItemSelectionAttribValSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Selection Attribute Value
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>FSItemSelectionAttribValType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class FSItemSelectionAttribVal extends VdmEntity<FSItemSelectionAttribVal>
{

    /**
     * Selector for all available fields of FSItemSelectionAttribVal.
     *
     */
    public final static FSItemSelectionAttribValSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemAttributeName</b>
     * </p>
     *
     * @return Financial Statement Item Selection Attribute
     */
    @Key
    @SerializedName( "FSItemAttributeName" )
    @JsonProperty( "FSItemAttributeName" )
    @Nullable
    @ODataField( odataName = "FSItemAttributeName" )
    private String fSItemAttributeName;
    /**
     * Use with available fluent helpers to apply the <b>FSItemAttributeName</b> field to query operations.
     *
     */
    public final static FSItemSelectionAttribValField<String> FS_ITEM_ATTRIBUTE_NAME =
        new FSItemSelectionAttribValField<String>("FSItemAttributeName");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemAttributeName_Text</b>
     * </p>
     *
     * @return Financial Statement Item Selection Attribute Description
     */
    @SerializedName( "FSItemAttributeName_Text" )
    @JsonProperty( "FSItemAttributeName_Text" )
    @Nullable
    @ODataField( odataName = "FSItemAttributeName_Text" )
    private String fSItemAttributeName_Text;
    /**
     * Use with available fluent helpers to apply the <b>FSItemAttributeName_Text</b> field to query operations.
     *
     */
    public final static FSItemSelectionAttribValField<String> FS_ITEM_ATTRIBUTE_NAME_TEXT =
        new FSItemSelectionAttribValField<String>("FSItemAttributeName_Text");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemAttributeValueName</b>
     * </p>
     *
     * @return Financial Statement Item Selection Attribute Value
     */
    @Key
    @SerializedName( "FSItemAttributeValueName" )
    @JsonProperty( "FSItemAttributeValueName" )
    @Nullable
    @ODataField( odataName = "FSItemAttributeValueName" )
    private String fSItemAttributeValueName;
    /**
     * Use with available fluent helpers to apply the <b>FSItemAttributeValueName</b> field to query operations.
     *
     */
    public final static FSItemSelectionAttribValField<String> FS_ITEM_ATTRIBUTE_VALUE_NAME =
        new FSItemSelectionAttribValField<String>("FSItemAttributeValueName");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemAttributeValueName_Text</b>
     * </p>
     *
     * @return Financial Statement Item Selection Attribute Value Description
     */
    @SerializedName( "FSItemAttributeValueName_Text" )
    @JsonProperty( "FSItemAttributeValueName_Text" )
    @Nullable
    @ODataField( odataName = "FSItemAttributeValueName_Text" )
    private String fSItemAttributeValueName_Text;
    /**
     * Use with available fluent helpers to apply the <b>FSItemAttributeValueName_Text</b> field to query operations.
     *
     */
    public final static FSItemSelectionAttribValField<String> FS_ITEM_ATTRIBUTE_VALUE_NAME_TEXT =
        new FSItemSelectionAttribValField<String>("FSItemAttributeValueName_Text");
    /**
     * Navigation property <b>to_CnsldtnFSItemSelAttribValT</b> for <b>FSItemSelectionAttribVal</b> to multiple
     * <b>FSItemSelectionAttribValText</b>.
     *
     */
    @SerializedName( "to_CnsldtnFSItemSelAttribValT" )
    @JsonProperty( "to_CnsldtnFSItemSelAttribValT" )
    @ODataField( odataName = "to_CnsldtnFSItemSelAttribValT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<FSItemSelectionAttribValText> toCnsldtnFSItemSelAttribValT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnFSItemSelAttribValT</b> navigation property to query
     * operations.
     *
     */
    public final static FSItemSelectionAttribValLink<FSItemSelectionAttribValText> TO_CNSLDTN_FS_ITEM_SEL_ATTRIB_VAL_T =
        new FSItemSelectionAttribValLink<FSItemSelectionAttribValText>("to_CnsldtnFSItemSelAttribValT");

    @Nonnull
    @Override
    public Class<FSItemSelectionAttribVal> getType()
    {
        return FSItemSelectionAttribVal.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemAttributeName</b>
     * </p>
     *
     * @param fSItemAttributeName
     *            Financial Statement Item Selection Attribute
     */
    public void setFSItemAttributeName( @Nullable final String fSItemAttributeName )
    {
        rememberChangedField("FSItemAttributeName", this.fSItemAttributeName);
        this.fSItemAttributeName = fSItemAttributeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemAttributeName_Text</b>
     * </p>
     *
     * @param fSItemAttributeName_Text
     *            Financial Statement Item Selection Attribute Description
     */
    public void setFSItemAttributeName_Text( @Nullable final String fSItemAttributeName_Text )
    {
        rememberChangedField("FSItemAttributeName_Text", this.fSItemAttributeName_Text);
        this.fSItemAttributeName_Text = fSItemAttributeName_Text;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemAttributeValueName</b>
     * </p>
     *
     * @param fSItemAttributeValueName
     *            Financial Statement Item Selection Attribute Value
     */
    public void setFSItemAttributeValueName( @Nullable final String fSItemAttributeValueName )
    {
        rememberChangedField("FSItemAttributeValueName", this.fSItemAttributeValueName);
        this.fSItemAttributeValueName = fSItemAttributeValueName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemAttributeValueName_Text</b>
     * </p>
     *
     * @param fSItemAttributeValueName_Text
     *            Financial Statement Item Selection Attribute Value Description
     */
    public void setFSItemAttributeValueName_Text( @Nullable final String fSItemAttributeValueName_Text )
    {
        rememberChangedField("FSItemAttributeValueName_Text", this.fSItemAttributeValueName_Text);
        this.fSItemAttributeValueName_Text = fSItemAttributeValueName_Text;
    }

    @Override
    protected String getEntityCollection()
    {
        return "FSItemSelectionAttribVal";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("FSItemAttributeName", getFSItemAttributeName());
        result.put("FSItemAttributeValueName", getFSItemAttributeValueName());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("FSItemAttributeName", getFSItemAttributeName());
        values.put("FSItemAttributeName_Text", getFSItemAttributeName_Text());
        values.put("FSItemAttributeValueName", getFSItemAttributeValueName());
        values.put("FSItemAttributeValueName_Text", getFSItemAttributeValueName_Text());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("FSItemAttributeName") ) {
                final Object value = values.remove("FSItemAttributeName");
                if( (value == null) || (!value.equals(getFSItemAttributeName())) ) {
                    setFSItemAttributeName(((String) value));
                }
            }
            if( values.containsKey("FSItemAttributeName_Text") ) {
                final Object value = values.remove("FSItemAttributeName_Text");
                if( (value == null) || (!value.equals(getFSItemAttributeName_Text())) ) {
                    setFSItemAttributeName_Text(((String) value));
                }
            }
            if( values.containsKey("FSItemAttributeValueName") ) {
                final Object value = values.remove("FSItemAttributeValueName");
                if( (value == null) || (!value.equals(getFSItemAttributeValueName())) ) {
                    setFSItemAttributeValueName(((String) value));
                }
            }
            if( values.containsKey("FSItemAttributeValueName_Text") ) {
                final Object value = values.remove("FSItemAttributeValueName_Text");
                if( (value == null) || (!value.equals(getFSItemAttributeValueName_Text())) ) {
                    setFSItemAttributeValueName_Text(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnFSItemSelAttribValT") ) {
                final Object value = (values).remove("to_CnsldtnFSItemSelAttribValT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnFSItemSelAttribValT == null ) {
                        toCnsldtnFSItemSelAttribValT = Lists.newArrayList();
                    } else {
                        toCnsldtnFSItemSelAttribValT = Lists.newArrayList(toCnsldtnFSItemSelAttribValT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        FSItemSelectionAttribValText entity;
                        if( toCnsldtnFSItemSelAttribValT.size() > i ) {
                            entity = toCnsldtnFSItemSelAttribValT.get(i);
                        } else {
                            entity = new FSItemSelectionAttribValText();
                            toCnsldtnFSItemSelAttribValT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> FSItemSelectionAttribValField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new FSItemSelectionAttribValField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FSItemSelectionAttribValField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FSItemSelectionAttribValField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnFSItemSelAttribValT != null ) {
            (values).put("to_CnsldtnFSItemSelAttribValT", toCnsldtnFSItemSelAttribValT);
        }
        return values;
    }

    /**
     * Fetches the <b>FSItemSelectionAttribValText</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_CnsldtnFSItemSelAttribValT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>FSItemSelectionAttribValText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<FSItemSelectionAttribValText> fetchCnsldtnFSItemSelAttribValT()
    {
        return fetchFieldAsList("to_CnsldtnFSItemSelAttribValT", FSItemSelectionAttribValText.class);
    }

    /**
     * Retrieval of associated <b>FSItemSelectionAttribValText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItemSelAttribValT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItemSelAttribValT</b> of a queried <b>FSItemSelectionAttribVal</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>FSItemSelectionAttribValText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<FSItemSelectionAttribValText> getCnsldtnFSItemSelAttribValTOrFetch()
    {
        if( toCnsldtnFSItemSelAttribValT == null ) {
            toCnsldtnFSItemSelAttribValT = fetchCnsldtnFSItemSelAttribValT();
        }
        return toCnsldtnFSItemSelAttribValT;
    }

    /**
     * Retrieval of associated <b>FSItemSelectionAttribValText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItemSelAttribValT</b>.
     * <p>
     * If the navigation property for an entity <b>FSItemSelectionAttribVal</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnFSItemSelAttribValT</b> is already loaded, the
     *         result will contain the <b>FSItemSelectionAttribValText</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<FSItemSelectionAttribValText>> getCnsldtnFSItemSelAttribValTIfPresent()
    {
        return Option.of(toCnsldtnFSItemSelAttribValT);
    }

    /**
     * Overwrites the list of associated <b>FSItemSelectionAttribValText</b> entities for the loaded navigation property
     * <b>to_CnsldtnFSItemSelAttribValT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItemSelAttribValT</b> of a queried <b>FSItemSelectionAttribVal</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>FSItemSelectionAttribValText</b> entities.
     */
    public void setCnsldtnFSItemSelAttribValT( @Nonnull final List<FSItemSelectionAttribValText> value )
    {
        if( toCnsldtnFSItemSelAttribValT == null ) {
            toCnsldtnFSItemSelAttribValT = Lists.newArrayList();
        }
        toCnsldtnFSItemSelAttribValT.clear();
        toCnsldtnFSItemSelAttribValT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>FSItemSelectionAttribValText</b> entities. This corresponds to the
     * OData navigation property <b>to_CnsldtnFSItemSelAttribValT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItemSelAttribValT</b> of a queried <b>FSItemSelectionAttribVal</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>FSItemSelectionAttribValText</b> entities.
     */
    public void addCnsldtnFSItemSelAttribValT( FSItemSelectionAttribValText... entity )
    {
        if( toCnsldtnFSItemSelAttribValT == null ) {
            toCnsldtnFSItemSelAttribValT = Lists.newArrayList();
        }
        toCnsldtnFSItemSelAttribValT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of FSItemSelectionAttribVal instances.
     *
     */
    public final static class FSItemSelectionAttribValBuilder
    {

        private List<FSItemSelectionAttribValText> toCnsldtnFSItemSelAttribValT = Lists.newArrayList();

        private FSItemSelectionAttribVal.FSItemSelectionAttribValBuilder toCnsldtnFSItemSelAttribValT(
            final List<FSItemSelectionAttribValText> value )
        {
            toCnsldtnFSItemSelAttribValT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnFSItemSelAttribValT</b> for <b>FSItemSelectionAttribVal</b> to multiple
         * <b>FSItemSelectionAttribValText</b>.
         *
         * @param value
         *            The FSItemSelectionAttribValTexts to build this FSItemSelectionAttribVal with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FSItemSelectionAttribVal.FSItemSelectionAttribValBuilder cnsldtnFSItemSelAttribValT(
            FSItemSelectionAttribValText... value )
        {
            return toCnsldtnFSItemSelAttribValT(Lists.newArrayList(value));
        }

    }

}
