/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.FSItemSelectionAttribValTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.FSItemSelectionAttribValTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.FSItemSelectionAttribValTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Selection Attribute Value - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>FSItemSelectionAttribValTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class FSItemSelectionAttribValText extends VdmEntity<FSItemSelectionAttribValText>
{

    /**
     * Selector for all available fields of FSItemSelectionAttribValText.
     *
     */
    public final static FSItemSelectionAttribValTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static FSItemSelectionAttribValTextField<String> LANGUAGE =
        new FSItemSelectionAttribValTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemAttributeName</b>
     * </p>
     *
     * @return Financial Statement Item Selection Attribute
     */
    @Key
    @SerializedName( "FSItemAttributeName" )
    @JsonProperty( "FSItemAttributeName" )
    @Nullable
    @ODataField( odataName = "FSItemAttributeName" )
    private String fSItemAttributeName;
    /**
     * Use with available fluent helpers to apply the <b>FSItemAttributeName</b> field to query operations.
     *
     */
    public final static FSItemSelectionAttribValTextField<String> FS_ITEM_ATTRIBUTE_NAME =
        new FSItemSelectionAttribValTextField<String>("FSItemAttributeName");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemAttributeName_Text</b>
     * </p>
     *
     * @return Financial Statement Item Selection Attribute Description
     */
    @SerializedName( "FSItemAttributeName_Text" )
    @JsonProperty( "FSItemAttributeName_Text" )
    @Nullable
    @ODataField( odataName = "FSItemAttributeName_Text" )
    private String fSItemAttributeName_Text;
    /**
     * Use with available fluent helpers to apply the <b>FSItemAttributeName_Text</b> field to query operations.
     *
     */
    public final static FSItemSelectionAttribValTextField<String> FS_ITEM_ATTRIBUTE_NAME_TEXT =
        new FSItemSelectionAttribValTextField<String>("FSItemAttributeName_Text");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemAttributeValueName</b>
     * </p>
     *
     * @return Financial Statement Item Selection Attribute Value
     */
    @Key
    @SerializedName( "FSItemAttributeValueName" )
    @JsonProperty( "FSItemAttributeValueName" )
    @Nullable
    @ODataField( odataName = "FSItemAttributeValueName" )
    private String fSItemAttributeValueName;
    /**
     * Use with available fluent helpers to apply the <b>FSItemAttributeValueName</b> field to query operations.
     *
     */
    public final static FSItemSelectionAttribValTextField<String> FS_ITEM_ATTRIBUTE_VALUE_NAME =
        new FSItemSelectionAttribValTextField<String>("FSItemAttributeValueName");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemAttributeValueText</b>
     * </p>
     *
     * @return Financial Statement Item Selection Attribute Value Description
     */
    @SerializedName( "FSItemAttributeValueText" )
    @JsonProperty( "FSItemAttributeValueText" )
    @Nullable
    @ODataField( odataName = "FSItemAttributeValueText" )
    private String fSItemAttributeValueText;
    /**
     * Use with available fluent helpers to apply the <b>FSItemAttributeValueText</b> field to query operations.
     *
     */
    public final static FSItemSelectionAttribValTextField<String> FS_ITEM_ATTRIBUTE_VALUE_TEXT =
        new FSItemSelectionAttribValTextField<String>("FSItemAttributeValueText");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>FSItemAttributeValueLongText</b>
     * </p>
     *
     * @return Financial Statement Item Selection Attribute Value Long Description
     */
    @SerializedName( "FSItemAttributeValueLongText" )
    @JsonProperty( "FSItemAttributeValueLongText" )
    @Nullable
    @ODataField( odataName = "FSItemAttributeValueLongText" )
    private String fSItemAttributeValueLongText;
    /**
     * Use with available fluent helpers to apply the <b>FSItemAttributeValueLongText</b> field to query operations.
     *
     */
    public final static FSItemSelectionAttribValTextField<String> FS_ITEM_ATTRIBUTE_VALUE_LONG_TEXT =
        new FSItemSelectionAttribValTextField<String>("FSItemAttributeValueLongText");
    /**
     * Navigation property <b>to_CnsldtnFSItemSelAttribVal</b> for <b>FSItemSelectionAttribValText</b> to single
     * <b>FSItemSelectionAttribVal</b>.
     *
     */
    @SerializedName( "to_CnsldtnFSItemSelAttribVal" )
    @JsonProperty( "to_CnsldtnFSItemSelAttribVal" )
    @ODataField( odataName = "to_CnsldtnFSItemSelAttribVal" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private FSItemSelectionAttribVal toCnsldtnFSItemSelAttribVal;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnFSItemSelAttribVal</b> navigation property to query
     * operations.
     *
     */
    public final static FSItemSelectionAttribValTextOneToOneLink<FSItemSelectionAttribVal> TO_CNSLDTN_FS_ITEM_SEL_ATTRIB_VAL =
        new FSItemSelectionAttribValTextOneToOneLink<FSItemSelectionAttribVal>("to_CnsldtnFSItemSelAttribVal");

    @Nonnull
    @Override
    public Class<FSItemSelectionAttribValText> getType()
    {
        return FSItemSelectionAttribValText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemAttributeName</b>
     * </p>
     *
     * @param fSItemAttributeName
     *            Financial Statement Item Selection Attribute
     */
    public void setFSItemAttributeName( @Nullable final String fSItemAttributeName )
    {
        rememberChangedField("FSItemAttributeName", this.fSItemAttributeName);
        this.fSItemAttributeName = fSItemAttributeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemAttributeName_Text</b>
     * </p>
     *
     * @param fSItemAttributeName_Text
     *            Financial Statement Item Selection Attribute Description
     */
    public void setFSItemAttributeName_Text( @Nullable final String fSItemAttributeName_Text )
    {
        rememberChangedField("FSItemAttributeName_Text", this.fSItemAttributeName_Text);
        this.fSItemAttributeName_Text = fSItemAttributeName_Text;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemAttributeValueName</b>
     * </p>
     *
     * @param fSItemAttributeValueName
     *            Financial Statement Item Selection Attribute Value
     */
    public void setFSItemAttributeValueName( @Nullable final String fSItemAttributeValueName )
    {
        rememberChangedField("FSItemAttributeValueName", this.fSItemAttributeValueName);
        this.fSItemAttributeValueName = fSItemAttributeValueName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemAttributeValueText</b>
     * </p>
     *
     * @param fSItemAttributeValueText
     *            Financial Statement Item Selection Attribute Value Description
     */
    public void setFSItemAttributeValueText( @Nullable final String fSItemAttributeValueText )
    {
        rememberChangedField("FSItemAttributeValueText", this.fSItemAttributeValueText);
        this.fSItemAttributeValueText = fSItemAttributeValueText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>FSItemAttributeValueLongText</b>
     * </p>
     *
     * @param fSItemAttributeValueLongText
     *            Financial Statement Item Selection Attribute Value Long Description
     */
    public void setFSItemAttributeValueLongText( @Nullable final String fSItemAttributeValueLongText )
    {
        rememberChangedField("FSItemAttributeValueLongText", this.fSItemAttributeValueLongText);
        this.fSItemAttributeValueLongText = fSItemAttributeValueLongText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "FSItemSelectionAttribValText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("FSItemAttributeName", getFSItemAttributeName());
        result.put("FSItemAttributeValueName", getFSItemAttributeValueName());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("FSItemAttributeName", getFSItemAttributeName());
        values.put("FSItemAttributeName_Text", getFSItemAttributeName_Text());
        values.put("FSItemAttributeValueName", getFSItemAttributeValueName());
        values.put("FSItemAttributeValueText", getFSItemAttributeValueText());
        values.put("FSItemAttributeValueLongText", getFSItemAttributeValueLongText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("FSItemAttributeName") ) {
                final Object value = values.remove("FSItemAttributeName");
                if( (value == null) || (!value.equals(getFSItemAttributeName())) ) {
                    setFSItemAttributeName(((String) value));
                }
            }
            if( values.containsKey("FSItemAttributeName_Text") ) {
                final Object value = values.remove("FSItemAttributeName_Text");
                if( (value == null) || (!value.equals(getFSItemAttributeName_Text())) ) {
                    setFSItemAttributeName_Text(((String) value));
                }
            }
            if( values.containsKey("FSItemAttributeValueName") ) {
                final Object value = values.remove("FSItemAttributeValueName");
                if( (value == null) || (!value.equals(getFSItemAttributeValueName())) ) {
                    setFSItemAttributeValueName(((String) value));
                }
            }
            if( values.containsKey("FSItemAttributeValueText") ) {
                final Object value = values.remove("FSItemAttributeValueText");
                if( (value == null) || (!value.equals(getFSItemAttributeValueText())) ) {
                    setFSItemAttributeValueText(((String) value));
                }
            }
            if( values.containsKey("FSItemAttributeValueLongText") ) {
                final Object value = values.remove("FSItemAttributeValueLongText");
                if( (value == null) || (!value.equals(getFSItemAttributeValueLongText())) ) {
                    setFSItemAttributeValueLongText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnFSItemSelAttribVal") ) {
                final Object value = (values).remove("to_CnsldtnFSItemSelAttribVal");
                if( value instanceof Map ) {
                    if( toCnsldtnFSItemSelAttribVal == null ) {
                        toCnsldtnFSItemSelAttribVal = new FSItemSelectionAttribVal();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnFSItemSelAttribVal.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> FSItemSelectionAttribValTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new FSItemSelectionAttribValTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FSItemSelectionAttribValTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FSItemSelectionAttribValTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnFSItemSelAttribVal != null ) {
            (values).put("to_CnsldtnFSItemSelAttribVal", toCnsldtnFSItemSelAttribVal);
        }
        return values;
    }

    /**
     * Fetches the <b>FSItemSelectionAttribVal</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CnsldtnFSItemSelAttribVal</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>FSItemSelectionAttribVal</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public FSItemSelectionAttribVal fetchCnsldtnFSItemSelAttribVal()
    {
        return fetchFieldAsSingle("to_CnsldtnFSItemSelAttribVal", FSItemSelectionAttribVal.class);
    }

    /**
     * Retrieval of associated <b>FSItemSelectionAttribVal</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItemSelAttribVal</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItemSelAttribVal</b> of a queried <b>FSItemSelectionAttribValText</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>FSItemSelectionAttribVal</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public FSItemSelectionAttribVal getCnsldtnFSItemSelAttribValOrFetch()
    {
        if( toCnsldtnFSItemSelAttribVal == null ) {
            toCnsldtnFSItemSelAttribVal = fetchCnsldtnFSItemSelAttribVal();
        }
        return toCnsldtnFSItemSelAttribVal;
    }

    /**
     * Retrieval of associated <b>FSItemSelectionAttribVal</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItemSelAttribVal</b>.
     * <p>
     * If the navigation property for an entity <b>FSItemSelectionAttribValText</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnFSItemSelAttribVal</b> is already loaded, the
     *         result will contain the <b>FSItemSelectionAttribVal</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<FSItemSelectionAttribVal> getCnsldtnFSItemSelAttribValIfPresent()
    {
        return Option.of(toCnsldtnFSItemSelAttribVal);
    }

    /**
     * Overwrites the associated <b>FSItemSelectionAttribVal</b> entity for the loaded navigation property
     * <b>to_CnsldtnFSItemSelAttribVal</b>.
     *
     * @param value
     *            New <b>FSItemSelectionAttribVal</b> entity.
     */
    public void setCnsldtnFSItemSelAttribVal( final FSItemSelectionAttribVal value )
    {
        toCnsldtnFSItemSelAttribVal = value;
    }

    /**
     * Helper class to allow for fluent creation of FSItemSelectionAttribValText instances.
     *
     */
    public final static class FSItemSelectionAttribValTextBuilder
    {

        private FSItemSelectionAttribVal toCnsldtnFSItemSelAttribVal;

        private FSItemSelectionAttribValText.FSItemSelectionAttribValTextBuilder toCnsldtnFSItemSelAttribVal(
            final FSItemSelectionAttribVal value )
        {
            toCnsldtnFSItemSelAttribVal = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnFSItemSelAttribVal</b> for <b>FSItemSelectionAttribValText</b> to single
         * <b>FSItemSelectionAttribVal</b>.
         *
         * @param value
         *            The FSItemSelectionAttribVal to build this FSItemSelectionAttribValText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FSItemSelectionAttribValText.FSItemSelectionAttribValTextBuilder cnsldtnFSItemSelAttribVal(
            final FSItemSelectionAttribVal value )
        {
            return toCnsldtnFSItemSelAttribVal(value);
        }

    }

}
