/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.FSItemSelectionAttribValTextSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemSelectionAttribValText
 * FSItemSelectionAttribValText} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class FSItemSelectionAttribValTextByKeyFluentHelper
    extends
    FluentHelperByKey<FSItemSelectionAttribValTextByKeyFluentHelper, FSItemSelectionAttribValText, FSItemSelectionAttribValTextSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemSelectionAttribValText
     * FSItemSelectionAttribValText} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code FSItemSelectionAttribValText}
     * @param fSItemAttributeValueName
     *            Financial Statement Item Selection Attribute Value
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     * @param fSItemAttributeName
     *            Financial Statement Item Selection Attribute
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code FSItemSelectionAttribValText}
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     */
    public FSItemSelectionAttribValTextByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String language,
        final String fSItemAttributeName,
        final String fSItemAttributeValueName )
    {
        super(servicePath, entityCollection);
        this.key.put("Language", language);
        this.key.put("FSItemAttributeName", fSItemAttributeName);
        this.key.put("FSItemAttributeValueName", fSItemAttributeValueName);
    }

    @Override
    @Nonnull
    protected Class<FSItemSelectionAttribValText> getEntityClass()
    {
        return FSItemSelectionAttribValText.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
