/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.FSItemTargetAttribField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.FSItemTargetAttribLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.FSItemTargetAttribSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Target Attribute
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>FSItemTargetAttribType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class FSItemTargetAttrib extends VdmEntity<FSItemTargetAttrib>
{

    /**
     * Selector for all available fields of FSItemTargetAttrib.
     *
     */
    public final static FSItemTargetAttribSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemAttributeName</b>
     * </p>
     *
     * @return Financial Statement Item Target Attribute
     */
    @Key
    @SerializedName( "FSItemAttributeName" )
    @JsonProperty( "FSItemAttributeName" )
    @Nullable
    @ODataField( odataName = "FSItemAttributeName" )
    private String fSItemAttributeName;
    /**
     * Use with available fluent helpers to apply the <b>FSItemAttributeName</b> field to query operations.
     *
     */
    public final static FSItemTargetAttribField<String> FS_ITEM_ATTRIBUTE_NAME =
        new FSItemTargetAttribField<String>("FSItemAttributeName");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemAttributeName_Text</b>
     * </p>
     *
     * @return Financial Statement Item Target Attribute Description
     */
    @SerializedName( "FSItemAttributeName_Text" )
    @JsonProperty( "FSItemAttributeName_Text" )
    @Nullable
    @ODataField( odataName = "FSItemAttributeName_Text" )
    private String fSItemAttributeName_Text;
    /**
     * Use with available fluent helpers to apply the <b>FSItemAttributeName_Text</b> field to query operations.
     *
     */
    public final static FSItemTargetAttribField<String> FS_ITEM_ATTRIBUTE_NAME_TEXT =
        new FSItemTargetAttribField<String>("FSItemAttributeName_Text");
    /**
     * Navigation property <b>to_CnsldtnFSItemTgtAttribT</b> for <b>FSItemTargetAttrib</b> to multiple
     * <b>FSItemTargetAttribText</b>.
     *
     */
    @SerializedName( "to_CnsldtnFSItemTgtAttribT" )
    @JsonProperty( "to_CnsldtnFSItemTgtAttribT" )
    @ODataField( odataName = "to_CnsldtnFSItemTgtAttribT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<FSItemTargetAttribText> toCnsldtnFSItemTgtAttribT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnFSItemTgtAttribT</b> navigation property to query
     * operations.
     *
     */
    public final static FSItemTargetAttribLink<FSItemTargetAttribText> TO_CNSLDTN_FS_ITEM_TGT_ATTRIB_T =
        new FSItemTargetAttribLink<FSItemTargetAttribText>("to_CnsldtnFSItemTgtAttribT");

    @Nonnull
    @Override
    public Class<FSItemTargetAttrib> getType()
    {
        return FSItemTargetAttrib.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemAttributeName</b>
     * </p>
     *
     * @param fSItemAttributeName
     *            Financial Statement Item Target Attribute
     */
    public void setFSItemAttributeName( @Nullable final String fSItemAttributeName )
    {
        rememberChangedField("FSItemAttributeName", this.fSItemAttributeName);
        this.fSItemAttributeName = fSItemAttributeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemAttributeName_Text</b>
     * </p>
     *
     * @param fSItemAttributeName_Text
     *            Financial Statement Item Target Attribute Description
     */
    public void setFSItemAttributeName_Text( @Nullable final String fSItemAttributeName_Text )
    {
        rememberChangedField("FSItemAttributeName_Text", this.fSItemAttributeName_Text);
        this.fSItemAttributeName_Text = fSItemAttributeName_Text;
    }

    @Override
    protected String getEntityCollection()
    {
        return "FSItemTargetAttrib";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("FSItemAttributeName", getFSItemAttributeName());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("FSItemAttributeName", getFSItemAttributeName());
        values.put("FSItemAttributeName_Text", getFSItemAttributeName_Text());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("FSItemAttributeName") ) {
                final Object value = values.remove("FSItemAttributeName");
                if( (value == null) || (!value.equals(getFSItemAttributeName())) ) {
                    setFSItemAttributeName(((String) value));
                }
            }
            if( values.containsKey("FSItemAttributeName_Text") ) {
                final Object value = values.remove("FSItemAttributeName_Text");
                if( (value == null) || (!value.equals(getFSItemAttributeName_Text())) ) {
                    setFSItemAttributeName_Text(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnFSItemTgtAttribT") ) {
                final Object value = (values).remove("to_CnsldtnFSItemTgtAttribT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnFSItemTgtAttribT == null ) {
                        toCnsldtnFSItemTgtAttribT = Lists.newArrayList();
                    } else {
                        toCnsldtnFSItemTgtAttribT = Lists.newArrayList(toCnsldtnFSItemTgtAttribT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        FSItemTargetAttribText entity;
                        if( toCnsldtnFSItemTgtAttribT.size() > i ) {
                            entity = toCnsldtnFSItemTgtAttribT.get(i);
                        } else {
                            entity = new FSItemTargetAttribText();
                            toCnsldtnFSItemTgtAttribT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> FSItemTargetAttribField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new FSItemTargetAttribField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FSItemTargetAttribField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FSItemTargetAttribField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnFSItemTgtAttribT != null ) {
            (values).put("to_CnsldtnFSItemTgtAttribT", toCnsldtnFSItemTgtAttribT);
        }
        return values;
    }

    /**
     * Fetches the <b>FSItemTargetAttribText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CnsldtnFSItemTgtAttribT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>FSItemTargetAttribText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<FSItemTargetAttribText> fetchCnsldtnFSItemTgtAttribT()
    {
        return fetchFieldAsList("to_CnsldtnFSItemTgtAttribT", FSItemTargetAttribText.class);
    }

    /**
     * Retrieval of associated <b>FSItemTargetAttribText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItemTgtAttribT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItemTgtAttribT</b> of a queried <b>FSItemTargetAttrib</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>FSItemTargetAttribText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<FSItemTargetAttribText> getCnsldtnFSItemTgtAttribTOrFetch()
    {
        if( toCnsldtnFSItemTgtAttribT == null ) {
            toCnsldtnFSItemTgtAttribT = fetchCnsldtnFSItemTgtAttribT();
        }
        return toCnsldtnFSItemTgtAttribT;
    }

    /**
     * Retrieval of associated <b>FSItemTargetAttribText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItemTgtAttribT</b>.
     * <p>
     * If the navigation property for an entity <b>FSItemTargetAttrib</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnFSItemTgtAttribT</b> is already loaded, the
     *         result will contain the <b>FSItemTargetAttribText</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<FSItemTargetAttribText>> getCnsldtnFSItemTgtAttribTIfPresent()
    {
        return Option.of(toCnsldtnFSItemTgtAttribT);
    }

    /**
     * Overwrites the list of associated <b>FSItemTargetAttribText</b> entities for the loaded navigation property
     * <b>to_CnsldtnFSItemTgtAttribT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItemTgtAttribT</b> of a queried <b>FSItemTargetAttrib</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>FSItemTargetAttribText</b> entities.
     */
    public void setCnsldtnFSItemTgtAttribT( @Nonnull final List<FSItemTargetAttribText> value )
    {
        if( toCnsldtnFSItemTgtAttribT == null ) {
            toCnsldtnFSItemTgtAttribT = Lists.newArrayList();
        }
        toCnsldtnFSItemTgtAttribT.clear();
        toCnsldtnFSItemTgtAttribT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>FSItemTargetAttribText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItemTgtAttribT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItemTgtAttribT</b> of a queried <b>FSItemTargetAttrib</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>FSItemTargetAttribText</b> entities.
     */
    public void addCnsldtnFSItemTgtAttribT( FSItemTargetAttribText... entity )
    {
        if( toCnsldtnFSItemTgtAttribT == null ) {
            toCnsldtnFSItemTgtAttribT = Lists.newArrayList();
        }
        toCnsldtnFSItemTgtAttribT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of FSItemTargetAttrib instances.
     *
     */
    public final static class FSItemTargetAttribBuilder
    {

        private List<FSItemTargetAttribText> toCnsldtnFSItemTgtAttribT = Lists.newArrayList();

        private FSItemTargetAttrib.FSItemTargetAttribBuilder toCnsldtnFSItemTgtAttribT(
            final List<FSItemTargetAttribText> value )
        {
            toCnsldtnFSItemTgtAttribT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnFSItemTgtAttribT</b> for <b>FSItemTargetAttrib</b> to multiple
         * <b>FSItemTargetAttribText</b>.
         *
         * @param value
         *            The FSItemTargetAttribTexts to build this FSItemTargetAttrib with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FSItemTargetAttrib.FSItemTargetAttribBuilder cnsldtnFSItemTgtAttribT( FSItemTargetAttribText... value )
        {
            return toCnsldtnFSItemTgtAttribT(Lists.newArrayList(value));
        }

    }

}
