/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.FSItemTargetAttribSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemTargetAttrib
 * FSItemTargetAttrib} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class FSItemTargetAttribByKeyFluentHelper
    extends
    FluentHelperByKey<FSItemTargetAttribByKeyFluentHelper, FSItemTargetAttrib, FSItemTargetAttribSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemTargetAttrib
     * FSItemTargetAttrib} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code FSItemTargetAttrib}
     * @param fSItemAttributeName
     *            Financial Statement Item Target Attribute
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code FSItemTargetAttrib}
     */
    public FSItemTargetAttribByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String fSItemAttributeName )
    {
        super(servicePath, entityCollection);
        this.key.put("FSItemAttributeName", fSItemAttributeName);
    }

    @Override
    @Nonnull
    protected Class<FSItemTargetAttrib> getEntityClass()
    {
        return FSItemTargetAttrib.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
