/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.FSItemTargetAttribTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.FSItemTargetAttribTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.FSItemTargetAttribTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Target Attribute - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>FSItemTargetAttribTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class FSItemTargetAttribText extends VdmEntity<FSItemTargetAttribText>
{

    /**
     * Selector for all available fields of FSItemTargetAttribText.
     *
     */
    public final static FSItemTargetAttribTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static FSItemTargetAttribTextField<String> LANGUAGE =
        new FSItemTargetAttribTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemAttributeName</b>
     * </p>
     *
     * @return Financial Statement Item Target Attribute
     */
    @Key
    @SerializedName( "FSItemAttributeName" )
    @JsonProperty( "FSItemAttributeName" )
    @Nullable
    @ODataField( odataName = "FSItemAttributeName" )
    private String fSItemAttributeName;
    /**
     * Use with available fluent helpers to apply the <b>FSItemAttributeName</b> field to query operations.
     *
     */
    public final static FSItemTargetAttribTextField<String> FS_ITEM_ATTRIBUTE_NAME =
        new FSItemTargetAttribTextField<String>("FSItemAttributeName");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemAttributeText</b>
     * </p>
     *
     * @return Financial Statement Item Target Attribute Description
     */
    @SerializedName( "FSItemAttributeText" )
    @JsonProperty( "FSItemAttributeText" )
    @Nullable
    @ODataField( odataName = "FSItemAttributeText" )
    private String fSItemAttributeText;
    /**
     * Use with available fluent helpers to apply the <b>FSItemAttributeText</b> field to query operations.
     *
     */
    public final static FSItemTargetAttribTextField<String> FS_ITEM_ATTRIBUTE_TEXT =
        new FSItemTargetAttribTextField<String>("FSItemAttributeText");
    /**
     * Navigation property <b>to_CnsldtnFSItemTgtAttrib</b> for <b>FSItemTargetAttribText</b> to single
     * <b>FSItemTargetAttrib</b>.
     *
     */
    @SerializedName( "to_CnsldtnFSItemTgtAttrib" )
    @JsonProperty( "to_CnsldtnFSItemTgtAttrib" )
    @ODataField( odataName = "to_CnsldtnFSItemTgtAttrib" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private FSItemTargetAttrib toCnsldtnFSItemTgtAttrib;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnFSItemTgtAttrib</b> navigation property to query
     * operations.
     *
     */
    public final static FSItemTargetAttribTextOneToOneLink<FSItemTargetAttrib> TO_CNSLDTN_FS_ITEM_TGT_ATTRIB =
        new FSItemTargetAttribTextOneToOneLink<FSItemTargetAttrib>("to_CnsldtnFSItemTgtAttrib");

    @Nonnull
    @Override
    public Class<FSItemTargetAttribText> getType()
    {
        return FSItemTargetAttribText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemAttributeName</b>
     * </p>
     *
     * @param fSItemAttributeName
     *            Financial Statement Item Target Attribute
     */
    public void setFSItemAttributeName( @Nullable final String fSItemAttributeName )
    {
        rememberChangedField("FSItemAttributeName", this.fSItemAttributeName);
        this.fSItemAttributeName = fSItemAttributeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemAttributeText</b>
     * </p>
     *
     * @param fSItemAttributeText
     *            Financial Statement Item Target Attribute Description
     */
    public void setFSItemAttributeText( @Nullable final String fSItemAttributeText )
    {
        rememberChangedField("FSItemAttributeText", this.fSItemAttributeText);
        this.fSItemAttributeText = fSItemAttributeText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "FSItemTargetAttribText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("FSItemAttributeName", getFSItemAttributeName());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("FSItemAttributeName", getFSItemAttributeName());
        values.put("FSItemAttributeText", getFSItemAttributeText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("FSItemAttributeName") ) {
                final Object value = values.remove("FSItemAttributeName");
                if( (value == null) || (!value.equals(getFSItemAttributeName())) ) {
                    setFSItemAttributeName(((String) value));
                }
            }
            if( values.containsKey("FSItemAttributeText") ) {
                final Object value = values.remove("FSItemAttributeText");
                if( (value == null) || (!value.equals(getFSItemAttributeText())) ) {
                    setFSItemAttributeText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnFSItemTgtAttrib") ) {
                final Object value = (values).remove("to_CnsldtnFSItemTgtAttrib");
                if( value instanceof Map ) {
                    if( toCnsldtnFSItemTgtAttrib == null ) {
                        toCnsldtnFSItemTgtAttrib = new FSItemTargetAttrib();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnFSItemTgtAttrib.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> FSItemTargetAttribTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new FSItemTargetAttribTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FSItemTargetAttribTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FSItemTargetAttribTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnFSItemTgtAttrib != null ) {
            (values).put("to_CnsldtnFSItemTgtAttrib", toCnsldtnFSItemTgtAttrib);
        }
        return values;
    }

    /**
     * Fetches the <b>FSItemTargetAttrib</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnFSItemTgtAttrib</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>FSItemTargetAttrib</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public FSItemTargetAttrib fetchCnsldtnFSItemTgtAttrib()
    {
        return fetchFieldAsSingle("to_CnsldtnFSItemTgtAttrib", FSItemTargetAttrib.class);
    }

    /**
     * Retrieval of associated <b>FSItemTargetAttrib</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnFSItemTgtAttrib</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItemTgtAttrib</b> of a queried <b>FSItemTargetAttribText</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>FSItemTargetAttrib</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public FSItemTargetAttrib getCnsldtnFSItemTgtAttribOrFetch()
    {
        if( toCnsldtnFSItemTgtAttrib == null ) {
            toCnsldtnFSItemTgtAttrib = fetchCnsldtnFSItemTgtAttrib();
        }
        return toCnsldtnFSItemTgtAttrib;
    }

    /**
     * Retrieval of associated <b>FSItemTargetAttrib</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnFSItemTgtAttrib</b>.
     * <p>
     * If the navigation property for an entity <b>FSItemTargetAttribText</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnFSItemTgtAttrib</b> is already loaded, the result
     *         will contain the <b>FSItemTargetAttrib</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<FSItemTargetAttrib> getCnsldtnFSItemTgtAttribIfPresent()
    {
        return Option.of(toCnsldtnFSItemTgtAttrib);
    }

    /**
     * Overwrites the associated <b>FSItemTargetAttrib</b> entity for the loaded navigation property
     * <b>to_CnsldtnFSItemTgtAttrib</b>.
     *
     * @param value
     *            New <b>FSItemTargetAttrib</b> entity.
     */
    public void setCnsldtnFSItemTgtAttrib( final FSItemTargetAttrib value )
    {
        toCnsldtnFSItemTgtAttrib = value;
    }

    /**
     * Helper class to allow for fluent creation of FSItemTargetAttribText instances.
     *
     */
    public final static class FSItemTargetAttribTextBuilder
    {

        private FSItemTargetAttrib toCnsldtnFSItemTgtAttrib;

        private FSItemTargetAttribText.FSItemTargetAttribTextBuilder toCnsldtnFSItemTgtAttrib(
            final FSItemTargetAttrib value )
        {
            toCnsldtnFSItemTgtAttrib = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnFSItemTgtAttrib</b> for <b>FSItemTargetAttribText</b> to single
         * <b>FSItemTargetAttrib</b>.
         *
         * @param value
         *            The FSItemTargetAttrib to build this FSItemTargetAttribText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FSItemTargetAttribText.FSItemTargetAttribTextBuilder cnsldtnFSItemTgtAttrib(
            final FSItemTargetAttrib value )
        {
            return toCnsldtnFSItemTgtAttrib(value);
        }

    }

}
