/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.FSItemTargetAttribValField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.FSItemTargetAttribValLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.FSItemTargetAttribValSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Target Attribute Value
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>FSItemTargetAttribValType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class FSItemTargetAttribVal extends VdmEntity<FSItemTargetAttribVal>
{

    /**
     * Selector for all available fields of FSItemTargetAttribVal.
     *
     */
    public final static FSItemTargetAttribValSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts</b>
     * </p>
     *
     * @return Consolidation Chart of Accounts
     */
    @Key
    @SerializedName( "ConsolidationChartOfAccounts" )
    @JsonProperty( "ConsolidationChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "ConsolidationChartOfAccounts" )
    private String consolidationChartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationChartOfAccounts</b> field to query operations.
     *
     */
    public final static FSItemTargetAttribValField<String> CONSOLIDATION_CHART_OF_ACCOUNTS =
        new FSItemTargetAttribValField<String>("ConsolidationChartOfAccounts");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts_Text</b>
     * </p>
     *
     * @return Consolidation Chart of Accounts Description
     */
    @SerializedName( "ConsolidationChartOfAccounts_Text" )
    @JsonProperty( "ConsolidationChartOfAccounts_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationChartOfAccounts_Text" )
    private String consolidationChartOfAccounts_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationChartOfAccounts_Text</b> field to query
     * operations.
     *
     */
    public final static FSItemTargetAttribValField<String> CONSOLIDATION_CHART_OF_ACCOUNTS_TEXT =
        new FSItemTargetAttribValField<String>("ConsolidationChartOfAccounts_Text");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItem</b>
     * </p>
     *
     * @return Financial Statement Item
     */
    @Key
    @SerializedName( "FinancialStatementItem" )
    @JsonProperty( "FinancialStatementItem" )
    @Nullable
    @ODataField( odataName = "FinancialStatementItem" )
    private String financialStatementItem;
    /**
     * Use with available fluent helpers to apply the <b>FinancialStatementItem</b> field to query operations.
     *
     */
    public final static FSItemTargetAttribValField<String> FINANCIAL_STATEMENT_ITEM =
        new FSItemTargetAttribValField<String>("FinancialStatementItem");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItem_Text</b>
     * </p>
     *
     * @return Financial Statement Item Medium Description
     */
    @SerializedName( "FinancialStatementItem_Text" )
    @JsonProperty( "FinancialStatementItem_Text" )
    @Nullable
    @ODataField( odataName = "FinancialStatementItem_Text" )
    private String financialStatementItem_Text;
    /**
     * Use with available fluent helpers to apply the <b>FinancialStatementItem_Text</b> field to query operations.
     *
     */
    public final static FSItemTargetAttribValField<String> FINANCIAL_STATEMENT_ITEM_TEXT =
        new FSItemTargetAttribValField<String>("FinancialStatementItem_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItemType</b>
     * </p>
     *
     * @return Financial Statement Item Type
     */
    @SerializedName( "FinancialStatementItemType" )
    @JsonProperty( "FinancialStatementItemType" )
    @Nullable
    @ODataField( odataName = "FinancialStatementItemType" )
    private String financialStatementItemType;
    /**
     * Use with available fluent helpers to apply the <b>FinancialStatementItemType</b> field to query operations.
     *
     */
    public final static FSItemTargetAttribValField<String> FINANCIAL_STATEMENT_ITEM_TYPE =
        new FSItemTargetAttribValField<String>("FinancialStatementItemType");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItemType_Text</b>
     * </p>
     *
     * @return Financial Statement Item Type Description
     */
    @SerializedName( "FinancialStatementItemType_Text" )
    @JsonProperty( "FinancialStatementItemType_Text" )
    @Nullable
    @ODataField( odataName = "FinancialStatementItemType_Text" )
    private String financialStatementItemType_Text;
    /**
     * Use with available fluent helpers to apply the <b>FinancialStatementItemType_Text</b> field to query operations.
     *
     */
    public final static FSItemTargetAttribValField<String> FINANCIAL_STATEMENT_ITEM_TYPE_TEXT =
        new FSItemTargetAttribValField<String>("FinancialStatementItemType_Text");
    /**
     * Navigation property <b>to_CnsldtnFSItemTgtAttribValT</b> for <b>FSItemTargetAttribVal</b> to multiple
     * <b>FSItemTargetAttribValText</b>.
     *
     */
    @SerializedName( "to_CnsldtnFSItemTgtAttribValT" )
    @JsonProperty( "to_CnsldtnFSItemTgtAttribValT" )
    @ODataField( odataName = "to_CnsldtnFSItemTgtAttribValT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<FSItemTargetAttribValText> toCnsldtnFSItemTgtAttribValT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnFSItemTgtAttribValT</b> navigation property to query
     * operations.
     *
     */
    public final static FSItemTargetAttribValLink<FSItemTargetAttribValText> TO_CNSLDTN_FS_ITEM_TGT_ATTRIB_VAL_T =
        new FSItemTargetAttribValLink<FSItemTargetAttribValText>("to_CnsldtnFSItemTgtAttribValT");

    @Nonnull
    @Override
    public Class<FSItemTargetAttribVal> getType()
    {
        return FSItemTargetAttribVal.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts</b>
     * </p>
     *
     * @param consolidationChartOfAccounts
     *            Consolidation Chart of Accounts
     */
    public void setConsolidationChartOfAccounts( @Nullable final String consolidationChartOfAccounts )
    {
        rememberChangedField("ConsolidationChartOfAccounts", this.consolidationChartOfAccounts);
        this.consolidationChartOfAccounts = consolidationChartOfAccounts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts_Text</b>
     * </p>
     *
     * @param consolidationChartOfAccounts_Text
     *            Consolidation Chart of Accounts Description
     */
    public void setConsolidationChartOfAccounts_Text( @Nullable final String consolidationChartOfAccounts_Text )
    {
        rememberChangedField("ConsolidationChartOfAccounts_Text", this.consolidationChartOfAccounts_Text);
        this.consolidationChartOfAccounts_Text = consolidationChartOfAccounts_Text;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItem</b>
     * </p>
     *
     * @param financialStatementItem
     *            Financial Statement Item
     */
    public void setFinancialStatementItem( @Nullable final String financialStatementItem )
    {
        rememberChangedField("FinancialStatementItem", this.financialStatementItem);
        this.financialStatementItem = financialStatementItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItem_Text</b>
     * </p>
     *
     * @param financialStatementItem_Text
     *            Financial Statement Item Medium Description
     */
    public void setFinancialStatementItem_Text( @Nullable final String financialStatementItem_Text )
    {
        rememberChangedField("FinancialStatementItem_Text", this.financialStatementItem_Text);
        this.financialStatementItem_Text = financialStatementItem_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItemType</b>
     * </p>
     *
     * @param financialStatementItemType
     *            Financial Statement Item Type
     */
    public void setFinancialStatementItemType( @Nullable final String financialStatementItemType )
    {
        rememberChangedField("FinancialStatementItemType", this.financialStatementItemType);
        this.financialStatementItemType = financialStatementItemType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItemType_Text</b>
     * </p>
     *
     * @param financialStatementItemType_Text
     *            Financial Statement Item Type Description
     */
    public void setFinancialStatementItemType_Text( @Nullable final String financialStatementItemType_Text )
    {
        rememberChangedField("FinancialStatementItemType_Text", this.financialStatementItemType_Text);
        this.financialStatementItemType_Text = financialStatementItemType_Text;
    }

    @Override
    protected String getEntityCollection()
    {
        return "FSItemTargetAttribVal";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConsolidationChartOfAccounts", getConsolidationChartOfAccounts());
        result.put("FinancialStatementItem", getFinancialStatementItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConsolidationChartOfAccounts", getConsolidationChartOfAccounts());
        values.put("ConsolidationChartOfAccounts_Text", getConsolidationChartOfAccounts_Text());
        values.put("FinancialStatementItem", getFinancialStatementItem());
        values.put("FinancialStatementItem_Text", getFinancialStatementItem_Text());
        values.put("FinancialStatementItemType", getFinancialStatementItemType());
        values.put("FinancialStatementItemType_Text", getFinancialStatementItemType_Text());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConsolidationChartOfAccounts") ) {
                final Object value = values.remove("ConsolidationChartOfAccounts");
                if( (value == null) || (!value.equals(getConsolidationChartOfAccounts())) ) {
                    setConsolidationChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("ConsolidationChartOfAccounts_Text") ) {
                final Object value = values.remove("ConsolidationChartOfAccounts_Text");
                if( (value == null) || (!value.equals(getConsolidationChartOfAccounts_Text())) ) {
                    setConsolidationChartOfAccounts_Text(((String) value));
                }
            }
            if( values.containsKey("FinancialStatementItem") ) {
                final Object value = values.remove("FinancialStatementItem");
                if( (value == null) || (!value.equals(getFinancialStatementItem())) ) {
                    setFinancialStatementItem(((String) value));
                }
            }
            if( values.containsKey("FinancialStatementItem_Text") ) {
                final Object value = values.remove("FinancialStatementItem_Text");
                if( (value == null) || (!value.equals(getFinancialStatementItem_Text())) ) {
                    setFinancialStatementItem_Text(((String) value));
                }
            }
            if( values.containsKey("FinancialStatementItemType") ) {
                final Object value = values.remove("FinancialStatementItemType");
                if( (value == null) || (!value.equals(getFinancialStatementItemType())) ) {
                    setFinancialStatementItemType(((String) value));
                }
            }
            if( values.containsKey("FinancialStatementItemType_Text") ) {
                final Object value = values.remove("FinancialStatementItemType_Text");
                if( (value == null) || (!value.equals(getFinancialStatementItemType_Text())) ) {
                    setFinancialStatementItemType_Text(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnFSItemTgtAttribValT") ) {
                final Object value = (values).remove("to_CnsldtnFSItemTgtAttribValT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnFSItemTgtAttribValT == null ) {
                        toCnsldtnFSItemTgtAttribValT = Lists.newArrayList();
                    } else {
                        toCnsldtnFSItemTgtAttribValT = Lists.newArrayList(toCnsldtnFSItemTgtAttribValT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        FSItemTargetAttribValText entity;
                        if( toCnsldtnFSItemTgtAttribValT.size() > i ) {
                            entity = toCnsldtnFSItemTgtAttribValT.get(i);
                        } else {
                            entity = new FSItemTargetAttribValText();
                            toCnsldtnFSItemTgtAttribValT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> FSItemTargetAttribValField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new FSItemTargetAttribValField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FSItemTargetAttribValField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FSItemTargetAttribValField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnFSItemTgtAttribValT != null ) {
            (values).put("to_CnsldtnFSItemTgtAttribValT", toCnsldtnFSItemTgtAttribValT);
        }
        return values;
    }

    /**
     * Fetches the <b>FSItemTargetAttribValText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CnsldtnFSItemTgtAttribValT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>FSItemTargetAttribValText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<FSItemTargetAttribValText> fetchCnsldtnFSItemTgtAttribValT()
    {
        return fetchFieldAsList("to_CnsldtnFSItemTgtAttribValT", FSItemTargetAttribValText.class);
    }

    /**
     * Retrieval of associated <b>FSItemTargetAttribValText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItemTgtAttribValT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItemTgtAttribValT</b> of a queried <b>FSItemTargetAttribVal</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>FSItemTargetAttribValText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<FSItemTargetAttribValText> getCnsldtnFSItemTgtAttribValTOrFetch()
    {
        if( toCnsldtnFSItemTgtAttribValT == null ) {
            toCnsldtnFSItemTgtAttribValT = fetchCnsldtnFSItemTgtAttribValT();
        }
        return toCnsldtnFSItemTgtAttribValT;
    }

    /**
     * Retrieval of associated <b>FSItemTargetAttribValText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItemTgtAttribValT</b>.
     * <p>
     * If the navigation property for an entity <b>FSItemTargetAttribVal</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnFSItemTgtAttribValT</b> is already loaded, the
     *         result will contain the <b>FSItemTargetAttribValText</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<FSItemTargetAttribValText>> getCnsldtnFSItemTgtAttribValTIfPresent()
    {
        return Option.of(toCnsldtnFSItemTgtAttribValT);
    }

    /**
     * Overwrites the list of associated <b>FSItemTargetAttribValText</b> entities for the loaded navigation property
     * <b>to_CnsldtnFSItemTgtAttribValT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItemTgtAttribValT</b> of a queried <b>FSItemTargetAttribVal</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>FSItemTargetAttribValText</b> entities.
     */
    public void setCnsldtnFSItemTgtAttribValT( @Nonnull final List<FSItemTargetAttribValText> value )
    {
        if( toCnsldtnFSItemTgtAttribValT == null ) {
            toCnsldtnFSItemTgtAttribValT = Lists.newArrayList();
        }
        toCnsldtnFSItemTgtAttribValT.clear();
        toCnsldtnFSItemTgtAttribValT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>FSItemTargetAttribValText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItemTgtAttribValT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItemTgtAttribValT</b> of a queried <b>FSItemTargetAttribVal</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>FSItemTargetAttribValText</b> entities.
     */
    public void addCnsldtnFSItemTgtAttribValT( FSItemTargetAttribValText... entity )
    {
        if( toCnsldtnFSItemTgtAttribValT == null ) {
            toCnsldtnFSItemTgtAttribValT = Lists.newArrayList();
        }
        toCnsldtnFSItemTgtAttribValT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of FSItemTargetAttribVal instances.
     *
     */
    public final static class FSItemTargetAttribValBuilder
    {

        private List<FSItemTargetAttribValText> toCnsldtnFSItemTgtAttribValT = Lists.newArrayList();

        private FSItemTargetAttribVal.FSItemTargetAttribValBuilder toCnsldtnFSItemTgtAttribValT(
            final List<FSItemTargetAttribValText> value )
        {
            toCnsldtnFSItemTgtAttribValT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnFSItemTgtAttribValT</b> for <b>FSItemTargetAttribVal</b> to multiple
         * <b>FSItemTargetAttribValText</b>.
         *
         * @param value
         *            The FSItemTargetAttribValTexts to build this FSItemTargetAttribVal with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FSItemTargetAttribVal.FSItemTargetAttribValBuilder cnsldtnFSItemTgtAttribValT(
            FSItemTargetAttribValText... value )
        {
            return toCnsldtnFSItemTgtAttribValT(Lists.newArrayList(value));
        }

    }

}
