/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.FSItemTypeTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.FSItemTypeTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.FSItemTypeTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Financial Statement Item Type - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>FSItemTypeTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class FSItemTypeText extends VdmEntity<FSItemTypeText>
{

    /**
     * Selector for all available fields of FSItemTypeText.
     *
     */
    public final static FSItemTypeTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static FSItemTypeTextField<String> LANGUAGE = new FSItemTypeTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItemType</b>
     * </p>
     *
     * @return Financial Statement Item Type
     */
    @Key
    @SerializedName( "FinancialStatementItemType" )
    @JsonProperty( "FinancialStatementItemType" )
    @Nullable
    @ODataField( odataName = "FinancialStatementItemType" )
    private String financialStatementItemType;
    /**
     * Use with available fluent helpers to apply the <b>FinancialStatementItemType</b> field to query operations.
     *
     */
    public final static FSItemTypeTextField<String> FINANCIAL_STATEMENT_ITEM_TYPE =
        new FSItemTypeTextField<String>("FinancialStatementItemType");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItemTypeText</b>
     * </p>
     *
     * @return Financial Statement Item Type Description
     */
    @SerializedName( "FinancialStatementItemTypeText" )
    @JsonProperty( "FinancialStatementItemTypeText" )
    @Nullable
    @ODataField( odataName = "FinancialStatementItemTypeText" )
    private String financialStatementItemTypeText;
    /**
     * Use with available fluent helpers to apply the <b>FinancialStatementItemTypeText</b> field to query operations.
     *
     */
    public final static FSItemTypeTextField<String> FINANCIAL_STATEMENT_ITEM_TYPE_TEXT =
        new FSItemTypeTextField<String>("FinancialStatementItemTypeText");
    /**
     * Navigation property <b>to_CnsldtnFSItemType</b> for <b>FSItemTypeText</b> to single <b>FSItemType</b>.
     *
     */
    @SerializedName( "to_CnsldtnFSItemType" )
    @JsonProperty( "to_CnsldtnFSItemType" )
    @ODataField( odataName = "to_CnsldtnFSItemType" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private FSItemType toCnsldtnFSItemType;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnFSItemType</b> navigation property to query
     * operations.
     *
     */
    public final static FSItemTypeTextOneToOneLink<FSItemType> TO_CNSLDTN_FS_ITEM_TYPE =
        new FSItemTypeTextOneToOneLink<FSItemType>("to_CnsldtnFSItemType");

    @Nonnull
    @Override
    public Class<FSItemTypeText> getType()
    {
        return FSItemTypeText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItemType</b>
     * </p>
     *
     * @param financialStatementItemType
     *            Financial Statement Item Type
     */
    public void setFinancialStatementItemType( @Nullable final String financialStatementItemType )
    {
        rememberChangedField("FinancialStatementItemType", this.financialStatementItemType);
        this.financialStatementItemType = financialStatementItemType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItemTypeText</b>
     * </p>
     *
     * @param financialStatementItemTypeText
     *            Financial Statement Item Type Description
     */
    public void setFinancialStatementItemTypeText( @Nullable final String financialStatementItemTypeText )
    {
        rememberChangedField("FinancialStatementItemTypeText", this.financialStatementItemTypeText);
        this.financialStatementItemTypeText = financialStatementItemTypeText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "FSItemTypeText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("FinancialStatementItemType", getFinancialStatementItemType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("FinancialStatementItemType", getFinancialStatementItemType());
        values.put("FinancialStatementItemTypeText", getFinancialStatementItemTypeText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("FinancialStatementItemType") ) {
                final Object value = values.remove("FinancialStatementItemType");
                if( (value == null) || (!value.equals(getFinancialStatementItemType())) ) {
                    setFinancialStatementItemType(((String) value));
                }
            }
            if( values.containsKey("FinancialStatementItemTypeText") ) {
                final Object value = values.remove("FinancialStatementItemTypeText");
                if( (value == null) || (!value.equals(getFinancialStatementItemTypeText())) ) {
                    setFinancialStatementItemTypeText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnFSItemType") ) {
                final Object value = (values).remove("to_CnsldtnFSItemType");
                if( value instanceof Map ) {
                    if( toCnsldtnFSItemType == null ) {
                        toCnsldtnFSItemType = new FSItemType();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnFSItemType.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> FSItemTypeTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new FSItemTypeTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FSItemTypeTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FSItemTypeTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnFSItemType != null ) {
            (values).put("to_CnsldtnFSItemType", toCnsldtnFSItemType);
        }
        return values;
    }

    /**
     * Fetches the <b>FSItemType</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItemType</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>FSItemType</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public FSItemType fetchCnsldtnFSItemType()
    {
        return fetchFieldAsSingle("to_CnsldtnFSItemType", FSItemType.class);
    }

    /**
     * Retrieval of associated <b>FSItemType</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_CnsldtnFSItemType</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItemType</b> of a queried <b>FSItemTypeText</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>FSItemType</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public FSItemType getCnsldtnFSItemTypeOrFetch()
    {
        if( toCnsldtnFSItemType == null ) {
            toCnsldtnFSItemType = fetchCnsldtnFSItemType();
        }
        return toCnsldtnFSItemType;
    }

    /**
     * Retrieval of associated <b>FSItemType</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_CnsldtnFSItemType</b>.
     * <p>
     * If the navigation property for an entity <b>FSItemTypeText</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnFSItemType</b> is already loaded, the result will
     *         contain the <b>FSItemType</b> entity. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<FSItemType> getCnsldtnFSItemTypeIfPresent()
    {
        return Option.of(toCnsldtnFSItemType);
    }

    /**
     * Overwrites the associated <b>FSItemType</b> entity for the loaded navigation property
     * <b>to_CnsldtnFSItemType</b>.
     *
     * @param value
     *            New <b>FSItemType</b> entity.
     */
    public void setCnsldtnFSItemType( final FSItemType value )
    {
        toCnsldtnFSItemType = value;
    }

    /**
     * Helper class to allow for fluent creation of FSItemTypeText instances.
     *
     */
    public final static class FSItemTypeTextBuilder
    {

        private FSItemType toCnsldtnFSItemType;

        private FSItemTypeText.FSItemTypeTextBuilder toCnsldtnFSItemType( final FSItemType value )
        {
            toCnsldtnFSItemType = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnFSItemType</b> for <b>FSItemTypeText</b> to single <b>FSItemType</b>.
         *
         * @param value
         *            The FSItemType to build this FSItemTypeText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FSItemTypeText.FSItemTypeTextBuilder cnsldtnFSItemType( final FSItemType value )
        {
            return toCnsldtnFSItemType(value);
        }

    }

}
