/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.FeatureField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.FeatureSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Consolidation Feature
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>FeatureType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class Feature extends VdmEntity<Feature>
{

    /**
     * Selector for all available fields of Feature.
     *
     */
    public final static FeatureSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnFeature</b>
     * </p>
     *
     * @return Feature
     */
    @Key
    @SerializedName( "CnsldtnFeature" )
    @JsonProperty( "CnsldtnFeature" )
    @Nullable
    @ODataField( odataName = "CnsldtnFeature" )
    private String cnsldtnFeature;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnFeature</b> field to query operations.
     *
     */
    public final static FeatureField<String> CNSLDTN_FEATURE = new FeatureField<String>("CnsldtnFeature");
    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnFeatureText</b>
     * </p>
     *
     * @return Feature Description
     */
    @SerializedName( "CnsldtnFeatureText" )
    @JsonProperty( "CnsldtnFeatureText" )
    @Nullable
    @ODataField( odataName = "CnsldtnFeatureText" )
    private String cnsldtnFeatureText;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnFeatureText</b> field to query operations.
     *
     */
    public final static FeatureField<String> CNSLDTN_FEATURE_TEXT = new FeatureField<String>("CnsldtnFeatureText");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnFeatureIsActive</b>
     * </p>
     *
     * @return Feature Activated
     */
    @SerializedName( "CnsldtnFeatureIsActive" )
    @JsonProperty( "CnsldtnFeatureIsActive" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CnsldtnFeatureIsActive" )
    private Boolean cnsldtnFeatureIsActive;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnFeatureIsActive</b> field to query operations.
     *
     */
    public final static FeatureField<Boolean> CNSLDTN_FEATURE_IS_ACTIVE =
        new FeatureField<Boolean>("CnsldtnFeatureIsActive");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnFeatureFromFiscalYear</b>
     * </p>
     *
     * @return Active as of Fiscal Year
     */
    @SerializedName( "CnsldtnFeatureFromFiscalYear" )
    @JsonProperty( "CnsldtnFeatureFromFiscalYear" )
    @Nullable
    @ODataField( odataName = "CnsldtnFeatureFromFiscalYear" )
    private String cnsldtnFeatureFromFiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnFeatureFromFiscalYear</b> field to query operations.
     *
     */
    public final static FeatureField<String> CNSLDTN_FEATURE_FROM_FISCAL_YEAR =
        new FeatureField<String>("CnsldtnFeatureFromFiscalYear");

    @Nonnull
    @Override
    public Class<Feature> getType()
    {
        return Feature.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnFeature</b>
     * </p>
     *
     * @param cnsldtnFeature
     *            Feature
     */
    public void setCnsldtnFeature( @Nullable final String cnsldtnFeature )
    {
        rememberChangedField("CnsldtnFeature", this.cnsldtnFeature);
        this.cnsldtnFeature = cnsldtnFeature;
    }

    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnFeatureText</b>
     * </p>
     *
     * @param cnsldtnFeatureText
     *            Feature Description
     */
    public void setCnsldtnFeatureText( @Nullable final String cnsldtnFeatureText )
    {
        rememberChangedField("CnsldtnFeatureText", this.cnsldtnFeatureText);
        this.cnsldtnFeatureText = cnsldtnFeatureText;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnFeatureIsActive</b>
     * </p>
     *
     * @param cnsldtnFeatureIsActive
     *            Feature Activated
     */
    public void setCnsldtnFeatureIsActive( @Nullable final Boolean cnsldtnFeatureIsActive )
    {
        rememberChangedField("CnsldtnFeatureIsActive", this.cnsldtnFeatureIsActive);
        this.cnsldtnFeatureIsActive = cnsldtnFeatureIsActive;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnFeatureFromFiscalYear</b>
     * </p>
     *
     * @param cnsldtnFeatureFromFiscalYear
     *            Active as of Fiscal Year
     */
    public void setCnsldtnFeatureFromFiscalYear( @Nullable final String cnsldtnFeatureFromFiscalYear )
    {
        rememberChangedField("CnsldtnFeatureFromFiscalYear", this.cnsldtnFeatureFromFiscalYear);
        this.cnsldtnFeatureFromFiscalYear = cnsldtnFeatureFromFiscalYear;
    }

    @Override
    protected String getEntityCollection()
    {
        return "Feature";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CnsldtnFeature", getCnsldtnFeature());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CnsldtnFeature", getCnsldtnFeature());
        values.put("CnsldtnFeatureText", getCnsldtnFeatureText());
        values.put("CnsldtnFeatureIsActive", getCnsldtnFeatureIsActive());
        values.put("CnsldtnFeatureFromFiscalYear", getCnsldtnFeatureFromFiscalYear());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CnsldtnFeature") ) {
                final Object value = values.remove("CnsldtnFeature");
                if( (value == null) || (!value.equals(getCnsldtnFeature())) ) {
                    setCnsldtnFeature(((String) value));
                }
            }
            if( values.containsKey("CnsldtnFeatureText") ) {
                final Object value = values.remove("CnsldtnFeatureText");
                if( (value == null) || (!value.equals(getCnsldtnFeatureText())) ) {
                    setCnsldtnFeatureText(((String) value));
                }
            }
            if( values.containsKey("CnsldtnFeatureIsActive") ) {
                final Object value = values.remove("CnsldtnFeatureIsActive");
                if( (value == null) || (!value.equals(getCnsldtnFeatureIsActive())) ) {
                    setCnsldtnFeatureIsActive(((Boolean) value));
                }
            }
            if( values.containsKey("CnsldtnFeatureFromFiscalYear") ) {
                final Object value = values.remove("CnsldtnFeatureFromFiscalYear");
                if( (value == null) || (!value.equals(getCnsldtnFeatureFromFiscalYear())) ) {
                    setCnsldtnFeatureFromFiscalYear(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> FeatureField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new FeatureField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FeatureField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FeatureField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

}
