/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.FinancialStatementItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.FinancialStatementItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.FinancialStatementItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Financial Statement Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>FinancialStatementItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class FinancialStatementItem extends VdmEntity<FinancialStatementItem>
{

    /**
     * Selector for all available fields of FinancialStatementItem.
     *
     */
    public final static FinancialStatementItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts</b>
     * </p>
     *
     * @return Consolidation Chart of Accounts
     */
    @Key
    @SerializedName( "ConsolidationChartOfAccounts" )
    @JsonProperty( "ConsolidationChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "ConsolidationChartOfAccounts" )
    private String consolidationChartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationChartOfAccounts</b> field to query operations.
     *
     */
    public final static FinancialStatementItemField<String> CONSOLIDATION_CHART_OF_ACCOUNTS =
        new FinancialStatementItemField<String>("ConsolidationChartOfAccounts");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts_Text</b>
     * </p>
     *
     * @return Consolidation Chart of Accounts Description
     */
    @SerializedName( "ConsolidationChartOfAccounts_Text" )
    @JsonProperty( "ConsolidationChartOfAccounts_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationChartOfAccounts_Text" )
    private String consolidationChartOfAccounts_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationChartOfAccounts_Text</b> field to query
     * operations.
     *
     */
    public final static FinancialStatementItemField<String> CONSOLIDATION_CHART_OF_ACCOUNTS_TEXT =
        new FinancialStatementItemField<String>("ConsolidationChartOfAccounts_Text");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItem</b>
     * </p>
     *
     * @return Financial Statement Item
     */
    @Key
    @SerializedName( "FinancialStatementItem" )
    @JsonProperty( "FinancialStatementItem" )
    @Nullable
    @ODataField( odataName = "FinancialStatementItem" )
    private String financialStatementItem;
    /**
     * Use with available fluent helpers to apply the <b>FinancialStatementItem</b> field to query operations.
     *
     */
    public final static FinancialStatementItemField<String> FINANCIAL_STATEMENT_ITEM =
        new FinancialStatementItemField<String>("FinancialStatementItem");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItem_Text</b>
     * </p>
     *
     * @return Financial Statement Item Description
     */
    @SerializedName( "FinancialStatementItem_Text" )
    @JsonProperty( "FinancialStatementItem_Text" )
    @Nullable
    @ODataField( odataName = "FinancialStatementItem_Text" )
    private String financialStatementItem_Text;
    /**
     * Use with available fluent helpers to apply the <b>FinancialStatementItem_Text</b> field to query operations.
     *
     */
    public final static FinancialStatementItemField<String> FINANCIAL_STATEMENT_ITEM_TEXT =
        new FinancialStatementItemField<String>("FinancialStatementItem_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationFSItemType</b>
     * </p>
     *
     * @return Financial Statement Item Type
     */
    @SerializedName( "ConsolidationFSItemType" )
    @JsonProperty( "ConsolidationFSItemType" )
    @Nullable
    @ODataField( odataName = "ConsolidationFSItemType" )
    private String consolidationFSItemType;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationFSItemType</b> field to query operations.
     *
     */
    public final static FinancialStatementItemField<String> CONSOLIDATION_FS_ITEM_TYPE =
        new FinancialStatementItemField<String>("ConsolidationFSItemType");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationFSItemType_Text</b>
     * </p>
     *
     * @return Financial Statement Item Type Description
     */
    @SerializedName( "ConsolidationFSItemType_Text" )
    @JsonProperty( "ConsolidationFSItemType_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationFSItemType_Text" )
    private String consolidationFSItemType_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationFSItemType_Text</b> field to query operations.
     *
     */
    public final static FinancialStatementItemField<String> CONSOLIDATION_FS_ITEM_TYPE_TEXT =
        new FinancialStatementItemField<String>("ConsolidationFSItemType_Text");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BreakdownCategory</b>
     * </p>
     *
     * @return Breakdown Category
     */
    @SerializedName( "BreakdownCategory" )
    @JsonProperty( "BreakdownCategory" )
    @Nullable
    @ODataField( odataName = "BreakdownCategory" )
    private String breakdownCategory;
    /**
     * Use with available fluent helpers to apply the <b>BreakdownCategory</b> field to query operations.
     *
     */
    public final static FinancialStatementItemField<String> BREAKDOWN_CATEGORY =
        new FinancialStatementItemField<String>("BreakdownCategory");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BreakdownCategory_Text</b>
     * </p>
     *
     * @return Breakdown Category Description
     */
    @SerializedName( "BreakdownCategory_Text" )
    @JsonProperty( "BreakdownCategory_Text" )
    @Nullable
    @ODataField( odataName = "BreakdownCategory_Text" )
    private String breakdownCategory_Text;
    /**
     * Use with available fluent helpers to apply the <b>BreakdownCategory_Text</b> field to query operations.
     *
     */
    public final static FinancialStatementItemField<String> BREAKDOWN_CATEGORY_TEXT =
        new FinancialStatementItemField<String>("BreakdownCategory_Text");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsConsolidationItem</b>
     * </p>
     *
     * @return Is Consolidation Item
     */
    @SerializedName( "IsConsolidationItem" )
    @JsonProperty( "IsConsolidationItem" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsConsolidationItem" )
    private Boolean isConsolidationItem;
    /**
     * Use with available fluent helpers to apply the <b>IsConsolidationItem</b> field to query operations.
     *
     */
    public final static FinancialStatementItemField<Boolean> IS_CONSOLIDATION_ITEM =
        new FinancialStatementItemField<Boolean>("IsConsolidationItem");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItemIsBlkd</b>
     * </p>
     *
     * @return Blocked for Posting
     */
    @SerializedName( "FinancialStatementItemIsBlkd" )
    @JsonProperty( "FinancialStatementItemIsBlkd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "FinancialStatementItemIsBlkd" )
    private Boolean financialStatementItemIsBlkd;
    /**
     * Use with available fluent helpers to apply the <b>FinancialStatementItemIsBlkd</b> field to query operations.
     *
     */
    public final static FinancialStatementItemField<Boolean> FINANCIAL_STATEMENT_ITEM_IS_BLKD =
        new FinancialStatementItemField<Boolean>("FinancialStatementItemIsBlkd");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemElimination</b>
     * </p>
     *
     * @return Elimination Selection Attribute
     */
    @SerializedName( "FSItemElimination" )
    @JsonProperty( "FSItemElimination" )
    @Nullable
    @ODataField( odataName = "FSItemElimination" )
    private String fSItemElimination;
    /**
     * Use with available fluent helpers to apply the <b>FSItemElimination</b> field to query operations.
     *
     */
    public final static FinancialStatementItemField<String> FS_ITEM_ELIMINATION =
        new FinancialStatementItemField<String>("FSItemElimination");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemEliminationText</b>
     * </p>
     *
     * @return Elimination Selection Attribute Description
     */
    @SerializedName( "FSItemEliminationText" )
    @JsonProperty( "FSItemEliminationText" )
    @Nullable
    @ODataField( odataName = "FSItemEliminationText" )
    private String fSItemEliminationText;
    /**
     * Use with available fluent helpers to apply the <b>FSItemEliminationText</b> field to query operations.
     *
     */
    public final static FinancialStatementItemField<String> FS_ITEM_ELIMINATION_TEXT =
        new FinancialStatementItemField<String>("FSItemEliminationText");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemCurrencyTranslation</b>
     * </p>
     *
     * @return Currency Translation Selection Attribute
     */
    @SerializedName( "FSItemCurrencyTranslation" )
    @JsonProperty( "FSItemCurrencyTranslation" )
    @Nullable
    @ODataField( odataName = "FSItemCurrencyTranslation" )
    private String fSItemCurrencyTranslation;
    /**
     * Use with available fluent helpers to apply the <b>FSItemCurrencyTranslation</b> field to query operations.
     *
     */
    public final static FinancialStatementItemField<String> FS_ITEM_CURRENCY_TRANSLATION =
        new FinancialStatementItemField<String>("FSItemCurrencyTranslation");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemCurrencyTranslationText</b>
     * </p>
     *
     * @return Currency Translation Selection Attribute Description
     */
    @SerializedName( "FSItemCurrencyTranslationText" )
    @JsonProperty( "FSItemCurrencyTranslationText" )
    @Nullable
    @ODataField( odataName = "FSItemCurrencyTranslationText" )
    private String fSItemCurrencyTranslationText;
    /**
     * Use with available fluent helpers to apply the <b>FSItemCurrencyTranslationText</b> field to query operations.
     *
     */
    public final static FinancialStatementItemField<String> FS_ITEM_CURRENCY_TRANSLATION_TEXT =
        new FinancialStatementItemField<String>("FSItemCurrencyTranslationText");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItemRole</b>
     * </p>
     *
     * @return Financial Statement Item Role
     */
    @SerializedName( "FinancialStatementItemRole" )
    @JsonProperty( "FinancialStatementItemRole" )
    @Nullable
    @ODataField( odataName = "FinancialStatementItemRole" )
    private String financialStatementItemRole;
    /**
     * Use with available fluent helpers to apply the <b>FinancialStatementItemRole</b> field to query operations.
     *
     */
    public final static FinancialStatementItemField<String> FINANCIAL_STATEMENT_ITEM_ROLE =
        new FinancialStatementItemField<String>("FinancialStatementItemRole");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemRoleText</b>
     * </p>
     *
     * @return Financial Statement Item Role Description
     */
    @SerializedName( "FSItemRoleText" )
    @JsonProperty( "FSItemRoleText" )
    @Nullable
    @ODataField( odataName = "FSItemRoleText" )
    private String fSItemRoleText;
    /**
     * Use with available fluent helpers to apply the <b>FSItemRoleText</b> field to query operations.
     *
     */
    public final static FinancialStatementItemField<String> FS_ITEM_ROLE_TEXT =
        new FinancialStatementItemField<String>("FSItemRoleText");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemDataCollection</b>
     * </p>
     *
     * @return Data Collection Selection Attribute
     */
    @SerializedName( "FSItemDataCollection" )
    @JsonProperty( "FSItemDataCollection" )
    @Nullable
    @ODataField( odataName = "FSItemDataCollection" )
    private String fSItemDataCollection;
    /**
     * Use with available fluent helpers to apply the <b>FSItemDataCollection</b> field to query operations.
     *
     */
    public final static FinancialStatementItemField<String> FS_ITEM_DATA_COLLECTION =
        new FinancialStatementItemField<String>("FSItemDataCollection");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemDataCollectionText</b>
     * </p>
     *
     * @return Data Collection Selection Attribute Description
     */
    @SerializedName( "FSItemDataCollectionText" )
    @JsonProperty( "FSItemDataCollectionText" )
    @Nullable
    @ODataField( odataName = "FSItemDataCollectionText" )
    private String fSItemDataCollectionText;
    /**
     * Use with available fluent helpers to apply the <b>FSItemDataCollectionText</b> field to query operations.
     *
     */
    public final static FinancialStatementItemField<String> FS_ITEM_DATA_COLLECTION_TEXT =
        new FinancialStatementItemField<String>("FSItemDataCollectionText");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemCashFlow</b>
     * </p>
     *
     * @return Cash Flow Selection Attribute
     */
    @SerializedName( "FSItemCashFlow" )
    @JsonProperty( "FSItemCashFlow" )
    @Nullable
    @ODataField( odataName = "FSItemCashFlow" )
    private String fSItemCashFlow;
    /**
     * Use with available fluent helpers to apply the <b>FSItemCashFlow</b> field to query operations.
     *
     */
    public final static FinancialStatementItemField<String> FS_ITEM_CASH_FLOW =
        new FinancialStatementItemField<String>("FSItemCashFlow");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemCashFlowText</b>
     * </p>
     *
     * @return Cash Flow Selection Attribute Description
     */
    @SerializedName( "FSItemCashFlowText" )
    @JsonProperty( "FSItemCashFlowText" )
    @Nullable
    @ODataField( odataName = "FSItemCashFlowText" )
    private String fSItemCashFlowText;
    /**
     * Use with available fluent helpers to apply the <b>FSItemCashFlowText</b> field to query operations.
     *
     */
    public final static FinancialStatementItemField<String> FS_ITEM_CASH_FLOW_TEXT =
        new FinancialStatementItemField<String>("FSItemCashFlowText");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemScope</b>
     * </p>
     *
     * @return Scope Selection Attribute
     */
    @SerializedName( "FSItemScope" )
    @JsonProperty( "FSItemScope" )
    @Nullable
    @ODataField( odataName = "FSItemScope" )
    private String fSItemScope;
    /**
     * Use with available fluent helpers to apply the <b>FSItemScope</b> field to query operations.
     *
     */
    public final static FinancialStatementItemField<String> FS_ITEM_SCOPE =
        new FinancialStatementItemField<String>("FSItemScope");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemScopeText</b>
     * </p>
     *
     * @return Scope Selection Attribute Description
     */
    @SerializedName( "FSItemScopeText" )
    @JsonProperty( "FSItemScopeText" )
    @Nullable
    @ODataField( odataName = "FSItemScopeText" )
    private String fSItemScopeText;
    /**
     * Use with available fluent helpers to apply the <b>FSItemScopeText</b> field to query operations.
     *
     */
    public final static FinancialStatementItemField<String> FS_ITEM_SCOPE_TEXT =
        new FinancialStatementItemField<String>("FSItemScopeText");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemCustomerSpecific</b>
     * </p>
     *
     * @return Other Selection Attribute
     */
    @SerializedName( "FSItemCustomerSpecific" )
    @JsonProperty( "FSItemCustomerSpecific" )
    @Nullable
    @ODataField( odataName = "FSItemCustomerSpecific" )
    private String fSItemCustomerSpecific;
    /**
     * Use with available fluent helpers to apply the <b>FSItemCustomerSpecific</b> field to query operations.
     *
     */
    public final static FinancialStatementItemField<String> FS_ITEM_CUSTOMER_SPECIFIC =
        new FinancialStatementItemField<String>("FSItemCustomerSpecific");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemCustomerSpecificText</b>
     * </p>
     *
     * @return Other Selection Attribute Description
     */
    @SerializedName( "FSItemCustomerSpecificText" )
    @JsonProperty( "FSItemCustomerSpecificText" )
    @Nullable
    @ODataField( odataName = "FSItemCustomerSpecificText" )
    private String fSItemCustomerSpecificText;
    /**
     * Use with available fluent helpers to apply the <b>FSItemCustomerSpecificText</b> field to query operations.
     *
     */
    public final static FinancialStatementItemField<String> FS_ITEM_CUSTOMER_SPECIFIC_TEXT =
        new FinancialStatementItemField<String>("FSItemCustomerSpecificText");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EliminationTargetFSItem</b>
     * </p>
     *
     * @return Elimination Target Attribute
     */
    @SerializedName( "EliminationTargetFSItem" )
    @JsonProperty( "EliminationTargetFSItem" )
    @Nullable
    @ODataField( odataName = "EliminationTargetFSItem" )
    private String eliminationTargetFSItem;
    /**
     * Use with available fluent helpers to apply the <b>EliminationTargetFSItem</b> field to query operations.
     *
     */
    public final static FinancialStatementItemField<String> ELIMINATION_TARGET_FS_ITEM =
        new FinancialStatementItemField<String>("EliminationTargetFSItem");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>EliminationTargetFSItemText</b>
     * </p>
     *
     * @return Elimination Target Attribute Description
     */
    @SerializedName( "EliminationTargetFSItemText" )
    @JsonProperty( "EliminationTargetFSItemText" )
    @Nullable
    @ODataField( odataName = "EliminationTargetFSItemText" )
    private String eliminationTargetFSItemText;
    /**
     * Use with available fluent helpers to apply the <b>EliminationTargetFSItemText</b> field to query operations.
     *
     */
    public final static FinancialStatementItemField<String> ELIMINATION_TARGET_FS_ITEM_TEXT =
        new FinancialStatementItemField<String>("EliminationTargetFSItemText");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>NCITargetFSItem</b>
     * </p>
     *
     * @return Non-Controlling Interest Target Attribute
     */
    @SerializedName( "NCITargetFSItem" )
    @JsonProperty( "NCITargetFSItem" )
    @Nullable
    @ODataField( odataName = "NCITargetFSItem" )
    private String nCITargetFSItem;
    /**
     * Use with available fluent helpers to apply the <b>NCITargetFSItem</b> field to query operations.
     *
     */
    public final static FinancialStatementItemField<String> NCI_TARGET_FS_ITEM =
        new FinancialStatementItemField<String>("NCITargetFSItem");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>NCITargetFSItemText</b>
     * </p>
     *
     * @return Non-Controlling Interest Target Attribute Description
     */
    @SerializedName( "NCITargetFSItemText" )
    @JsonProperty( "NCITargetFSItemText" )
    @Nullable
    @ODataField( odataName = "NCITargetFSItemText" )
    private String nCITargetFSItemText;
    /**
     * Use with available fluent helpers to apply the <b>NCITargetFSItemText</b> field to query operations.
     *
     */
    public final static FinancialStatementItemField<String> NCI_TARGET_FS_ITEM_TEXT =
        new FinancialStatementItemField<String>("NCITargetFSItemText");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PlanningTargetFSItem</b>
     * </p>
     *
     * @return Planning Target Attribute
     */
    @SerializedName( "PlanningTargetFSItem" )
    @JsonProperty( "PlanningTargetFSItem" )
    @Nullable
    @ODataField( odataName = "PlanningTargetFSItem" )
    private String planningTargetFSItem;
    /**
     * Use with available fluent helpers to apply the <b>PlanningTargetFSItem</b> field to query operations.
     *
     */
    public final static FinancialStatementItemField<String> PLANNING_TARGET_FS_ITEM =
        new FinancialStatementItemField<String>("PlanningTargetFSItem");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>PlanningTargetFSItemText</b>
     * </p>
     *
     * @return Planning Target Attribute Description
     */
    @SerializedName( "PlanningTargetFSItemText" )
    @JsonProperty( "PlanningTargetFSItemText" )
    @Nullable
    @ODataField( odataName = "PlanningTargetFSItemText" )
    private String planningTargetFSItemText;
    /**
     * Use with available fluent helpers to apply the <b>PlanningTargetFSItemText</b> field to query operations.
     *
     */
    public final static FinancialStatementItemField<String> PLANNING_TARGET_FS_ITEM_TEXT =
        new FinancialStatementItemField<String>("PlanningTargetFSItemText");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnOffsettingTargetFSItem</b>
     * </p>
     *
     * @return Offsetting Target Attribute
     */
    @SerializedName( "CnsldtnOffsettingTargetFSItem" )
    @JsonProperty( "CnsldtnOffsettingTargetFSItem" )
    @Nullable
    @ODataField( odataName = "CnsldtnOffsettingTargetFSItem" )
    private String cnsldtnOffsettingTargetFSItem;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnOffsettingTargetFSItem</b> field to query operations.
     *
     */
    public final static FinancialStatementItemField<String> CNSLDTN_OFFSETTING_TARGET_FS_ITEM =
        new FinancialStatementItemField<String>("CnsldtnOffsettingTargetFSItem");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnOffstgTargetFSItemText</b>
     * </p>
     *
     * @return Offsetting Target Attribute Description
     */
    @SerializedName( "CnsldtnOffstgTargetFSItemText" )
    @JsonProperty( "CnsldtnOffstgTargetFSItemText" )
    @Nullable
    @ODataField( odataName = "CnsldtnOffstgTargetFSItemText" )
    private String cnsldtnOffstgTargetFSItemText;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnOffstgTargetFSItemText</b> field to query operations.
     *
     */
    public final static FinancialStatementItemField<String> CNSLDTN_OFFSTG_TARGET_FS_ITEM_TEXT =
        new FinancialStatementItemField<String>("CnsldtnOffstgTargetFSItemText");
    /**
     * Navigation property <b>to_CnsldtnFSItemHier</b> for <b>FinancialStatementItem</b> to multiple
     * <b>FinancialStatementItemHier</b>.
     *
     */
    @SerializedName( "to_CnsldtnFSItemHier" )
    @JsonProperty( "to_CnsldtnFSItemHier" )
    @ODataField( odataName = "to_CnsldtnFSItemHier" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<FinancialStatementItemHier> toCnsldtnFSItemHier;
    /**
     * Navigation property <b>to_CnsldtnFSItemT</b> for <b>FinancialStatementItem</b> to multiple
     * <b>FinancialStatementItemText</b>.
     *
     */
    @SerializedName( "to_CnsldtnFSItemT" )
    @JsonProperty( "to_CnsldtnFSItemT" )
    @ODataField( odataName = "to_CnsldtnFSItemT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<FinancialStatementItemText> toCnsldtnFSItemT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnFSItemHier</b> navigation property to query
     * operations.
     *
     */
    public final static FinancialStatementItemLink<FinancialStatementItemHier> TO_CNSLDTN_FS_ITEM_HIER =
        new FinancialStatementItemLink<FinancialStatementItemHier>("to_CnsldtnFSItemHier");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnFSItemT</b> navigation property to query operations.
     *
     */
    public final static FinancialStatementItemLink<FinancialStatementItemText> TO_CNSLDTN_FS_ITEM_T =
        new FinancialStatementItemLink<FinancialStatementItemText>("to_CnsldtnFSItemT");

    @Nonnull
    @Override
    public Class<FinancialStatementItem> getType()
    {
        return FinancialStatementItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts</b>
     * </p>
     *
     * @param consolidationChartOfAccounts
     *            Consolidation Chart of Accounts
     */
    public void setConsolidationChartOfAccounts( @Nullable final String consolidationChartOfAccounts )
    {
        rememberChangedField("ConsolidationChartOfAccounts", this.consolidationChartOfAccounts);
        this.consolidationChartOfAccounts = consolidationChartOfAccounts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts_Text</b>
     * </p>
     *
     * @param consolidationChartOfAccounts_Text
     *            Consolidation Chart of Accounts Description
     */
    public void setConsolidationChartOfAccounts_Text( @Nullable final String consolidationChartOfAccounts_Text )
    {
        rememberChangedField("ConsolidationChartOfAccounts_Text", this.consolidationChartOfAccounts_Text);
        this.consolidationChartOfAccounts_Text = consolidationChartOfAccounts_Text;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItem</b>
     * </p>
     *
     * @param financialStatementItem
     *            Financial Statement Item
     */
    public void setFinancialStatementItem( @Nullable final String financialStatementItem )
    {
        rememberChangedField("FinancialStatementItem", this.financialStatementItem);
        this.financialStatementItem = financialStatementItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItem_Text</b>
     * </p>
     *
     * @param financialStatementItem_Text
     *            Financial Statement Item Description
     */
    public void setFinancialStatementItem_Text( @Nullable final String financialStatementItem_Text )
    {
        rememberChangedField("FinancialStatementItem_Text", this.financialStatementItem_Text);
        this.financialStatementItem_Text = financialStatementItem_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationFSItemType</b>
     * </p>
     *
     * @param consolidationFSItemType
     *            Financial Statement Item Type
     */
    public void setConsolidationFSItemType( @Nullable final String consolidationFSItemType )
    {
        rememberChangedField("ConsolidationFSItemType", this.consolidationFSItemType);
        this.consolidationFSItemType = consolidationFSItemType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationFSItemType_Text</b>
     * </p>
     *
     * @param consolidationFSItemType_Text
     *            Financial Statement Item Type Description
     */
    public void setConsolidationFSItemType_Text( @Nullable final String consolidationFSItemType_Text )
    {
        rememberChangedField("ConsolidationFSItemType_Text", this.consolidationFSItemType_Text);
        this.consolidationFSItemType_Text = consolidationFSItemType_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BreakdownCategory</b>
     * </p>
     *
     * @param breakdownCategory
     *            Breakdown Category
     */
    public void setBreakdownCategory( @Nullable final String breakdownCategory )
    {
        rememberChangedField("BreakdownCategory", this.breakdownCategory);
        this.breakdownCategory = breakdownCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BreakdownCategory_Text</b>
     * </p>
     *
     * @param breakdownCategory_Text
     *            Breakdown Category Description
     */
    public void setBreakdownCategory_Text( @Nullable final String breakdownCategory_Text )
    {
        rememberChangedField("BreakdownCategory_Text", this.breakdownCategory_Text);
        this.breakdownCategory_Text = breakdownCategory_Text;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsConsolidationItem</b>
     * </p>
     *
     * @param isConsolidationItem
     *            Is Consolidation Item
     */
    public void setIsConsolidationItem( @Nullable final Boolean isConsolidationItem )
    {
        rememberChangedField("IsConsolidationItem", this.isConsolidationItem);
        this.isConsolidationItem = isConsolidationItem;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItemIsBlkd</b>
     * </p>
     *
     * @param financialStatementItemIsBlkd
     *            Blocked for Posting
     */
    public void setFinancialStatementItemIsBlkd( @Nullable final Boolean financialStatementItemIsBlkd )
    {
        rememberChangedField("FinancialStatementItemIsBlkd", this.financialStatementItemIsBlkd);
        this.financialStatementItemIsBlkd = financialStatementItemIsBlkd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemElimination</b>
     * </p>
     *
     * @param fSItemElimination
     *            Elimination Selection Attribute
     */
    public void setFSItemElimination( @Nullable final String fSItemElimination )
    {
        rememberChangedField("FSItemElimination", this.fSItemElimination);
        this.fSItemElimination = fSItemElimination;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemEliminationText</b>
     * </p>
     *
     * @param fSItemEliminationText
     *            Elimination Selection Attribute Description
     */
    public void setFSItemEliminationText( @Nullable final String fSItemEliminationText )
    {
        rememberChangedField("FSItemEliminationText", this.fSItemEliminationText);
        this.fSItemEliminationText = fSItemEliminationText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemCurrencyTranslation</b>
     * </p>
     *
     * @param fSItemCurrencyTranslation
     *            Currency Translation Selection Attribute
     */
    public void setFSItemCurrencyTranslation( @Nullable final String fSItemCurrencyTranslation )
    {
        rememberChangedField("FSItemCurrencyTranslation", this.fSItemCurrencyTranslation);
        this.fSItemCurrencyTranslation = fSItemCurrencyTranslation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemCurrencyTranslationText</b>
     * </p>
     *
     * @param fSItemCurrencyTranslationText
     *            Currency Translation Selection Attribute Description
     */
    public void setFSItemCurrencyTranslationText( @Nullable final String fSItemCurrencyTranslationText )
    {
        rememberChangedField("FSItemCurrencyTranslationText", this.fSItemCurrencyTranslationText);
        this.fSItemCurrencyTranslationText = fSItemCurrencyTranslationText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItemRole</b>
     * </p>
     *
     * @param financialStatementItemRole
     *            Financial Statement Item Role
     */
    public void setFinancialStatementItemRole( @Nullable final String financialStatementItemRole )
    {
        rememberChangedField("FinancialStatementItemRole", this.financialStatementItemRole);
        this.financialStatementItemRole = financialStatementItemRole;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemRoleText</b>
     * </p>
     *
     * @param fSItemRoleText
     *            Financial Statement Item Role Description
     */
    public void setFSItemRoleText( @Nullable final String fSItemRoleText )
    {
        rememberChangedField("FSItemRoleText", this.fSItemRoleText);
        this.fSItemRoleText = fSItemRoleText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemDataCollection</b>
     * </p>
     *
     * @param fSItemDataCollection
     *            Data Collection Selection Attribute
     */
    public void setFSItemDataCollection( @Nullable final String fSItemDataCollection )
    {
        rememberChangedField("FSItemDataCollection", this.fSItemDataCollection);
        this.fSItemDataCollection = fSItemDataCollection;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemDataCollectionText</b>
     * </p>
     *
     * @param fSItemDataCollectionText
     *            Data Collection Selection Attribute Description
     */
    public void setFSItemDataCollectionText( @Nullable final String fSItemDataCollectionText )
    {
        rememberChangedField("FSItemDataCollectionText", this.fSItemDataCollectionText);
        this.fSItemDataCollectionText = fSItemDataCollectionText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemCashFlow</b>
     * </p>
     *
     * @param fSItemCashFlow
     *            Cash Flow Selection Attribute
     */
    public void setFSItemCashFlow( @Nullable final String fSItemCashFlow )
    {
        rememberChangedField("FSItemCashFlow", this.fSItemCashFlow);
        this.fSItemCashFlow = fSItemCashFlow;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemCashFlowText</b>
     * </p>
     *
     * @param fSItemCashFlowText
     *            Cash Flow Selection Attribute Description
     */
    public void setFSItemCashFlowText( @Nullable final String fSItemCashFlowText )
    {
        rememberChangedField("FSItemCashFlowText", this.fSItemCashFlowText);
        this.fSItemCashFlowText = fSItemCashFlowText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemScope</b>
     * </p>
     *
     * @param fSItemScope
     *            Scope Selection Attribute
     */
    public void setFSItemScope( @Nullable final String fSItemScope )
    {
        rememberChangedField("FSItemScope", this.fSItemScope);
        this.fSItemScope = fSItemScope;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemScopeText</b>
     * </p>
     *
     * @param fSItemScopeText
     *            Scope Selection Attribute Description
     */
    public void setFSItemScopeText( @Nullable final String fSItemScopeText )
    {
        rememberChangedField("FSItemScopeText", this.fSItemScopeText);
        this.fSItemScopeText = fSItemScopeText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemCustomerSpecific</b>
     * </p>
     *
     * @param fSItemCustomerSpecific
     *            Other Selection Attribute
     */
    public void setFSItemCustomerSpecific( @Nullable final String fSItemCustomerSpecific )
    {
        rememberChangedField("FSItemCustomerSpecific", this.fSItemCustomerSpecific);
        this.fSItemCustomerSpecific = fSItemCustomerSpecific;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FSItemCustomerSpecificText</b>
     * </p>
     *
     * @param fSItemCustomerSpecificText
     *            Other Selection Attribute Description
     */
    public void setFSItemCustomerSpecificText( @Nullable final String fSItemCustomerSpecificText )
    {
        rememberChangedField("FSItemCustomerSpecificText", this.fSItemCustomerSpecificText);
        this.fSItemCustomerSpecificText = fSItemCustomerSpecificText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EliminationTargetFSItem</b>
     * </p>
     *
     * @param eliminationTargetFSItem
     *            Elimination Target Attribute
     */
    public void setEliminationTargetFSItem( @Nullable final String eliminationTargetFSItem )
    {
        rememberChangedField("EliminationTargetFSItem", this.eliminationTargetFSItem);
        this.eliminationTargetFSItem = eliminationTargetFSItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>EliminationTargetFSItemText</b>
     * </p>
     *
     * @param eliminationTargetFSItemText
     *            Elimination Target Attribute Description
     */
    public void setEliminationTargetFSItemText( @Nullable final String eliminationTargetFSItemText )
    {
        rememberChangedField("EliminationTargetFSItemText", this.eliminationTargetFSItemText);
        this.eliminationTargetFSItemText = eliminationTargetFSItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>NCITargetFSItem</b>
     * </p>
     *
     * @param nCITargetFSItem
     *            Non-Controlling Interest Target Attribute
     */
    public void setNCITargetFSItem( @Nullable final String nCITargetFSItem )
    {
        rememberChangedField("NCITargetFSItem", this.nCITargetFSItem);
        this.nCITargetFSItem = nCITargetFSItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>NCITargetFSItemText</b>
     * </p>
     *
     * @param nCITargetFSItemText
     *            Non-Controlling Interest Target Attribute Description
     */
    public void setNCITargetFSItemText( @Nullable final String nCITargetFSItemText )
    {
        rememberChangedField("NCITargetFSItemText", this.nCITargetFSItemText);
        this.nCITargetFSItemText = nCITargetFSItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PlanningTargetFSItem</b>
     * </p>
     *
     * @param planningTargetFSItem
     *            Planning Target Attribute
     */
    public void setPlanningTargetFSItem( @Nullable final String planningTargetFSItem )
    {
        rememberChangedField("PlanningTargetFSItem", this.planningTargetFSItem);
        this.planningTargetFSItem = planningTargetFSItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>PlanningTargetFSItemText</b>
     * </p>
     *
     * @param planningTargetFSItemText
     *            Planning Target Attribute Description
     */
    public void setPlanningTargetFSItemText( @Nullable final String planningTargetFSItemText )
    {
        rememberChangedField("PlanningTargetFSItemText", this.planningTargetFSItemText);
        this.planningTargetFSItemText = planningTargetFSItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnOffsettingTargetFSItem</b>
     * </p>
     *
     * @param cnsldtnOffsettingTargetFSItem
     *            Offsetting Target Attribute
     */
    public void setCnsldtnOffsettingTargetFSItem( @Nullable final String cnsldtnOffsettingTargetFSItem )
    {
        rememberChangedField("CnsldtnOffsettingTargetFSItem", this.cnsldtnOffsettingTargetFSItem);
        this.cnsldtnOffsettingTargetFSItem = cnsldtnOffsettingTargetFSItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnOffstgTargetFSItemText</b>
     * </p>
     *
     * @param cnsldtnOffstgTargetFSItemText
     *            Offsetting Target Attribute Description
     */
    public void setCnsldtnOffstgTargetFSItemText( @Nullable final String cnsldtnOffstgTargetFSItemText )
    {
        rememberChangedField("CnsldtnOffstgTargetFSItemText", this.cnsldtnOffstgTargetFSItemText);
        this.cnsldtnOffstgTargetFSItemText = cnsldtnOffstgTargetFSItemText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "FinancialStatementItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConsolidationChartOfAccounts", getConsolidationChartOfAccounts());
        result.put("FinancialStatementItem", getFinancialStatementItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConsolidationChartOfAccounts", getConsolidationChartOfAccounts());
        values.put("ConsolidationChartOfAccounts_Text", getConsolidationChartOfAccounts_Text());
        values.put("FinancialStatementItem", getFinancialStatementItem());
        values.put("FinancialStatementItem_Text", getFinancialStatementItem_Text());
        values.put("ConsolidationFSItemType", getConsolidationFSItemType());
        values.put("ConsolidationFSItemType_Text", getConsolidationFSItemType_Text());
        values.put("BreakdownCategory", getBreakdownCategory());
        values.put("BreakdownCategory_Text", getBreakdownCategory_Text());
        values.put("IsConsolidationItem", getIsConsolidationItem());
        values.put("FinancialStatementItemIsBlkd", getFinancialStatementItemIsBlkd());
        values.put("FSItemElimination", getFSItemElimination());
        values.put("FSItemEliminationText", getFSItemEliminationText());
        values.put("FSItemCurrencyTranslation", getFSItemCurrencyTranslation());
        values.put("FSItemCurrencyTranslationText", getFSItemCurrencyTranslationText());
        values.put("FinancialStatementItemRole", getFinancialStatementItemRole());
        values.put("FSItemRoleText", getFSItemRoleText());
        values.put("FSItemDataCollection", getFSItemDataCollection());
        values.put("FSItemDataCollectionText", getFSItemDataCollectionText());
        values.put("FSItemCashFlow", getFSItemCashFlow());
        values.put("FSItemCashFlowText", getFSItemCashFlowText());
        values.put("FSItemScope", getFSItemScope());
        values.put("FSItemScopeText", getFSItemScopeText());
        values.put("FSItemCustomerSpecific", getFSItemCustomerSpecific());
        values.put("FSItemCustomerSpecificText", getFSItemCustomerSpecificText());
        values.put("EliminationTargetFSItem", getEliminationTargetFSItem());
        values.put("EliminationTargetFSItemText", getEliminationTargetFSItemText());
        values.put("NCITargetFSItem", getNCITargetFSItem());
        values.put("NCITargetFSItemText", getNCITargetFSItemText());
        values.put("PlanningTargetFSItem", getPlanningTargetFSItem());
        values.put("PlanningTargetFSItemText", getPlanningTargetFSItemText());
        values.put("CnsldtnOffsettingTargetFSItem", getCnsldtnOffsettingTargetFSItem());
        values.put("CnsldtnOffstgTargetFSItemText", getCnsldtnOffstgTargetFSItemText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConsolidationChartOfAccounts") ) {
                final Object value = values.remove("ConsolidationChartOfAccounts");
                if( (value == null) || (!value.equals(getConsolidationChartOfAccounts())) ) {
                    setConsolidationChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("ConsolidationChartOfAccounts_Text") ) {
                final Object value = values.remove("ConsolidationChartOfAccounts_Text");
                if( (value == null) || (!value.equals(getConsolidationChartOfAccounts_Text())) ) {
                    setConsolidationChartOfAccounts_Text(((String) value));
                }
            }
            if( values.containsKey("FinancialStatementItem") ) {
                final Object value = values.remove("FinancialStatementItem");
                if( (value == null) || (!value.equals(getFinancialStatementItem())) ) {
                    setFinancialStatementItem(((String) value));
                }
            }
            if( values.containsKey("FinancialStatementItem_Text") ) {
                final Object value = values.remove("FinancialStatementItem_Text");
                if( (value == null) || (!value.equals(getFinancialStatementItem_Text())) ) {
                    setFinancialStatementItem_Text(((String) value));
                }
            }
            if( values.containsKey("ConsolidationFSItemType") ) {
                final Object value = values.remove("ConsolidationFSItemType");
                if( (value == null) || (!value.equals(getConsolidationFSItemType())) ) {
                    setConsolidationFSItemType(((String) value));
                }
            }
            if( values.containsKey("ConsolidationFSItemType_Text") ) {
                final Object value = values.remove("ConsolidationFSItemType_Text");
                if( (value == null) || (!value.equals(getConsolidationFSItemType_Text())) ) {
                    setConsolidationFSItemType_Text(((String) value));
                }
            }
            if( values.containsKey("BreakdownCategory") ) {
                final Object value = values.remove("BreakdownCategory");
                if( (value == null) || (!value.equals(getBreakdownCategory())) ) {
                    setBreakdownCategory(((String) value));
                }
            }
            if( values.containsKey("BreakdownCategory_Text") ) {
                final Object value = values.remove("BreakdownCategory_Text");
                if( (value == null) || (!value.equals(getBreakdownCategory_Text())) ) {
                    setBreakdownCategory_Text(((String) value));
                }
            }
            if( values.containsKey("IsConsolidationItem") ) {
                final Object value = values.remove("IsConsolidationItem");
                if( (value == null) || (!value.equals(getIsConsolidationItem())) ) {
                    setIsConsolidationItem(((Boolean) value));
                }
            }
            if( values.containsKey("FinancialStatementItemIsBlkd") ) {
                final Object value = values.remove("FinancialStatementItemIsBlkd");
                if( (value == null) || (!value.equals(getFinancialStatementItemIsBlkd())) ) {
                    setFinancialStatementItemIsBlkd(((Boolean) value));
                }
            }
            if( values.containsKey("FSItemElimination") ) {
                final Object value = values.remove("FSItemElimination");
                if( (value == null) || (!value.equals(getFSItemElimination())) ) {
                    setFSItemElimination(((String) value));
                }
            }
            if( values.containsKey("FSItemEliminationText") ) {
                final Object value = values.remove("FSItemEliminationText");
                if( (value == null) || (!value.equals(getFSItemEliminationText())) ) {
                    setFSItemEliminationText(((String) value));
                }
            }
            if( values.containsKey("FSItemCurrencyTranslation") ) {
                final Object value = values.remove("FSItemCurrencyTranslation");
                if( (value == null) || (!value.equals(getFSItemCurrencyTranslation())) ) {
                    setFSItemCurrencyTranslation(((String) value));
                }
            }
            if( values.containsKey("FSItemCurrencyTranslationText") ) {
                final Object value = values.remove("FSItemCurrencyTranslationText");
                if( (value == null) || (!value.equals(getFSItemCurrencyTranslationText())) ) {
                    setFSItemCurrencyTranslationText(((String) value));
                }
            }
            if( values.containsKey("FinancialStatementItemRole") ) {
                final Object value = values.remove("FinancialStatementItemRole");
                if( (value == null) || (!value.equals(getFinancialStatementItemRole())) ) {
                    setFinancialStatementItemRole(((String) value));
                }
            }
            if( values.containsKey("FSItemRoleText") ) {
                final Object value = values.remove("FSItemRoleText");
                if( (value == null) || (!value.equals(getFSItemRoleText())) ) {
                    setFSItemRoleText(((String) value));
                }
            }
            if( values.containsKey("FSItemDataCollection") ) {
                final Object value = values.remove("FSItemDataCollection");
                if( (value == null) || (!value.equals(getFSItemDataCollection())) ) {
                    setFSItemDataCollection(((String) value));
                }
            }
            if( values.containsKey("FSItemDataCollectionText") ) {
                final Object value = values.remove("FSItemDataCollectionText");
                if( (value == null) || (!value.equals(getFSItemDataCollectionText())) ) {
                    setFSItemDataCollectionText(((String) value));
                }
            }
            if( values.containsKey("FSItemCashFlow") ) {
                final Object value = values.remove("FSItemCashFlow");
                if( (value == null) || (!value.equals(getFSItemCashFlow())) ) {
                    setFSItemCashFlow(((String) value));
                }
            }
            if( values.containsKey("FSItemCashFlowText") ) {
                final Object value = values.remove("FSItemCashFlowText");
                if( (value == null) || (!value.equals(getFSItemCashFlowText())) ) {
                    setFSItemCashFlowText(((String) value));
                }
            }
            if( values.containsKey("FSItemScope") ) {
                final Object value = values.remove("FSItemScope");
                if( (value == null) || (!value.equals(getFSItemScope())) ) {
                    setFSItemScope(((String) value));
                }
            }
            if( values.containsKey("FSItemScopeText") ) {
                final Object value = values.remove("FSItemScopeText");
                if( (value == null) || (!value.equals(getFSItemScopeText())) ) {
                    setFSItemScopeText(((String) value));
                }
            }
            if( values.containsKey("FSItemCustomerSpecific") ) {
                final Object value = values.remove("FSItemCustomerSpecific");
                if( (value == null) || (!value.equals(getFSItemCustomerSpecific())) ) {
                    setFSItemCustomerSpecific(((String) value));
                }
            }
            if( values.containsKey("FSItemCustomerSpecificText") ) {
                final Object value = values.remove("FSItemCustomerSpecificText");
                if( (value == null) || (!value.equals(getFSItemCustomerSpecificText())) ) {
                    setFSItemCustomerSpecificText(((String) value));
                }
            }
            if( values.containsKey("EliminationTargetFSItem") ) {
                final Object value = values.remove("EliminationTargetFSItem");
                if( (value == null) || (!value.equals(getEliminationTargetFSItem())) ) {
                    setEliminationTargetFSItem(((String) value));
                }
            }
            if( values.containsKey("EliminationTargetFSItemText") ) {
                final Object value = values.remove("EliminationTargetFSItemText");
                if( (value == null) || (!value.equals(getEliminationTargetFSItemText())) ) {
                    setEliminationTargetFSItemText(((String) value));
                }
            }
            if( values.containsKey("NCITargetFSItem") ) {
                final Object value = values.remove("NCITargetFSItem");
                if( (value == null) || (!value.equals(getNCITargetFSItem())) ) {
                    setNCITargetFSItem(((String) value));
                }
            }
            if( values.containsKey("NCITargetFSItemText") ) {
                final Object value = values.remove("NCITargetFSItemText");
                if( (value == null) || (!value.equals(getNCITargetFSItemText())) ) {
                    setNCITargetFSItemText(((String) value));
                }
            }
            if( values.containsKey("PlanningTargetFSItem") ) {
                final Object value = values.remove("PlanningTargetFSItem");
                if( (value == null) || (!value.equals(getPlanningTargetFSItem())) ) {
                    setPlanningTargetFSItem(((String) value));
                }
            }
            if( values.containsKey("PlanningTargetFSItemText") ) {
                final Object value = values.remove("PlanningTargetFSItemText");
                if( (value == null) || (!value.equals(getPlanningTargetFSItemText())) ) {
                    setPlanningTargetFSItemText(((String) value));
                }
            }
            if( values.containsKey("CnsldtnOffsettingTargetFSItem") ) {
                final Object value = values.remove("CnsldtnOffsettingTargetFSItem");
                if( (value == null) || (!value.equals(getCnsldtnOffsettingTargetFSItem())) ) {
                    setCnsldtnOffsettingTargetFSItem(((String) value));
                }
            }
            if( values.containsKey("CnsldtnOffstgTargetFSItemText") ) {
                final Object value = values.remove("CnsldtnOffstgTargetFSItemText");
                if( (value == null) || (!value.equals(getCnsldtnOffstgTargetFSItemText())) ) {
                    setCnsldtnOffstgTargetFSItemText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnFSItemHier") ) {
                final Object value = (values).remove("to_CnsldtnFSItemHier");
                if( value instanceof Iterable ) {
                    if( toCnsldtnFSItemHier == null ) {
                        toCnsldtnFSItemHier = Lists.newArrayList();
                    } else {
                        toCnsldtnFSItemHier = Lists.newArrayList(toCnsldtnFSItemHier);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        FinancialStatementItemHier entity;
                        if( toCnsldtnFSItemHier.size() > i ) {
                            entity = toCnsldtnFSItemHier.get(i);
                        } else {
                            entity = new FinancialStatementItemHier();
                            toCnsldtnFSItemHier.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CnsldtnFSItemT") ) {
                final Object value = (values).remove("to_CnsldtnFSItemT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnFSItemT == null ) {
                        toCnsldtnFSItemT = Lists.newArrayList();
                    } else {
                        toCnsldtnFSItemT = Lists.newArrayList(toCnsldtnFSItemT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        FinancialStatementItemText entity;
                        if( toCnsldtnFSItemT.size() > i ) {
                            entity = toCnsldtnFSItemT.get(i);
                        } else {
                            entity = new FinancialStatementItemText();
                            toCnsldtnFSItemT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> FinancialStatementItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new FinancialStatementItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FinancialStatementItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FinancialStatementItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnFSItemHier != null ) {
            (values).put("to_CnsldtnFSItemHier", toCnsldtnFSItemHier);
        }
        if( toCnsldtnFSItemT != null ) {
            (values).put("to_CnsldtnFSItemT", toCnsldtnFSItemT);
        }
        return values;
    }

    /**
     * Fetches the <b>FinancialStatementItemHier</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_CnsldtnFSItemHier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>FinancialStatementItemHier</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<FinancialStatementItemHier> fetchCnsldtnFSItemHier()
    {
        return fetchFieldAsList("to_CnsldtnFSItemHier", FinancialStatementItemHier.class);
    }

    /**
     * Retrieval of associated <b>FinancialStatementItemHier</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItemHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItemHier</b> of a queried <b>FinancialStatementItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>FinancialStatementItemHier</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<FinancialStatementItemHier> getCnsldtnFSItemHierOrFetch()
    {
        if( toCnsldtnFSItemHier == null ) {
            toCnsldtnFSItemHier = fetchCnsldtnFSItemHier();
        }
        return toCnsldtnFSItemHier;
    }

    /**
     * Retrieval of associated <b>FinancialStatementItemHier</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItemHier</b>.
     * <p>
     * If the navigation property for an entity <b>FinancialStatementItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnFSItemHier</b> is already loaded, the result will
     *         contain the <b>FinancialStatementItemHier</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<FinancialStatementItemHier>> getCnsldtnFSItemHierIfPresent()
    {
        return Option.of(toCnsldtnFSItemHier);
    }

    /**
     * Overwrites the list of associated <b>FinancialStatementItemHier</b> entities for the loaded navigation property
     * <b>to_CnsldtnFSItemHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItemHier</b> of a queried <b>FinancialStatementItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>FinancialStatementItemHier</b> entities.
     */
    public void setCnsldtnFSItemHier( @Nonnull final List<FinancialStatementItemHier> value )
    {
        if( toCnsldtnFSItemHier == null ) {
            toCnsldtnFSItemHier = Lists.newArrayList();
        }
        toCnsldtnFSItemHier.clear();
        toCnsldtnFSItemHier.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>FinancialStatementItemHier</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItemHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItemHier</b> of a queried <b>FinancialStatementItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>FinancialStatementItemHier</b> entities.
     */
    public void addCnsldtnFSItemHier( FinancialStatementItemHier... entity )
    {
        if( toCnsldtnFSItemHier == null ) {
            toCnsldtnFSItemHier = Lists.newArrayList();
        }
        toCnsldtnFSItemHier.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>FinancialStatementItemText</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_CnsldtnFSItemT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>FinancialStatementItemText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<FinancialStatementItemText> fetchCnsldtnFSItemT()
    {
        return fetchFieldAsList("to_CnsldtnFSItemT", FinancialStatementItemText.class);
    }

    /**
     * Retrieval of associated <b>FinancialStatementItemText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItemT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItemT</b> of a queried <b>FinancialStatementItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>FinancialStatementItemText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<FinancialStatementItemText> getCnsldtnFSItemTOrFetch()
    {
        if( toCnsldtnFSItemT == null ) {
            toCnsldtnFSItemT = fetchCnsldtnFSItemT();
        }
        return toCnsldtnFSItemT;
    }

    /**
     * Retrieval of associated <b>FinancialStatementItemText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItemT</b>.
     * <p>
     * If the navigation property for an entity <b>FinancialStatementItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnFSItemT</b> is already loaded, the result will
     *         contain the <b>FinancialStatementItemText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<FinancialStatementItemText>> getCnsldtnFSItemTIfPresent()
    {
        return Option.of(toCnsldtnFSItemT);
    }

    /**
     * Overwrites the list of associated <b>FinancialStatementItemText</b> entities for the loaded navigation property
     * <b>to_CnsldtnFSItemT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItemT</b> of a queried <b>FinancialStatementItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>FinancialStatementItemText</b> entities.
     */
    public void setCnsldtnFSItemT( @Nonnull final List<FinancialStatementItemText> value )
    {
        if( toCnsldtnFSItemT == null ) {
            toCnsldtnFSItemT = Lists.newArrayList();
        }
        toCnsldtnFSItemT.clear();
        toCnsldtnFSItemT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>FinancialStatementItemText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItemT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItemT</b> of a queried <b>FinancialStatementItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>FinancialStatementItemText</b> entities.
     */
    public void addCnsldtnFSItemT( FinancialStatementItemText... entity )
    {
        if( toCnsldtnFSItemT == null ) {
            toCnsldtnFSItemT = Lists.newArrayList();
        }
        toCnsldtnFSItemT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of FinancialStatementItem instances.
     *
     */
    public final static class FinancialStatementItemBuilder
    {

        private List<FinancialStatementItemHier> toCnsldtnFSItemHier = Lists.newArrayList();
        private List<FinancialStatementItemText> toCnsldtnFSItemT = Lists.newArrayList();

        private FinancialStatementItem.FinancialStatementItemBuilder toCnsldtnFSItemHier(
            final List<FinancialStatementItemHier> value )
        {
            toCnsldtnFSItemHier.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnFSItemHier</b> for <b>FinancialStatementItem</b> to multiple
         * <b>FinancialStatementItemHier</b>.
         *
         * @param value
         *            The FinancialStatementItemHiers to build this FinancialStatementItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FinancialStatementItem.FinancialStatementItemBuilder cnsldtnFSItemHier(
            FinancialStatementItemHier... value )
        {
            return toCnsldtnFSItemHier(Lists.newArrayList(value));
        }

        private FinancialStatementItem.FinancialStatementItemBuilder toCnsldtnFSItemT(
            final List<FinancialStatementItemText> value )
        {
            toCnsldtnFSItemT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnFSItemT</b> for <b>FinancialStatementItem</b> to multiple
         * <b>FinancialStatementItemText</b>.
         *
         * @param value
         *            The FinancialStatementItemTexts to build this FinancialStatementItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FinancialStatementItem.FinancialStatementItemBuilder cnsldtnFSItemT(
            FinancialStatementItemText... value )
        {
            return toCnsldtnFSItemT(Lists.newArrayList(value));
        }

    }

}
