/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.FinancialStatementItemHier_2Field;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.FinancialStatementItemHier_2Link;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.FinancialStatementItemHier_2OneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.FinancialStatementItemHier_2Selectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Financial Statement Item V2 - Hier Node
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>FinancialStatementItemHier_2Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class FinancialStatementItemHier_2 extends VdmEntity<FinancialStatementItemHier_2>
{

    /**
     * Selector for all available fields of FinancialStatementItemHier_2.
     *
     */
    public final static FinancialStatementItemHier_2Selectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts</b>
     * </p>
     *
     * @return Consolidation Chart of Accounts
     */
    @Key
    @SerializedName( "ConsolidationChartOfAccounts" )
    @JsonProperty( "ConsolidationChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "ConsolidationChartOfAccounts" )
    private String consolidationChartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationChartOfAccounts</b> field to query operations.
     *
     */
    public final static FinancialStatementItemHier_2Field<String> CONSOLIDATION_CHART_OF_ACCOUNTS =
        new FinancialStatementItemHier_2Field<String>("ConsolidationChartOfAccounts");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts_Text</b>
     * </p>
     *
     * @return Consolidation Chart of Accounts Description
     */
    @SerializedName( "ConsolidationChartOfAccounts_Text" )
    @JsonProperty( "ConsolidationChartOfAccounts_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationChartOfAccounts_Text" )
    private String consolidationChartOfAccounts_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationChartOfAccounts_Text</b> field to query
     * operations.
     *
     */
    public final static FinancialStatementItemHier_2Field<String> CONSOLIDATION_CHART_OF_ACCOUNTS_TEXT =
        new FinancialStatementItemHier_2Field<String>("ConsolidationChartOfAccounts_Text");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItemHier</b>
     * </p>
     *
     * @return Consolidation Financial Item Statement Hierarchy
     */
    @Key
    @SerializedName( "FinancialStatementItemHier" )
    @JsonProperty( "FinancialStatementItemHier" )
    @Nullable
    @ODataField( odataName = "FinancialStatementItemHier" )
    private String financialStatementItemHier;
    /**
     * Use with available fluent helpers to apply the <b>FinancialStatementItemHier</b> field to query operations.
     *
     */
    public final static FinancialStatementItemHier_2Field<String> FINANCIAL_STATEMENT_ITEM_HIER =
        new FinancialStatementItemHier_2Field<String>("FinancialStatementItemHier");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @return Consolidation Hierarchy Node
     */
    @Key
    @SerializedName( "HierarchyNode" )
    @JsonProperty( "HierarchyNode" )
    @Nullable
    @ODataField( odataName = "HierarchyNode" )
    private String hierarchyNode;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNode</b> field to query operations.
     *
     */
    public final static FinancialStatementItemHier_2Field<String> HIERARCHY_NODE =
        new FinancialStatementItemHier_2Field<String>("HierarchyNode");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode_Text</b>
     * </p>
     *
     * @return Consolidation Hierarchy Node Description
     */
    @SerializedName( "HierarchyNode_Text" )
    @JsonProperty( "HierarchyNode_Text" )
    @Nullable
    @ODataField( odataName = "HierarchyNode_Text" )
    private String hierarchyNode_Text;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNode_Text</b> field to query operations.
     *
     */
    public final static FinancialStatementItemHier_2Field<String> HIERARCHY_NODE_TEXT =
        new FinancialStatementItemHier_2Field<String>("HierarchyNode_Text");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ParentNode</b>
     * </p>
     *
     * @return Consolidation Hierarchy Parent Node
     */
    @SerializedName( "ParentNode" )
    @JsonProperty( "ParentNode" )
    @Nullable
    @ODataField( odataName = "ParentNode" )
    private String parentNode;
    /**
     * Use with available fluent helpers to apply the <b>ParentNode</b> field to query operations.
     *
     */
    public final static FinancialStatementItemHier_2Field<String> PARENT_NODE =
        new FinancialStatementItemHier_2Field<String>("ParentNode");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyVersion</b>
     * </p>
     *
     * @return Consolidation Hierarchy Version
     */
    @SerializedName( "HierarchyVersion" )
    @JsonProperty( "HierarchyVersion" )
    @Nullable
    @ODataField( odataName = "HierarchyVersion" )
    private String hierarchyVersion;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyVersion</b> field to query operations.
     *
     */
    public final static FinancialStatementItemHier_2Field<String> HIERARCHY_VERSION =
        new FinancialStatementItemHier_2Field<String>("HierarchyVersion");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItem</b>
     * </p>
     *
     * @return Financial Statement Item
     */
    @SerializedName( "FinancialStatementItem" )
    @JsonProperty( "FinancialStatementItem" )
    @Nullable
    @ODataField( odataName = "FinancialStatementItem" )
    private String financialStatementItem;
    /**
     * Use with available fluent helpers to apply the <b>FinancialStatementItem</b> field to query operations.
     *
     */
    public final static FinancialStatementItemHier_2Field<String> FINANCIAL_STATEMENT_ITEM =
        new FinancialStatementItemHier_2Field<String>("FinancialStatementItem");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItem_Text</b>
     * </p>
     *
     * @return Financial Statement Item Medium Description
     */
    @SerializedName( "FinancialStatementItem_Text" )
    @JsonProperty( "FinancialStatementItem_Text" )
    @Nullable
    @ODataField( odataName = "FinancialStatementItem_Text" )
    private String financialStatementItem_Text;
    /**
     * Use with available fluent helpers to apply the <b>FinancialStatementItem_Text</b> field to query operations.
     *
     */
    public final static FinancialStatementItemHier_2Field<String> FINANCIAL_STATEMENT_ITEM_TEXT =
        new FinancialStatementItemHier_2Field<String>("FinancialStatementItem_Text");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SequenceNumber</b>
     * </p>
     *
     * @return Consolidation Hierarchy Sequence Number
     */
    @SerializedName( "SequenceNumber" )
    @JsonProperty( "SequenceNumber" )
    @Nullable
    @ODataField( odataName = "SequenceNumber" )
    private String sequenceNumber;
    /**
     * Use with available fluent helpers to apply the <b>SequenceNumber</b> field to query operations.
     *
     */
    public final static FinancialStatementItemHier_2Field<String> SEQUENCE_NUMBER =
        new FinancialStatementItemHier_2Field<String>("SequenceNumber");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeLevel</b>
     * </p>
     *
     * @return Consolidation Hierarchy Level
     */
    @SerializedName( "HierarchyNodeLevel" )
    @JsonProperty( "HierarchyNodeLevel" )
    @Nullable
    @ODataField( odataName = "HierarchyNodeLevel" )
    private String hierarchyNodeLevel;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNodeLevel</b> field to query operations.
     *
     */
    public final static FinancialStatementItemHier_2Field<String> HIERARCHY_NODE_LEVEL =
        new FinancialStatementItemHier_2Field<String>("HierarchyNodeLevel");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @return Consolidation Hierarchy Node Type
     */
    @SerializedName( "NodeType" )
    @JsonProperty( "NodeType" )
    @Nullable
    @ODataField( odataName = "NodeType" )
    private String nodeType;
    /**
     * Use with available fluent helpers to apply the <b>NodeType</b> field to query operations.
     *
     */
    public final static FinancialStatementItemHier_2Field<String> NODE_TYPE =
        new FinancialStatementItemHier_2Field<String>("NodeType");
    /**
     * Navigation property <b>to_CnsldtnFSItem</b> for <b>FinancialStatementItemHier_2</b> to single
     * <b>FinancialStatementItem_2</b>.
     *
     */
    @SerializedName( "to_CnsldtnFSItem" )
    @JsonProperty( "to_CnsldtnFSItem" )
    @ODataField( odataName = "to_CnsldtnFSItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private FinancialStatementItem_2 toCnsldtnFSItem;
    /**
     * Navigation property <b>to_CnsldtnFSItemHierT</b> for <b>FinancialStatementItemHier_2</b> to multiple
     * <b>FinancialStmntItemHierText_2</b>.
     *
     */
    @SerializedName( "to_CnsldtnFSItemHierT" )
    @JsonProperty( "to_CnsldtnFSItemHierT" )
    @ODataField( odataName = "to_CnsldtnFSItemHierT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<FinancialStmntItemHierText_2> toCnsldtnFSItemHierT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnFSItem</b> navigation property to query operations.
     *
     */
    public final static FinancialStatementItemHier_2OneToOneLink<FinancialStatementItem_2> TO_CNSLDTN_FS_ITEM =
        new FinancialStatementItemHier_2OneToOneLink<FinancialStatementItem_2>("to_CnsldtnFSItem");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnFSItemHierT</b> navigation property to query
     * operations.
     *
     */
    public final static FinancialStatementItemHier_2Link<FinancialStmntItemHierText_2> TO_CNSLDTN_FS_ITEM_HIER_T =
        new FinancialStatementItemHier_2Link<FinancialStmntItemHierText_2>("to_CnsldtnFSItemHierT");

    @Nonnull
    @Override
    public Class<FinancialStatementItemHier_2> getType()
    {
        return FinancialStatementItemHier_2.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts</b>
     * </p>
     *
     * @param consolidationChartOfAccounts
     *            Consolidation Chart of Accounts
     */
    public void setConsolidationChartOfAccounts( @Nullable final String consolidationChartOfAccounts )
    {
        rememberChangedField("ConsolidationChartOfAccounts", this.consolidationChartOfAccounts);
        this.consolidationChartOfAccounts = consolidationChartOfAccounts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts_Text</b>
     * </p>
     *
     * @param consolidationChartOfAccounts_Text
     *            Consolidation Chart of Accounts Description
     */
    public void setConsolidationChartOfAccounts_Text( @Nullable final String consolidationChartOfAccounts_Text )
    {
        rememberChangedField("ConsolidationChartOfAccounts_Text", this.consolidationChartOfAccounts_Text);
        this.consolidationChartOfAccounts_Text = consolidationChartOfAccounts_Text;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItemHier</b>
     * </p>
     *
     * @param financialStatementItemHier
     *            Consolidation Financial Item Statement Hierarchy
     */
    public void setFinancialStatementItemHier( @Nullable final String financialStatementItemHier )
    {
        rememberChangedField("FinancialStatementItemHier", this.financialStatementItemHier);
        this.financialStatementItemHier = financialStatementItemHier;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @param hierarchyNode
     *            Consolidation Hierarchy Node
     */
    public void setHierarchyNode( @Nullable final String hierarchyNode )
    {
        rememberChangedField("HierarchyNode", this.hierarchyNode);
        this.hierarchyNode = hierarchyNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode_Text</b>
     * </p>
     *
     * @param hierarchyNode_Text
     *            Consolidation Hierarchy Node Description
     */
    public void setHierarchyNode_Text( @Nullable final String hierarchyNode_Text )
    {
        rememberChangedField("HierarchyNode_Text", this.hierarchyNode_Text);
        this.hierarchyNode_Text = hierarchyNode_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ParentNode</b>
     * </p>
     *
     * @param parentNode
     *            Consolidation Hierarchy Parent Node
     */
    public void setParentNode( @Nullable final String parentNode )
    {
        rememberChangedField("ParentNode", this.parentNode);
        this.parentNode = parentNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyVersion</b>
     * </p>
     *
     * @param hierarchyVersion
     *            Consolidation Hierarchy Version
     */
    public void setHierarchyVersion( @Nullable final String hierarchyVersion )
    {
        rememberChangedField("HierarchyVersion", this.hierarchyVersion);
        this.hierarchyVersion = hierarchyVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItem</b>
     * </p>
     *
     * @param financialStatementItem
     *            Financial Statement Item
     */
    public void setFinancialStatementItem( @Nullable final String financialStatementItem )
    {
        rememberChangedField("FinancialStatementItem", this.financialStatementItem);
        this.financialStatementItem = financialStatementItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItem_Text</b>
     * </p>
     *
     * @param financialStatementItem_Text
     *            Financial Statement Item Medium Description
     */
    public void setFinancialStatementItem_Text( @Nullable final String financialStatementItem_Text )
    {
        rememberChangedField("FinancialStatementItem_Text", this.financialStatementItem_Text);
        this.financialStatementItem_Text = financialStatementItem_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SequenceNumber</b>
     * </p>
     *
     * @param sequenceNumber
     *            Consolidation Hierarchy Sequence Number
     */
    public void setSequenceNumber( @Nullable final String sequenceNumber )
    {
        rememberChangedField("SequenceNumber", this.sequenceNumber);
        this.sequenceNumber = sequenceNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeLevel</b>
     * </p>
     *
     * @param hierarchyNodeLevel
     *            Consolidation Hierarchy Level
     */
    public void setHierarchyNodeLevel( @Nullable final String hierarchyNodeLevel )
    {
        rememberChangedField("HierarchyNodeLevel", this.hierarchyNodeLevel);
        this.hierarchyNodeLevel = hierarchyNodeLevel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @param nodeType
     *            Consolidation Hierarchy Node Type
     */
    public void setNodeType( @Nullable final String nodeType )
    {
        rememberChangedField("NodeType", this.nodeType);
        this.nodeType = nodeType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "FinancialStatementItemHier_2";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConsolidationChartOfAccounts", getConsolidationChartOfAccounts());
        result.put("FinancialStatementItemHier", getFinancialStatementItemHier());
        result.put("HierarchyNode", getHierarchyNode());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConsolidationChartOfAccounts", getConsolidationChartOfAccounts());
        values.put("ConsolidationChartOfAccounts_Text", getConsolidationChartOfAccounts_Text());
        values.put("FinancialStatementItemHier", getFinancialStatementItemHier());
        values.put("HierarchyNode", getHierarchyNode());
        values.put("HierarchyNode_Text", getHierarchyNode_Text());
        values.put("ParentNode", getParentNode());
        values.put("HierarchyVersion", getHierarchyVersion());
        values.put("FinancialStatementItem", getFinancialStatementItem());
        values.put("FinancialStatementItem_Text", getFinancialStatementItem_Text());
        values.put("SequenceNumber", getSequenceNumber());
        values.put("HierarchyNodeLevel", getHierarchyNodeLevel());
        values.put("NodeType", getNodeType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConsolidationChartOfAccounts") ) {
                final Object value = values.remove("ConsolidationChartOfAccounts");
                if( (value == null) || (!value.equals(getConsolidationChartOfAccounts())) ) {
                    setConsolidationChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("ConsolidationChartOfAccounts_Text") ) {
                final Object value = values.remove("ConsolidationChartOfAccounts_Text");
                if( (value == null) || (!value.equals(getConsolidationChartOfAccounts_Text())) ) {
                    setConsolidationChartOfAccounts_Text(((String) value));
                }
            }
            if( values.containsKey("FinancialStatementItemHier") ) {
                final Object value = values.remove("FinancialStatementItemHier");
                if( (value == null) || (!value.equals(getFinancialStatementItemHier())) ) {
                    setFinancialStatementItemHier(((String) value));
                }
            }
            if( values.containsKey("HierarchyNode") ) {
                final Object value = values.remove("HierarchyNode");
                if( (value == null) || (!value.equals(getHierarchyNode())) ) {
                    setHierarchyNode(((String) value));
                }
            }
            if( values.containsKey("HierarchyNode_Text") ) {
                final Object value = values.remove("HierarchyNode_Text");
                if( (value == null) || (!value.equals(getHierarchyNode_Text())) ) {
                    setHierarchyNode_Text(((String) value));
                }
            }
            if( values.containsKey("ParentNode") ) {
                final Object value = values.remove("ParentNode");
                if( (value == null) || (!value.equals(getParentNode())) ) {
                    setParentNode(((String) value));
                }
            }
            if( values.containsKey("HierarchyVersion") ) {
                final Object value = values.remove("HierarchyVersion");
                if( (value == null) || (!value.equals(getHierarchyVersion())) ) {
                    setHierarchyVersion(((String) value));
                }
            }
            if( values.containsKey("FinancialStatementItem") ) {
                final Object value = values.remove("FinancialStatementItem");
                if( (value == null) || (!value.equals(getFinancialStatementItem())) ) {
                    setFinancialStatementItem(((String) value));
                }
            }
            if( values.containsKey("FinancialStatementItem_Text") ) {
                final Object value = values.remove("FinancialStatementItem_Text");
                if( (value == null) || (!value.equals(getFinancialStatementItem_Text())) ) {
                    setFinancialStatementItem_Text(((String) value));
                }
            }
            if( values.containsKey("SequenceNumber") ) {
                final Object value = values.remove("SequenceNumber");
                if( (value == null) || (!value.equals(getSequenceNumber())) ) {
                    setSequenceNumber(((String) value));
                }
            }
            if( values.containsKey("HierarchyNodeLevel") ) {
                final Object value = values.remove("HierarchyNodeLevel");
                if( (value == null) || (!value.equals(getHierarchyNodeLevel())) ) {
                    setHierarchyNodeLevel(((String) value));
                }
            }
            if( values.containsKey("NodeType") ) {
                final Object value = values.remove("NodeType");
                if( (value == null) || (!value.equals(getNodeType())) ) {
                    setNodeType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnFSItem") ) {
                final Object value = (values).remove("to_CnsldtnFSItem");
                if( value instanceof Map ) {
                    if( toCnsldtnFSItem == null ) {
                        toCnsldtnFSItem = new FinancialStatementItem_2();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnFSItem.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_CnsldtnFSItemHierT") ) {
                final Object value = (values).remove("to_CnsldtnFSItemHierT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnFSItemHierT == null ) {
                        toCnsldtnFSItemHierT = Lists.newArrayList();
                    } else {
                        toCnsldtnFSItemHierT = Lists.newArrayList(toCnsldtnFSItemHierT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        FinancialStmntItemHierText_2 entity;
                        if( toCnsldtnFSItemHierT.size() > i ) {
                            entity = toCnsldtnFSItemHierT.get(i);
                        } else {
                            entity = new FinancialStmntItemHierText_2();
                            toCnsldtnFSItemHierT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> FinancialStatementItemHier_2Field<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new FinancialStatementItemHier_2Field<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FinancialStatementItemHier_2Field<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FinancialStatementItemHier_2Field<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnFSItem != null ) {
            (values).put("to_CnsldtnFSItem", toCnsldtnFSItem);
        }
        if( toCnsldtnFSItemHierT != null ) {
            (values).put("to_CnsldtnFSItemHierT", toCnsldtnFSItemHierT);
        }
        return values;
    }

    /**
     * Fetches the <b>FinancialStatementItem_2</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CnsldtnFSItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>FinancialStatementItem_2</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public FinancialStatementItem_2 fetchCnsldtnFSItem()
    {
        return fetchFieldAsSingle("to_CnsldtnFSItem", FinancialStatementItem_2.class);
    }

    /**
     * Retrieval of associated <b>FinancialStatementItem_2</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItem</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItem</b> of a queried <b>FinancialStatementItemHier_2</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>FinancialStatementItem_2</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public FinancialStatementItem_2 getCnsldtnFSItemOrFetch()
    {
        if( toCnsldtnFSItem == null ) {
            toCnsldtnFSItem = fetchCnsldtnFSItem();
        }
        return toCnsldtnFSItem;
    }

    /**
     * Retrieval of associated <b>FinancialStatementItem_2</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItem</b>.
     * <p>
     * If the navigation property for an entity <b>FinancialStatementItemHier_2</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnFSItem</b> is already loaded, the result will
     *         contain the <b>FinancialStatementItem_2</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<FinancialStatementItem_2> getCnsldtnFSItemIfPresent()
    {
        return Option.of(toCnsldtnFSItem);
    }

    /**
     * Overwrites the associated <b>FinancialStatementItem_2</b> entity for the loaded navigation property
     * <b>to_CnsldtnFSItem</b>.
     *
     * @param value
     *            New <b>FinancialStatementItem_2</b> entity.
     */
    public void setCnsldtnFSItem( final FinancialStatementItem_2 value )
    {
        toCnsldtnFSItem = value;
    }

    /**
     * Fetches the <b>FinancialStmntItemHierText_2</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_CnsldtnFSItemHierT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>FinancialStmntItemHierText_2</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<FinancialStmntItemHierText_2> fetchCnsldtnFSItemHierT()
    {
        return fetchFieldAsList("to_CnsldtnFSItemHierT", FinancialStmntItemHierText_2.class);
    }

    /**
     * Retrieval of associated <b>FinancialStmntItemHierText_2</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItemHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItemHierT</b> of a queried <b>FinancialStatementItemHier_2</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>FinancialStmntItemHierText_2</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<FinancialStmntItemHierText_2> getCnsldtnFSItemHierTOrFetch()
    {
        if( toCnsldtnFSItemHierT == null ) {
            toCnsldtnFSItemHierT = fetchCnsldtnFSItemHierT();
        }
        return toCnsldtnFSItemHierT;
    }

    /**
     * Retrieval of associated <b>FinancialStmntItemHierText_2</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItemHierT</b>.
     * <p>
     * If the navigation property for an entity <b>FinancialStatementItemHier_2</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnFSItemHierT</b> is already loaded, the result
     *         will contain the <b>FinancialStmntItemHierText_2</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<FinancialStmntItemHierText_2>> getCnsldtnFSItemHierTIfPresent()
    {
        return Option.of(toCnsldtnFSItemHierT);
    }

    /**
     * Overwrites the list of associated <b>FinancialStmntItemHierText_2</b> entities for the loaded navigation property
     * <b>to_CnsldtnFSItemHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItemHierT</b> of a queried <b>FinancialStatementItemHier_2</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>FinancialStmntItemHierText_2</b> entities.
     */
    public void setCnsldtnFSItemHierT( @Nonnull final List<FinancialStmntItemHierText_2> value )
    {
        if( toCnsldtnFSItemHierT == null ) {
            toCnsldtnFSItemHierT = Lists.newArrayList();
        }
        toCnsldtnFSItemHierT.clear();
        toCnsldtnFSItemHierT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>FinancialStmntItemHierText_2</b> entities. This corresponds to the
     * OData navigation property <b>to_CnsldtnFSItemHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItemHierT</b> of a queried <b>FinancialStatementItemHier_2</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>FinancialStmntItemHierText_2</b> entities.
     */
    public void addCnsldtnFSItemHierT( FinancialStmntItemHierText_2... entity )
    {
        if( toCnsldtnFSItemHierT == null ) {
            toCnsldtnFSItemHierT = Lists.newArrayList();
        }
        toCnsldtnFSItemHierT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of FinancialStatementItemHier_2 instances.
     *
     */
    public final static class FinancialStatementItemHier_2Builder
    {

        private FinancialStatementItem_2 toCnsldtnFSItem;
        private List<FinancialStmntItemHierText_2> toCnsldtnFSItemHierT = Lists.newArrayList();

        private FinancialStatementItemHier_2.FinancialStatementItemHier_2Builder toCnsldtnFSItem(
            final FinancialStatementItem_2 value )
        {
            toCnsldtnFSItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnFSItem</b> for <b>FinancialStatementItemHier_2</b> to single
         * <b>FinancialStatementItem_2</b>.
         *
         * @param value
         *            The FinancialStatementItem_2 to build this FinancialStatementItemHier_2 with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FinancialStatementItemHier_2.FinancialStatementItemHier_2Builder cnsldtnFSItem(
            final FinancialStatementItem_2 value )
        {
            return toCnsldtnFSItem(value);
        }

        private FinancialStatementItemHier_2.FinancialStatementItemHier_2Builder toCnsldtnFSItemHierT(
            final List<FinancialStmntItemHierText_2> value )
        {
            toCnsldtnFSItemHierT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnFSItemHierT</b> for <b>FinancialStatementItemHier_2</b> to multiple
         * <b>FinancialStmntItemHierText_2</b>.
         *
         * @param value
         *            The FinancialStmntItemHierText_2s to build this FinancialStatementItemHier_2 with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FinancialStatementItemHier_2.FinancialStatementItemHier_2Builder cnsldtnFSItemHierT(
            FinancialStmntItemHierText_2... value )
        {
            return toCnsldtnFSItemHierT(Lists.newArrayList(value));
        }

    }

}
