/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.FinancialStatementItemText_2Field;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.FinancialStatementItemText_2OneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.FinancialStatementItemText_2Selectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Financial Statement Item V2 - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>FinancialStatementItemText_2Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class FinancialStatementItemText_2 extends VdmEntity<FinancialStatementItemText_2>
{

    /**
     * Selector for all available fields of FinancialStatementItemText_2.
     *
     */
    public final static FinancialStatementItemText_2Selectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static FinancialStatementItemText_2Field<String> LANGUAGE =
        new FinancialStatementItemText_2Field<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts</b>
     * </p>
     *
     * @return Consolidation Chart of Accounts
     */
    @Key
    @SerializedName( "ConsolidationChartOfAccounts" )
    @JsonProperty( "ConsolidationChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "ConsolidationChartOfAccounts" )
    private String consolidationChartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationChartOfAccounts</b> field to query operations.
     *
     */
    public final static FinancialStatementItemText_2Field<String> CONSOLIDATION_CHART_OF_ACCOUNTS =
        new FinancialStatementItemText_2Field<String>("ConsolidationChartOfAccounts");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts_Text</b>
     * </p>
     *
     * @return Consolidation Chart of Accounts Description
     */
    @SerializedName( "ConsolidationChartOfAccounts_Text" )
    @JsonProperty( "ConsolidationChartOfAccounts_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationChartOfAccounts_Text" )
    private String consolidationChartOfAccounts_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationChartOfAccounts_Text</b> field to query
     * operations.
     *
     */
    public final static FinancialStatementItemText_2Field<String> CONSOLIDATION_CHART_OF_ACCOUNTS_TEXT =
        new FinancialStatementItemText_2Field<String>("ConsolidationChartOfAccounts_Text");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItem</b>
     * </p>
     *
     * @return Financial Statement Item
     */
    @Key
    @SerializedName( "FinancialStatementItem" )
    @JsonProperty( "FinancialStatementItem" )
    @Nullable
    @ODataField( odataName = "FinancialStatementItem" )
    private String financialStatementItem;
    /**
     * Use with available fluent helpers to apply the <b>FinancialStatementItem</b> field to query operations.
     *
     */
    public final static FinancialStatementItemText_2Field<String> FINANCIAL_STATEMENT_ITEM =
        new FinancialStatementItemText_2Field<String>("FinancialStatementItem");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItemText</b>
     * </p>
     *
     * @return Financial Statement Item Description
     */
    @SerializedName( "FinancialStatementItemText" )
    @JsonProperty( "FinancialStatementItemText" )
    @Nullable
    @ODataField( odataName = "FinancialStatementItemText" )
    private String financialStatementItemText;
    /**
     * Use with available fluent helpers to apply the <b>FinancialStatementItemText</b> field to query operations.
     *
     */
    public final static FinancialStatementItemText_2Field<String> FINANCIAL_STATEMENT_ITEM_TEXT =
        new FinancialStatementItemText_2Field<String>("FinancialStatementItemText");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItemMdmText</b>
     * </p>
     *
     * @return Financial Statement Item Medium Description
     */
    @SerializedName( "FinancialStatementItemMdmText" )
    @JsonProperty( "FinancialStatementItemMdmText" )
    @Nullable
    @ODataField( odataName = "FinancialStatementItemMdmText" )
    private String financialStatementItemMdmText;
    /**
     * Use with available fluent helpers to apply the <b>FinancialStatementItemMdmText</b> field to query operations.
     *
     */
    public final static FinancialStatementItemText_2Field<String> FINANCIAL_STATEMENT_ITEM_MDM_TEXT =
        new FinancialStatementItemText_2Field<String>("FinancialStatementItemMdmText");
    /**
     * Constraints: Not nullable, Maximum length: 250
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItemLongText</b>
     * </p>
     *
     * @return Financial Statement Item Long Description
     */
    @SerializedName( "FinancialStatementItemLongText" )
    @JsonProperty( "FinancialStatementItemLongText" )
    @Nullable
    @ODataField( odataName = "FinancialStatementItemLongText" )
    private String financialStatementItemLongText;
    /**
     * Use with available fluent helpers to apply the <b>FinancialStatementItemLongText</b> field to query operations.
     *
     */
    public final static FinancialStatementItemText_2Field<String> FINANCIAL_STATEMENT_ITEM_LONG_TEXT =
        new FinancialStatementItemText_2Field<String>("FinancialStatementItemLongText");
    /**
     * Navigation property <b>to_CnsldtnFSItem</b> for <b>FinancialStatementItemText_2</b> to single
     * <b>FinancialStatementItem_2</b>.
     *
     */
    @SerializedName( "to_CnsldtnFSItem" )
    @JsonProperty( "to_CnsldtnFSItem" )
    @ODataField( odataName = "to_CnsldtnFSItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private FinancialStatementItem_2 toCnsldtnFSItem;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnFSItem</b> navigation property to query operations.
     *
     */
    public final static FinancialStatementItemText_2OneToOneLink<FinancialStatementItem_2> TO_CNSLDTN_FS_ITEM =
        new FinancialStatementItemText_2OneToOneLink<FinancialStatementItem_2>("to_CnsldtnFSItem");

    @Nonnull
    @Override
    public Class<FinancialStatementItemText_2> getType()
    {
        return FinancialStatementItemText_2.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts</b>
     * </p>
     *
     * @param consolidationChartOfAccounts
     *            Consolidation Chart of Accounts
     */
    public void setConsolidationChartOfAccounts( @Nullable final String consolidationChartOfAccounts )
    {
        rememberChangedField("ConsolidationChartOfAccounts", this.consolidationChartOfAccounts);
        this.consolidationChartOfAccounts = consolidationChartOfAccounts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts_Text</b>
     * </p>
     *
     * @param consolidationChartOfAccounts_Text
     *            Consolidation Chart of Accounts Description
     */
    public void setConsolidationChartOfAccounts_Text( @Nullable final String consolidationChartOfAccounts_Text )
    {
        rememberChangedField("ConsolidationChartOfAccounts_Text", this.consolidationChartOfAccounts_Text);
        this.consolidationChartOfAccounts_Text = consolidationChartOfAccounts_Text;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItem</b>
     * </p>
     *
     * @param financialStatementItem
     *            Financial Statement Item
     */
    public void setFinancialStatementItem( @Nullable final String financialStatementItem )
    {
        rememberChangedField("FinancialStatementItem", this.financialStatementItem);
        this.financialStatementItem = financialStatementItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItemText</b>
     * </p>
     *
     * @param financialStatementItemText
     *            Financial Statement Item Description
     */
    public void setFinancialStatementItemText( @Nullable final String financialStatementItemText )
    {
        rememberChangedField("FinancialStatementItemText", this.financialStatementItemText);
        this.financialStatementItemText = financialStatementItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItemMdmText</b>
     * </p>
     *
     * @param financialStatementItemMdmText
     *            Financial Statement Item Medium Description
     */
    public void setFinancialStatementItemMdmText( @Nullable final String financialStatementItemMdmText )
    {
        rememberChangedField("FinancialStatementItemMdmText", this.financialStatementItemMdmText);
        this.financialStatementItemMdmText = financialStatementItemMdmText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 250
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItemLongText</b>
     * </p>
     *
     * @param financialStatementItemLongText
     *            Financial Statement Item Long Description
     */
    public void setFinancialStatementItemLongText( @Nullable final String financialStatementItemLongText )
    {
        rememberChangedField("FinancialStatementItemLongText", this.financialStatementItemLongText);
        this.financialStatementItemLongText = financialStatementItemLongText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "FinancialStatementItemText_2";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("ConsolidationChartOfAccounts", getConsolidationChartOfAccounts());
        result.put("FinancialStatementItem", getFinancialStatementItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("ConsolidationChartOfAccounts", getConsolidationChartOfAccounts());
        values.put("ConsolidationChartOfAccounts_Text", getConsolidationChartOfAccounts_Text());
        values.put("FinancialStatementItem", getFinancialStatementItem());
        values.put("FinancialStatementItemText", getFinancialStatementItemText());
        values.put("FinancialStatementItemMdmText", getFinancialStatementItemMdmText());
        values.put("FinancialStatementItemLongText", getFinancialStatementItemLongText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("ConsolidationChartOfAccounts") ) {
                final Object value = values.remove("ConsolidationChartOfAccounts");
                if( (value == null) || (!value.equals(getConsolidationChartOfAccounts())) ) {
                    setConsolidationChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("ConsolidationChartOfAccounts_Text") ) {
                final Object value = values.remove("ConsolidationChartOfAccounts_Text");
                if( (value == null) || (!value.equals(getConsolidationChartOfAccounts_Text())) ) {
                    setConsolidationChartOfAccounts_Text(((String) value));
                }
            }
            if( values.containsKey("FinancialStatementItem") ) {
                final Object value = values.remove("FinancialStatementItem");
                if( (value == null) || (!value.equals(getFinancialStatementItem())) ) {
                    setFinancialStatementItem(((String) value));
                }
            }
            if( values.containsKey("FinancialStatementItemText") ) {
                final Object value = values.remove("FinancialStatementItemText");
                if( (value == null) || (!value.equals(getFinancialStatementItemText())) ) {
                    setFinancialStatementItemText(((String) value));
                }
            }
            if( values.containsKey("FinancialStatementItemMdmText") ) {
                final Object value = values.remove("FinancialStatementItemMdmText");
                if( (value == null) || (!value.equals(getFinancialStatementItemMdmText())) ) {
                    setFinancialStatementItemMdmText(((String) value));
                }
            }
            if( values.containsKey("FinancialStatementItemLongText") ) {
                final Object value = values.remove("FinancialStatementItemLongText");
                if( (value == null) || (!value.equals(getFinancialStatementItemLongText())) ) {
                    setFinancialStatementItemLongText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnFSItem") ) {
                final Object value = (values).remove("to_CnsldtnFSItem");
                if( value instanceof Map ) {
                    if( toCnsldtnFSItem == null ) {
                        toCnsldtnFSItem = new FinancialStatementItem_2();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnFSItem.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> FinancialStatementItemText_2Field<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new FinancialStatementItemText_2Field<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FinancialStatementItemText_2Field<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FinancialStatementItemText_2Field<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnFSItem != null ) {
            (values).put("to_CnsldtnFSItem", toCnsldtnFSItem);
        }
        return values;
    }

    /**
     * Fetches the <b>FinancialStatementItem_2</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CnsldtnFSItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>FinancialStatementItem_2</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public FinancialStatementItem_2 fetchCnsldtnFSItem()
    {
        return fetchFieldAsSingle("to_CnsldtnFSItem", FinancialStatementItem_2.class);
    }

    /**
     * Retrieval of associated <b>FinancialStatementItem_2</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItem</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItem</b> of a queried <b>FinancialStatementItemText_2</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>FinancialStatementItem_2</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public FinancialStatementItem_2 getCnsldtnFSItemOrFetch()
    {
        if( toCnsldtnFSItem == null ) {
            toCnsldtnFSItem = fetchCnsldtnFSItem();
        }
        return toCnsldtnFSItem;
    }

    /**
     * Retrieval of associated <b>FinancialStatementItem_2</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItem</b>.
     * <p>
     * If the navigation property for an entity <b>FinancialStatementItemText_2</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnFSItem</b> is already loaded, the result will
     *         contain the <b>FinancialStatementItem_2</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<FinancialStatementItem_2> getCnsldtnFSItemIfPresent()
    {
        return Option.of(toCnsldtnFSItem);
    }

    /**
     * Overwrites the associated <b>FinancialStatementItem_2</b> entity for the loaded navigation property
     * <b>to_CnsldtnFSItem</b>.
     *
     * @param value
     *            New <b>FinancialStatementItem_2</b> entity.
     */
    public void setCnsldtnFSItem( final FinancialStatementItem_2 value )
    {
        toCnsldtnFSItem = value;
    }

    /**
     * Helper class to allow for fluent creation of FinancialStatementItemText_2 instances.
     *
     */
    public final static class FinancialStatementItemText_2Builder
    {

        private FinancialStatementItem_2 toCnsldtnFSItem;

        private FinancialStatementItemText_2.FinancialStatementItemText_2Builder toCnsldtnFSItem(
            final FinancialStatementItem_2 value )
        {
            toCnsldtnFSItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnFSItem</b> for <b>FinancialStatementItemText_2</b> to single
         * <b>FinancialStatementItem_2</b>.
         *
         * @param value
         *            The FinancialStatementItem_2 to build this FinancialStatementItemText_2 with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FinancialStatementItemText_2.FinancialStatementItemText_2Builder cnsldtnFSItem(
            final FinancialStatementItem_2 value )
        {
            return toCnsldtnFSItem(value);
        }

    }

}
