/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.FinancialStatementItem_2Field;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.FinancialStatementItem_2Link;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.FinancialStatementItem_2Selectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Financial Statement Item Version 2
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>FinancialStatementItem_2Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class FinancialStatementItem_2 extends VdmEntity<FinancialStatementItem_2>
{

    /**
     * Selector for all available fields of FinancialStatementItem_2.
     *
     */
    public final static FinancialStatementItem_2Selectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts</b>
     * </p>
     *
     * @return Consolidation Chart of Accounts
     */
    @Key
    @SerializedName( "ConsolidationChartOfAccounts" )
    @JsonProperty( "ConsolidationChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "ConsolidationChartOfAccounts" )
    private String consolidationChartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationChartOfAccounts</b> field to query operations.
     *
     */
    public final static FinancialStatementItem_2Field<String> CONSOLIDATION_CHART_OF_ACCOUNTS =
        new FinancialStatementItem_2Field<String>("ConsolidationChartOfAccounts");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts_Text</b>
     * </p>
     *
     * @return Consolidation Chart of Accounts Description
     */
    @SerializedName( "ConsolidationChartOfAccounts_Text" )
    @JsonProperty( "ConsolidationChartOfAccounts_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationChartOfAccounts_Text" )
    private String consolidationChartOfAccounts_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationChartOfAccounts_Text</b> field to query
     * operations.
     *
     */
    public final static FinancialStatementItem_2Field<String> CONSOLIDATION_CHART_OF_ACCOUNTS_TEXT =
        new FinancialStatementItem_2Field<String>("ConsolidationChartOfAccounts_Text");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItem</b>
     * </p>
     *
     * @return Financial Statement Item
     */
    @Key
    @SerializedName( "FinancialStatementItem" )
    @JsonProperty( "FinancialStatementItem" )
    @Nullable
    @ODataField( odataName = "FinancialStatementItem" )
    private String financialStatementItem;
    /**
     * Use with available fluent helpers to apply the <b>FinancialStatementItem</b> field to query operations.
     *
     */
    public final static FinancialStatementItem_2Field<String> FINANCIAL_STATEMENT_ITEM =
        new FinancialStatementItem_2Field<String>("FinancialStatementItem");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItem_Text</b>
     * </p>
     *
     * @return Financial Statement Item Medium Description
     */
    @SerializedName( "FinancialStatementItem_Text" )
    @JsonProperty( "FinancialStatementItem_Text" )
    @Nullable
    @ODataField( odataName = "FinancialStatementItem_Text" )
    private String financialStatementItem_Text;
    /**
     * Use with available fluent helpers to apply the <b>FinancialStatementItem_Text</b> field to query operations.
     *
     */
    public final static FinancialStatementItem_2Field<String> FINANCIAL_STATEMENT_ITEM_TEXT =
        new FinancialStatementItem_2Field<String>("FinancialStatementItem_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItemType</b>
     * </p>
     *
     * @return Financial Statement Item Type
     */
    @SerializedName( "FinancialStatementItemType" )
    @JsonProperty( "FinancialStatementItemType" )
    @Nullable
    @ODataField( odataName = "FinancialStatementItemType" )
    private String financialStatementItemType;
    /**
     * Use with available fluent helpers to apply the <b>FinancialStatementItemType</b> field to query operations.
     *
     */
    public final static FinancialStatementItem_2Field<String> FINANCIAL_STATEMENT_ITEM_TYPE =
        new FinancialStatementItem_2Field<String>("FinancialStatementItemType");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItemType_Text</b>
     * </p>
     *
     * @return Financial Statement Item Type Description
     */
    @SerializedName( "FinancialStatementItemType_Text" )
    @JsonProperty( "FinancialStatementItemType_Text" )
    @Nullable
    @ODataField( odataName = "FinancialStatementItemType_Text" )
    private String financialStatementItemType_Text;
    /**
     * Use with available fluent helpers to apply the <b>FinancialStatementItemType_Text</b> field to query operations.
     *
     */
    public final static FinancialStatementItem_2Field<String> FINANCIAL_STATEMENT_ITEM_TYPE_TEXT =
        new FinancialStatementItem_2Field<String>("FinancialStatementItemType_Text");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BreakdownCategory</b>
     * </p>
     *
     * @return Breakdown Category
     */
    @SerializedName( "BreakdownCategory" )
    @JsonProperty( "BreakdownCategory" )
    @Nullable
    @ODataField( odataName = "BreakdownCategory" )
    private String breakdownCategory;
    /**
     * Use with available fluent helpers to apply the <b>BreakdownCategory</b> field to query operations.
     *
     */
    public final static FinancialStatementItem_2Field<String> BREAKDOWN_CATEGORY =
        new FinancialStatementItem_2Field<String>("BreakdownCategory");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BreakdownCategory_Text</b>
     * </p>
     *
     * @return Breakdown Category Description
     */
    @SerializedName( "BreakdownCategory_Text" )
    @JsonProperty( "BreakdownCategory_Text" )
    @Nullable
    @ODataField( odataName = "BreakdownCategory_Text" )
    private String breakdownCategory_Text;
    /**
     * Use with available fluent helpers to apply the <b>BreakdownCategory_Text</b> field to query operations.
     *
     */
    public final static FinancialStatementItem_2Field<String> BREAKDOWN_CATEGORY_TEXT =
        new FinancialStatementItem_2Field<String>("BreakdownCategory_Text");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsConsolidationItem</b>
     * </p>
     *
     * @return Is Consolidation Item
     */
    @SerializedName( "IsConsolidationItem" )
    @JsonProperty( "IsConsolidationItem" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsConsolidationItem" )
    private Boolean isConsolidationItem;
    /**
     * Use with available fluent helpers to apply the <b>IsConsolidationItem</b> field to query operations.
     *
     */
    public final static FinancialStatementItem_2Field<Boolean> IS_CONSOLIDATION_ITEM =
        new FinancialStatementItem_2Field<Boolean>("IsConsolidationItem");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItemIsBlkd</b>
     * </p>
     *
     * @return Blocked for Posting
     */
    @SerializedName( "FinancialStatementItemIsBlkd" )
    @JsonProperty( "FinancialStatementItemIsBlkd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "FinancialStatementItemIsBlkd" )
    private Boolean financialStatementItemIsBlkd;
    /**
     * Use with available fluent helpers to apply the <b>FinancialStatementItemIsBlkd</b> field to query operations.
     *
     */
    public final static FinancialStatementItem_2Field<Boolean> FINANCIAL_STATEMENT_ITEM_IS_BLKD =
        new FinancialStatementItem_2Field<Boolean>("FinancialStatementItemIsBlkd");
    /**
     * Navigation property <b>to_CnsldtnFSItemAttribAssgmt</b> for <b>FinancialStatementItem_2</b> to multiple
     * <b>FSItemAttribByTimeVersion</b>.
     *
     */
    @SerializedName( "to_CnsldtnFSItemAttribAssgmt" )
    @JsonProperty( "to_CnsldtnFSItemAttribAssgmt" )
    @ODataField( odataName = "to_CnsldtnFSItemAttribAssgmt" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<FSItemAttribByTimeVersion> toCnsldtnFSItemAttribAssgmt;
    /**
     * Navigation property <b>to_CnsldtnFSItemHier</b> for <b>FinancialStatementItem_2</b> to multiple
     * <b>FinancialStatementItemHier_2</b>.
     *
     */
    @SerializedName( "to_CnsldtnFSItemHier" )
    @JsonProperty( "to_CnsldtnFSItemHier" )
    @ODataField( odataName = "to_CnsldtnFSItemHier" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<FinancialStatementItemHier_2> toCnsldtnFSItemHier;
    /**
     * Navigation property <b>to_CnsldtnFSItemT</b> for <b>FinancialStatementItem_2</b> to multiple
     * <b>FinancialStatementItemText_2</b>.
     *
     */
    @SerializedName( "to_CnsldtnFSItemT" )
    @JsonProperty( "to_CnsldtnFSItemT" )
    @ODataField( odataName = "to_CnsldtnFSItemT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<FinancialStatementItemText_2> toCnsldtnFSItemT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnFSItemAttribAssgmt</b> navigation property to query
     * operations.
     *
     */
    public final static FinancialStatementItem_2Link<FSItemAttribByTimeVersion> TO_CNSLDTN_FS_ITEM_ATTRIB_ASSGMT =
        new FinancialStatementItem_2Link<FSItemAttribByTimeVersion>("to_CnsldtnFSItemAttribAssgmt");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnFSItemHier</b> navigation property to query
     * operations.
     *
     */
    public final static FinancialStatementItem_2Link<FinancialStatementItemHier_2> TO_CNSLDTN_FS_ITEM_HIER =
        new FinancialStatementItem_2Link<FinancialStatementItemHier_2>("to_CnsldtnFSItemHier");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnFSItemT</b> navigation property to query operations.
     *
     */
    public final static FinancialStatementItem_2Link<FinancialStatementItemText_2> TO_CNSLDTN_FS_ITEM_T =
        new FinancialStatementItem_2Link<FinancialStatementItemText_2>("to_CnsldtnFSItemT");

    @Nonnull
    @Override
    public Class<FinancialStatementItem_2> getType()
    {
        return FinancialStatementItem_2.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts</b>
     * </p>
     *
     * @param consolidationChartOfAccounts
     *            Consolidation Chart of Accounts
     */
    public void setConsolidationChartOfAccounts( @Nullable final String consolidationChartOfAccounts )
    {
        rememberChangedField("ConsolidationChartOfAccounts", this.consolidationChartOfAccounts);
        this.consolidationChartOfAccounts = consolidationChartOfAccounts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts_Text</b>
     * </p>
     *
     * @param consolidationChartOfAccounts_Text
     *            Consolidation Chart of Accounts Description
     */
    public void setConsolidationChartOfAccounts_Text( @Nullable final String consolidationChartOfAccounts_Text )
    {
        rememberChangedField("ConsolidationChartOfAccounts_Text", this.consolidationChartOfAccounts_Text);
        this.consolidationChartOfAccounts_Text = consolidationChartOfAccounts_Text;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItem</b>
     * </p>
     *
     * @param financialStatementItem
     *            Financial Statement Item
     */
    public void setFinancialStatementItem( @Nullable final String financialStatementItem )
    {
        rememberChangedField("FinancialStatementItem", this.financialStatementItem);
        this.financialStatementItem = financialStatementItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItem_Text</b>
     * </p>
     *
     * @param financialStatementItem_Text
     *            Financial Statement Item Medium Description
     */
    public void setFinancialStatementItem_Text( @Nullable final String financialStatementItem_Text )
    {
        rememberChangedField("FinancialStatementItem_Text", this.financialStatementItem_Text);
        this.financialStatementItem_Text = financialStatementItem_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItemType</b>
     * </p>
     *
     * @param financialStatementItemType
     *            Financial Statement Item Type
     */
    public void setFinancialStatementItemType( @Nullable final String financialStatementItemType )
    {
        rememberChangedField("FinancialStatementItemType", this.financialStatementItemType);
        this.financialStatementItemType = financialStatementItemType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItemType_Text</b>
     * </p>
     *
     * @param financialStatementItemType_Text
     *            Financial Statement Item Type Description
     */
    public void setFinancialStatementItemType_Text( @Nullable final String financialStatementItemType_Text )
    {
        rememberChangedField("FinancialStatementItemType_Text", this.financialStatementItemType_Text);
        this.financialStatementItemType_Text = financialStatementItemType_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BreakdownCategory</b>
     * </p>
     *
     * @param breakdownCategory
     *            Breakdown Category
     */
    public void setBreakdownCategory( @Nullable final String breakdownCategory )
    {
        rememberChangedField("BreakdownCategory", this.breakdownCategory);
        this.breakdownCategory = breakdownCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BreakdownCategory_Text</b>
     * </p>
     *
     * @param breakdownCategory_Text
     *            Breakdown Category Description
     */
    public void setBreakdownCategory_Text( @Nullable final String breakdownCategory_Text )
    {
        rememberChangedField("BreakdownCategory_Text", this.breakdownCategory_Text);
        this.breakdownCategory_Text = breakdownCategory_Text;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsConsolidationItem</b>
     * </p>
     *
     * @param isConsolidationItem
     *            Is Consolidation Item
     */
    public void setIsConsolidationItem( @Nullable final Boolean isConsolidationItem )
    {
        rememberChangedField("IsConsolidationItem", this.isConsolidationItem);
        this.isConsolidationItem = isConsolidationItem;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItemIsBlkd</b>
     * </p>
     *
     * @param financialStatementItemIsBlkd
     *            Blocked for Posting
     */
    public void setFinancialStatementItemIsBlkd( @Nullable final Boolean financialStatementItemIsBlkd )
    {
        rememberChangedField("FinancialStatementItemIsBlkd", this.financialStatementItemIsBlkd);
        this.financialStatementItemIsBlkd = financialStatementItemIsBlkd;
    }

    @Override
    protected String getEntityCollection()
    {
        return "FinancialStatementItem_2";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConsolidationChartOfAccounts", getConsolidationChartOfAccounts());
        result.put("FinancialStatementItem", getFinancialStatementItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConsolidationChartOfAccounts", getConsolidationChartOfAccounts());
        values.put("ConsolidationChartOfAccounts_Text", getConsolidationChartOfAccounts_Text());
        values.put("FinancialStatementItem", getFinancialStatementItem());
        values.put("FinancialStatementItem_Text", getFinancialStatementItem_Text());
        values.put("FinancialStatementItemType", getFinancialStatementItemType());
        values.put("FinancialStatementItemType_Text", getFinancialStatementItemType_Text());
        values.put("BreakdownCategory", getBreakdownCategory());
        values.put("BreakdownCategory_Text", getBreakdownCategory_Text());
        values.put("IsConsolidationItem", getIsConsolidationItem());
        values.put("FinancialStatementItemIsBlkd", getFinancialStatementItemIsBlkd());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConsolidationChartOfAccounts") ) {
                final Object value = values.remove("ConsolidationChartOfAccounts");
                if( (value == null) || (!value.equals(getConsolidationChartOfAccounts())) ) {
                    setConsolidationChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("ConsolidationChartOfAccounts_Text") ) {
                final Object value = values.remove("ConsolidationChartOfAccounts_Text");
                if( (value == null) || (!value.equals(getConsolidationChartOfAccounts_Text())) ) {
                    setConsolidationChartOfAccounts_Text(((String) value));
                }
            }
            if( values.containsKey("FinancialStatementItem") ) {
                final Object value = values.remove("FinancialStatementItem");
                if( (value == null) || (!value.equals(getFinancialStatementItem())) ) {
                    setFinancialStatementItem(((String) value));
                }
            }
            if( values.containsKey("FinancialStatementItem_Text") ) {
                final Object value = values.remove("FinancialStatementItem_Text");
                if( (value == null) || (!value.equals(getFinancialStatementItem_Text())) ) {
                    setFinancialStatementItem_Text(((String) value));
                }
            }
            if( values.containsKey("FinancialStatementItemType") ) {
                final Object value = values.remove("FinancialStatementItemType");
                if( (value == null) || (!value.equals(getFinancialStatementItemType())) ) {
                    setFinancialStatementItemType(((String) value));
                }
            }
            if( values.containsKey("FinancialStatementItemType_Text") ) {
                final Object value = values.remove("FinancialStatementItemType_Text");
                if( (value == null) || (!value.equals(getFinancialStatementItemType_Text())) ) {
                    setFinancialStatementItemType_Text(((String) value));
                }
            }
            if( values.containsKey("BreakdownCategory") ) {
                final Object value = values.remove("BreakdownCategory");
                if( (value == null) || (!value.equals(getBreakdownCategory())) ) {
                    setBreakdownCategory(((String) value));
                }
            }
            if( values.containsKey("BreakdownCategory_Text") ) {
                final Object value = values.remove("BreakdownCategory_Text");
                if( (value == null) || (!value.equals(getBreakdownCategory_Text())) ) {
                    setBreakdownCategory_Text(((String) value));
                }
            }
            if( values.containsKey("IsConsolidationItem") ) {
                final Object value = values.remove("IsConsolidationItem");
                if( (value == null) || (!value.equals(getIsConsolidationItem())) ) {
                    setIsConsolidationItem(((Boolean) value));
                }
            }
            if( values.containsKey("FinancialStatementItemIsBlkd") ) {
                final Object value = values.remove("FinancialStatementItemIsBlkd");
                if( (value == null) || (!value.equals(getFinancialStatementItemIsBlkd())) ) {
                    setFinancialStatementItemIsBlkd(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnFSItemAttribAssgmt") ) {
                final Object value = (values).remove("to_CnsldtnFSItemAttribAssgmt");
                if( value instanceof Iterable ) {
                    if( toCnsldtnFSItemAttribAssgmt == null ) {
                        toCnsldtnFSItemAttribAssgmt = Lists.newArrayList();
                    } else {
                        toCnsldtnFSItemAttribAssgmt = Lists.newArrayList(toCnsldtnFSItemAttribAssgmt);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        FSItemAttribByTimeVersion entity;
                        if( toCnsldtnFSItemAttribAssgmt.size() > i ) {
                            entity = toCnsldtnFSItemAttribAssgmt.get(i);
                        } else {
                            entity = new FSItemAttribByTimeVersion();
                            toCnsldtnFSItemAttribAssgmt.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CnsldtnFSItemHier") ) {
                final Object value = (values).remove("to_CnsldtnFSItemHier");
                if( value instanceof Iterable ) {
                    if( toCnsldtnFSItemHier == null ) {
                        toCnsldtnFSItemHier = Lists.newArrayList();
                    } else {
                        toCnsldtnFSItemHier = Lists.newArrayList(toCnsldtnFSItemHier);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        FinancialStatementItemHier_2 entity;
                        if( toCnsldtnFSItemHier.size() > i ) {
                            entity = toCnsldtnFSItemHier.get(i);
                        } else {
                            entity = new FinancialStatementItemHier_2();
                            toCnsldtnFSItemHier.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CnsldtnFSItemT") ) {
                final Object value = (values).remove("to_CnsldtnFSItemT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnFSItemT == null ) {
                        toCnsldtnFSItemT = Lists.newArrayList();
                    } else {
                        toCnsldtnFSItemT = Lists.newArrayList(toCnsldtnFSItemT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        FinancialStatementItemText_2 entity;
                        if( toCnsldtnFSItemT.size() > i ) {
                            entity = toCnsldtnFSItemT.get(i);
                        } else {
                            entity = new FinancialStatementItemText_2();
                            toCnsldtnFSItemT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> FinancialStatementItem_2Field<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new FinancialStatementItem_2Field<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FinancialStatementItem_2Field<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FinancialStatementItem_2Field<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnFSItemAttribAssgmt != null ) {
            (values).put("to_CnsldtnFSItemAttribAssgmt", toCnsldtnFSItemAttribAssgmt);
        }
        if( toCnsldtnFSItemHier != null ) {
            (values).put("to_CnsldtnFSItemHier", toCnsldtnFSItemHier);
        }
        if( toCnsldtnFSItemT != null ) {
            (values).put("to_CnsldtnFSItemT", toCnsldtnFSItemT);
        }
        return values;
    }

    /**
     * Fetches the <b>FSItemAttribByTimeVersion</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CnsldtnFSItemAttribAssgmt</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>FSItemAttribByTimeVersion</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<FSItemAttribByTimeVersion> fetchCnsldtnFSItemAttribAssgmt()
    {
        return fetchFieldAsList("to_CnsldtnFSItemAttribAssgmt", FSItemAttribByTimeVersion.class);
    }

    /**
     * Retrieval of associated <b>FSItemAttribByTimeVersion</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItemAttribAssgmt</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItemAttribAssgmt</b> of a queried <b>FinancialStatementItem_2</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>FSItemAttribByTimeVersion</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<FSItemAttribByTimeVersion> getCnsldtnFSItemAttribAssgmtOrFetch()
    {
        if( toCnsldtnFSItemAttribAssgmt == null ) {
            toCnsldtnFSItemAttribAssgmt = fetchCnsldtnFSItemAttribAssgmt();
        }
        return toCnsldtnFSItemAttribAssgmt;
    }

    /**
     * Retrieval of associated <b>FSItemAttribByTimeVersion</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItemAttribAssgmt</b>.
     * <p>
     * If the navigation property for an entity <b>FinancialStatementItem_2</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnFSItemAttribAssgmt</b> is already loaded, the
     *         result will contain the <b>FSItemAttribByTimeVersion</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<FSItemAttribByTimeVersion>> getCnsldtnFSItemAttribAssgmtIfPresent()
    {
        return Option.of(toCnsldtnFSItemAttribAssgmt);
    }

    /**
     * Overwrites the list of associated <b>FSItemAttribByTimeVersion</b> entities for the loaded navigation property
     * <b>to_CnsldtnFSItemAttribAssgmt</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItemAttribAssgmt</b> of a queried <b>FinancialStatementItem_2</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>FSItemAttribByTimeVersion</b> entities.
     */
    public void setCnsldtnFSItemAttribAssgmt( @Nonnull final List<FSItemAttribByTimeVersion> value )
    {
        if( toCnsldtnFSItemAttribAssgmt == null ) {
            toCnsldtnFSItemAttribAssgmt = Lists.newArrayList();
        }
        toCnsldtnFSItemAttribAssgmt.clear();
        toCnsldtnFSItemAttribAssgmt.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>FSItemAttribByTimeVersion</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItemAttribAssgmt</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItemAttribAssgmt</b> of a queried <b>FinancialStatementItem_2</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>FSItemAttribByTimeVersion</b> entities.
     */
    public void addCnsldtnFSItemAttribAssgmt( FSItemAttribByTimeVersion... entity )
    {
        if( toCnsldtnFSItemAttribAssgmt == null ) {
            toCnsldtnFSItemAttribAssgmt = Lists.newArrayList();
        }
        toCnsldtnFSItemAttribAssgmt.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>FinancialStatementItemHier_2</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_CnsldtnFSItemHier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>FinancialStatementItemHier_2</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<FinancialStatementItemHier_2> fetchCnsldtnFSItemHier()
    {
        return fetchFieldAsList("to_CnsldtnFSItemHier", FinancialStatementItemHier_2.class);
    }

    /**
     * Retrieval of associated <b>FinancialStatementItemHier_2</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItemHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItemHier</b> of a queried <b>FinancialStatementItem_2</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>FinancialStatementItemHier_2</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<FinancialStatementItemHier_2> getCnsldtnFSItemHierOrFetch()
    {
        if( toCnsldtnFSItemHier == null ) {
            toCnsldtnFSItemHier = fetchCnsldtnFSItemHier();
        }
        return toCnsldtnFSItemHier;
    }

    /**
     * Retrieval of associated <b>FinancialStatementItemHier_2</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItemHier</b>.
     * <p>
     * If the navigation property for an entity <b>FinancialStatementItem_2</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnFSItemHier</b> is already loaded, the result will
     *         contain the <b>FinancialStatementItemHier_2</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<FinancialStatementItemHier_2>> getCnsldtnFSItemHierIfPresent()
    {
        return Option.of(toCnsldtnFSItemHier);
    }

    /**
     * Overwrites the list of associated <b>FinancialStatementItemHier_2</b> entities for the loaded navigation property
     * <b>to_CnsldtnFSItemHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItemHier</b> of a queried <b>FinancialStatementItem_2</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>FinancialStatementItemHier_2</b> entities.
     */
    public void setCnsldtnFSItemHier( @Nonnull final List<FinancialStatementItemHier_2> value )
    {
        if( toCnsldtnFSItemHier == null ) {
            toCnsldtnFSItemHier = Lists.newArrayList();
        }
        toCnsldtnFSItemHier.clear();
        toCnsldtnFSItemHier.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>FinancialStatementItemHier_2</b> entities. This corresponds to the
     * OData navigation property <b>to_CnsldtnFSItemHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItemHier</b> of a queried <b>FinancialStatementItem_2</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>FinancialStatementItemHier_2</b> entities.
     */
    public void addCnsldtnFSItemHier( FinancialStatementItemHier_2... entity )
    {
        if( toCnsldtnFSItemHier == null ) {
            toCnsldtnFSItemHier = Lists.newArrayList();
        }
        toCnsldtnFSItemHier.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>FinancialStatementItemText_2</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_CnsldtnFSItemT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>FinancialStatementItemText_2</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<FinancialStatementItemText_2> fetchCnsldtnFSItemT()
    {
        return fetchFieldAsList("to_CnsldtnFSItemT", FinancialStatementItemText_2.class);
    }

    /**
     * Retrieval of associated <b>FinancialStatementItemText_2</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItemT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItemT</b> of a queried <b>FinancialStatementItem_2</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>FinancialStatementItemText_2</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<FinancialStatementItemText_2> getCnsldtnFSItemTOrFetch()
    {
        if( toCnsldtnFSItemT == null ) {
            toCnsldtnFSItemT = fetchCnsldtnFSItemT();
        }
        return toCnsldtnFSItemT;
    }

    /**
     * Retrieval of associated <b>FinancialStatementItemText_2</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItemT</b>.
     * <p>
     * If the navigation property for an entity <b>FinancialStatementItem_2</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnFSItemT</b> is already loaded, the result will
     *         contain the <b>FinancialStatementItemText_2</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<FinancialStatementItemText_2>> getCnsldtnFSItemTIfPresent()
    {
        return Option.of(toCnsldtnFSItemT);
    }

    /**
     * Overwrites the list of associated <b>FinancialStatementItemText_2</b> entities for the loaded navigation property
     * <b>to_CnsldtnFSItemT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItemT</b> of a queried <b>FinancialStatementItem_2</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>FinancialStatementItemText_2</b> entities.
     */
    public void setCnsldtnFSItemT( @Nonnull final List<FinancialStatementItemText_2> value )
    {
        if( toCnsldtnFSItemT == null ) {
            toCnsldtnFSItemT = Lists.newArrayList();
        }
        toCnsldtnFSItemT.clear();
        toCnsldtnFSItemT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>FinancialStatementItemText_2</b> entities. This corresponds to the
     * OData navigation property <b>to_CnsldtnFSItemT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItemT</b> of a queried <b>FinancialStatementItem_2</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>FinancialStatementItemText_2</b> entities.
     */
    public void addCnsldtnFSItemT( FinancialStatementItemText_2... entity )
    {
        if( toCnsldtnFSItemT == null ) {
            toCnsldtnFSItemT = Lists.newArrayList();
        }
        toCnsldtnFSItemT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of FinancialStatementItem_2 instances.
     *
     */
    public final static class FinancialStatementItem_2Builder
    {

        private List<FSItemAttribByTimeVersion> toCnsldtnFSItemAttribAssgmt = Lists.newArrayList();
        private List<FinancialStatementItemHier_2> toCnsldtnFSItemHier = Lists.newArrayList();
        private List<FinancialStatementItemText_2> toCnsldtnFSItemT = Lists.newArrayList();

        private FinancialStatementItem_2.FinancialStatementItem_2Builder toCnsldtnFSItemAttribAssgmt(
            final List<FSItemAttribByTimeVersion> value )
        {
            toCnsldtnFSItemAttribAssgmt.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnFSItemAttribAssgmt</b> for <b>FinancialStatementItem_2</b> to multiple
         * <b>FSItemAttribByTimeVersion</b>.
         *
         * @param value
         *            The FSItemAttribByTimeVersions to build this FinancialStatementItem_2 with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FinancialStatementItem_2.FinancialStatementItem_2Builder cnsldtnFSItemAttribAssgmt(
            FSItemAttribByTimeVersion... value )
        {
            return toCnsldtnFSItemAttribAssgmt(Lists.newArrayList(value));
        }

        private FinancialStatementItem_2.FinancialStatementItem_2Builder toCnsldtnFSItemHier(
            final List<FinancialStatementItemHier_2> value )
        {
            toCnsldtnFSItemHier.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnFSItemHier</b> for <b>FinancialStatementItem_2</b> to multiple
         * <b>FinancialStatementItemHier_2</b>.
         *
         * @param value
         *            The FinancialStatementItemHier_2s to build this FinancialStatementItem_2 with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FinancialStatementItem_2.FinancialStatementItem_2Builder cnsldtnFSItemHier(
            FinancialStatementItemHier_2... value )
        {
            return toCnsldtnFSItemHier(Lists.newArrayList(value));
        }

        private FinancialStatementItem_2.FinancialStatementItem_2Builder toCnsldtnFSItemT(
            final List<FinancialStatementItemText_2> value )
        {
            toCnsldtnFSItemT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnFSItemT</b> for <b>FinancialStatementItem_2</b> to multiple
         * <b>FinancialStatementItemText_2</b>.
         *
         * @param value
         *            The FinancialStatementItemText_2s to build this FinancialStatementItem_2 with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FinancialStatementItem_2.FinancialStatementItem_2Builder cnsldtnFSItemT(
            FinancialStatementItemText_2... value )
        {
            return toCnsldtnFSItemT(Lists.newArrayList(value));
        }

    }

}
