/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.FinancialStmntItemHierTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.FinancialStmntItemHierTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.FinancialStmntItemHierTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Financial Statement Item Hier Node - Txt
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>FinancialStmntItemHierTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class FinancialStmntItemHierText extends VdmEntity<FinancialStmntItemHierText>
{

    /**
     * Selector for all available fields of FinancialStmntItemHierText.
     *
     */
    public final static FinancialStmntItemHierTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts</b>
     * </p>
     *
     * @return Consolidation Chart of Accounts
     */
    @Key
    @SerializedName( "ConsolidationChartOfAccounts" )
    @JsonProperty( "ConsolidationChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "ConsolidationChartOfAccounts" )
    private String consolidationChartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationChartOfAccounts</b> field to query operations.
     *
     */
    public final static FinancialStmntItemHierTextField<String> CONSOLIDATION_CHART_OF_ACCOUNTS =
        new FinancialStmntItemHierTextField<String>("ConsolidationChartOfAccounts");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts_Text</b>
     * </p>
     *
     * @return Consolidation Chart of Accounts Description
     */
    @SerializedName( "ConsolidationChartOfAccounts_Text" )
    @JsonProperty( "ConsolidationChartOfAccounts_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationChartOfAccounts_Text" )
    private String consolidationChartOfAccounts_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationChartOfAccounts_Text</b> field to query
     * operations.
     *
     */
    public final static FinancialStmntItemHierTextField<String> CONSOLIDATION_CHART_OF_ACCOUNTS_TEXT =
        new FinancialStmntItemHierTextField<String>("ConsolidationChartOfAccounts_Text");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItemHier</b>
     * </p>
     *
     * @return Consolidation Financial Item Statement Hierarchy
     */
    @Key
    @SerializedName( "FinancialStatementItemHier" )
    @JsonProperty( "FinancialStatementItemHier" )
    @Nullable
    @ODataField( odataName = "FinancialStatementItemHier" )
    private String financialStatementItemHier;
    /**
     * Use with available fluent helpers to apply the <b>FinancialStatementItemHier</b> field to query operations.
     *
     */
    public final static FinancialStmntItemHierTextField<String> FINANCIAL_STATEMENT_ITEM_HIER =
        new FinancialStmntItemHierTextField<String>("FinancialStatementItemHier");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @return Consolidation Hierarchy Node
     */
    @Key
    @SerializedName( "HierarchyNode" )
    @JsonProperty( "HierarchyNode" )
    @Nullable
    @ODataField( odataName = "HierarchyNode" )
    private String hierarchyNode;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNode</b> field to query operations.
     *
     */
    public final static FinancialStmntItemHierTextField<String> HIERARCHY_NODE =
        new FinancialStmntItemHierTextField<String>("HierarchyNode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static FinancialStmntItemHierTextField<String> LANGUAGE =
        new FinancialStmntItemHierTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeText</b>
     * </p>
     *
     * @return Consolidation Hierarchy Node Description
     */
    @SerializedName( "HierarchyNodeText" )
    @JsonProperty( "HierarchyNodeText" )
    @Nullable
    @ODataField( odataName = "HierarchyNodeText" )
    private String hierarchyNodeText;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNodeText</b> field to query operations.
     *
     */
    public final static FinancialStmntItemHierTextField<String> HIERARCHY_NODE_TEXT =
        new FinancialStmntItemHierTextField<String>("HierarchyNodeText");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @return Consolidation Hierarchy Node Type
     */
    @SerializedName( "NodeType" )
    @JsonProperty( "NodeType" )
    @Nullable
    @ODataField( odataName = "NodeType" )
    private String nodeType;
    /**
     * Use with available fluent helpers to apply the <b>NodeType</b> field to query operations.
     *
     */
    public final static FinancialStmntItemHierTextField<String> NODE_TYPE =
        new FinancialStmntItemHierTextField<String>("NodeType");
    /**
     * Navigation property <b>to_CnsldtnFSItemHier</b> for <b>FinancialStmntItemHierText</b> to single
     * <b>FinancialStatementItemHier</b>.
     *
     */
    @SerializedName( "to_CnsldtnFSItemHier" )
    @JsonProperty( "to_CnsldtnFSItemHier" )
    @ODataField( odataName = "to_CnsldtnFSItemHier" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private FinancialStatementItemHier toCnsldtnFSItemHier;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnFSItemHier</b> navigation property to query
     * operations.
     *
     */
    public final static FinancialStmntItemHierTextOneToOneLink<FinancialStatementItemHier> TO_CNSLDTN_FS_ITEM_HIER =
        new FinancialStmntItemHierTextOneToOneLink<FinancialStatementItemHier>("to_CnsldtnFSItemHier");

    @Nonnull
    @Override
    public Class<FinancialStmntItemHierText> getType()
    {
        return FinancialStmntItemHierText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts</b>
     * </p>
     *
     * @param consolidationChartOfAccounts
     *            Consolidation Chart of Accounts
     */
    public void setConsolidationChartOfAccounts( @Nullable final String consolidationChartOfAccounts )
    {
        rememberChangedField("ConsolidationChartOfAccounts", this.consolidationChartOfAccounts);
        this.consolidationChartOfAccounts = consolidationChartOfAccounts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts_Text</b>
     * </p>
     *
     * @param consolidationChartOfAccounts_Text
     *            Consolidation Chart of Accounts Description
     */
    public void setConsolidationChartOfAccounts_Text( @Nullable final String consolidationChartOfAccounts_Text )
    {
        rememberChangedField("ConsolidationChartOfAccounts_Text", this.consolidationChartOfAccounts_Text);
        this.consolidationChartOfAccounts_Text = consolidationChartOfAccounts_Text;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FinancialStatementItemHier</b>
     * </p>
     *
     * @param financialStatementItemHier
     *            Consolidation Financial Item Statement Hierarchy
     */
    public void setFinancialStatementItemHier( @Nullable final String financialStatementItemHier )
    {
        rememberChangedField("FinancialStatementItemHier", this.financialStatementItemHier);
        this.financialStatementItemHier = financialStatementItemHier;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @param hierarchyNode
     *            Consolidation Hierarchy Node
     */
    public void setHierarchyNode( @Nullable final String hierarchyNode )
    {
        rememberChangedField("HierarchyNode", this.hierarchyNode);
        this.hierarchyNode = hierarchyNode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeText</b>
     * </p>
     *
     * @param hierarchyNodeText
     *            Consolidation Hierarchy Node Description
     */
    public void setHierarchyNodeText( @Nullable final String hierarchyNodeText )
    {
        rememberChangedField("HierarchyNodeText", this.hierarchyNodeText);
        this.hierarchyNodeText = hierarchyNodeText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @param nodeType
     *            Consolidation Hierarchy Node Type
     */
    public void setNodeType( @Nullable final String nodeType )
    {
        rememberChangedField("NodeType", this.nodeType);
        this.nodeType = nodeType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "FinancialStmntItemHierText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConsolidationChartOfAccounts", getConsolidationChartOfAccounts());
        result.put("FinancialStatementItemHier", getFinancialStatementItemHier());
        result.put("HierarchyNode", getHierarchyNode());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConsolidationChartOfAccounts", getConsolidationChartOfAccounts());
        values.put("ConsolidationChartOfAccounts_Text", getConsolidationChartOfAccounts_Text());
        values.put("FinancialStatementItemHier", getFinancialStatementItemHier());
        values.put("HierarchyNode", getHierarchyNode());
        values.put("Language", getLanguage());
        values.put("HierarchyNodeText", getHierarchyNodeText());
        values.put("NodeType", getNodeType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConsolidationChartOfAccounts") ) {
                final Object value = values.remove("ConsolidationChartOfAccounts");
                if( (value == null) || (!value.equals(getConsolidationChartOfAccounts())) ) {
                    setConsolidationChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("ConsolidationChartOfAccounts_Text") ) {
                final Object value = values.remove("ConsolidationChartOfAccounts_Text");
                if( (value == null) || (!value.equals(getConsolidationChartOfAccounts_Text())) ) {
                    setConsolidationChartOfAccounts_Text(((String) value));
                }
            }
            if( values.containsKey("FinancialStatementItemHier") ) {
                final Object value = values.remove("FinancialStatementItemHier");
                if( (value == null) || (!value.equals(getFinancialStatementItemHier())) ) {
                    setFinancialStatementItemHier(((String) value));
                }
            }
            if( values.containsKey("HierarchyNode") ) {
                final Object value = values.remove("HierarchyNode");
                if( (value == null) || (!value.equals(getHierarchyNode())) ) {
                    setHierarchyNode(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("HierarchyNodeText") ) {
                final Object value = values.remove("HierarchyNodeText");
                if( (value == null) || (!value.equals(getHierarchyNodeText())) ) {
                    setHierarchyNodeText(((String) value));
                }
            }
            if( values.containsKey("NodeType") ) {
                final Object value = values.remove("NodeType");
                if( (value == null) || (!value.equals(getNodeType())) ) {
                    setNodeType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnFSItemHier") ) {
                final Object value = (values).remove("to_CnsldtnFSItemHier");
                if( value instanceof Map ) {
                    if( toCnsldtnFSItemHier == null ) {
                        toCnsldtnFSItemHier = new FinancialStatementItemHier();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnFSItemHier.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> FinancialStmntItemHierTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new FinancialStmntItemHierTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FinancialStmntItemHierTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FinancialStmntItemHierTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnFSItemHier != null ) {
            (values).put("to_CnsldtnFSItemHier", toCnsldtnFSItemHier);
        }
        return values;
    }

    /**
     * Fetches the <b>FinancialStatementItemHier</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CnsldtnFSItemHier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>FinancialStatementItemHier</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public FinancialStatementItemHier fetchCnsldtnFSItemHier()
    {
        return fetchFieldAsSingle("to_CnsldtnFSItemHier", FinancialStatementItemHier.class);
    }

    /**
     * Retrieval of associated <b>FinancialStatementItemHier</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItemHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFSItemHier</b> of a queried <b>FinancialStmntItemHierText</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>FinancialStatementItemHier</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public FinancialStatementItemHier getCnsldtnFSItemHierOrFetch()
    {
        if( toCnsldtnFSItemHier == null ) {
            toCnsldtnFSItemHier = fetchCnsldtnFSItemHier();
        }
        return toCnsldtnFSItemHier;
    }

    /**
     * Retrieval of associated <b>FinancialStatementItemHier</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnFSItemHier</b>.
     * <p>
     * If the navigation property for an entity <b>FinancialStmntItemHierText</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnFSItemHier</b> is already loaded, the result will
     *         contain the <b>FinancialStatementItemHier</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<FinancialStatementItemHier> getCnsldtnFSItemHierIfPresent()
    {
        return Option.of(toCnsldtnFSItemHier);
    }

    /**
     * Overwrites the associated <b>FinancialStatementItemHier</b> entity for the loaded navigation property
     * <b>to_CnsldtnFSItemHier</b>.
     *
     * @param value
     *            New <b>FinancialStatementItemHier</b> entity.
     */
    public void setCnsldtnFSItemHier( final FinancialStatementItemHier value )
    {
        toCnsldtnFSItemHier = value;
    }

    /**
     * Helper class to allow for fluent creation of FinancialStmntItemHierText instances.
     *
     */
    public final static class FinancialStmntItemHierTextBuilder
    {

        private FinancialStatementItemHier toCnsldtnFSItemHier;

        private FinancialStmntItemHierText.FinancialStmntItemHierTextBuilder toCnsldtnFSItemHier(
            final FinancialStatementItemHier value )
        {
            toCnsldtnFSItemHier = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnFSItemHier</b> for <b>FinancialStmntItemHierText</b> to single
         * <b>FinancialStatementItemHier</b>.
         *
         * @param value
         *            The FinancialStatementItemHier to build this FinancialStmntItemHierText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FinancialStmntItemHierText.FinancialStmntItemHierTextBuilder cnsldtnFSItemHier(
            final FinancialStatementItemHier value )
        {
            return toCnsldtnFSItemHier(value);
        }

    }

}
