/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.FinancialStmntItemHierText_2Selectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStmntItemHierText_2
 * FinancialStmntItemHierText_2} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class FinancialStmntItemHierText_2ByKeyFluentHelper
    extends
    FluentHelperByKey<FinancialStmntItemHierText_2ByKeyFluentHelper, FinancialStmntItemHierText_2, FinancialStmntItemHierText_2Selectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStmntItemHierText_2
     * FinancialStmntItemHierText_2} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code FinancialStmntItemHierText_2}
     * @param servicePath
     *            Service path to be used to fetch a single {@code FinancialStmntItemHierText_2}
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param consolidationChartOfAccounts
     *            Consolidation Chart of Accounts
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param hierarchyNode
     *            Consolidation Hierarchy Node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 50
     *            </p>
     * @param financialStatementItemHier
     *            Consolidation Financial Item Statement Hierarchy
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public FinancialStmntItemHierText_2ByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String language,
        final String consolidationChartOfAccounts,
        final String financialStatementItemHier,
        final String hierarchyNode )
    {
        super(servicePath, entityCollection);
        this.key.put("Language", language);
        this.key.put("ConsolidationChartOfAccounts", consolidationChartOfAccounts);
        this.key.put("FinancialStatementItemHier", financialStatementItemHier);
        this.key.put("HierarchyNode", hierarchyNode);
    }

    @Override
    @Nonnull
    protected Class<FinancialStmntItemHierText_2> getEntityClass()
    {
        return FinancialStmntItemHierText_2.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
