/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.FinancialTransactionTypeField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.FinancialTransactionTypeLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.FinancialTransactionTypeSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Financial Transaction Type
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>FinancialTransactionTypeType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class FinancialTransactionType extends VdmEntity<FinancialTransactionType>
{

    /**
     * Selector for all available fields of FinancialTransactionType.
     *
     */
    public final static FinancialTransactionTypeSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FinancialTransactionType</b>
     * </p>
     *
     * @return Transaction type
     */
    @Key
    @SerializedName( "FinancialTransactionType" )
    @JsonProperty( "FinancialTransactionType" )
    @Nullable
    @ODataField( odataName = "FinancialTransactionType" )
    private String financialTransactionType;
    /**
     * Use with available fluent helpers to apply the <b>FinancialTransactionType</b> field to query operations.
     *
     */
    public final static FinancialTransactionTypeField<String> FINANCIAL_TRANSACTION_TYPE =
        new FinancialTransactionTypeField<String>("FinancialTransactionType");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>FinancialTransactionType_Text</b>
     * </p>
     *
     * @return Financial Transaction Type Description
     */
    @SerializedName( "FinancialTransactionType_Text" )
    @JsonProperty( "FinancialTransactionType_Text" )
    @Nullable
    @ODataField( odataName = "FinancialTransactionType_Text" )
    private String financialTransactionType_Text;
    /**
     * Use with available fluent helpers to apply the <b>FinancialTransactionType_Text</b> field to query operations.
     *
     */
    public final static FinancialTransactionTypeField<String> FINANCIAL_TRANSACTION_TYPE_TEXT =
        new FinancialTransactionTypeField<String>("FinancialTransactionType_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @return Consolidation Additional Master Data Source
     */
    @SerializedName( "AdditionalMasterDataSource" )
    @JsonProperty( "AdditionalMasterDataSource" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataSource" )
    private String additionalMasterDataSource;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataSource</b> field to query operations.
     *
     */
    public final static FinancialTransactionTypeField<String> ADDITIONAL_MASTER_DATA_SOURCE =
        new FinancialTransactionTypeField<String>("AdditionalMasterDataSource");
    /**
     * Navigation property <b>to_CnsldtnFinTransTypeHier</b> for <b>FinancialTransactionType</b> to multiple
     * <b>FinancialTransactionTypeHier</b>.
     *
     */
    @SerializedName( "to_CnsldtnFinTransTypeHier" )
    @JsonProperty( "to_CnsldtnFinTransTypeHier" )
    @ODataField( odataName = "to_CnsldtnFinTransTypeHier" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<FinancialTransactionTypeHier> toCnsldtnFinTransTypeHier;
    /**
     * Navigation property <b>to_CnsldtnFinTransTypeT</b> for <b>FinancialTransactionType</b> to multiple
     * <b>FinancialTransactionTypeText</b>.
     *
     */
    @SerializedName( "to_CnsldtnFinTransTypeT" )
    @JsonProperty( "to_CnsldtnFinTransTypeT" )
    @ODataField( odataName = "to_CnsldtnFinTransTypeT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<FinancialTransactionTypeText> toCnsldtnFinTransTypeT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnFinTransTypeHier</b> navigation property to query
     * operations.
     *
     */
    public final static FinancialTransactionTypeLink<FinancialTransactionTypeHier> TO_CNSLDTN_FIN_TRANS_TYPE_HIER =
        new FinancialTransactionTypeLink<FinancialTransactionTypeHier>("to_CnsldtnFinTransTypeHier");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnFinTransTypeT</b> navigation property to query
     * operations.
     *
     */
    public final static FinancialTransactionTypeLink<FinancialTransactionTypeText> TO_CNSLDTN_FIN_TRANS_TYPE_T =
        new FinancialTransactionTypeLink<FinancialTransactionTypeText>("to_CnsldtnFinTransTypeT");

    @Nonnull
    @Override
    public Class<FinancialTransactionType> getType()
    {
        return FinancialTransactionType.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FinancialTransactionType</b>
     * </p>
     *
     * @param financialTransactionType
     *            Transaction type
     */
    public void setFinancialTransactionType( @Nullable final String financialTransactionType )
    {
        rememberChangedField("FinancialTransactionType", this.financialTransactionType);
        this.financialTransactionType = financialTransactionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>FinancialTransactionType_Text</b>
     * </p>
     *
     * @param financialTransactionType_Text
     *            Financial Transaction Type Description
     */
    public void setFinancialTransactionType_Text( @Nullable final String financialTransactionType_Text )
    {
        rememberChangedField("FinancialTransactionType_Text", this.financialTransactionType_Text);
        this.financialTransactionType_Text = financialTransactionType_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @param additionalMasterDataSource
     *            Consolidation Additional Master Data Source
     */
    public void setAdditionalMasterDataSource( @Nullable final String additionalMasterDataSource )
    {
        rememberChangedField("AdditionalMasterDataSource", this.additionalMasterDataSource);
        this.additionalMasterDataSource = additionalMasterDataSource;
    }

    @Override
    protected String getEntityCollection()
    {
        return "FinancialTransactionType";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("FinancialTransactionType", getFinancialTransactionType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("FinancialTransactionType", getFinancialTransactionType());
        values.put("FinancialTransactionType_Text", getFinancialTransactionType_Text());
        values.put("AdditionalMasterDataSource", getAdditionalMasterDataSource());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("FinancialTransactionType") ) {
                final Object value = values.remove("FinancialTransactionType");
                if( (value == null) || (!value.equals(getFinancialTransactionType())) ) {
                    setFinancialTransactionType(((String) value));
                }
            }
            if( values.containsKey("FinancialTransactionType_Text") ) {
                final Object value = values.remove("FinancialTransactionType_Text");
                if( (value == null) || (!value.equals(getFinancialTransactionType_Text())) ) {
                    setFinancialTransactionType_Text(((String) value));
                }
            }
            if( values.containsKey("AdditionalMasterDataSource") ) {
                final Object value = values.remove("AdditionalMasterDataSource");
                if( (value == null) || (!value.equals(getAdditionalMasterDataSource())) ) {
                    setAdditionalMasterDataSource(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnFinTransTypeHier") ) {
                final Object value = (values).remove("to_CnsldtnFinTransTypeHier");
                if( value instanceof Iterable ) {
                    if( toCnsldtnFinTransTypeHier == null ) {
                        toCnsldtnFinTransTypeHier = Lists.newArrayList();
                    } else {
                        toCnsldtnFinTransTypeHier = Lists.newArrayList(toCnsldtnFinTransTypeHier);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        FinancialTransactionTypeHier entity;
                        if( toCnsldtnFinTransTypeHier.size() > i ) {
                            entity = toCnsldtnFinTransTypeHier.get(i);
                        } else {
                            entity = new FinancialTransactionTypeHier();
                            toCnsldtnFinTransTypeHier.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CnsldtnFinTransTypeT") ) {
                final Object value = (values).remove("to_CnsldtnFinTransTypeT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnFinTransTypeT == null ) {
                        toCnsldtnFinTransTypeT = Lists.newArrayList();
                    } else {
                        toCnsldtnFinTransTypeT = Lists.newArrayList(toCnsldtnFinTransTypeT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        FinancialTransactionTypeText entity;
                        if( toCnsldtnFinTransTypeT.size() > i ) {
                            entity = toCnsldtnFinTransTypeT.get(i);
                        } else {
                            entity = new FinancialTransactionTypeText();
                            toCnsldtnFinTransTypeT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> FinancialTransactionTypeField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new FinancialTransactionTypeField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FinancialTransactionTypeField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FinancialTransactionTypeField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnFinTransTypeHier != null ) {
            (values).put("to_CnsldtnFinTransTypeHier", toCnsldtnFinTransTypeHier);
        }
        if( toCnsldtnFinTransTypeT != null ) {
            (values).put("to_CnsldtnFinTransTypeT", toCnsldtnFinTransTypeT);
        }
        return values;
    }

    /**
     * Fetches the <b>FinancialTransactionTypeHier</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_CnsldtnFinTransTypeHier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>FinancialTransactionTypeHier</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<FinancialTransactionTypeHier> fetchCnsldtnFinTransTypeHier()
    {
        return fetchFieldAsList("to_CnsldtnFinTransTypeHier", FinancialTransactionTypeHier.class);
    }

    /**
     * Retrieval of associated <b>FinancialTransactionTypeHier</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnFinTransTypeHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFinTransTypeHier</b> of a queried <b>FinancialTransactionType</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>FinancialTransactionTypeHier</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<FinancialTransactionTypeHier> getCnsldtnFinTransTypeHierOrFetch()
    {
        if( toCnsldtnFinTransTypeHier == null ) {
            toCnsldtnFinTransTypeHier = fetchCnsldtnFinTransTypeHier();
        }
        return toCnsldtnFinTransTypeHier;
    }

    /**
     * Retrieval of associated <b>FinancialTransactionTypeHier</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnFinTransTypeHier</b>.
     * <p>
     * If the navigation property for an entity <b>FinancialTransactionType</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnFinTransTypeHier</b> is already loaded, the
     *         result will contain the <b>FinancialTransactionTypeHier</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<FinancialTransactionTypeHier>> getCnsldtnFinTransTypeHierIfPresent()
    {
        return Option.of(toCnsldtnFinTransTypeHier);
    }

    /**
     * Overwrites the list of associated <b>FinancialTransactionTypeHier</b> entities for the loaded navigation property
     * <b>to_CnsldtnFinTransTypeHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFinTransTypeHier</b> of a queried <b>FinancialTransactionType</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>FinancialTransactionTypeHier</b> entities.
     */
    public void setCnsldtnFinTransTypeHier( @Nonnull final List<FinancialTransactionTypeHier> value )
    {
        if( toCnsldtnFinTransTypeHier == null ) {
            toCnsldtnFinTransTypeHier = Lists.newArrayList();
        }
        toCnsldtnFinTransTypeHier.clear();
        toCnsldtnFinTransTypeHier.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>FinancialTransactionTypeHier</b> entities. This corresponds to the
     * OData navigation property <b>to_CnsldtnFinTransTypeHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFinTransTypeHier</b> of a queried <b>FinancialTransactionType</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>FinancialTransactionTypeHier</b> entities.
     */
    public void addCnsldtnFinTransTypeHier( FinancialTransactionTypeHier... entity )
    {
        if( toCnsldtnFinTransTypeHier == null ) {
            toCnsldtnFinTransTypeHier = Lists.newArrayList();
        }
        toCnsldtnFinTransTypeHier.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>FinancialTransactionTypeText</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_CnsldtnFinTransTypeT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>FinancialTransactionTypeText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<FinancialTransactionTypeText> fetchCnsldtnFinTransTypeT()
    {
        return fetchFieldAsList("to_CnsldtnFinTransTypeT", FinancialTransactionTypeText.class);
    }

    /**
     * Retrieval of associated <b>FinancialTransactionTypeText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnFinTransTypeT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFinTransTypeT</b> of a queried <b>FinancialTransactionType</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>FinancialTransactionTypeText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<FinancialTransactionTypeText> getCnsldtnFinTransTypeTOrFetch()
    {
        if( toCnsldtnFinTransTypeT == null ) {
            toCnsldtnFinTransTypeT = fetchCnsldtnFinTransTypeT();
        }
        return toCnsldtnFinTransTypeT;
    }

    /**
     * Retrieval of associated <b>FinancialTransactionTypeText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnFinTransTypeT</b>.
     * <p>
     * If the navigation property for an entity <b>FinancialTransactionType</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnFinTransTypeT</b> is already loaded, the result
     *         will contain the <b>FinancialTransactionTypeText</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<FinancialTransactionTypeText>> getCnsldtnFinTransTypeTIfPresent()
    {
        return Option.of(toCnsldtnFinTransTypeT);
    }

    /**
     * Overwrites the list of associated <b>FinancialTransactionTypeText</b> entities for the loaded navigation property
     * <b>to_CnsldtnFinTransTypeT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFinTransTypeT</b> of a queried <b>FinancialTransactionType</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>FinancialTransactionTypeText</b> entities.
     */
    public void setCnsldtnFinTransTypeT( @Nonnull final List<FinancialTransactionTypeText> value )
    {
        if( toCnsldtnFinTransTypeT == null ) {
            toCnsldtnFinTransTypeT = Lists.newArrayList();
        }
        toCnsldtnFinTransTypeT.clear();
        toCnsldtnFinTransTypeT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>FinancialTransactionTypeText</b> entities. This corresponds to the
     * OData navigation property <b>to_CnsldtnFinTransTypeT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFinTransTypeT</b> of a queried <b>FinancialTransactionType</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>FinancialTransactionTypeText</b> entities.
     */
    public void addCnsldtnFinTransTypeT( FinancialTransactionTypeText... entity )
    {
        if( toCnsldtnFinTransTypeT == null ) {
            toCnsldtnFinTransTypeT = Lists.newArrayList();
        }
        toCnsldtnFinTransTypeT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of FinancialTransactionType instances.
     *
     */
    public final static class FinancialTransactionTypeBuilder
    {

        private List<FinancialTransactionTypeHier> toCnsldtnFinTransTypeHier = Lists.newArrayList();
        private List<FinancialTransactionTypeText> toCnsldtnFinTransTypeT = Lists.newArrayList();

        private FinancialTransactionType.FinancialTransactionTypeBuilder toCnsldtnFinTransTypeHier(
            final List<FinancialTransactionTypeHier> value )
        {
            toCnsldtnFinTransTypeHier.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnFinTransTypeHier</b> for <b>FinancialTransactionType</b> to multiple
         * <b>FinancialTransactionTypeHier</b>.
         *
         * @param value
         *            The FinancialTransactionTypeHiers to build this FinancialTransactionType with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FinancialTransactionType.FinancialTransactionTypeBuilder cnsldtnFinTransTypeHier(
            FinancialTransactionTypeHier... value )
        {
            return toCnsldtnFinTransTypeHier(Lists.newArrayList(value));
        }

        private FinancialTransactionType.FinancialTransactionTypeBuilder toCnsldtnFinTransTypeT(
            final List<FinancialTransactionTypeText> value )
        {
            toCnsldtnFinTransTypeT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnFinTransTypeT</b> for <b>FinancialTransactionType</b> to multiple
         * <b>FinancialTransactionTypeText</b>.
         *
         * @param value
         *            The FinancialTransactionTypeTexts to build this FinancialTransactionType with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FinancialTransactionType.FinancialTransactionTypeBuilder cnsldtnFinTransTypeT(
            FinancialTransactionTypeText... value )
        {
            return toCnsldtnFinTransTypeT(Lists.newArrayList(value));
        }

    }

}
