/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.FinancialTransactionTypeHierField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.FinancialTransactionTypeHierLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.FinancialTransactionTypeHierOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.FinancialTransactionTypeHierSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Financial Transaction Type Hierarchy
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>FinancialTransactionTypeHierType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class FinancialTransactionTypeHier extends VdmEntity<FinancialTransactionTypeHier>
{

    /**
     * Selector for all available fields of FinancialTransactionTypeHier.
     *
     */
    public final static FinancialTransactionTypeHierSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataHierarchy</b>
     * </p>
     *
     * @return Consolidation Transaction Type Hierarchy
     */
    @Key
    @SerializedName( "AdditionalMasterDataHierarchy" )
    @JsonProperty( "AdditionalMasterDataHierarchy" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataHierarchy" )
    private String additionalMasterDataHierarchy;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataHierarchy</b> field to query operations.
     *
     */
    public final static FinancialTransactionTypeHierField<String> ADDITIONAL_MASTER_DATA_HIERARCHY =
        new FinancialTransactionTypeHierField<String>("AdditionalMasterDataHierarchy");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @return Consolidation Hierarchy Node
     */
    @Key
    @SerializedName( "HierarchyNode" )
    @JsonProperty( "HierarchyNode" )
    @Nullable
    @ODataField( odataName = "HierarchyNode" )
    private String hierarchyNode;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNode</b> field to query operations.
     *
     */
    public final static FinancialTransactionTypeHierField<String> HIERARCHY_NODE =
        new FinancialTransactionTypeHierField<String>("HierarchyNode");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode_Text</b>
     * </p>
     *
     * @return Consolidation Hierarchy Node Description
     */
    @SerializedName( "HierarchyNode_Text" )
    @JsonProperty( "HierarchyNode_Text" )
    @Nullable
    @ODataField( odataName = "HierarchyNode_Text" )
    private String hierarchyNode_Text;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNode_Text</b> field to query operations.
     *
     */
    public final static FinancialTransactionTypeHierField<String> HIERARCHY_NODE_TEXT =
        new FinancialTransactionTypeHierField<String>("HierarchyNode_Text");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Validity End Date
     */
    @Key
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static FinancialTransactionTypeHierField<LocalDateTime> VALIDITY_END_DATE =
        new FinancialTransactionTypeHierField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ParentNode</b>
     * </p>
     *
     * @return Consolidation Hierarchy Parent Node
     */
    @SerializedName( "ParentNode" )
    @JsonProperty( "ParentNode" )
    @Nullable
    @ODataField( odataName = "ParentNode" )
    private String parentNode;
    /**
     * Use with available fluent helpers to apply the <b>ParentNode</b> field to query operations.
     *
     */
    public final static FinancialTransactionTypeHierField<String> PARENT_NODE =
        new FinancialTransactionTypeHierField<String>("ParentNode");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Validity Start Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static FinancialTransactionTypeHierField<LocalDateTime> VALIDITY_START_DATE =
        new FinancialTransactionTypeHierField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FinancialTransactionType</b>
     * </p>
     *
     * @return Financial Transaction Type
     */
    @SerializedName( "FinancialTransactionType" )
    @JsonProperty( "FinancialTransactionType" )
    @Nullable
    @ODataField( odataName = "FinancialTransactionType" )
    private String financialTransactionType;
    /**
     * Use with available fluent helpers to apply the <b>FinancialTransactionType</b> field to query operations.
     *
     */
    public final static FinancialTransactionTypeHierField<String> FINANCIAL_TRANSACTION_TYPE =
        new FinancialTransactionTypeHierField<String>("FinancialTransactionType");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>FinancialTransactionType_Text</b>
     * </p>
     *
     * @return Financial Transaction Type Description
     */
    @SerializedName( "FinancialTransactionType_Text" )
    @JsonProperty( "FinancialTransactionType_Text" )
    @Nullable
    @ODataField( odataName = "FinancialTransactionType_Text" )
    private String financialTransactionType_Text;
    /**
     * Use with available fluent helpers to apply the <b>FinancialTransactionType_Text</b> field to query operations.
     *
     */
    public final static FinancialTransactionTypeHierField<String> FINANCIAL_TRANSACTION_TYPE_TEXT =
        new FinancialTransactionTypeHierField<String>("FinancialTransactionType_Text");
    /**
     * Constraints: Not nullable, Maximum length: 56
     * <p>
     * Original property name from the Odata EDM: <b>SequenceNumber</b>
     * </p>
     *
     * @return The sequenceNumber contained in this entity.
     */
    @SerializedName( "SequenceNumber" )
    @JsonProperty( "SequenceNumber" )
    @Nullable
    @ODataField( odataName = "SequenceNumber" )
    private String sequenceNumber;
    /**
     * Use with available fluent helpers to apply the <b>SequenceNumber</b> field to query operations.
     *
     */
    public final static FinancialTransactionTypeHierField<String> SEQUENCE_NUMBER =
        new FinancialTransactionTypeHierField<String>("SequenceNumber");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeSequence</b>
     * </p>
     *
     * @return Consolidation Hierarchy Sequence Number
     */
    @SerializedName( "HierarchyNodeSequence" )
    @JsonProperty( "HierarchyNodeSequence" )
    @Nullable
    @ODataField( odataName = "HierarchyNodeSequence" )
    private String hierarchyNodeSequence;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNodeSequence</b> field to query operations.
     *
     */
    public final static FinancialTransactionTypeHierField<String> HIERARCHY_NODE_SEQUENCE =
        new FinancialTransactionTypeHierField<String>("HierarchyNodeSequence");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeLevel</b>
     * </p>
     *
     * @return Consolidation Hierarchy Level
     */
    @SerializedName( "HierarchyNodeLevel" )
    @JsonProperty( "HierarchyNodeLevel" )
    @Nullable
    @ODataField( odataName = "HierarchyNodeLevel" )
    private String hierarchyNodeLevel;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNodeLevel</b> field to query operations.
     *
     */
    public final static FinancialTransactionTypeHierField<String> HIERARCHY_NODE_LEVEL =
        new FinancialTransactionTypeHierField<String>("HierarchyNodeLevel");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @return Consolidation Hierarchy Node Type
     */
    @SerializedName( "NodeType" )
    @JsonProperty( "NodeType" )
    @Nullable
    @ODataField( odataName = "NodeType" )
    private String nodeType;
    /**
     * Use with available fluent helpers to apply the <b>NodeType</b> field to query operations.
     *
     */
    public final static FinancialTransactionTypeHierField<String> NODE_TYPE =
        new FinancialTransactionTypeHierField<String>("NodeType");
    /**
     * Navigation property <b>to_CnsldtnFinTransType</b> for <b>FinancialTransactionTypeHier</b> to single
     * <b>FinancialTransactionType</b>.
     *
     */
    @SerializedName( "to_CnsldtnFinTransType" )
    @JsonProperty( "to_CnsldtnFinTransType" )
    @ODataField( odataName = "to_CnsldtnFinTransType" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private FinancialTransactionType toCnsldtnFinTransType;
    /**
     * Navigation property <b>to_CnsldtnFinTransTypeHierT</b> for <b>FinancialTransactionTypeHier</b> to multiple
     * <b>FinancialTransTypeHierText</b>.
     *
     */
    @SerializedName( "to_CnsldtnFinTransTypeHierT" )
    @JsonProperty( "to_CnsldtnFinTransTypeHierT" )
    @ODataField( odataName = "to_CnsldtnFinTransTypeHierT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<FinancialTransTypeHierText> toCnsldtnFinTransTypeHierT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnFinTransType</b> navigation property to query
     * operations.
     *
     */
    public final static FinancialTransactionTypeHierOneToOneLink<FinancialTransactionType> TO_CNSLDTN_FIN_TRANS_TYPE =
        new FinancialTransactionTypeHierOneToOneLink<FinancialTransactionType>("to_CnsldtnFinTransType");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnFinTransTypeHierT</b> navigation property to query
     * operations.
     *
     */
    public final static FinancialTransactionTypeHierLink<FinancialTransTypeHierText> TO_CNSLDTN_FIN_TRANS_TYPE_HIER_T =
        new FinancialTransactionTypeHierLink<FinancialTransTypeHierText>("to_CnsldtnFinTransTypeHierT");

    @Nonnull
    @Override
    public Class<FinancialTransactionTypeHier> getType()
    {
        return FinancialTransactionTypeHier.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataHierarchy</b>
     * </p>
     *
     * @param additionalMasterDataHierarchy
     *            Consolidation Transaction Type Hierarchy
     */
    public void setAdditionalMasterDataHierarchy( @Nullable final String additionalMasterDataHierarchy )
    {
        rememberChangedField("AdditionalMasterDataHierarchy", this.additionalMasterDataHierarchy);
        this.additionalMasterDataHierarchy = additionalMasterDataHierarchy;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @param hierarchyNode
     *            Consolidation Hierarchy Node
     */
    public void setHierarchyNode( @Nullable final String hierarchyNode )
    {
        rememberChangedField("HierarchyNode", this.hierarchyNode);
        this.hierarchyNode = hierarchyNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode_Text</b>
     * </p>
     *
     * @param hierarchyNode_Text
     *            Consolidation Hierarchy Node Description
     */
    public void setHierarchyNode_Text( @Nullable final String hierarchyNode_Text )
    {
        rememberChangedField("HierarchyNode_Text", this.hierarchyNode_Text);
        this.hierarchyNode_Text = hierarchyNode_Text;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Validity End Date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ParentNode</b>
     * </p>
     *
     * @param parentNode
     *            Consolidation Hierarchy Parent Node
     */
    public void setParentNode( @Nullable final String parentNode )
    {
        rememberChangedField("ParentNode", this.parentNode);
        this.parentNode = parentNode;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Validity Start Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FinancialTransactionType</b>
     * </p>
     *
     * @param financialTransactionType
     *            Financial Transaction Type
     */
    public void setFinancialTransactionType( @Nullable final String financialTransactionType )
    {
        rememberChangedField("FinancialTransactionType", this.financialTransactionType);
        this.financialTransactionType = financialTransactionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>FinancialTransactionType_Text</b>
     * </p>
     *
     * @param financialTransactionType_Text
     *            Financial Transaction Type Description
     */
    public void setFinancialTransactionType_Text( @Nullable final String financialTransactionType_Text )
    {
        rememberChangedField("FinancialTransactionType_Text", this.financialTransactionType_Text);
        this.financialTransactionType_Text = financialTransactionType_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 56
     * <p>
     * Original property name from the Odata EDM: <b>SequenceNumber</b>
     * </p>
     *
     * @param sequenceNumber
     *            The sequenceNumber to set.
     */
    public void setSequenceNumber( @Nullable final String sequenceNumber )
    {
        rememberChangedField("SequenceNumber", this.sequenceNumber);
        this.sequenceNumber = sequenceNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeSequence</b>
     * </p>
     *
     * @param hierarchyNodeSequence
     *            Consolidation Hierarchy Sequence Number
     */
    public void setHierarchyNodeSequence( @Nullable final String hierarchyNodeSequence )
    {
        rememberChangedField("HierarchyNodeSequence", this.hierarchyNodeSequence);
        this.hierarchyNodeSequence = hierarchyNodeSequence;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeLevel</b>
     * </p>
     *
     * @param hierarchyNodeLevel
     *            Consolidation Hierarchy Level
     */
    public void setHierarchyNodeLevel( @Nullable final String hierarchyNodeLevel )
    {
        rememberChangedField("HierarchyNodeLevel", this.hierarchyNodeLevel);
        this.hierarchyNodeLevel = hierarchyNodeLevel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @param nodeType
     *            Consolidation Hierarchy Node Type
     */
    public void setNodeType( @Nullable final String nodeType )
    {
        rememberChangedField("NodeType", this.nodeType);
        this.nodeType = nodeType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "FinancialTransactionTypeHier";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("AdditionalMasterDataHierarchy", getAdditionalMasterDataHierarchy());
        result.put("HierarchyNode", getHierarchyNode());
        result.put("ValidityEndDate", getValidityEndDate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("AdditionalMasterDataHierarchy", getAdditionalMasterDataHierarchy());
        values.put("HierarchyNode", getHierarchyNode());
        values.put("HierarchyNode_Text", getHierarchyNode_Text());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ParentNode", getParentNode());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("FinancialTransactionType", getFinancialTransactionType());
        values.put("FinancialTransactionType_Text", getFinancialTransactionType_Text());
        values.put("SequenceNumber", getSequenceNumber());
        values.put("HierarchyNodeSequence", getHierarchyNodeSequence());
        values.put("HierarchyNodeLevel", getHierarchyNodeLevel());
        values.put("NodeType", getNodeType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("AdditionalMasterDataHierarchy") ) {
                final Object value = values.remove("AdditionalMasterDataHierarchy");
                if( (value == null) || (!value.equals(getAdditionalMasterDataHierarchy())) ) {
                    setAdditionalMasterDataHierarchy(((String) value));
                }
            }
            if( values.containsKey("HierarchyNode") ) {
                final Object value = values.remove("HierarchyNode");
                if( (value == null) || (!value.equals(getHierarchyNode())) ) {
                    setHierarchyNode(((String) value));
                }
            }
            if( values.containsKey("HierarchyNode_Text") ) {
                final Object value = values.remove("HierarchyNode_Text");
                if( (value == null) || (!value.equals(getHierarchyNode_Text())) ) {
                    setHierarchyNode_Text(((String) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ParentNode") ) {
                final Object value = values.remove("ParentNode");
                if( (value == null) || (!value.equals(getParentNode())) ) {
                    setParentNode(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("FinancialTransactionType") ) {
                final Object value = values.remove("FinancialTransactionType");
                if( (value == null) || (!value.equals(getFinancialTransactionType())) ) {
                    setFinancialTransactionType(((String) value));
                }
            }
            if( values.containsKey("FinancialTransactionType_Text") ) {
                final Object value = values.remove("FinancialTransactionType_Text");
                if( (value == null) || (!value.equals(getFinancialTransactionType_Text())) ) {
                    setFinancialTransactionType_Text(((String) value));
                }
            }
            if( values.containsKey("SequenceNumber") ) {
                final Object value = values.remove("SequenceNumber");
                if( (value == null) || (!value.equals(getSequenceNumber())) ) {
                    setSequenceNumber(((String) value));
                }
            }
            if( values.containsKey("HierarchyNodeSequence") ) {
                final Object value = values.remove("HierarchyNodeSequence");
                if( (value == null) || (!value.equals(getHierarchyNodeSequence())) ) {
                    setHierarchyNodeSequence(((String) value));
                }
            }
            if( values.containsKey("HierarchyNodeLevel") ) {
                final Object value = values.remove("HierarchyNodeLevel");
                if( (value == null) || (!value.equals(getHierarchyNodeLevel())) ) {
                    setHierarchyNodeLevel(((String) value));
                }
            }
            if( values.containsKey("NodeType") ) {
                final Object value = values.remove("NodeType");
                if( (value == null) || (!value.equals(getNodeType())) ) {
                    setNodeType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnFinTransType") ) {
                final Object value = (values).remove("to_CnsldtnFinTransType");
                if( value instanceof Map ) {
                    if( toCnsldtnFinTransType == null ) {
                        toCnsldtnFinTransType = new FinancialTransactionType();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnFinTransType.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_CnsldtnFinTransTypeHierT") ) {
                final Object value = (values).remove("to_CnsldtnFinTransTypeHierT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnFinTransTypeHierT == null ) {
                        toCnsldtnFinTransTypeHierT = Lists.newArrayList();
                    } else {
                        toCnsldtnFinTransTypeHierT = Lists.newArrayList(toCnsldtnFinTransTypeHierT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        FinancialTransTypeHierText entity;
                        if( toCnsldtnFinTransTypeHierT.size() > i ) {
                            entity = toCnsldtnFinTransTypeHierT.get(i);
                        } else {
                            entity = new FinancialTransTypeHierText();
                            toCnsldtnFinTransTypeHierT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> FinancialTransactionTypeHierField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new FinancialTransactionTypeHierField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FinancialTransactionTypeHierField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FinancialTransactionTypeHierField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnFinTransType != null ) {
            (values).put("to_CnsldtnFinTransType", toCnsldtnFinTransType);
        }
        if( toCnsldtnFinTransTypeHierT != null ) {
            (values).put("to_CnsldtnFinTransTypeHierT", toCnsldtnFinTransTypeHierT);
        }
        return values;
    }

    /**
     * Fetches the <b>FinancialTransactionType</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CnsldtnFinTransType</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>FinancialTransactionType</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public FinancialTransactionType fetchCnsldtnFinTransType()
    {
        return fetchFieldAsSingle("to_CnsldtnFinTransType", FinancialTransactionType.class);
    }

    /**
     * Retrieval of associated <b>FinancialTransactionType</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnFinTransType</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFinTransType</b> of a queried <b>FinancialTransactionTypeHier</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>FinancialTransactionType</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public FinancialTransactionType getCnsldtnFinTransTypeOrFetch()
    {
        if( toCnsldtnFinTransType == null ) {
            toCnsldtnFinTransType = fetchCnsldtnFinTransType();
        }
        return toCnsldtnFinTransType;
    }

    /**
     * Retrieval of associated <b>FinancialTransactionType</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnFinTransType</b>.
     * <p>
     * If the navigation property for an entity <b>FinancialTransactionTypeHier</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnFinTransType</b> is already loaded, the result
     *         will contain the <b>FinancialTransactionType</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<FinancialTransactionType> getCnsldtnFinTransTypeIfPresent()
    {
        return Option.of(toCnsldtnFinTransType);
    }

    /**
     * Overwrites the associated <b>FinancialTransactionType</b> entity for the loaded navigation property
     * <b>to_CnsldtnFinTransType</b>.
     *
     * @param value
     *            New <b>FinancialTransactionType</b> entity.
     */
    public void setCnsldtnFinTransType( final FinancialTransactionType value )
    {
        toCnsldtnFinTransType = value;
    }

    /**
     * Fetches the <b>FinancialTransTypeHierText</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_CnsldtnFinTransTypeHierT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>FinancialTransTypeHierText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<FinancialTransTypeHierText> fetchCnsldtnFinTransTypeHierT()
    {
        return fetchFieldAsList("to_CnsldtnFinTransTypeHierT", FinancialTransTypeHierText.class);
    }

    /**
     * Retrieval of associated <b>FinancialTransTypeHierText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnFinTransTypeHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFinTransTypeHierT</b> of a queried <b>FinancialTransactionTypeHier</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>FinancialTransTypeHierText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<FinancialTransTypeHierText> getCnsldtnFinTransTypeHierTOrFetch()
    {
        if( toCnsldtnFinTransTypeHierT == null ) {
            toCnsldtnFinTransTypeHierT = fetchCnsldtnFinTransTypeHierT();
        }
        return toCnsldtnFinTransTypeHierT;
    }

    /**
     * Retrieval of associated <b>FinancialTransTypeHierText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnFinTransTypeHierT</b>.
     * <p>
     * If the navigation property for an entity <b>FinancialTransactionTypeHier</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnFinTransTypeHierT</b> is already loaded, the
     *         result will contain the <b>FinancialTransTypeHierText</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<FinancialTransTypeHierText>> getCnsldtnFinTransTypeHierTIfPresent()
    {
        return Option.of(toCnsldtnFinTransTypeHierT);
    }

    /**
     * Overwrites the list of associated <b>FinancialTransTypeHierText</b> entities for the loaded navigation property
     * <b>to_CnsldtnFinTransTypeHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFinTransTypeHierT</b> of a queried <b>FinancialTransactionTypeHier</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>FinancialTransTypeHierText</b> entities.
     */
    public void setCnsldtnFinTransTypeHierT( @Nonnull final List<FinancialTransTypeHierText> value )
    {
        if( toCnsldtnFinTransTypeHierT == null ) {
            toCnsldtnFinTransTypeHierT = Lists.newArrayList();
        }
        toCnsldtnFinTransTypeHierT.clear();
        toCnsldtnFinTransTypeHierT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>FinancialTransTypeHierText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnFinTransTypeHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFinTransTypeHierT</b> of a queried <b>FinancialTransactionTypeHier</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>FinancialTransTypeHierText</b> entities.
     */
    public void addCnsldtnFinTransTypeHierT( FinancialTransTypeHierText... entity )
    {
        if( toCnsldtnFinTransTypeHierT == null ) {
            toCnsldtnFinTransTypeHierT = Lists.newArrayList();
        }
        toCnsldtnFinTransTypeHierT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of FinancialTransactionTypeHier instances.
     *
     */
    public final static class FinancialTransactionTypeHierBuilder
    {

        private FinancialTransactionType toCnsldtnFinTransType;
        private List<FinancialTransTypeHierText> toCnsldtnFinTransTypeHierT = Lists.newArrayList();

        private FinancialTransactionTypeHier.FinancialTransactionTypeHierBuilder toCnsldtnFinTransType(
            final FinancialTransactionType value )
        {
            toCnsldtnFinTransType = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnFinTransType</b> for <b>FinancialTransactionTypeHier</b> to single
         * <b>FinancialTransactionType</b>.
         *
         * @param value
         *            The FinancialTransactionType to build this FinancialTransactionTypeHier with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FinancialTransactionTypeHier.FinancialTransactionTypeHierBuilder cnsldtnFinTransType(
            final FinancialTransactionType value )
        {
            return toCnsldtnFinTransType(value);
        }

        private FinancialTransactionTypeHier.FinancialTransactionTypeHierBuilder toCnsldtnFinTransTypeHierT(
            final List<FinancialTransTypeHierText> value )
        {
            toCnsldtnFinTransTypeHierT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnFinTransTypeHierT</b> for <b>FinancialTransactionTypeHier</b> to multiple
         * <b>FinancialTransTypeHierText</b>.
         *
         * @param value
         *            The FinancialTransTypeHierTexts to build this FinancialTransactionTypeHier with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FinancialTransactionTypeHier.FinancialTransactionTypeHierBuilder cnsldtnFinTransTypeHierT(
            FinancialTransTypeHierText... value )
        {
            return toCnsldtnFinTransTypeHierT(Lists.newArrayList(value));
        }

    }

}
