/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.FunctionalAreaHierField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.FunctionalAreaHierLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.FunctionalAreaHierOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.FunctionalAreaHierSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Functional Area Hierarchy
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>FunctionalAreaHierType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class FunctionalAreaHier extends VdmEntity<FunctionalAreaHier>
{

    /**
     * Selector for all available fields of FunctionalAreaHier.
     *
     */
    public final static FunctionalAreaHierSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataHierarchy</b>
     * </p>
     *
     * @return Consolidation Hierarchy ID
     */
    @Key
    @SerializedName( "AdditionalMasterDataHierarchy" )
    @JsonProperty( "AdditionalMasterDataHierarchy" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataHierarchy" )
    private String additionalMasterDataHierarchy;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataHierarchy</b> field to query operations.
     *
     */
    public final static FunctionalAreaHierField<String> ADDITIONAL_MASTER_DATA_HIERARCHY =
        new FunctionalAreaHierField<String>("AdditionalMasterDataHierarchy");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @return Consolidation Hierarchy Node
     */
    @Key
    @SerializedName( "HierarchyNode" )
    @JsonProperty( "HierarchyNode" )
    @Nullable
    @ODataField( odataName = "HierarchyNode" )
    private String hierarchyNode;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNode</b> field to query operations.
     *
     */
    public final static FunctionalAreaHierField<String> HIERARCHY_NODE =
        new FunctionalAreaHierField<String>("HierarchyNode");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode_Text</b>
     * </p>
     *
     * @return Consolidation Hierarchy Node Description
     */
    @SerializedName( "HierarchyNode_Text" )
    @JsonProperty( "HierarchyNode_Text" )
    @Nullable
    @ODataField( odataName = "HierarchyNode_Text" )
    private String hierarchyNode_Text;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNode_Text</b> field to query operations.
     *
     */
    public final static FunctionalAreaHierField<String> HIERARCHY_NODE_TEXT =
        new FunctionalAreaHierField<String>("HierarchyNode_Text");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Validity End Date
     */
    @Key
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static FunctionalAreaHierField<LocalDateTime> VALIDITY_END_DATE =
        new FunctionalAreaHierField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ParentNode</b>
     * </p>
     *
     * @return Consolidation Hierarchy Parent Node
     */
    @SerializedName( "ParentNode" )
    @JsonProperty( "ParentNode" )
    @Nullable
    @ODataField( odataName = "ParentNode" )
    private String parentNode;
    /**
     * Use with available fluent helpers to apply the <b>ParentNode</b> field to query operations.
     *
     */
    public final static FunctionalAreaHierField<String> PARENT_NODE = new FunctionalAreaHierField<String>("ParentNode");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Validity Start Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static FunctionalAreaHierField<LocalDateTime> VALIDITY_START_DATE =
        new FunctionalAreaHierField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @return Consolidation Functional Area
     */
    @SerializedName( "FunctionalArea" )
    @JsonProperty( "FunctionalArea" )
    @Nullable
    @ODataField( odataName = "FunctionalArea" )
    private String functionalArea;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalArea</b> field to query operations.
     *
     */
    public final static FunctionalAreaHierField<String> FUNCTIONAL_AREA =
        new FunctionalAreaHierField<String>("FunctionalArea");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea_Text</b>
     * </p>
     *
     * @return Functional Area Description
     */
    @SerializedName( "FunctionalArea_Text" )
    @JsonProperty( "FunctionalArea_Text" )
    @Nullable
    @ODataField( odataName = "FunctionalArea_Text" )
    private String functionalArea_Text;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalArea_Text</b> field to query operations.
     *
     */
    public final static FunctionalAreaHierField<String> FUNCTIONAL_AREA_TEXT =
        new FunctionalAreaHierField<String>("FunctionalArea_Text");
    /**
     * Constraints: Not nullable, Maximum length: 56
     * <p>
     * Original property name from the Odata EDM: <b>SequenceNumber</b>
     * </p>
     *
     * @return The sequenceNumber contained in this entity.
     */
    @SerializedName( "SequenceNumber" )
    @JsonProperty( "SequenceNumber" )
    @Nullable
    @ODataField( odataName = "SequenceNumber" )
    private String sequenceNumber;
    /**
     * Use with available fluent helpers to apply the <b>SequenceNumber</b> field to query operations.
     *
     */
    public final static FunctionalAreaHierField<String> SEQUENCE_NUMBER =
        new FunctionalAreaHierField<String>("SequenceNumber");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeSequence</b>
     * </p>
     *
     * @return Consolidation Hierarchy Sequence Number
     */
    @SerializedName( "HierarchyNodeSequence" )
    @JsonProperty( "HierarchyNodeSequence" )
    @Nullable
    @ODataField( odataName = "HierarchyNodeSequence" )
    private String hierarchyNodeSequence;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNodeSequence</b> field to query operations.
     *
     */
    public final static FunctionalAreaHierField<String> HIERARCHY_NODE_SEQUENCE =
        new FunctionalAreaHierField<String>("HierarchyNodeSequence");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeLevel</b>
     * </p>
     *
     * @return Consolidation Hierarchy Level
     */
    @SerializedName( "HierarchyNodeLevel" )
    @JsonProperty( "HierarchyNodeLevel" )
    @Nullable
    @ODataField( odataName = "HierarchyNodeLevel" )
    private String hierarchyNodeLevel;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNodeLevel</b> field to query operations.
     *
     */
    public final static FunctionalAreaHierField<String> HIERARCHY_NODE_LEVEL =
        new FunctionalAreaHierField<String>("HierarchyNodeLevel");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @return Consolidation Hierarchy Node Type
     */
    @SerializedName( "NodeType" )
    @JsonProperty( "NodeType" )
    @Nullable
    @ODataField( odataName = "NodeType" )
    private String nodeType;
    /**
     * Use with available fluent helpers to apply the <b>NodeType</b> field to query operations.
     *
     */
    public final static FunctionalAreaHierField<String> NODE_TYPE = new FunctionalAreaHierField<String>("NodeType");
    /**
     * Navigation property <b>to_CnsldtnFuncnlAreaHierT</b> for <b>FunctionalAreaHier</b> to multiple
     * <b>FunctionalAreaHierText</b>.
     *
     */
    @SerializedName( "to_CnsldtnFuncnlAreaHierT" )
    @JsonProperty( "to_CnsldtnFuncnlAreaHierT" )
    @ODataField( odataName = "to_CnsldtnFuncnlAreaHierT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<FunctionalAreaHierText> toCnsldtnFuncnlAreaHierT;
    /**
     * Navigation property <b>to_CnsldtnFunctionalArea</b> for <b>FunctionalAreaHier</b> to single
     * <b>FunctionalArea</b>.
     *
     */
    @SerializedName( "to_CnsldtnFunctionalArea" )
    @JsonProperty( "to_CnsldtnFunctionalArea" )
    @ODataField( odataName = "to_CnsldtnFunctionalArea" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private FunctionalArea toCnsldtnFunctionalArea;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnFuncnlAreaHierT</b> navigation property to query
     * operations.
     *
     */
    public final static FunctionalAreaHierLink<FunctionalAreaHierText> TO_CNSLDTN_FUNCNL_AREA_HIER_T =
        new FunctionalAreaHierLink<FunctionalAreaHierText>("to_CnsldtnFuncnlAreaHierT");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnFunctionalArea</b> navigation property to query
     * operations.
     *
     */
    public final static FunctionalAreaHierOneToOneLink<FunctionalArea> TO_CNSLDTN_FUNCTIONAL_AREA =
        new FunctionalAreaHierOneToOneLink<FunctionalArea>("to_CnsldtnFunctionalArea");

    @Nonnull
    @Override
    public Class<FunctionalAreaHier> getType()
    {
        return FunctionalAreaHier.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataHierarchy</b>
     * </p>
     *
     * @param additionalMasterDataHierarchy
     *            Consolidation Hierarchy ID
     */
    public void setAdditionalMasterDataHierarchy( @Nullable final String additionalMasterDataHierarchy )
    {
        rememberChangedField("AdditionalMasterDataHierarchy", this.additionalMasterDataHierarchy);
        this.additionalMasterDataHierarchy = additionalMasterDataHierarchy;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @param hierarchyNode
     *            Consolidation Hierarchy Node
     */
    public void setHierarchyNode( @Nullable final String hierarchyNode )
    {
        rememberChangedField("HierarchyNode", this.hierarchyNode);
        this.hierarchyNode = hierarchyNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode_Text</b>
     * </p>
     *
     * @param hierarchyNode_Text
     *            Consolidation Hierarchy Node Description
     */
    public void setHierarchyNode_Text( @Nullable final String hierarchyNode_Text )
    {
        rememberChangedField("HierarchyNode_Text", this.hierarchyNode_Text);
        this.hierarchyNode_Text = hierarchyNode_Text;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Validity End Date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ParentNode</b>
     * </p>
     *
     * @param parentNode
     *            Consolidation Hierarchy Parent Node
     */
    public void setParentNode( @Nullable final String parentNode )
    {
        rememberChangedField("ParentNode", this.parentNode);
        this.parentNode = parentNode;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Validity Start Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @param functionalArea
     *            Consolidation Functional Area
     */
    public void setFunctionalArea( @Nullable final String functionalArea )
    {
        rememberChangedField("FunctionalArea", this.functionalArea);
        this.functionalArea = functionalArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea_Text</b>
     * </p>
     *
     * @param functionalArea_Text
     *            Functional Area Description
     */
    public void setFunctionalArea_Text( @Nullable final String functionalArea_Text )
    {
        rememberChangedField("FunctionalArea_Text", this.functionalArea_Text);
        this.functionalArea_Text = functionalArea_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 56
     * <p>
     * Original property name from the Odata EDM: <b>SequenceNumber</b>
     * </p>
     *
     * @param sequenceNumber
     *            The sequenceNumber to set.
     */
    public void setSequenceNumber( @Nullable final String sequenceNumber )
    {
        rememberChangedField("SequenceNumber", this.sequenceNumber);
        this.sequenceNumber = sequenceNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeSequence</b>
     * </p>
     *
     * @param hierarchyNodeSequence
     *            Consolidation Hierarchy Sequence Number
     */
    public void setHierarchyNodeSequence( @Nullable final String hierarchyNodeSequence )
    {
        rememberChangedField("HierarchyNodeSequence", this.hierarchyNodeSequence);
        this.hierarchyNodeSequence = hierarchyNodeSequence;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeLevel</b>
     * </p>
     *
     * @param hierarchyNodeLevel
     *            Consolidation Hierarchy Level
     */
    public void setHierarchyNodeLevel( @Nullable final String hierarchyNodeLevel )
    {
        rememberChangedField("HierarchyNodeLevel", this.hierarchyNodeLevel);
        this.hierarchyNodeLevel = hierarchyNodeLevel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @param nodeType
     *            Consolidation Hierarchy Node Type
     */
    public void setNodeType( @Nullable final String nodeType )
    {
        rememberChangedField("NodeType", this.nodeType);
        this.nodeType = nodeType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "FunctionalAreaHier";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("AdditionalMasterDataHierarchy", getAdditionalMasterDataHierarchy());
        result.put("HierarchyNode", getHierarchyNode());
        result.put("ValidityEndDate", getValidityEndDate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("AdditionalMasterDataHierarchy", getAdditionalMasterDataHierarchy());
        values.put("HierarchyNode", getHierarchyNode());
        values.put("HierarchyNode_Text", getHierarchyNode_Text());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ParentNode", getParentNode());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("FunctionalArea", getFunctionalArea());
        values.put("FunctionalArea_Text", getFunctionalArea_Text());
        values.put("SequenceNumber", getSequenceNumber());
        values.put("HierarchyNodeSequence", getHierarchyNodeSequence());
        values.put("HierarchyNodeLevel", getHierarchyNodeLevel());
        values.put("NodeType", getNodeType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("AdditionalMasterDataHierarchy") ) {
                final Object value = values.remove("AdditionalMasterDataHierarchy");
                if( (value == null) || (!value.equals(getAdditionalMasterDataHierarchy())) ) {
                    setAdditionalMasterDataHierarchy(((String) value));
                }
            }
            if( values.containsKey("HierarchyNode") ) {
                final Object value = values.remove("HierarchyNode");
                if( (value == null) || (!value.equals(getHierarchyNode())) ) {
                    setHierarchyNode(((String) value));
                }
            }
            if( values.containsKey("HierarchyNode_Text") ) {
                final Object value = values.remove("HierarchyNode_Text");
                if( (value == null) || (!value.equals(getHierarchyNode_Text())) ) {
                    setHierarchyNode_Text(((String) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ParentNode") ) {
                final Object value = values.remove("ParentNode");
                if( (value == null) || (!value.equals(getParentNode())) ) {
                    setParentNode(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("FunctionalArea") ) {
                final Object value = values.remove("FunctionalArea");
                if( (value == null) || (!value.equals(getFunctionalArea())) ) {
                    setFunctionalArea(((String) value));
                }
            }
            if( values.containsKey("FunctionalArea_Text") ) {
                final Object value = values.remove("FunctionalArea_Text");
                if( (value == null) || (!value.equals(getFunctionalArea_Text())) ) {
                    setFunctionalArea_Text(((String) value));
                }
            }
            if( values.containsKey("SequenceNumber") ) {
                final Object value = values.remove("SequenceNumber");
                if( (value == null) || (!value.equals(getSequenceNumber())) ) {
                    setSequenceNumber(((String) value));
                }
            }
            if( values.containsKey("HierarchyNodeSequence") ) {
                final Object value = values.remove("HierarchyNodeSequence");
                if( (value == null) || (!value.equals(getHierarchyNodeSequence())) ) {
                    setHierarchyNodeSequence(((String) value));
                }
            }
            if( values.containsKey("HierarchyNodeLevel") ) {
                final Object value = values.remove("HierarchyNodeLevel");
                if( (value == null) || (!value.equals(getHierarchyNodeLevel())) ) {
                    setHierarchyNodeLevel(((String) value));
                }
            }
            if( values.containsKey("NodeType") ) {
                final Object value = values.remove("NodeType");
                if( (value == null) || (!value.equals(getNodeType())) ) {
                    setNodeType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnFuncnlAreaHierT") ) {
                final Object value = (values).remove("to_CnsldtnFuncnlAreaHierT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnFuncnlAreaHierT == null ) {
                        toCnsldtnFuncnlAreaHierT = Lists.newArrayList();
                    } else {
                        toCnsldtnFuncnlAreaHierT = Lists.newArrayList(toCnsldtnFuncnlAreaHierT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        FunctionalAreaHierText entity;
                        if( toCnsldtnFuncnlAreaHierT.size() > i ) {
                            entity = toCnsldtnFuncnlAreaHierT.get(i);
                        } else {
                            entity = new FunctionalAreaHierText();
                            toCnsldtnFuncnlAreaHierT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CnsldtnFunctionalArea") ) {
                final Object value = (values).remove("to_CnsldtnFunctionalArea");
                if( value instanceof Map ) {
                    if( toCnsldtnFunctionalArea == null ) {
                        toCnsldtnFunctionalArea = new FunctionalArea();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnFunctionalArea.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> FunctionalAreaHierField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new FunctionalAreaHierField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FunctionalAreaHierField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FunctionalAreaHierField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnFuncnlAreaHierT != null ) {
            (values).put("to_CnsldtnFuncnlAreaHierT", toCnsldtnFuncnlAreaHierT);
        }
        if( toCnsldtnFunctionalArea != null ) {
            (values).put("to_CnsldtnFunctionalArea", toCnsldtnFunctionalArea);
        }
        return values;
    }

    /**
     * Fetches the <b>FunctionalAreaHierText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CnsldtnFuncnlAreaHierT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>FunctionalAreaHierText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<FunctionalAreaHierText> fetchCnsldtnFuncnlAreaHierT()
    {
        return fetchFieldAsList("to_CnsldtnFuncnlAreaHierT", FunctionalAreaHierText.class);
    }

    /**
     * Retrieval of associated <b>FunctionalAreaHierText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnFuncnlAreaHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFuncnlAreaHierT</b> of a queried <b>FunctionalAreaHier</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>FunctionalAreaHierText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<FunctionalAreaHierText> getCnsldtnFuncnlAreaHierTOrFetch()
    {
        if( toCnsldtnFuncnlAreaHierT == null ) {
            toCnsldtnFuncnlAreaHierT = fetchCnsldtnFuncnlAreaHierT();
        }
        return toCnsldtnFuncnlAreaHierT;
    }

    /**
     * Retrieval of associated <b>FunctionalAreaHierText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnFuncnlAreaHierT</b>.
     * <p>
     * If the navigation property for an entity <b>FunctionalAreaHier</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnFuncnlAreaHierT</b> is already loaded, the result
     *         will contain the <b>FunctionalAreaHierText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<FunctionalAreaHierText>> getCnsldtnFuncnlAreaHierTIfPresent()
    {
        return Option.of(toCnsldtnFuncnlAreaHierT);
    }

    /**
     * Overwrites the list of associated <b>FunctionalAreaHierText</b> entities for the loaded navigation property
     * <b>to_CnsldtnFuncnlAreaHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFuncnlAreaHierT</b> of a queried <b>FunctionalAreaHier</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>FunctionalAreaHierText</b> entities.
     */
    public void setCnsldtnFuncnlAreaHierT( @Nonnull final List<FunctionalAreaHierText> value )
    {
        if( toCnsldtnFuncnlAreaHierT == null ) {
            toCnsldtnFuncnlAreaHierT = Lists.newArrayList();
        }
        toCnsldtnFuncnlAreaHierT.clear();
        toCnsldtnFuncnlAreaHierT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>FunctionalAreaHierText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnFuncnlAreaHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFuncnlAreaHierT</b> of a queried <b>FunctionalAreaHier</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>FunctionalAreaHierText</b> entities.
     */
    public void addCnsldtnFuncnlAreaHierT( FunctionalAreaHierText... entity )
    {
        if( toCnsldtnFuncnlAreaHierT == null ) {
            toCnsldtnFuncnlAreaHierT = Lists.newArrayList();
        }
        toCnsldtnFuncnlAreaHierT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>FunctionalArea</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnFunctionalArea</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>FunctionalArea</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public FunctionalArea fetchCnsldtnFunctionalArea()
    {
        return fetchFieldAsSingle("to_CnsldtnFunctionalArea", FunctionalArea.class);
    }

    /**
     * Retrieval of associated <b>FunctionalArea</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnFunctionalArea</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnFunctionalArea</b> of a queried <b>FunctionalAreaHier</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>FunctionalArea</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public FunctionalArea getCnsldtnFunctionalAreaOrFetch()
    {
        if( toCnsldtnFunctionalArea == null ) {
            toCnsldtnFunctionalArea = fetchCnsldtnFunctionalArea();
        }
        return toCnsldtnFunctionalArea;
    }

    /**
     * Retrieval of associated <b>FunctionalArea</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnFunctionalArea</b>.
     * <p>
     * If the navigation property for an entity <b>FunctionalAreaHier</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnFunctionalArea</b> is already loaded, the result
     *         will contain the <b>FunctionalArea</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<FunctionalArea> getCnsldtnFunctionalAreaIfPresent()
    {
        return Option.of(toCnsldtnFunctionalArea);
    }

    /**
     * Overwrites the associated <b>FunctionalArea</b> entity for the loaded navigation property
     * <b>to_CnsldtnFunctionalArea</b>.
     *
     * @param value
     *            New <b>FunctionalArea</b> entity.
     */
    public void setCnsldtnFunctionalArea( final FunctionalArea value )
    {
        toCnsldtnFunctionalArea = value;
    }

    /**
     * Helper class to allow for fluent creation of FunctionalAreaHier instances.
     *
     */
    public final static class FunctionalAreaHierBuilder
    {

        private List<FunctionalAreaHierText> toCnsldtnFuncnlAreaHierT = Lists.newArrayList();
        private FunctionalArea toCnsldtnFunctionalArea;

        private FunctionalAreaHier.FunctionalAreaHierBuilder toCnsldtnFuncnlAreaHierT(
            final List<FunctionalAreaHierText> value )
        {
            toCnsldtnFuncnlAreaHierT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnFuncnlAreaHierT</b> for <b>FunctionalAreaHier</b> to multiple
         * <b>FunctionalAreaHierText</b>.
         *
         * @param value
         *            The FunctionalAreaHierTexts to build this FunctionalAreaHier with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FunctionalAreaHier.FunctionalAreaHierBuilder cnsldtnFuncnlAreaHierT( FunctionalAreaHierText... value )
        {
            return toCnsldtnFuncnlAreaHierT(Lists.newArrayList(value));
        }

        private FunctionalAreaHier.FunctionalAreaHierBuilder toCnsldtnFunctionalArea( final FunctionalArea value )
        {
            toCnsldtnFunctionalArea = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnFunctionalArea</b> for <b>FunctionalAreaHier</b> to single
         * <b>FunctionalArea</b>.
         *
         * @param value
         *            The FunctionalArea to build this FunctionalAreaHier with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FunctionalAreaHier.FunctionalAreaHierBuilder cnsldtnFunctionalArea( final FunctionalArea value )
        {
            return toCnsldtnFunctionalArea(value);
        }

    }

}
