/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.GLAccountField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.GLAccountLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.GLAccountSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined G/L Account
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>GLAccountType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class GLAccount extends VdmEntity<GLAccount>
{

    /**
     * Selector for all available fields of GLAccount.
     *
     */
    public final static GLAccountSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @return G/L Account Number
     */
    @Key
    @SerializedName( "GLAccount" )
    @JsonProperty( "GLAccount" )
    @Nullable
    @ODataField( odataName = "GLAccount" )
    private String gLAccount;
    /**
     * Use with available fluent helpers to apply the <b>GLAccount</b> field to query operations.
     *
     */
    public final static GLAccountField<String> GL_ACCOUNT = new GLAccountField<String>("GLAccount");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount_Text</b>
     * </p>
     *
     * @return G/L Account Description
     */
    @SerializedName( "GLAccount_Text" )
    @JsonProperty( "GLAccount_Text" )
    @Nullable
    @ODataField( odataName = "GLAccount_Text" )
    private String gLAccount_Text;
    /**
     * Use with available fluent helpers to apply the <b>GLAccount_Text</b> field to query operations.
     *
     */
    public final static GLAccountField<String> GL_ACCOUNT_TEXT = new GLAccountField<String>("GLAccount_Text");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     *
     * @return Chart of Accounts
     */
    @Key
    @SerializedName( "ChartOfAccounts" )
    @JsonProperty( "ChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "ChartOfAccounts" )
    private String chartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>ChartOfAccounts</b> field to query operations.
     *
     */
    public final static GLAccountField<String> CHART_OF_ACCOUNTS = new GLAccountField<String>("ChartOfAccounts");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @return Master Data Source
     */
    @SerializedName( "AdditionalMasterDataSource" )
    @JsonProperty( "AdditionalMasterDataSource" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataSource" )
    private String additionalMasterDataSource;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataSource</b> field to query operations.
     *
     */
    public final static GLAccountField<String> ADDITIONAL_MASTER_DATA_SOURCE =
        new GLAccountField<String>("AdditionalMasterDataSource");
    /**
     * Navigation property <b>to_CnsldtnGLAccountHier</b> for <b>GLAccount</b> to multiple <b>GLAccountHier</b>.
     *
     */
    @SerializedName( "to_CnsldtnGLAccountHier" )
    @JsonProperty( "to_CnsldtnGLAccountHier" )
    @ODataField( odataName = "to_CnsldtnGLAccountHier" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<GLAccountHier> toCnsldtnGLAccountHier;
    /**
     * Navigation property <b>to_CnsldtnGLAccountT</b> for <b>GLAccount</b> to multiple <b>GLAccountText</b>.
     *
     */
    @SerializedName( "to_CnsldtnGLAccountT" )
    @JsonProperty( "to_CnsldtnGLAccountT" )
    @ODataField( odataName = "to_CnsldtnGLAccountT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<GLAccountText> toCnsldtnGLAccountT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnGLAccountHier</b> navigation property to query
     * operations.
     *
     */
    public final static GLAccountLink<GLAccountHier> TO_CNSLDTN_GL_ACCOUNT_HIER =
        new GLAccountLink<GLAccountHier>("to_CnsldtnGLAccountHier");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnGLAccountT</b> navigation property to query
     * operations.
     *
     */
    public final static GLAccountLink<GLAccountText> TO_CNSLDTN_GL_ACCOUNT_T =
        new GLAccountLink<GLAccountText>("to_CnsldtnGLAccountT");

    @Nonnull
    @Override
    public Class<GLAccount> getType()
    {
        return GLAccount.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @param gLAccount
     *            G/L Account Number
     */
    public void setGLAccount( @Nullable final String gLAccount )
    {
        rememberChangedField("GLAccount", this.gLAccount);
        this.gLAccount = gLAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount_Text</b>
     * </p>
     *
     * @param gLAccount_Text
     *            G/L Account Description
     */
    public void setGLAccount_Text( @Nullable final String gLAccount_Text )
    {
        rememberChangedField("GLAccount_Text", this.gLAccount_Text);
        this.gLAccount_Text = gLAccount_Text;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     *
     * @param chartOfAccounts
     *            Chart of Accounts
     */
    public void setChartOfAccounts( @Nullable final String chartOfAccounts )
    {
        rememberChangedField("ChartOfAccounts", this.chartOfAccounts);
        this.chartOfAccounts = chartOfAccounts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @param additionalMasterDataSource
     *            Master Data Source
     */
    public void setAdditionalMasterDataSource( @Nullable final String additionalMasterDataSource )
    {
        rememberChangedField("AdditionalMasterDataSource", this.additionalMasterDataSource);
        this.additionalMasterDataSource = additionalMasterDataSource;
    }

    @Override
    protected String getEntityCollection()
    {
        return "GLAccount";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("GLAccount", getGLAccount());
        result.put("ChartOfAccounts", getChartOfAccounts());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("GLAccount", getGLAccount());
        values.put("GLAccount_Text", getGLAccount_Text());
        values.put("ChartOfAccounts", getChartOfAccounts());
        values.put("AdditionalMasterDataSource", getAdditionalMasterDataSource());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("GLAccount") ) {
                final Object value = values.remove("GLAccount");
                if( (value == null) || (!value.equals(getGLAccount())) ) {
                    setGLAccount(((String) value));
                }
            }
            if( values.containsKey("GLAccount_Text") ) {
                final Object value = values.remove("GLAccount_Text");
                if( (value == null) || (!value.equals(getGLAccount_Text())) ) {
                    setGLAccount_Text(((String) value));
                }
            }
            if( values.containsKey("ChartOfAccounts") ) {
                final Object value = values.remove("ChartOfAccounts");
                if( (value == null) || (!value.equals(getChartOfAccounts())) ) {
                    setChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("AdditionalMasterDataSource") ) {
                final Object value = values.remove("AdditionalMasterDataSource");
                if( (value == null) || (!value.equals(getAdditionalMasterDataSource())) ) {
                    setAdditionalMasterDataSource(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnGLAccountHier") ) {
                final Object value = (values).remove("to_CnsldtnGLAccountHier");
                if( value instanceof Iterable ) {
                    if( toCnsldtnGLAccountHier == null ) {
                        toCnsldtnGLAccountHier = Lists.newArrayList();
                    } else {
                        toCnsldtnGLAccountHier = Lists.newArrayList(toCnsldtnGLAccountHier);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        GLAccountHier entity;
                        if( toCnsldtnGLAccountHier.size() > i ) {
                            entity = toCnsldtnGLAccountHier.get(i);
                        } else {
                            entity = new GLAccountHier();
                            toCnsldtnGLAccountHier.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CnsldtnGLAccountT") ) {
                final Object value = (values).remove("to_CnsldtnGLAccountT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnGLAccountT == null ) {
                        toCnsldtnGLAccountT = Lists.newArrayList();
                    } else {
                        toCnsldtnGLAccountT = Lists.newArrayList(toCnsldtnGLAccountT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        GLAccountText entity;
                        if( toCnsldtnGLAccountT.size() > i ) {
                            entity = toCnsldtnGLAccountT.get(i);
                        } else {
                            entity = new GLAccountText();
                            toCnsldtnGLAccountT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> GLAccountField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new GLAccountField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> GLAccountField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new GLAccountField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnGLAccountHier != null ) {
            (values).put("to_CnsldtnGLAccountHier", toCnsldtnGLAccountHier);
        }
        if( toCnsldtnGLAccountT != null ) {
            (values).put("to_CnsldtnGLAccountT", toCnsldtnGLAccountT);
        }
        return values;
    }

    /**
     * Fetches the <b>GLAccountHier</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnGLAccountHier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>GLAccountHier</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<GLAccountHier> fetchCnsldtnGLAccountHier()
    {
        return fetchFieldAsList("to_CnsldtnGLAccountHier", GLAccountHier.class);
    }

    /**
     * Retrieval of associated <b>GLAccountHier</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnGLAccountHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnGLAccountHier</b> of a queried <b>GLAccount</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>GLAccountHier</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<GLAccountHier> getCnsldtnGLAccountHierOrFetch()
    {
        if( toCnsldtnGLAccountHier == null ) {
            toCnsldtnGLAccountHier = fetchCnsldtnGLAccountHier();
        }
        return toCnsldtnGLAccountHier;
    }

    /**
     * Retrieval of associated <b>GLAccountHier</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnGLAccountHier</b>.
     * <p>
     * If the navigation property for an entity <b>GLAccount</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnGLAccountHier</b> is already loaded, the result
     *         will contain the <b>GLAccountHier</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<GLAccountHier>> getCnsldtnGLAccountHierIfPresent()
    {
        return Option.of(toCnsldtnGLAccountHier);
    }

    /**
     * Overwrites the list of associated <b>GLAccountHier</b> entities for the loaded navigation property
     * <b>to_CnsldtnGLAccountHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnGLAccountHier</b> of a queried <b>GLAccount</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>GLAccountHier</b> entities.
     */
    public void setCnsldtnGLAccountHier( @Nonnull final List<GLAccountHier> value )
    {
        if( toCnsldtnGLAccountHier == null ) {
            toCnsldtnGLAccountHier = Lists.newArrayList();
        }
        toCnsldtnGLAccountHier.clear();
        toCnsldtnGLAccountHier.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>GLAccountHier</b> entities. This corresponds to the OData navigation
     * property <b>to_CnsldtnGLAccountHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnGLAccountHier</b> of a queried <b>GLAccount</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>GLAccountHier</b> entities.
     */
    public void addCnsldtnGLAccountHier( GLAccountHier... entity )
    {
        if( toCnsldtnGLAccountHier == null ) {
            toCnsldtnGLAccountHier = Lists.newArrayList();
        }
        toCnsldtnGLAccountHier.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>GLAccountText</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnGLAccountT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>GLAccountText</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<GLAccountText> fetchCnsldtnGLAccountT()
    {
        return fetchFieldAsList("to_CnsldtnGLAccountT", GLAccountText.class);
    }

    /**
     * Retrieval of associated <b>GLAccountText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnGLAccountT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnGLAccountT</b> of a queried <b>GLAccount</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>GLAccountText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<GLAccountText> getCnsldtnGLAccountTOrFetch()
    {
        if( toCnsldtnGLAccountT == null ) {
            toCnsldtnGLAccountT = fetchCnsldtnGLAccountT();
        }
        return toCnsldtnGLAccountT;
    }

    /**
     * Retrieval of associated <b>GLAccountText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnGLAccountT</b>.
     * <p>
     * If the navigation property for an entity <b>GLAccount</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnGLAccountT</b> is already loaded, the result will
     *         contain the <b>GLAccountText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<GLAccountText>> getCnsldtnGLAccountTIfPresent()
    {
        return Option.of(toCnsldtnGLAccountT);
    }

    /**
     * Overwrites the list of associated <b>GLAccountText</b> entities for the loaded navigation property
     * <b>to_CnsldtnGLAccountT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnGLAccountT</b> of a queried <b>GLAccount</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>GLAccountText</b> entities.
     */
    public void setCnsldtnGLAccountT( @Nonnull final List<GLAccountText> value )
    {
        if( toCnsldtnGLAccountT == null ) {
            toCnsldtnGLAccountT = Lists.newArrayList();
        }
        toCnsldtnGLAccountT.clear();
        toCnsldtnGLAccountT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>GLAccountText</b> entities. This corresponds to the OData navigation
     * property <b>to_CnsldtnGLAccountT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnGLAccountT</b> of a queried <b>GLAccount</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>GLAccountText</b> entities.
     */
    public void addCnsldtnGLAccountT( GLAccountText... entity )
    {
        if( toCnsldtnGLAccountT == null ) {
            toCnsldtnGLAccountT = Lists.newArrayList();
        }
        toCnsldtnGLAccountT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of GLAccount instances.
     *
     */
    public final static class GLAccountBuilder
    {

        private List<GLAccountHier> toCnsldtnGLAccountHier = Lists.newArrayList();
        private List<GLAccountText> toCnsldtnGLAccountT = Lists.newArrayList();

        private GLAccount.GLAccountBuilder toCnsldtnGLAccountHier( final List<GLAccountHier> value )
        {
            toCnsldtnGLAccountHier.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnGLAccountHier</b> for <b>GLAccount</b> to multiple <b>GLAccountHier</b>.
         *
         * @param value
         *            The GLAccountHiers to build this GLAccount with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public GLAccount.GLAccountBuilder cnsldtnGLAccountHier( GLAccountHier... value )
        {
            return toCnsldtnGLAccountHier(Lists.newArrayList(value));
        }

        private GLAccount.GLAccountBuilder toCnsldtnGLAccountT( final List<GLAccountText> value )
        {
            toCnsldtnGLAccountT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnGLAccountT</b> for <b>GLAccount</b> to multiple <b>GLAccountText</b>.
         *
         * @param value
         *            The GLAccountTexts to build this GLAccount with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public GLAccount.GLAccountBuilder cnsldtnGLAccountT( GLAccountText... value )
        {
            return toCnsldtnGLAccountT(Lists.newArrayList(value));
        }

    }

}
