/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.GLAccountSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.GLAccount GLAccount} entity
 * using key fields. This fluent helper allows methods which modify the underlying query to be called before executing
 * the query itself.
 *
 */
public class GLAccountByKeyFluentHelper
    extends
    FluentHelperByKey<GLAccountByKeyFluentHelper, GLAccount, GLAccountSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.GLAccount GLAccount}
     * entity with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest}
     * method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code GLAccount}
     * @param gLAccount
     *            G/L Account Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code GLAccount}
     * @param chartOfAccounts
     *            Chart of Accounts
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     */
    public GLAccountByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String gLAccount,
        final String chartOfAccounts )
    {
        super(servicePath, entityCollection);
        this.key.put("GLAccount", gLAccount);
        this.key.put("ChartOfAccounts", chartOfAccounts);
    }

    @Override
    @Nonnull
    protected Class<GLAccount> getEntityClass()
    {
        return GLAccount.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
