/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.GLAccountTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.GLAccountTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.GLAccountTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined G/L Account - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>GLAccountTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class GLAccountText extends VdmEntity<GLAccountText>
{

    /**
     * Selector for all available fields of GLAccountText.
     *
     */
    public final static GLAccountTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static GLAccountTextField<String> LANGUAGE = new GLAccountTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @return G/L Account Number
     */
    @Key
    @SerializedName( "GLAccount" )
    @JsonProperty( "GLAccount" )
    @Nullable
    @ODataField( odataName = "GLAccount" )
    private String gLAccount;
    /**
     * Use with available fluent helpers to apply the <b>GLAccount</b> field to query operations.
     *
     */
    public final static GLAccountTextField<String> GL_ACCOUNT = new GLAccountTextField<String>("GLAccount");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     *
     * @return Chart of Accounts
     */
    @Key
    @SerializedName( "ChartOfAccounts" )
    @JsonProperty( "ChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "ChartOfAccounts" )
    private String chartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>ChartOfAccounts</b> field to query operations.
     *
     */
    public final static GLAccountTextField<String> CHART_OF_ACCOUNTS =
        new GLAccountTextField<String>("ChartOfAccounts");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountText</b>
     * </p>
     *
     * @return G/L Account Description
     */
    @SerializedName( "GLAccountText" )
    @JsonProperty( "GLAccountText" )
    @Nullable
    @ODataField( odataName = "GLAccountText" )
    private String gLAccountText;
    /**
     * Use with available fluent helpers to apply the <b>GLAccountText</b> field to query operations.
     *
     */
    public final static GLAccountTextField<String> GL_ACCOUNT_TEXT = new GLAccountTextField<String>("GLAccountText");
    /**
     * Navigation property <b>to_CnsldtnGLAccount</b> for <b>GLAccountText</b> to single <b>GLAccount</b>.
     *
     */
    @SerializedName( "to_CnsldtnGLAccount" )
    @JsonProperty( "to_CnsldtnGLAccount" )
    @ODataField( odataName = "to_CnsldtnGLAccount" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private GLAccount toCnsldtnGLAccount;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnGLAccount</b> navigation property to query
     * operations.
     *
     */
    public final static GLAccountTextOneToOneLink<GLAccount> TO_CNSLDTN_GL_ACCOUNT =
        new GLAccountTextOneToOneLink<GLAccount>("to_CnsldtnGLAccount");

    @Nonnull
    @Override
    public Class<GLAccountText> getType()
    {
        return GLAccountText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @param gLAccount
     *            G/L Account Number
     */
    public void setGLAccount( @Nullable final String gLAccount )
    {
        rememberChangedField("GLAccount", this.gLAccount);
        this.gLAccount = gLAccount;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     *
     * @param chartOfAccounts
     *            Chart of Accounts
     */
    public void setChartOfAccounts( @Nullable final String chartOfAccounts )
    {
        rememberChangedField("ChartOfAccounts", this.chartOfAccounts);
        this.chartOfAccounts = chartOfAccounts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountText</b>
     * </p>
     *
     * @param gLAccountText
     *            G/L Account Description
     */
    public void setGLAccountText( @Nullable final String gLAccountText )
    {
        rememberChangedField("GLAccountText", this.gLAccountText);
        this.gLAccountText = gLAccountText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "GLAccountText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("GLAccount", getGLAccount());
        result.put("ChartOfAccounts", getChartOfAccounts());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("GLAccount", getGLAccount());
        values.put("ChartOfAccounts", getChartOfAccounts());
        values.put("GLAccountText", getGLAccountText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("GLAccount") ) {
                final Object value = values.remove("GLAccount");
                if( (value == null) || (!value.equals(getGLAccount())) ) {
                    setGLAccount(((String) value));
                }
            }
            if( values.containsKey("ChartOfAccounts") ) {
                final Object value = values.remove("ChartOfAccounts");
                if( (value == null) || (!value.equals(getChartOfAccounts())) ) {
                    setChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("GLAccountText") ) {
                final Object value = values.remove("GLAccountText");
                if( (value == null) || (!value.equals(getGLAccountText())) ) {
                    setGLAccountText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnGLAccount") ) {
                final Object value = (values).remove("to_CnsldtnGLAccount");
                if( value instanceof Map ) {
                    if( toCnsldtnGLAccount == null ) {
                        toCnsldtnGLAccount = new GLAccount();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnGLAccount.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> GLAccountTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new GLAccountTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> GLAccountTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new GLAccountTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnGLAccount != null ) {
            (values).put("to_CnsldtnGLAccount", toCnsldtnGLAccount);
        }
        return values;
    }

    /**
     * Fetches the <b>GLAccount</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnGLAccount</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>GLAccount</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public GLAccount fetchCnsldtnGLAccount()
    {
        return fetchFieldAsSingle("to_CnsldtnGLAccount", GLAccount.class);
    }

    /**
     * Retrieval of associated <b>GLAccount</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_CnsldtnGLAccount</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnGLAccount</b> of a queried <b>GLAccountText</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>GLAccount</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public GLAccount getCnsldtnGLAccountOrFetch()
    {
        if( toCnsldtnGLAccount == null ) {
            toCnsldtnGLAccount = fetchCnsldtnGLAccount();
        }
        return toCnsldtnGLAccount;
    }

    /**
     * Retrieval of associated <b>GLAccount</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_CnsldtnGLAccount</b>.
     * <p>
     * If the navigation property for an entity <b>GLAccountText</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnGLAccount</b> is already loaded, the result will
     *         contain the <b>GLAccount</b> entity. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<GLAccount> getCnsldtnGLAccountIfPresent()
    {
        return Option.of(toCnsldtnGLAccount);
    }

    /**
     * Overwrites the associated <b>GLAccount</b> entity for the loaded navigation property <b>to_CnsldtnGLAccount</b>.
     *
     * @param value
     *            New <b>GLAccount</b> entity.
     */
    public void setCnsldtnGLAccount( final GLAccount value )
    {
        toCnsldtnGLAccount = value;
    }

    /**
     * Helper class to allow for fluent creation of GLAccountText instances.
     *
     */
    public final static class GLAccountTextBuilder
    {

        private GLAccount toCnsldtnGLAccount;

        private GLAccountText.GLAccountTextBuilder toCnsldtnGLAccount( final GLAccount value )
        {
            toCnsldtnGLAccount = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnGLAccount</b> for <b>GLAccountText</b> to single <b>GLAccount</b>.
         *
         * @param value
         *            The GLAccount to build this GLAccountText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public GLAccountText.GLAccountTextBuilder cnsldtnGLAccount( final GLAccount value )
        {
            return toCnsldtnGLAccount(value);
        }

    }

}
