/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.InvestmentActivityTypeTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.InvestmentActivityTypeTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.InvestmentActivityTypeTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Investment Activity Type Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>InvestmentActivityTypeTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class InvestmentActivityTypeText extends VdmEntity<InvestmentActivityTypeText>
{

    /**
     * Selector for all available fields of InvestmentActivityTypeText.
     *
     */
    public final static InvestmentActivityTypeTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static InvestmentActivityTypeTextField<String> LANGUAGE =
        new InvestmentActivityTypeTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InvestmentActivityType</b>
     * </p>
     *
     * @return Consolidation of Investments Activity
     */
    @Key
    @SerializedName( "InvestmentActivityType" )
    @JsonProperty( "InvestmentActivityType" )
    @Nullable
    @ODataField( odataName = "InvestmentActivityType" )
    private String investmentActivityType;
    /**
     * Use with available fluent helpers to apply the <b>InvestmentActivityType</b> field to query operations.
     *
     */
    public final static InvestmentActivityTypeTextField<String> INVESTMENT_ACTIVITY_TYPE =
        new InvestmentActivityTypeTextField<String>("InvestmentActivityType");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>InvestmentActivityTypeText</b>
     * </p>
     *
     * @return Cnsldtn of Investments Activity Description
     */
    @SerializedName( "InvestmentActivityTypeText" )
    @JsonProperty( "InvestmentActivityTypeText" )
    @Nullable
    @ODataField( odataName = "InvestmentActivityTypeText" )
    private String investmentActivityTypeText;
    /**
     * Use with available fluent helpers to apply the <b>InvestmentActivityTypeText</b> field to query operations.
     *
     */
    public final static InvestmentActivityTypeTextField<String> INVESTMENT_ACTIVITY_TYPE_TEXT =
        new InvestmentActivityTypeTextField<String>("InvestmentActivityTypeText");
    /**
     * Navigation property <b>to_CnsldtnInvmtActyType</b> for <b>InvestmentActivityTypeText</b> to single
     * <b>InvestmentActivityType</b>.
     *
     */
    @SerializedName( "to_CnsldtnInvmtActyType" )
    @JsonProperty( "to_CnsldtnInvmtActyType" )
    @ODataField( odataName = "to_CnsldtnInvmtActyType" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private InvestmentActivityType toCnsldtnInvmtActyType;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnInvmtActyType</b> navigation property to query
     * operations.
     *
     */
    public final static InvestmentActivityTypeTextOneToOneLink<InvestmentActivityType> TO_CNSLDTN_INVMT_ACTY_TYPE =
        new InvestmentActivityTypeTextOneToOneLink<InvestmentActivityType>("to_CnsldtnInvmtActyType");

    @Nonnull
    @Override
    public Class<InvestmentActivityTypeText> getType()
    {
        return InvestmentActivityTypeText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InvestmentActivityType</b>
     * </p>
     *
     * @param investmentActivityType
     *            Consolidation of Investments Activity
     */
    public void setInvestmentActivityType( @Nullable final String investmentActivityType )
    {
        rememberChangedField("InvestmentActivityType", this.investmentActivityType);
        this.investmentActivityType = investmentActivityType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>InvestmentActivityTypeText</b>
     * </p>
     *
     * @param investmentActivityTypeText
     *            Cnsldtn of Investments Activity Description
     */
    public void setInvestmentActivityTypeText( @Nullable final String investmentActivityTypeText )
    {
        rememberChangedField("InvestmentActivityTypeText", this.investmentActivityTypeText);
        this.investmentActivityTypeText = investmentActivityTypeText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "InvestmentActivityTypeText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("InvestmentActivityType", getInvestmentActivityType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("InvestmentActivityType", getInvestmentActivityType());
        values.put("InvestmentActivityTypeText", getInvestmentActivityTypeText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("InvestmentActivityType") ) {
                final Object value = values.remove("InvestmentActivityType");
                if( (value == null) || (!value.equals(getInvestmentActivityType())) ) {
                    setInvestmentActivityType(((String) value));
                }
            }
            if( values.containsKey("InvestmentActivityTypeText") ) {
                final Object value = values.remove("InvestmentActivityTypeText");
                if( (value == null) || (!value.equals(getInvestmentActivityTypeText())) ) {
                    setInvestmentActivityTypeText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnInvmtActyType") ) {
                final Object value = (values).remove("to_CnsldtnInvmtActyType");
                if( value instanceof Map ) {
                    if( toCnsldtnInvmtActyType == null ) {
                        toCnsldtnInvmtActyType = new InvestmentActivityType();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnInvmtActyType.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> InvestmentActivityTypeTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new InvestmentActivityTypeTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> InvestmentActivityTypeTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new InvestmentActivityTypeTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnInvmtActyType != null ) {
            (values).put("to_CnsldtnInvmtActyType", toCnsldtnInvmtActyType);
        }
        return values;
    }

    /**
     * Fetches the <b>InvestmentActivityType</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CnsldtnInvmtActyType</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>InvestmentActivityType</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public InvestmentActivityType fetchCnsldtnInvmtActyType()
    {
        return fetchFieldAsSingle("to_CnsldtnInvmtActyType", InvestmentActivityType.class);
    }

    /**
     * Retrieval of associated <b>InvestmentActivityType</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnInvmtActyType</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnInvmtActyType</b> of a queried <b>InvestmentActivityTypeText</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>InvestmentActivityType</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public InvestmentActivityType getCnsldtnInvmtActyTypeOrFetch()
    {
        if( toCnsldtnInvmtActyType == null ) {
            toCnsldtnInvmtActyType = fetchCnsldtnInvmtActyType();
        }
        return toCnsldtnInvmtActyType;
    }

    /**
     * Retrieval of associated <b>InvestmentActivityType</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnInvmtActyType</b>.
     * <p>
     * If the navigation property for an entity <b>InvestmentActivityTypeText</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnInvmtActyType</b> is already loaded, the result
     *         will contain the <b>InvestmentActivityType</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<InvestmentActivityType> getCnsldtnInvmtActyTypeIfPresent()
    {
        return Option.of(toCnsldtnInvmtActyType);
    }

    /**
     * Overwrites the associated <b>InvestmentActivityType</b> entity for the loaded navigation property
     * <b>to_CnsldtnInvmtActyType</b>.
     *
     * @param value
     *            New <b>InvestmentActivityType</b> entity.
     */
    public void setCnsldtnInvmtActyType( final InvestmentActivityType value )
    {
        toCnsldtnInvmtActyType = value;
    }

    /**
     * Helper class to allow for fluent creation of InvestmentActivityTypeText instances.
     *
     */
    public final static class InvestmentActivityTypeTextBuilder
    {

        private InvestmentActivityType toCnsldtnInvmtActyType;

        private InvestmentActivityTypeText.InvestmentActivityTypeTextBuilder toCnsldtnInvmtActyType(
            final InvestmentActivityType value )
        {
            toCnsldtnInvmtActyType = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnInvmtActyType</b> for <b>InvestmentActivityTypeText</b> to single
         * <b>InvestmentActivityType</b>.
         *
         * @param value
         *            The InvestmentActivityType to build this InvestmentActivityTypeText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public InvestmentActivityTypeText.InvestmentActivityTypeTextBuilder cnsldtnInvmtActyType(
            final InvestmentActivityType value )
        {
            return toCnsldtnInvmtActyType(value);
        }

    }

}
