/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.MaterialField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.MaterialLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.MaterialSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Material
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaterialType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class Material extends VdmEntity<Material>
{

    /**
     * Selector for all available fields of Material.
     *
     */
    public final static MaterialSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Consolidation Material
     */
    @Key
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static MaterialField<String> MATERIAL = new MaterialField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material_Text</b>
     * </p>
     *
     * @return Material Description
     */
    @SerializedName( "Material_Text" )
    @JsonProperty( "Material_Text" )
    @Nullable
    @ODataField( odataName = "Material_Text" )
    private String material_Text;
    /**
     * Use with available fluent helpers to apply the <b>Material_Text</b> field to query operations.
     *
     */
    public final static MaterialField<String> MATERIAL_TEXT = new MaterialField<String>("Material_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @return Consolidation Additional Master Data Source
     */
    @SerializedName( "AdditionalMasterDataSource" )
    @JsonProperty( "AdditionalMasterDataSource" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataSource" )
    private String additionalMasterDataSource;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataSource</b> field to query operations.
     *
     */
    public final static MaterialField<String> ADDITIONAL_MASTER_DATA_SOURCE =
        new MaterialField<String>("AdditionalMasterDataSource");
    /**
     * Navigation property <b>to_CnsldtnMaterialHier</b> for <b>Material</b> to multiple <b>MaterialHier</b>.
     *
     */
    @SerializedName( "to_CnsldtnMaterialHier" )
    @JsonProperty( "to_CnsldtnMaterialHier" )
    @ODataField( odataName = "to_CnsldtnMaterialHier" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaterialHier> toCnsldtnMaterialHier;
    /**
     * Navigation property <b>to_CnsldtnMaterialT</b> for <b>Material</b> to multiple <b>MaterialText</b>.
     *
     */
    @SerializedName( "to_CnsldtnMaterialT" )
    @JsonProperty( "to_CnsldtnMaterialT" )
    @ODataField( odataName = "to_CnsldtnMaterialT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaterialText> toCnsldtnMaterialT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnMaterialHier</b> navigation property to query
     * operations.
     *
     */
    public final static MaterialLink<MaterialHier> TO_CNSLDTN_MATERIAL_HIER =
        new MaterialLink<MaterialHier>("to_CnsldtnMaterialHier");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnMaterialT</b> navigation property to query
     * operations.
     *
     */
    public final static MaterialLink<MaterialText> TO_CNSLDTN_MATERIAL_T =
        new MaterialLink<MaterialText>("to_CnsldtnMaterialT");

    @Nonnull
    @Override
    public Class<Material> getType()
    {
        return Material.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Consolidation Material
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material_Text</b>
     * </p>
     *
     * @param material_Text
     *            Material Description
     */
    public void setMaterial_Text( @Nullable final String material_Text )
    {
        rememberChangedField("Material_Text", this.material_Text);
        this.material_Text = material_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @param additionalMasterDataSource
     *            Consolidation Additional Master Data Source
     */
    public void setAdditionalMasterDataSource( @Nullable final String additionalMasterDataSource )
    {
        rememberChangedField("AdditionalMasterDataSource", this.additionalMasterDataSource);
        this.additionalMasterDataSource = additionalMasterDataSource;
    }

    @Override
    protected String getEntityCollection()
    {
        return "Material";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Material", getMaterial());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Material", getMaterial());
        values.put("Material_Text", getMaterial_Text());
        values.put("AdditionalMasterDataSource", getAdditionalMasterDataSource());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("Material_Text") ) {
                final Object value = values.remove("Material_Text");
                if( (value == null) || (!value.equals(getMaterial_Text())) ) {
                    setMaterial_Text(((String) value));
                }
            }
            if( values.containsKey("AdditionalMasterDataSource") ) {
                final Object value = values.remove("AdditionalMasterDataSource");
                if( (value == null) || (!value.equals(getAdditionalMasterDataSource())) ) {
                    setAdditionalMasterDataSource(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnMaterialHier") ) {
                final Object value = (values).remove("to_CnsldtnMaterialHier");
                if( value instanceof Iterable ) {
                    if( toCnsldtnMaterialHier == null ) {
                        toCnsldtnMaterialHier = Lists.newArrayList();
                    } else {
                        toCnsldtnMaterialHier = Lists.newArrayList(toCnsldtnMaterialHier);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaterialHier entity;
                        if( toCnsldtnMaterialHier.size() > i ) {
                            entity = toCnsldtnMaterialHier.get(i);
                        } else {
                            entity = new MaterialHier();
                            toCnsldtnMaterialHier.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CnsldtnMaterialT") ) {
                final Object value = (values).remove("to_CnsldtnMaterialT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnMaterialT == null ) {
                        toCnsldtnMaterialT = Lists.newArrayList();
                    } else {
                        toCnsldtnMaterialT = Lists.newArrayList(toCnsldtnMaterialT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaterialText entity;
                        if( toCnsldtnMaterialT.size() > i ) {
                            entity = toCnsldtnMaterialT.get(i);
                        } else {
                            entity = new MaterialText();
                            toCnsldtnMaterialT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> MaterialField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaterialField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaterialField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaterialField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnMaterialHier != null ) {
            (values).put("to_CnsldtnMaterialHier", toCnsldtnMaterialHier);
        }
        if( toCnsldtnMaterialT != null ) {
            (values).put("to_CnsldtnMaterialT", toCnsldtnMaterialT);
        }
        return values;
    }

    /**
     * Fetches the <b>MaterialHier</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnMaterialHier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaterialHier</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaterialHier> fetchCnsldtnMaterialHier()
    {
        return fetchFieldAsList("to_CnsldtnMaterialHier", MaterialHier.class);
    }

    /**
     * Retrieval of associated <b>MaterialHier</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnMaterialHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnMaterialHier</b> of a queried <b>Material</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaterialHier</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaterialHier> getCnsldtnMaterialHierOrFetch()
    {
        if( toCnsldtnMaterialHier == null ) {
            toCnsldtnMaterialHier = fetchCnsldtnMaterialHier();
        }
        return toCnsldtnMaterialHier;
    }

    /**
     * Retrieval of associated <b>MaterialHier</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnMaterialHier</b>.
     * <p>
     * If the navigation property for an entity <b>Material</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnMaterialHier</b> is already loaded, the result
     *         will contain the <b>MaterialHier</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaterialHier>> getCnsldtnMaterialHierIfPresent()
    {
        return Option.of(toCnsldtnMaterialHier);
    }

    /**
     * Overwrites the list of associated <b>MaterialHier</b> entities for the loaded navigation property
     * <b>to_CnsldtnMaterialHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnMaterialHier</b> of a queried <b>Material</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaterialHier</b> entities.
     */
    public void setCnsldtnMaterialHier( @Nonnull final List<MaterialHier> value )
    {
        if( toCnsldtnMaterialHier == null ) {
            toCnsldtnMaterialHier = Lists.newArrayList();
        }
        toCnsldtnMaterialHier.clear();
        toCnsldtnMaterialHier.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaterialHier</b> entities. This corresponds to the OData navigation
     * property <b>to_CnsldtnMaterialHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnMaterialHier</b> of a queried <b>Material</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaterialHier</b> entities.
     */
    public void addCnsldtnMaterialHier( MaterialHier... entity )
    {
        if( toCnsldtnMaterialHier == null ) {
            toCnsldtnMaterialHier = Lists.newArrayList();
        }
        toCnsldtnMaterialHier.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>MaterialText</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnMaterialT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaterialText</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaterialText> fetchCnsldtnMaterialT()
    {
        return fetchFieldAsList("to_CnsldtnMaterialT", MaterialText.class);
    }

    /**
     * Retrieval of associated <b>MaterialText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnMaterialT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnMaterialT</b> of a queried <b>Material</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaterialText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaterialText> getCnsldtnMaterialTOrFetch()
    {
        if( toCnsldtnMaterialT == null ) {
            toCnsldtnMaterialT = fetchCnsldtnMaterialT();
        }
        return toCnsldtnMaterialT;
    }

    /**
     * Retrieval of associated <b>MaterialText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnMaterialT</b>.
     * <p>
     * If the navigation property for an entity <b>Material</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnMaterialT</b> is already loaded, the result will
     *         contain the <b>MaterialText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaterialText>> getCnsldtnMaterialTIfPresent()
    {
        return Option.of(toCnsldtnMaterialT);
    }

    /**
     * Overwrites the list of associated <b>MaterialText</b> entities for the loaded navigation property
     * <b>to_CnsldtnMaterialT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnMaterialT</b> of a queried <b>Material</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaterialText</b> entities.
     */
    public void setCnsldtnMaterialT( @Nonnull final List<MaterialText> value )
    {
        if( toCnsldtnMaterialT == null ) {
            toCnsldtnMaterialT = Lists.newArrayList();
        }
        toCnsldtnMaterialT.clear();
        toCnsldtnMaterialT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaterialText</b> entities. This corresponds to the OData navigation
     * property <b>to_CnsldtnMaterialT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnMaterialT</b> of a queried <b>Material</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaterialText</b> entities.
     */
    public void addCnsldtnMaterialT( MaterialText... entity )
    {
        if( toCnsldtnMaterialT == null ) {
            toCnsldtnMaterialT = Lists.newArrayList();
        }
        toCnsldtnMaterialT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of Material instances.
     *
     */
    public final static class MaterialBuilder
    {

        private List<MaterialHier> toCnsldtnMaterialHier = Lists.newArrayList();
        private List<MaterialText> toCnsldtnMaterialT = Lists.newArrayList();

        private Material.MaterialBuilder toCnsldtnMaterialHier( final List<MaterialHier> value )
        {
            toCnsldtnMaterialHier.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnMaterialHier</b> for <b>Material</b> to multiple <b>MaterialHier</b>.
         *
         * @param value
         *            The MaterialHiers to build this Material with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Material.MaterialBuilder cnsldtnMaterialHier( MaterialHier... value )
        {
            return toCnsldtnMaterialHier(Lists.newArrayList(value));
        }

        private Material.MaterialBuilder toCnsldtnMaterialT( final List<MaterialText> value )
        {
            toCnsldtnMaterialT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnMaterialT</b> for <b>Material</b> to multiple <b>MaterialText</b>.
         *
         * @param value
         *            The MaterialTexts to build this Material with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Material.MaterialBuilder cnsldtnMaterialT( MaterialText... value )
        {
            return toCnsldtnMaterialT(Lists.newArrayList(value));
        }

    }

}
