/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.MaterialGroupField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.MaterialGroupLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.MaterialGroupSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Material Group
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaterialGroupType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaterialGroup extends VdmEntity<MaterialGroup>
{

    /**
     * Selector for all available fields of MaterialGroup.
     *
     */
    public final static MaterialGroupSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Product Group
     */
    @Key
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static MaterialGroupField<String> MATERIAL_GROUP = new MaterialGroupField<String>("MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup_Text</b>
     * </p>
     *
     * @return Material Group Description
     */
    @SerializedName( "MaterialGroup_Text" )
    @JsonProperty( "MaterialGroup_Text" )
    @Nullable
    @ODataField( odataName = "MaterialGroup_Text" )
    private String materialGroup_Text;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup_Text</b> field to query operations.
     *
     */
    public final static MaterialGroupField<String> MATERIAL_GROUP_TEXT =
        new MaterialGroupField<String>("MaterialGroup_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @return Master Data Source
     */
    @SerializedName( "AdditionalMasterDataSource" )
    @JsonProperty( "AdditionalMasterDataSource" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataSource" )
    private String additionalMasterDataSource;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataSource</b> field to query operations.
     *
     */
    public final static MaterialGroupField<String> ADDITIONAL_MASTER_DATA_SOURCE =
        new MaterialGroupField<String>("AdditionalMasterDataSource");
    /**
     * Navigation property <b>to_CnsldtnMaterialGroupHier</b> for <b>MaterialGroup</b> to multiple
     * <b>MaterialGroupHier</b>.
     *
     */
    @SerializedName( "to_CnsldtnMaterialGroupHier" )
    @JsonProperty( "to_CnsldtnMaterialGroupHier" )
    @ODataField( odataName = "to_CnsldtnMaterialGroupHier" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaterialGroupHier> toCnsldtnMaterialGroupHier;
    /**
     * Navigation property <b>to_CnsldtnMaterialGroupT</b> for <b>MaterialGroup</b> to multiple
     * <b>MaterialGroupText</b>.
     *
     */
    @SerializedName( "to_CnsldtnMaterialGroupT" )
    @JsonProperty( "to_CnsldtnMaterialGroupT" )
    @ODataField( odataName = "to_CnsldtnMaterialGroupT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaterialGroupText> toCnsldtnMaterialGroupT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnMaterialGroupHier</b> navigation property to query
     * operations.
     *
     */
    public final static MaterialGroupLink<MaterialGroupHier> TO_CNSLDTN_MATERIAL_GROUP_HIER =
        new MaterialGroupLink<MaterialGroupHier>("to_CnsldtnMaterialGroupHier");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnMaterialGroupT</b> navigation property to query
     * operations.
     *
     */
    public final static MaterialGroupLink<MaterialGroupText> TO_CNSLDTN_MATERIAL_GROUP_T =
        new MaterialGroupLink<MaterialGroupText>("to_CnsldtnMaterialGroupT");

    @Nonnull
    @Override
    public Class<MaterialGroup> getType()
    {
        return MaterialGroup.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Product Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup_Text</b>
     * </p>
     *
     * @param materialGroup_Text
     *            Material Group Description
     */
    public void setMaterialGroup_Text( @Nullable final String materialGroup_Text )
    {
        rememberChangedField("MaterialGroup_Text", this.materialGroup_Text);
        this.materialGroup_Text = materialGroup_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @param additionalMasterDataSource
     *            Master Data Source
     */
    public void setAdditionalMasterDataSource( @Nullable final String additionalMasterDataSource )
    {
        rememberChangedField("AdditionalMasterDataSource", this.additionalMasterDataSource);
        this.additionalMasterDataSource = additionalMasterDataSource;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaterialGroup";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MaterialGroup", getMaterialGroup());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MaterialGroup", getMaterialGroup());
        values.put("MaterialGroup_Text", getMaterialGroup_Text());
        values.put("AdditionalMasterDataSource", getAdditionalMasterDataSource());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("MaterialGroup_Text") ) {
                final Object value = values.remove("MaterialGroup_Text");
                if( (value == null) || (!value.equals(getMaterialGroup_Text())) ) {
                    setMaterialGroup_Text(((String) value));
                }
            }
            if( values.containsKey("AdditionalMasterDataSource") ) {
                final Object value = values.remove("AdditionalMasterDataSource");
                if( (value == null) || (!value.equals(getAdditionalMasterDataSource())) ) {
                    setAdditionalMasterDataSource(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnMaterialGroupHier") ) {
                final Object value = (values).remove("to_CnsldtnMaterialGroupHier");
                if( value instanceof Iterable ) {
                    if( toCnsldtnMaterialGroupHier == null ) {
                        toCnsldtnMaterialGroupHier = Lists.newArrayList();
                    } else {
                        toCnsldtnMaterialGroupHier = Lists.newArrayList(toCnsldtnMaterialGroupHier);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaterialGroupHier entity;
                        if( toCnsldtnMaterialGroupHier.size() > i ) {
                            entity = toCnsldtnMaterialGroupHier.get(i);
                        } else {
                            entity = new MaterialGroupHier();
                            toCnsldtnMaterialGroupHier.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CnsldtnMaterialGroupT") ) {
                final Object value = (values).remove("to_CnsldtnMaterialGroupT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnMaterialGroupT == null ) {
                        toCnsldtnMaterialGroupT = Lists.newArrayList();
                    } else {
                        toCnsldtnMaterialGroupT = Lists.newArrayList(toCnsldtnMaterialGroupT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaterialGroupText entity;
                        if( toCnsldtnMaterialGroupT.size() > i ) {
                            entity = toCnsldtnMaterialGroupT.get(i);
                        } else {
                            entity = new MaterialGroupText();
                            toCnsldtnMaterialGroupT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> MaterialGroupField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaterialGroupField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaterialGroupField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaterialGroupField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnMaterialGroupHier != null ) {
            (values).put("to_CnsldtnMaterialGroupHier", toCnsldtnMaterialGroupHier);
        }
        if( toCnsldtnMaterialGroupT != null ) {
            (values).put("to_CnsldtnMaterialGroupT", toCnsldtnMaterialGroupT);
        }
        return values;
    }

    /**
     * Fetches the <b>MaterialGroupHier</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnMaterialGroupHier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaterialGroupHier</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaterialGroupHier> fetchCnsldtnMaterialGroupHier()
    {
        return fetchFieldAsList("to_CnsldtnMaterialGroupHier", MaterialGroupHier.class);
    }

    /**
     * Retrieval of associated <b>MaterialGroupHier</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnMaterialGroupHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnMaterialGroupHier</b> of a queried <b>MaterialGroup</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaterialGroupHier</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaterialGroupHier> getCnsldtnMaterialGroupHierOrFetch()
    {
        if( toCnsldtnMaterialGroupHier == null ) {
            toCnsldtnMaterialGroupHier = fetchCnsldtnMaterialGroupHier();
        }
        return toCnsldtnMaterialGroupHier;
    }

    /**
     * Retrieval of associated <b>MaterialGroupHier</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnMaterialGroupHier</b>.
     * <p>
     * If the navigation property for an entity <b>MaterialGroup</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnMaterialGroupHier</b> is already loaded, the
     *         result will contain the <b>MaterialGroupHier</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaterialGroupHier>> getCnsldtnMaterialGroupHierIfPresent()
    {
        return Option.of(toCnsldtnMaterialGroupHier);
    }

    /**
     * Overwrites the list of associated <b>MaterialGroupHier</b> entities for the loaded navigation property
     * <b>to_CnsldtnMaterialGroupHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnMaterialGroupHier</b> of a queried <b>MaterialGroup</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaterialGroupHier</b> entities.
     */
    public void setCnsldtnMaterialGroupHier( @Nonnull final List<MaterialGroupHier> value )
    {
        if( toCnsldtnMaterialGroupHier == null ) {
            toCnsldtnMaterialGroupHier = Lists.newArrayList();
        }
        toCnsldtnMaterialGroupHier.clear();
        toCnsldtnMaterialGroupHier.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaterialGroupHier</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnMaterialGroupHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnMaterialGroupHier</b> of a queried <b>MaterialGroup</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaterialGroupHier</b> entities.
     */
    public void addCnsldtnMaterialGroupHier( MaterialGroupHier... entity )
    {
        if( toCnsldtnMaterialGroupHier == null ) {
            toCnsldtnMaterialGroupHier = Lists.newArrayList();
        }
        toCnsldtnMaterialGroupHier.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>MaterialGroupText</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnMaterialGroupT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaterialGroupText</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaterialGroupText> fetchCnsldtnMaterialGroupT()
    {
        return fetchFieldAsList("to_CnsldtnMaterialGroupT", MaterialGroupText.class);
    }

    /**
     * Retrieval of associated <b>MaterialGroupText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnMaterialGroupT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnMaterialGroupT</b> of a queried <b>MaterialGroup</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaterialGroupText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaterialGroupText> getCnsldtnMaterialGroupTOrFetch()
    {
        if( toCnsldtnMaterialGroupT == null ) {
            toCnsldtnMaterialGroupT = fetchCnsldtnMaterialGroupT();
        }
        return toCnsldtnMaterialGroupT;
    }

    /**
     * Retrieval of associated <b>MaterialGroupText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnMaterialGroupT</b>.
     * <p>
     * If the navigation property for an entity <b>MaterialGroup</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnMaterialGroupT</b> is already loaded, the result
     *         will contain the <b>MaterialGroupText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaterialGroupText>> getCnsldtnMaterialGroupTIfPresent()
    {
        return Option.of(toCnsldtnMaterialGroupT);
    }

    /**
     * Overwrites the list of associated <b>MaterialGroupText</b> entities for the loaded navigation property
     * <b>to_CnsldtnMaterialGroupT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnMaterialGroupT</b> of a queried <b>MaterialGroup</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaterialGroupText</b> entities.
     */
    public void setCnsldtnMaterialGroupT( @Nonnull final List<MaterialGroupText> value )
    {
        if( toCnsldtnMaterialGroupT == null ) {
            toCnsldtnMaterialGroupT = Lists.newArrayList();
        }
        toCnsldtnMaterialGroupT.clear();
        toCnsldtnMaterialGroupT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaterialGroupText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnMaterialGroupT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnMaterialGroupT</b> of a queried <b>MaterialGroup</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaterialGroupText</b> entities.
     */
    public void addCnsldtnMaterialGroupT( MaterialGroupText... entity )
    {
        if( toCnsldtnMaterialGroupT == null ) {
            toCnsldtnMaterialGroupT = Lists.newArrayList();
        }
        toCnsldtnMaterialGroupT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of MaterialGroup instances.
     *
     */
    public final static class MaterialGroupBuilder
    {

        private List<MaterialGroupHier> toCnsldtnMaterialGroupHier = Lists.newArrayList();
        private List<MaterialGroupText> toCnsldtnMaterialGroupT = Lists.newArrayList();

        private MaterialGroup.MaterialGroupBuilder toCnsldtnMaterialGroupHier( final List<MaterialGroupHier> value )
        {
            toCnsldtnMaterialGroupHier.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnMaterialGroupHier</b> for <b>MaterialGroup</b> to multiple
         * <b>MaterialGroupHier</b>.
         *
         * @param value
         *            The MaterialGroupHiers to build this MaterialGroup with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaterialGroup.MaterialGroupBuilder cnsldtnMaterialGroupHier( MaterialGroupHier... value )
        {
            return toCnsldtnMaterialGroupHier(Lists.newArrayList(value));
        }

        private MaterialGroup.MaterialGroupBuilder toCnsldtnMaterialGroupT( final List<MaterialGroupText> value )
        {
            toCnsldtnMaterialGroupT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnMaterialGroupT</b> for <b>MaterialGroup</b> to multiple
         * <b>MaterialGroupText</b>.
         *
         * @param value
         *            The MaterialGroupTexts to build this MaterialGroup with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaterialGroup.MaterialGroupBuilder cnsldtnMaterialGroupT( MaterialGroupText... value )
        {
            return toCnsldtnMaterialGroupT(Lists.newArrayList(value));
        }

    }

}
