/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.MaterialGroupHierField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.MaterialGroupHierLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.MaterialGroupHierOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.MaterialGroupHierSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Material Group Hierarchy
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaterialGroupHierType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaterialGroupHier extends VdmEntity<MaterialGroupHier>
{

    /**
     * Selector for all available fields of MaterialGroupHier.
     *
     */
    public final static MaterialGroupHierSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 42
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataHierarchy</b>
     * </p>
     *
     * @return Hierarchy ID
     */
    @Key
    @SerializedName( "AdditionalMasterDataHierarchy" )
    @JsonProperty( "AdditionalMasterDataHierarchy" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataHierarchy" )
    private String additionalMasterDataHierarchy;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataHierarchy</b> field to query operations.
     *
     */
    public final static MaterialGroupHierField<String> ADDITIONAL_MASTER_DATA_HIERARCHY =
        new MaterialGroupHierField<String>("AdditionalMasterDataHierarchy");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @return Hierarchy node
     */
    @Key
    @SerializedName( "HierarchyNode" )
    @JsonProperty( "HierarchyNode" )
    @Nullable
    @ODataField( odataName = "HierarchyNode" )
    private String hierarchyNode;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNode</b> field to query operations.
     *
     */
    public final static MaterialGroupHierField<String> HIERARCHY_NODE =
        new MaterialGroupHierField<String>("HierarchyNode");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode_Text</b>
     * </p>
     *
     * @return Hierarchy node description
     */
    @SerializedName( "HierarchyNode_Text" )
    @JsonProperty( "HierarchyNode_Text" )
    @Nullable
    @ODataField( odataName = "HierarchyNode_Text" )
    private String hierarchyNode_Text;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNode_Text</b> field to query operations.
     *
     */
    public final static MaterialGroupHierField<String> HIERARCHY_NODE_TEXT =
        new MaterialGroupHierField<String>("HierarchyNode_Text");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ParentNode</b>
     * </p>
     *
     * @return Hierarchy parent node
     */
    @SerializedName( "ParentNode" )
    @JsonProperty( "ParentNode" )
    @Nullable
    @ODataField( odataName = "ParentNode" )
    private String parentNode;
    /**
     * Use with available fluent helpers to apply the <b>ParentNode</b> field to query operations.
     *
     */
    public final static MaterialGroupHierField<String> PARENT_NODE = new MaterialGroupHierField<String>("ParentNode");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Material Group
     */
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static MaterialGroupHierField<String> MATERIAL_GROUP =
        new MaterialGroupHierField<String>("MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup_Text</b>
     * </p>
     *
     * @return Material Group Description
     */
    @SerializedName( "MaterialGroup_Text" )
    @JsonProperty( "MaterialGroup_Text" )
    @Nullable
    @ODataField( odataName = "MaterialGroup_Text" )
    private String materialGroup_Text;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup_Text</b> field to query operations.
     *
     */
    public final static MaterialGroupHierField<String> MATERIAL_GROUP_TEXT =
        new MaterialGroupHierField<String>("MaterialGroup_Text");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeSequence</b>
     * </p>
     *
     * @return Hierarchy Sequence Number
     */
    @SerializedName( "HierarchyNodeSequence" )
    @JsonProperty( "HierarchyNodeSequence" )
    @Nullable
    @ODataField( odataName = "HierarchyNodeSequence" )
    private String hierarchyNodeSequence;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNodeSequence</b> field to query operations.
     *
     */
    public final static MaterialGroupHierField<String> HIERARCHY_NODE_SEQUENCE =
        new MaterialGroupHierField<String>("HierarchyNodeSequence");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeLevel</b>
     * </p>
     *
     * @return Hierarchy Level
     */
    @SerializedName( "HierarchyNodeLevel" )
    @JsonProperty( "HierarchyNodeLevel" )
    @Nullable
    @ODataField( odataName = "HierarchyNodeLevel" )
    private String hierarchyNodeLevel;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNodeLevel</b> field to query operations.
     *
     */
    public final static MaterialGroupHierField<String> HIERARCHY_NODE_LEVEL =
        new MaterialGroupHierField<String>("HierarchyNodeLevel");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @return Hierarchy node type
     */
    @SerializedName( "NodeType" )
    @JsonProperty( "NodeType" )
    @Nullable
    @ODataField( odataName = "NodeType" )
    private String nodeType;
    /**
     * Use with available fluent helpers to apply the <b>NodeType</b> field to query operations.
     *
     */
    public final static MaterialGroupHierField<String> NODE_TYPE = new MaterialGroupHierField<String>("NodeType");
    /**
     * Navigation property <b>to_CnsldtnMaterialGroup</b> for <b>MaterialGroupHier</b> to single <b>MaterialGroup</b>.
     *
     */
    @SerializedName( "to_CnsldtnMaterialGroup" )
    @JsonProperty( "to_CnsldtnMaterialGroup" )
    @ODataField( odataName = "to_CnsldtnMaterialGroup" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaterialGroup toCnsldtnMaterialGroup;
    /**
     * Navigation property <b>to_CnsldtnMaterialGroupHierT</b> for <b>MaterialGroupHier</b> to multiple
     * <b>MaterialGroupHierText</b>.
     *
     */
    @SerializedName( "to_CnsldtnMaterialGroupHierT" )
    @JsonProperty( "to_CnsldtnMaterialGroupHierT" )
    @ODataField( odataName = "to_CnsldtnMaterialGroupHierT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaterialGroupHierText> toCnsldtnMaterialGroupHierT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnMaterialGroup</b> navigation property to query
     * operations.
     *
     */
    public final static MaterialGroupHierOneToOneLink<MaterialGroup> TO_CNSLDTN_MATERIAL_GROUP =
        new MaterialGroupHierOneToOneLink<MaterialGroup>("to_CnsldtnMaterialGroup");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnMaterialGroupHierT</b> navigation property to query
     * operations.
     *
     */
    public final static MaterialGroupHierLink<MaterialGroupHierText> TO_CNSLDTN_MATERIAL_GROUP_HIER_T =
        new MaterialGroupHierLink<MaterialGroupHierText>("to_CnsldtnMaterialGroupHierT");

    @Nonnull
    @Override
    public Class<MaterialGroupHier> getType()
    {
        return MaterialGroupHier.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 42
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataHierarchy</b>
     * </p>
     *
     * @param additionalMasterDataHierarchy
     *            Hierarchy ID
     */
    public void setAdditionalMasterDataHierarchy( @Nullable final String additionalMasterDataHierarchy )
    {
        rememberChangedField("AdditionalMasterDataHierarchy", this.additionalMasterDataHierarchy);
        this.additionalMasterDataHierarchy = additionalMasterDataHierarchy;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @param hierarchyNode
     *            Hierarchy node
     */
    public void setHierarchyNode( @Nullable final String hierarchyNode )
    {
        rememberChangedField("HierarchyNode", this.hierarchyNode);
        this.hierarchyNode = hierarchyNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode_Text</b>
     * </p>
     *
     * @param hierarchyNode_Text
     *            Hierarchy node description
     */
    public void setHierarchyNode_Text( @Nullable final String hierarchyNode_Text )
    {
        rememberChangedField("HierarchyNode_Text", this.hierarchyNode_Text);
        this.hierarchyNode_Text = hierarchyNode_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ParentNode</b>
     * </p>
     *
     * @param parentNode
     *            Hierarchy parent node
     */
    public void setParentNode( @Nullable final String parentNode )
    {
        rememberChangedField("ParentNode", this.parentNode);
        this.parentNode = parentNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Material Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup_Text</b>
     * </p>
     *
     * @param materialGroup_Text
     *            Material Group Description
     */
    public void setMaterialGroup_Text( @Nullable final String materialGroup_Text )
    {
        rememberChangedField("MaterialGroup_Text", this.materialGroup_Text);
        this.materialGroup_Text = materialGroup_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeSequence</b>
     * </p>
     *
     * @param hierarchyNodeSequence
     *            Hierarchy Sequence Number
     */
    public void setHierarchyNodeSequence( @Nullable final String hierarchyNodeSequence )
    {
        rememberChangedField("HierarchyNodeSequence", this.hierarchyNodeSequence);
        this.hierarchyNodeSequence = hierarchyNodeSequence;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeLevel</b>
     * </p>
     *
     * @param hierarchyNodeLevel
     *            Hierarchy Level
     */
    public void setHierarchyNodeLevel( @Nullable final String hierarchyNodeLevel )
    {
        rememberChangedField("HierarchyNodeLevel", this.hierarchyNodeLevel);
        this.hierarchyNodeLevel = hierarchyNodeLevel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @param nodeType
     *            Hierarchy node type
     */
    public void setNodeType( @Nullable final String nodeType )
    {
        rememberChangedField("NodeType", this.nodeType);
        this.nodeType = nodeType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaterialGroupHier";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("AdditionalMasterDataHierarchy", getAdditionalMasterDataHierarchy());
        result.put("HierarchyNode", getHierarchyNode());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("AdditionalMasterDataHierarchy", getAdditionalMasterDataHierarchy());
        values.put("HierarchyNode", getHierarchyNode());
        values.put("HierarchyNode_Text", getHierarchyNode_Text());
        values.put("ParentNode", getParentNode());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("MaterialGroup_Text", getMaterialGroup_Text());
        values.put("HierarchyNodeSequence", getHierarchyNodeSequence());
        values.put("HierarchyNodeLevel", getHierarchyNodeLevel());
        values.put("NodeType", getNodeType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("AdditionalMasterDataHierarchy") ) {
                final Object value = values.remove("AdditionalMasterDataHierarchy");
                if( (value == null) || (!value.equals(getAdditionalMasterDataHierarchy())) ) {
                    setAdditionalMasterDataHierarchy(((String) value));
                }
            }
            if( values.containsKey("HierarchyNode") ) {
                final Object value = values.remove("HierarchyNode");
                if( (value == null) || (!value.equals(getHierarchyNode())) ) {
                    setHierarchyNode(((String) value));
                }
            }
            if( values.containsKey("HierarchyNode_Text") ) {
                final Object value = values.remove("HierarchyNode_Text");
                if( (value == null) || (!value.equals(getHierarchyNode_Text())) ) {
                    setHierarchyNode_Text(((String) value));
                }
            }
            if( values.containsKey("ParentNode") ) {
                final Object value = values.remove("ParentNode");
                if( (value == null) || (!value.equals(getParentNode())) ) {
                    setParentNode(((String) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("MaterialGroup_Text") ) {
                final Object value = values.remove("MaterialGroup_Text");
                if( (value == null) || (!value.equals(getMaterialGroup_Text())) ) {
                    setMaterialGroup_Text(((String) value));
                }
            }
            if( values.containsKey("HierarchyNodeSequence") ) {
                final Object value = values.remove("HierarchyNodeSequence");
                if( (value == null) || (!value.equals(getHierarchyNodeSequence())) ) {
                    setHierarchyNodeSequence(((String) value));
                }
            }
            if( values.containsKey("HierarchyNodeLevel") ) {
                final Object value = values.remove("HierarchyNodeLevel");
                if( (value == null) || (!value.equals(getHierarchyNodeLevel())) ) {
                    setHierarchyNodeLevel(((String) value));
                }
            }
            if( values.containsKey("NodeType") ) {
                final Object value = values.remove("NodeType");
                if( (value == null) || (!value.equals(getNodeType())) ) {
                    setNodeType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnMaterialGroup") ) {
                final Object value = (values).remove("to_CnsldtnMaterialGroup");
                if( value instanceof Map ) {
                    if( toCnsldtnMaterialGroup == null ) {
                        toCnsldtnMaterialGroup = new MaterialGroup();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnMaterialGroup.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_CnsldtnMaterialGroupHierT") ) {
                final Object value = (values).remove("to_CnsldtnMaterialGroupHierT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnMaterialGroupHierT == null ) {
                        toCnsldtnMaterialGroupHierT = Lists.newArrayList();
                    } else {
                        toCnsldtnMaterialGroupHierT = Lists.newArrayList(toCnsldtnMaterialGroupHierT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaterialGroupHierText entity;
                        if( toCnsldtnMaterialGroupHierT.size() > i ) {
                            entity = toCnsldtnMaterialGroupHierT.get(i);
                        } else {
                            entity = new MaterialGroupHierText();
                            toCnsldtnMaterialGroupHierT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MaterialGroupHierField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaterialGroupHierField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaterialGroupHierField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaterialGroupHierField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnMaterialGroup != null ) {
            (values).put("to_CnsldtnMaterialGroup", toCnsldtnMaterialGroup);
        }
        if( toCnsldtnMaterialGroupHierT != null ) {
            (values).put("to_CnsldtnMaterialGroupHierT", toCnsldtnMaterialGroupHierT);
        }
        return values;
    }

    /**
     * Fetches the <b>MaterialGroup</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnMaterialGroup</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaterialGroup</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaterialGroup fetchCnsldtnMaterialGroup()
    {
        return fetchFieldAsSingle("to_CnsldtnMaterialGroup", MaterialGroup.class);
    }

    /**
     * Retrieval of associated <b>MaterialGroup</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnMaterialGroup</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnMaterialGroup</b> of a queried <b>MaterialGroupHier</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaterialGroup</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaterialGroup getCnsldtnMaterialGroupOrFetch()
    {
        if( toCnsldtnMaterialGroup == null ) {
            toCnsldtnMaterialGroup = fetchCnsldtnMaterialGroup();
        }
        return toCnsldtnMaterialGroup;
    }

    /**
     * Retrieval of associated <b>MaterialGroup</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnMaterialGroup</b>.
     * <p>
     * If the navigation property for an entity <b>MaterialGroupHier</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnMaterialGroup</b> is already loaded, the result
     *         will contain the <b>MaterialGroup</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaterialGroup> getCnsldtnMaterialGroupIfPresent()
    {
        return Option.of(toCnsldtnMaterialGroup);
    }

    /**
     * Overwrites the associated <b>MaterialGroup</b> entity for the loaded navigation property
     * <b>to_CnsldtnMaterialGroup</b>.
     *
     * @param value
     *            New <b>MaterialGroup</b> entity.
     */
    public void setCnsldtnMaterialGroup( final MaterialGroup value )
    {
        toCnsldtnMaterialGroup = value;
    }

    /**
     * Fetches the <b>MaterialGroupHierText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CnsldtnMaterialGroupHierT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaterialGroupHierText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaterialGroupHierText> fetchCnsldtnMaterialGroupHierT()
    {
        return fetchFieldAsList("to_CnsldtnMaterialGroupHierT", MaterialGroupHierText.class);
    }

    /**
     * Retrieval of associated <b>MaterialGroupHierText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnMaterialGroupHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnMaterialGroupHierT</b> of a queried <b>MaterialGroupHier</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaterialGroupHierText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaterialGroupHierText> getCnsldtnMaterialGroupHierTOrFetch()
    {
        if( toCnsldtnMaterialGroupHierT == null ) {
            toCnsldtnMaterialGroupHierT = fetchCnsldtnMaterialGroupHierT();
        }
        return toCnsldtnMaterialGroupHierT;
    }

    /**
     * Retrieval of associated <b>MaterialGroupHierText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnMaterialGroupHierT</b>.
     * <p>
     * If the navigation property for an entity <b>MaterialGroupHier</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnMaterialGroupHierT</b> is already loaded, the
     *         result will contain the <b>MaterialGroupHierText</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaterialGroupHierText>> getCnsldtnMaterialGroupHierTIfPresent()
    {
        return Option.of(toCnsldtnMaterialGroupHierT);
    }

    /**
     * Overwrites the list of associated <b>MaterialGroupHierText</b> entities for the loaded navigation property
     * <b>to_CnsldtnMaterialGroupHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnMaterialGroupHierT</b> of a queried <b>MaterialGroupHier</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaterialGroupHierText</b> entities.
     */
    public void setCnsldtnMaterialGroupHierT( @Nonnull final List<MaterialGroupHierText> value )
    {
        if( toCnsldtnMaterialGroupHierT == null ) {
            toCnsldtnMaterialGroupHierT = Lists.newArrayList();
        }
        toCnsldtnMaterialGroupHierT.clear();
        toCnsldtnMaterialGroupHierT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaterialGroupHierText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnMaterialGroupHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnMaterialGroupHierT</b> of a queried <b>MaterialGroupHier</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaterialGroupHierText</b> entities.
     */
    public void addCnsldtnMaterialGroupHierT( MaterialGroupHierText... entity )
    {
        if( toCnsldtnMaterialGroupHierT == null ) {
            toCnsldtnMaterialGroupHierT = Lists.newArrayList();
        }
        toCnsldtnMaterialGroupHierT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of MaterialGroupHier instances.
     *
     */
    public final static class MaterialGroupHierBuilder
    {

        private MaterialGroup toCnsldtnMaterialGroup;
        private List<MaterialGroupHierText> toCnsldtnMaterialGroupHierT = Lists.newArrayList();

        private MaterialGroupHier.MaterialGroupHierBuilder toCnsldtnMaterialGroup( final MaterialGroup value )
        {
            toCnsldtnMaterialGroup = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnMaterialGroup</b> for <b>MaterialGroupHier</b> to single
         * <b>MaterialGroup</b>.
         *
         * @param value
         *            The MaterialGroup to build this MaterialGroupHier with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaterialGroupHier.MaterialGroupHierBuilder cnsldtnMaterialGroup( final MaterialGroup value )
        {
            return toCnsldtnMaterialGroup(value);
        }

        private MaterialGroupHier.MaterialGroupHierBuilder toCnsldtnMaterialGroupHierT(
            final List<MaterialGroupHierText> value )
        {
            toCnsldtnMaterialGroupHierT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnMaterialGroupHierT</b> for <b>MaterialGroupHier</b> to multiple
         * <b>MaterialGroupHierText</b>.
         *
         * @param value
         *            The MaterialGroupHierTexts to build this MaterialGroupHier with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaterialGroupHier.MaterialGroupHierBuilder cnsldtnMaterialGroupHierT( MaterialGroupHierText... value )
        {
            return toCnsldtnMaterialGroupHierT(Lists.newArrayList(value));
        }

    }

}
