/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.MaterialGroupHierTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.MaterialGroupHierTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.MaterialGroupHierTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Material Group HierNode - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaterialGroupHierTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaterialGroupHierText extends VdmEntity<MaterialGroupHierText>
{

    /**
     * Selector for all available fields of MaterialGroupHierText.
     *
     */
    public final static MaterialGroupHierTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static MaterialGroupHierTextField<String> LANGUAGE =
        new MaterialGroupHierTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 42
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataHierarchy</b>
     * </p>
     *
     * @return Hierarchy ID
     */
    @Key
    @SerializedName( "AdditionalMasterDataHierarchy" )
    @JsonProperty( "AdditionalMasterDataHierarchy" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataHierarchy" )
    private String additionalMasterDataHierarchy;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataHierarchy</b> field to query operations.
     *
     */
    public final static MaterialGroupHierTextField<String> ADDITIONAL_MASTER_DATA_HIERARCHY =
        new MaterialGroupHierTextField<String>("AdditionalMasterDataHierarchy");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @return Hierarchy node
     */
    @Key
    @SerializedName( "HierarchyNode" )
    @JsonProperty( "HierarchyNode" )
    @Nullable
    @ODataField( odataName = "HierarchyNode" )
    private String hierarchyNode;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNode</b> field to query operations.
     *
     */
    public final static MaterialGroupHierTextField<String> HIERARCHY_NODE =
        new MaterialGroupHierTextField<String>("HierarchyNode");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeText</b>
     * </p>
     *
     * @return Hierarchy node description
     */
    @SerializedName( "HierarchyNodeText" )
    @JsonProperty( "HierarchyNodeText" )
    @Nullable
    @ODataField( odataName = "HierarchyNodeText" )
    private String hierarchyNodeText;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNodeText</b> field to query operations.
     *
     */
    public final static MaterialGroupHierTextField<String> HIERARCHY_NODE_TEXT =
        new MaterialGroupHierTextField<String>("HierarchyNodeText");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @return Hierarchy node type
     */
    @SerializedName( "NodeType" )
    @JsonProperty( "NodeType" )
    @Nullable
    @ODataField( odataName = "NodeType" )
    private String nodeType;
    /**
     * Use with available fluent helpers to apply the <b>NodeType</b> field to query operations.
     *
     */
    public final static MaterialGroupHierTextField<String> NODE_TYPE =
        new MaterialGroupHierTextField<String>("NodeType");
    /**
     * Navigation property <b>to_CnsldtnMaterialGroupHier</b> for <b>MaterialGroupHierText</b> to single
     * <b>MaterialGroupHier</b>.
     *
     */
    @SerializedName( "to_CnsldtnMaterialGroupHier" )
    @JsonProperty( "to_CnsldtnMaterialGroupHier" )
    @ODataField( odataName = "to_CnsldtnMaterialGroupHier" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaterialGroupHier toCnsldtnMaterialGroupHier;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnMaterialGroupHier</b> navigation property to query
     * operations.
     *
     */
    public final static MaterialGroupHierTextOneToOneLink<MaterialGroupHier> TO_CNSLDTN_MATERIAL_GROUP_HIER =
        new MaterialGroupHierTextOneToOneLink<MaterialGroupHier>("to_CnsldtnMaterialGroupHier");

    @Nonnull
    @Override
    public Class<MaterialGroupHierText> getType()
    {
        return MaterialGroupHierText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 42
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataHierarchy</b>
     * </p>
     *
     * @param additionalMasterDataHierarchy
     *            Hierarchy ID
     */
    public void setAdditionalMasterDataHierarchy( @Nullable final String additionalMasterDataHierarchy )
    {
        rememberChangedField("AdditionalMasterDataHierarchy", this.additionalMasterDataHierarchy);
        this.additionalMasterDataHierarchy = additionalMasterDataHierarchy;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @param hierarchyNode
     *            Hierarchy node
     */
    public void setHierarchyNode( @Nullable final String hierarchyNode )
    {
        rememberChangedField("HierarchyNode", this.hierarchyNode);
        this.hierarchyNode = hierarchyNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeText</b>
     * </p>
     *
     * @param hierarchyNodeText
     *            Hierarchy node description
     */
    public void setHierarchyNodeText( @Nullable final String hierarchyNodeText )
    {
        rememberChangedField("HierarchyNodeText", this.hierarchyNodeText);
        this.hierarchyNodeText = hierarchyNodeText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @param nodeType
     *            Hierarchy node type
     */
    public void setNodeType( @Nullable final String nodeType )
    {
        rememberChangedField("NodeType", this.nodeType);
        this.nodeType = nodeType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaterialGroupHierText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("AdditionalMasterDataHierarchy", getAdditionalMasterDataHierarchy());
        result.put("HierarchyNode", getHierarchyNode());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("AdditionalMasterDataHierarchy", getAdditionalMasterDataHierarchy());
        values.put("HierarchyNode", getHierarchyNode());
        values.put("HierarchyNodeText", getHierarchyNodeText());
        values.put("NodeType", getNodeType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("AdditionalMasterDataHierarchy") ) {
                final Object value = values.remove("AdditionalMasterDataHierarchy");
                if( (value == null) || (!value.equals(getAdditionalMasterDataHierarchy())) ) {
                    setAdditionalMasterDataHierarchy(((String) value));
                }
            }
            if( values.containsKey("HierarchyNode") ) {
                final Object value = values.remove("HierarchyNode");
                if( (value == null) || (!value.equals(getHierarchyNode())) ) {
                    setHierarchyNode(((String) value));
                }
            }
            if( values.containsKey("HierarchyNodeText") ) {
                final Object value = values.remove("HierarchyNodeText");
                if( (value == null) || (!value.equals(getHierarchyNodeText())) ) {
                    setHierarchyNodeText(((String) value));
                }
            }
            if( values.containsKey("NodeType") ) {
                final Object value = values.remove("NodeType");
                if( (value == null) || (!value.equals(getNodeType())) ) {
                    setNodeType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnMaterialGroupHier") ) {
                final Object value = (values).remove("to_CnsldtnMaterialGroupHier");
                if( value instanceof Map ) {
                    if( toCnsldtnMaterialGroupHier == null ) {
                        toCnsldtnMaterialGroupHier = new MaterialGroupHier();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnMaterialGroupHier.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MaterialGroupHierTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaterialGroupHierTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaterialGroupHierTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaterialGroupHierTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnMaterialGroupHier != null ) {
            (values).put("to_CnsldtnMaterialGroupHier", toCnsldtnMaterialGroupHier);
        }
        return values;
    }

    /**
     * Fetches the <b>MaterialGroupHier</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnMaterialGroupHier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaterialGroupHier</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaterialGroupHier fetchCnsldtnMaterialGroupHier()
    {
        return fetchFieldAsSingle("to_CnsldtnMaterialGroupHier", MaterialGroupHier.class);
    }

    /**
     * Retrieval of associated <b>MaterialGroupHier</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnMaterialGroupHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnMaterialGroupHier</b> of a queried <b>MaterialGroupHierText</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaterialGroupHier</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaterialGroupHier getCnsldtnMaterialGroupHierOrFetch()
    {
        if( toCnsldtnMaterialGroupHier == null ) {
            toCnsldtnMaterialGroupHier = fetchCnsldtnMaterialGroupHier();
        }
        return toCnsldtnMaterialGroupHier;
    }

    /**
     * Retrieval of associated <b>MaterialGroupHier</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnMaterialGroupHier</b>.
     * <p>
     * If the navigation property for an entity <b>MaterialGroupHierText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnMaterialGroupHier</b> is already loaded, the
     *         result will contain the <b>MaterialGroupHier</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaterialGroupHier> getCnsldtnMaterialGroupHierIfPresent()
    {
        return Option.of(toCnsldtnMaterialGroupHier);
    }

    /**
     * Overwrites the associated <b>MaterialGroupHier</b> entity for the loaded navigation property
     * <b>to_CnsldtnMaterialGroupHier</b>.
     *
     * @param value
     *            New <b>MaterialGroupHier</b> entity.
     */
    public void setCnsldtnMaterialGroupHier( final MaterialGroupHier value )
    {
        toCnsldtnMaterialGroupHier = value;
    }

    /**
     * Helper class to allow for fluent creation of MaterialGroupHierText instances.
     *
     */
    public final static class MaterialGroupHierTextBuilder
    {

        private MaterialGroupHier toCnsldtnMaterialGroupHier;

        private MaterialGroupHierText.MaterialGroupHierTextBuilder toCnsldtnMaterialGroupHier(
            final MaterialGroupHier value )
        {
            toCnsldtnMaterialGroupHier = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnMaterialGroupHier</b> for <b>MaterialGroupHierText</b> to single
         * <b>MaterialGroupHier</b>.
         *
         * @param value
         *            The MaterialGroupHier to build this MaterialGroupHierText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaterialGroupHierText.MaterialGroupHierTextBuilder cnsldtnMaterialGroupHier(
            final MaterialGroupHier value )
        {
            return toCnsldtnMaterialGroupHier(value);
        }

    }

}
