/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.MaterialGroupHierTextSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.MaterialGroupHierText
 * MaterialGroupHierText} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class MaterialGroupHierTextByKeyFluentHelper
    extends
    FluentHelperByKey<MaterialGroupHierTextByKeyFluentHelper, MaterialGroupHierText, MaterialGroupHierTextSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.MaterialGroupHierText
     * MaterialGroupHierText} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code MaterialGroupHierText}
     * @param servicePath
     *            Service path to be used to fetch a single {@code MaterialGroupHierText}
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param additionalMasterDataHierarchy
     *            Hierarchy ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 42
     *            </p>
     * @param hierarchyNode
     *            Hierarchy node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 50
     *            </p>
     */
    public MaterialGroupHierTextByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String language,
        final String additionalMasterDataHierarchy,
        final String hierarchyNode )
    {
        super(servicePath, entityCollection);
        this.key.put("Language", language);
        this.key.put("AdditionalMasterDataHierarchy", additionalMasterDataHierarchy);
        this.key.put("HierarchyNode", hierarchyNode);
    }

    @Override
    @Nonnull
    protected Class<MaterialGroupHierText> getEntityClass()
    {
        return MaterialGroupHierText.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
