/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.MaterialGroupTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.MaterialGroupTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.MaterialGroupTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Material Group - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaterialGroupTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaterialGroupText extends VdmEntity<MaterialGroupText>
{

    /**
     * Selector for all available fields of MaterialGroupText.
     *
     */
    public final static MaterialGroupTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static MaterialGroupTextField<String> LANGUAGE = new MaterialGroupTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Product Group
     */
    @Key
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static MaterialGroupTextField<String> MATERIAL_GROUP =
        new MaterialGroupTextField<String>("MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroupText</b>
     * </p>
     *
     * @return Material Group Description
     */
    @SerializedName( "MaterialGroupText" )
    @JsonProperty( "MaterialGroupText" )
    @Nullable
    @ODataField( odataName = "MaterialGroupText" )
    private String materialGroupText;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroupText</b> field to query operations.
     *
     */
    public final static MaterialGroupTextField<String> MATERIAL_GROUP_TEXT =
        new MaterialGroupTextField<String>("MaterialGroupText");
    /**
     * Navigation property <b>to_CnsldtnMaterialGroup</b> for <b>MaterialGroupText</b> to single <b>MaterialGroup</b>.
     *
     */
    @SerializedName( "to_CnsldtnMaterialGroup" )
    @JsonProperty( "to_CnsldtnMaterialGroup" )
    @ODataField( odataName = "to_CnsldtnMaterialGroup" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaterialGroup toCnsldtnMaterialGroup;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnMaterialGroup</b> navigation property to query
     * operations.
     *
     */
    public final static MaterialGroupTextOneToOneLink<MaterialGroup> TO_CNSLDTN_MATERIAL_GROUP =
        new MaterialGroupTextOneToOneLink<MaterialGroup>("to_CnsldtnMaterialGroup");

    @Nonnull
    @Override
    public Class<MaterialGroupText> getType()
    {
        return MaterialGroupText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Product Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroupText</b>
     * </p>
     *
     * @param materialGroupText
     *            Material Group Description
     */
    public void setMaterialGroupText( @Nullable final String materialGroupText )
    {
        rememberChangedField("MaterialGroupText", this.materialGroupText);
        this.materialGroupText = materialGroupText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaterialGroupText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("MaterialGroup", getMaterialGroup());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("MaterialGroupText", getMaterialGroupText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("MaterialGroupText") ) {
                final Object value = values.remove("MaterialGroupText");
                if( (value == null) || (!value.equals(getMaterialGroupText())) ) {
                    setMaterialGroupText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnMaterialGroup") ) {
                final Object value = (values).remove("to_CnsldtnMaterialGroup");
                if( value instanceof Map ) {
                    if( toCnsldtnMaterialGroup == null ) {
                        toCnsldtnMaterialGroup = new MaterialGroup();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnMaterialGroup.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MaterialGroupTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaterialGroupTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaterialGroupTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaterialGroupTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnMaterialGroup != null ) {
            (values).put("to_CnsldtnMaterialGroup", toCnsldtnMaterialGroup);
        }
        return values;
    }

    /**
     * Fetches the <b>MaterialGroup</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnMaterialGroup</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaterialGroup</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaterialGroup fetchCnsldtnMaterialGroup()
    {
        return fetchFieldAsSingle("to_CnsldtnMaterialGroup", MaterialGroup.class);
    }

    /**
     * Retrieval of associated <b>MaterialGroup</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnMaterialGroup</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnMaterialGroup</b> of a queried <b>MaterialGroupText</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaterialGroup</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaterialGroup getCnsldtnMaterialGroupOrFetch()
    {
        if( toCnsldtnMaterialGroup == null ) {
            toCnsldtnMaterialGroup = fetchCnsldtnMaterialGroup();
        }
        return toCnsldtnMaterialGroup;
    }

    /**
     * Retrieval of associated <b>MaterialGroup</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnMaterialGroup</b>.
     * <p>
     * If the navigation property for an entity <b>MaterialGroupText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnMaterialGroup</b> is already loaded, the result
     *         will contain the <b>MaterialGroup</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaterialGroup> getCnsldtnMaterialGroupIfPresent()
    {
        return Option.of(toCnsldtnMaterialGroup);
    }

    /**
     * Overwrites the associated <b>MaterialGroup</b> entity for the loaded navigation property
     * <b>to_CnsldtnMaterialGroup</b>.
     *
     * @param value
     *            New <b>MaterialGroup</b> entity.
     */
    public void setCnsldtnMaterialGroup( final MaterialGroup value )
    {
        toCnsldtnMaterialGroup = value;
    }

    /**
     * Helper class to allow for fluent creation of MaterialGroupText instances.
     *
     */
    public final static class MaterialGroupTextBuilder
    {

        private MaterialGroup toCnsldtnMaterialGroup;

        private MaterialGroupText.MaterialGroupTextBuilder toCnsldtnMaterialGroup( final MaterialGroup value )
        {
            toCnsldtnMaterialGroup = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnMaterialGroup</b> for <b>MaterialGroupText</b> to single
         * <b>MaterialGroup</b>.
         *
         * @param value
         *            The MaterialGroup to build this MaterialGroupText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaterialGroupText.MaterialGroupTextBuilder cnsldtnMaterialGroup( final MaterialGroup value )
        {
            return toCnsldtnMaterialGroup(value);
        }

    }

}
