/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.OrderIDField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.OrderIDLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.OrderIDSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Internal Order
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>OrderIDType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class OrderID extends VdmEntity<OrderID>
{

    /**
     * Selector for all available fields of OrderID.
     *
     */
    public final static OrderIDSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InternalOrder</b>
     * </p>
     *
     * @return Internal Order
     */
    @Key
    @SerializedName( "InternalOrder" )
    @JsonProperty( "InternalOrder" )
    @Nullable
    @ODataField( odataName = "InternalOrder" )
    private String internalOrder;
    /**
     * Use with available fluent helpers to apply the <b>InternalOrder</b> field to query operations.
     *
     */
    public final static OrderIDField<String> INTERNAL_ORDER = new OrderIDField<String>("InternalOrder");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InternalOrder_Text</b>
     * </p>
     *
     * @return Order ID Description
     */
    @SerializedName( "InternalOrder_Text" )
    @JsonProperty( "InternalOrder_Text" )
    @Nullable
    @ODataField( odataName = "InternalOrder_Text" )
    private String internalOrder_Text;
    /**
     * Use with available fluent helpers to apply the <b>InternalOrder_Text</b> field to query operations.
     *
     */
    public final static OrderIDField<String> INTERNAL_ORDER_TEXT = new OrderIDField<String>("InternalOrder_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @return Consolidation Additional Master Data Source
     */
    @SerializedName( "AdditionalMasterDataSource" )
    @JsonProperty( "AdditionalMasterDataSource" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataSource" )
    private String additionalMasterDataSource;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataSource</b> field to query operations.
     *
     */
    public final static OrderIDField<String> ADDITIONAL_MASTER_DATA_SOURCE =
        new OrderIDField<String>("AdditionalMasterDataSource");
    /**
     * Navigation property <b>to_CnsldtnInternalOrderT</b> for <b>OrderID</b> to multiple <b>OrderIDText</b>.
     *
     */
    @SerializedName( "to_CnsldtnInternalOrderT" )
    @JsonProperty( "to_CnsldtnInternalOrderT" )
    @ODataField( odataName = "to_CnsldtnInternalOrderT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<OrderIDText> toCnsldtnInternalOrderT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnInternalOrderT</b> navigation property to query
     * operations.
     *
     */
    public final static OrderIDLink<OrderIDText> TO_CNSLDTN_INTERNAL_ORDER_T =
        new OrderIDLink<OrderIDText>("to_CnsldtnInternalOrderT");

    @Nonnull
    @Override
    public Class<OrderID> getType()
    {
        return OrderID.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InternalOrder</b>
     * </p>
     *
     * @param internalOrder
     *            Internal Order
     */
    public void setInternalOrder( @Nullable final String internalOrder )
    {
        rememberChangedField("InternalOrder", this.internalOrder);
        this.internalOrder = internalOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InternalOrder_Text</b>
     * </p>
     *
     * @param internalOrder_Text
     *            Order ID Description
     */
    public void setInternalOrder_Text( @Nullable final String internalOrder_Text )
    {
        rememberChangedField("InternalOrder_Text", this.internalOrder_Text);
        this.internalOrder_Text = internalOrder_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @param additionalMasterDataSource
     *            Consolidation Additional Master Data Source
     */
    public void setAdditionalMasterDataSource( @Nullable final String additionalMasterDataSource )
    {
        rememberChangedField("AdditionalMasterDataSource", this.additionalMasterDataSource);
        this.additionalMasterDataSource = additionalMasterDataSource;
    }

    @Override
    protected String getEntityCollection()
    {
        return "OrderID";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("InternalOrder", getInternalOrder());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("InternalOrder", getInternalOrder());
        values.put("InternalOrder_Text", getInternalOrder_Text());
        values.put("AdditionalMasterDataSource", getAdditionalMasterDataSource());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InternalOrder") ) {
                final Object value = values.remove("InternalOrder");
                if( (value == null) || (!value.equals(getInternalOrder())) ) {
                    setInternalOrder(((String) value));
                }
            }
            if( values.containsKey("InternalOrder_Text") ) {
                final Object value = values.remove("InternalOrder_Text");
                if( (value == null) || (!value.equals(getInternalOrder_Text())) ) {
                    setInternalOrder_Text(((String) value));
                }
            }
            if( values.containsKey("AdditionalMasterDataSource") ) {
                final Object value = values.remove("AdditionalMasterDataSource");
                if( (value == null) || (!value.equals(getAdditionalMasterDataSource())) ) {
                    setAdditionalMasterDataSource(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnInternalOrderT") ) {
                final Object value = (values).remove("to_CnsldtnInternalOrderT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnInternalOrderT == null ) {
                        toCnsldtnInternalOrderT = Lists.newArrayList();
                    } else {
                        toCnsldtnInternalOrderT = Lists.newArrayList(toCnsldtnInternalOrderT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        OrderIDText entity;
                        if( toCnsldtnInternalOrderT.size() > i ) {
                            entity = toCnsldtnInternalOrderT.get(i);
                        } else {
                            entity = new OrderIDText();
                            toCnsldtnInternalOrderT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> OrderIDField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new OrderIDField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> OrderIDField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new OrderIDField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnInternalOrderT != null ) {
            (values).put("to_CnsldtnInternalOrderT", toCnsldtnInternalOrderT);
        }
        return values;
    }

    /**
     * Fetches the <b>OrderIDText</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnInternalOrderT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>OrderIDText</b> entities. If no entities are associated then an
     *         empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<OrderIDText> fetchCnsldtnInternalOrderT()
    {
        return fetchFieldAsList("to_CnsldtnInternalOrderT", OrderIDText.class);
    }

    /**
     * Retrieval of associated <b>OrderIDText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnInternalOrderT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnInternalOrderT</b> of a queried <b>OrderID</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>OrderIDText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<OrderIDText> getCnsldtnInternalOrderTOrFetch()
    {
        if( toCnsldtnInternalOrderT == null ) {
            toCnsldtnInternalOrderT = fetchCnsldtnInternalOrderT();
        }
        return toCnsldtnInternalOrderT;
    }

    /**
     * Retrieval of associated <b>OrderIDText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnInternalOrderT</b>.
     * <p>
     * If the navigation property for an entity <b>OrderID</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnInternalOrderT</b> is already loaded, the result
     *         will contain the <b>OrderIDText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<OrderIDText>> getCnsldtnInternalOrderTIfPresent()
    {
        return Option.of(toCnsldtnInternalOrderT);
    }

    /**
     * Overwrites the list of associated <b>OrderIDText</b> entities for the loaded navigation property
     * <b>to_CnsldtnInternalOrderT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnInternalOrderT</b> of a queried <b>OrderID</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>OrderIDText</b> entities.
     */
    public void setCnsldtnInternalOrderT( @Nonnull final List<OrderIDText> value )
    {
        if( toCnsldtnInternalOrderT == null ) {
            toCnsldtnInternalOrderT = Lists.newArrayList();
        }
        toCnsldtnInternalOrderT.clear();
        toCnsldtnInternalOrderT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>OrderIDText</b> entities. This corresponds to the OData navigation
     * property <b>to_CnsldtnInternalOrderT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnInternalOrderT</b> of a queried <b>OrderID</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>OrderIDText</b> entities.
     */
    public void addCnsldtnInternalOrderT( OrderIDText... entity )
    {
        if( toCnsldtnInternalOrderT == null ) {
            toCnsldtnInternalOrderT = Lists.newArrayList();
        }
        toCnsldtnInternalOrderT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of OrderID instances.
     *
     */
    public final static class OrderIDBuilder
    {

        private List<OrderIDText> toCnsldtnInternalOrderT = Lists.newArrayList();

        private OrderID.OrderIDBuilder toCnsldtnInternalOrderT( final List<OrderIDText> value )
        {
            toCnsldtnInternalOrderT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnInternalOrderT</b> for <b>OrderID</b> to multiple <b>OrderIDText</b>.
         *
         * @param value
         *            The OrderIDTexts to build this OrderID with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public OrderID.OrderIDBuilder cnsldtnInternalOrderT( OrderIDText... value )
        {
            return toCnsldtnInternalOrderT(Lists.newArrayList(value));
        }

    }

}
