/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.OrderIDTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.OrderIDTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.OrderIDTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Internal Order Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>OrderIDTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class OrderIDText extends VdmEntity<OrderIDText>
{

    /**
     * Selector for all available fields of OrderIDText.
     *
     */
    public final static OrderIDTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static OrderIDTextField<String> LANGUAGE = new OrderIDTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InternalOrder</b>
     * </p>
     *
     * @return Internal Order
     */
    @Key
    @SerializedName( "InternalOrder" )
    @JsonProperty( "InternalOrder" )
    @Nullable
    @ODataField( odataName = "InternalOrder" )
    private String internalOrder;
    /**
     * Use with available fluent helpers to apply the <b>InternalOrder</b> field to query operations.
     *
     */
    public final static OrderIDTextField<String> INTERNAL_ORDER = new OrderIDTextField<String>("InternalOrder");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnOrderIDText</b>
     * </p>
     *
     * @return Order ID Description
     */
    @SerializedName( "CnsldtnOrderIDText" )
    @JsonProperty( "CnsldtnOrderIDText" )
    @Nullable
    @ODataField( odataName = "CnsldtnOrderIDText" )
    private String cnsldtnOrderIDText;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnOrderIDText</b> field to query operations.
     *
     */
    public final static OrderIDTextField<String> CNSLDTN_ORDER_ID_TEXT =
        new OrderIDTextField<String>("CnsldtnOrderIDText");
    /**
     * Navigation property <b>to_CnsldtnInternalOrder</b> for <b>OrderIDText</b> to single <b>OrderID</b>.
     *
     */
    @SerializedName( "to_CnsldtnInternalOrder" )
    @JsonProperty( "to_CnsldtnInternalOrder" )
    @ODataField( odataName = "to_CnsldtnInternalOrder" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private OrderID toCnsldtnInternalOrder;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnInternalOrder</b> navigation property to query
     * operations.
     *
     */
    public final static OrderIDTextOneToOneLink<OrderID> TO_CNSLDTN_INTERNAL_ORDER =
        new OrderIDTextOneToOneLink<OrderID>("to_CnsldtnInternalOrder");

    @Nonnull
    @Override
    public Class<OrderIDText> getType()
    {
        return OrderIDText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InternalOrder</b>
     * </p>
     *
     * @param internalOrder
     *            Internal Order
     */
    public void setInternalOrder( @Nullable final String internalOrder )
    {
        rememberChangedField("InternalOrder", this.internalOrder);
        this.internalOrder = internalOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnOrderIDText</b>
     * </p>
     *
     * @param cnsldtnOrderIDText
     *            Order ID Description
     */
    public void setCnsldtnOrderIDText( @Nullable final String cnsldtnOrderIDText )
    {
        rememberChangedField("CnsldtnOrderIDText", this.cnsldtnOrderIDText);
        this.cnsldtnOrderIDText = cnsldtnOrderIDText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "OrderIDText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("InternalOrder", getInternalOrder());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("InternalOrder", getInternalOrder());
        values.put("CnsldtnOrderIDText", getCnsldtnOrderIDText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("InternalOrder") ) {
                final Object value = values.remove("InternalOrder");
                if( (value == null) || (!value.equals(getInternalOrder())) ) {
                    setInternalOrder(((String) value));
                }
            }
            if( values.containsKey("CnsldtnOrderIDText") ) {
                final Object value = values.remove("CnsldtnOrderIDText");
                if( (value == null) || (!value.equals(getCnsldtnOrderIDText())) ) {
                    setCnsldtnOrderIDText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnInternalOrder") ) {
                final Object value = (values).remove("to_CnsldtnInternalOrder");
                if( value instanceof Map ) {
                    if( toCnsldtnInternalOrder == null ) {
                        toCnsldtnInternalOrder = new OrderID();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnInternalOrder.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> OrderIDTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new OrderIDTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> OrderIDTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new OrderIDTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnInternalOrder != null ) {
            (values).put("to_CnsldtnInternalOrder", toCnsldtnInternalOrder);
        }
        return values;
    }

    /**
     * Fetches the <b>OrderID</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnInternalOrder</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>OrderID</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public OrderID fetchCnsldtnInternalOrder()
    {
        return fetchFieldAsSingle("to_CnsldtnInternalOrder", OrderID.class);
    }

    /**
     * Retrieval of associated <b>OrderID</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_CnsldtnInternalOrder</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnInternalOrder</b> of a queried <b>OrderIDText</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>OrderID</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public OrderID getCnsldtnInternalOrderOrFetch()
    {
        if( toCnsldtnInternalOrder == null ) {
            toCnsldtnInternalOrder = fetchCnsldtnInternalOrder();
        }
        return toCnsldtnInternalOrder;
    }

    /**
     * Retrieval of associated <b>OrderID</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_CnsldtnInternalOrder</b>.
     * <p>
     * If the navigation property for an entity <b>OrderIDText</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnInternalOrder</b> is already loaded, the result
     *         will contain the <b>OrderID</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<OrderID> getCnsldtnInternalOrderIfPresent()
    {
        return Option.of(toCnsldtnInternalOrder);
    }

    /**
     * Overwrites the associated <b>OrderID</b> entity for the loaded navigation property
     * <b>to_CnsldtnInternalOrder</b>.
     *
     * @param value
     *            New <b>OrderID</b> entity.
     */
    public void setCnsldtnInternalOrder( final OrderID value )
    {
        toCnsldtnInternalOrder = value;
    }

    /**
     * Helper class to allow for fluent creation of OrderIDText instances.
     *
     */
    public final static class OrderIDTextBuilder
    {

        private OrderID toCnsldtnInternalOrder;

        private OrderIDText.OrderIDTextBuilder toCnsldtnInternalOrder( final OrderID value )
        {
            toCnsldtnInternalOrder = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnInternalOrder</b> for <b>OrderIDText</b> to single <b>OrderID</b>.
         *
         * @param value
         *            The OrderID to build this OrderIDText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public OrderIDText.OrderIDTextBuilder cnsldtnInternalOrder( final OrderID value )
        {
            return toCnsldtnInternalOrder(value);
        }

    }

}
