/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.OrganizationDivisionField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.OrganizationDivisionLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.OrganizationDivisionSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Division
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>OrganizationDivisionType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class OrganizationDivision extends VdmEntity<OrganizationDivision>
{

    /**
     * Selector for all available fields of OrganizationDivision.
     *
     */
    public final static OrganizationDivisionSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @return Division
     */
    @Key
    @SerializedName( "Division" )
    @JsonProperty( "Division" )
    @Nullable
    @ODataField( odataName = "Division" )
    private String division;
    /**
     * Use with available fluent helpers to apply the <b>Division</b> field to query operations.
     *
     */
    public final static OrganizationDivisionField<String> DIVISION = new OrganizationDivisionField<String>("Division");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Division_Text</b>
     * </p>
     *
     * @return Division Description
     */
    @SerializedName( "Division_Text" )
    @JsonProperty( "Division_Text" )
    @Nullable
    @ODataField( odataName = "Division_Text" )
    private String division_Text;
    /**
     * Use with available fluent helpers to apply the <b>Division_Text</b> field to query operations.
     *
     */
    public final static OrganizationDivisionField<String> DIVISION_TEXT =
        new OrganizationDivisionField<String>("Division_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @return Consolidation Additional Master Data Source
     */
    @SerializedName( "AdditionalMasterDataSource" )
    @JsonProperty( "AdditionalMasterDataSource" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataSource" )
    private String additionalMasterDataSource;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataSource</b> field to query operations.
     *
     */
    public final static OrganizationDivisionField<String> ADDITIONAL_MASTER_DATA_SOURCE =
        new OrganizationDivisionField<String>("AdditionalMasterDataSource");
    /**
     * Navigation property <b>to_CnsldtnDivisionT</b> for <b>OrganizationDivision</b> to multiple
     * <b>OrganizationDivisionText</b>.
     *
     */
    @SerializedName( "to_CnsldtnDivisionT" )
    @JsonProperty( "to_CnsldtnDivisionT" )
    @ODataField( odataName = "to_CnsldtnDivisionT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<OrganizationDivisionText> toCnsldtnDivisionT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnDivisionT</b> navigation property to query
     * operations.
     *
     */
    public final static OrganizationDivisionLink<OrganizationDivisionText> TO_CNSLDTN_DIVISION_T =
        new OrganizationDivisionLink<OrganizationDivisionText>("to_CnsldtnDivisionT");

    @Nonnull
    @Override
    public Class<OrganizationDivision> getType()
    {
        return OrganizationDivision.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @param division
     *            Division
     */
    public void setDivision( @Nullable final String division )
    {
        rememberChangedField("Division", this.division);
        this.division = division;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Division_Text</b>
     * </p>
     *
     * @param division_Text
     *            Division Description
     */
    public void setDivision_Text( @Nullable final String division_Text )
    {
        rememberChangedField("Division_Text", this.division_Text);
        this.division_Text = division_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @param additionalMasterDataSource
     *            Consolidation Additional Master Data Source
     */
    public void setAdditionalMasterDataSource( @Nullable final String additionalMasterDataSource )
    {
        rememberChangedField("AdditionalMasterDataSource", this.additionalMasterDataSource);
        this.additionalMasterDataSource = additionalMasterDataSource;
    }

    @Override
    protected String getEntityCollection()
    {
        return "OrganizationDivision";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Division", getDivision());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Division", getDivision());
        values.put("Division_Text", getDivision_Text());
        values.put("AdditionalMasterDataSource", getAdditionalMasterDataSource());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Division") ) {
                final Object value = values.remove("Division");
                if( (value == null) || (!value.equals(getDivision())) ) {
                    setDivision(((String) value));
                }
            }
            if( values.containsKey("Division_Text") ) {
                final Object value = values.remove("Division_Text");
                if( (value == null) || (!value.equals(getDivision_Text())) ) {
                    setDivision_Text(((String) value));
                }
            }
            if( values.containsKey("AdditionalMasterDataSource") ) {
                final Object value = values.remove("AdditionalMasterDataSource");
                if( (value == null) || (!value.equals(getAdditionalMasterDataSource())) ) {
                    setAdditionalMasterDataSource(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnDivisionT") ) {
                final Object value = (values).remove("to_CnsldtnDivisionT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnDivisionT == null ) {
                        toCnsldtnDivisionT = Lists.newArrayList();
                    } else {
                        toCnsldtnDivisionT = Lists.newArrayList(toCnsldtnDivisionT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        OrganizationDivisionText entity;
                        if( toCnsldtnDivisionT.size() > i ) {
                            entity = toCnsldtnDivisionT.get(i);
                        } else {
                            entity = new OrganizationDivisionText();
                            toCnsldtnDivisionT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> OrganizationDivisionField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new OrganizationDivisionField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> OrganizationDivisionField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new OrganizationDivisionField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnDivisionT != null ) {
            (values).put("to_CnsldtnDivisionT", toCnsldtnDivisionT);
        }
        return values;
    }

    /**
     * Fetches the <b>OrganizationDivisionText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CnsldtnDivisionT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>OrganizationDivisionText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<OrganizationDivisionText> fetchCnsldtnDivisionT()
    {
        return fetchFieldAsList("to_CnsldtnDivisionT", OrganizationDivisionText.class);
    }

    /**
     * Retrieval of associated <b>OrganizationDivisionText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnDivisionT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnDivisionT</b> of a queried <b>OrganizationDivision</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>OrganizationDivisionText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<OrganizationDivisionText> getCnsldtnDivisionTOrFetch()
    {
        if( toCnsldtnDivisionT == null ) {
            toCnsldtnDivisionT = fetchCnsldtnDivisionT();
        }
        return toCnsldtnDivisionT;
    }

    /**
     * Retrieval of associated <b>OrganizationDivisionText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnDivisionT</b>.
     * <p>
     * If the navigation property for an entity <b>OrganizationDivision</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnDivisionT</b> is already loaded, the result will
     *         contain the <b>OrganizationDivisionText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<OrganizationDivisionText>> getCnsldtnDivisionTIfPresent()
    {
        return Option.of(toCnsldtnDivisionT);
    }

    /**
     * Overwrites the list of associated <b>OrganizationDivisionText</b> entities for the loaded navigation property
     * <b>to_CnsldtnDivisionT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnDivisionT</b> of a queried <b>OrganizationDivision</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>OrganizationDivisionText</b> entities.
     */
    public void setCnsldtnDivisionT( @Nonnull final List<OrganizationDivisionText> value )
    {
        if( toCnsldtnDivisionT == null ) {
            toCnsldtnDivisionT = Lists.newArrayList();
        }
        toCnsldtnDivisionT.clear();
        toCnsldtnDivisionT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>OrganizationDivisionText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnDivisionT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnDivisionT</b> of a queried <b>OrganizationDivision</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>OrganizationDivisionText</b> entities.
     */
    public void addCnsldtnDivisionT( OrganizationDivisionText... entity )
    {
        if( toCnsldtnDivisionT == null ) {
            toCnsldtnDivisionT = Lists.newArrayList();
        }
        toCnsldtnDivisionT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of OrganizationDivision instances.
     *
     */
    public final static class OrganizationDivisionBuilder
    {

        private List<OrganizationDivisionText> toCnsldtnDivisionT = Lists.newArrayList();

        private OrganizationDivision.OrganizationDivisionBuilder toCnsldtnDivisionT(
            final List<OrganizationDivisionText> value )
        {
            toCnsldtnDivisionT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnDivisionT</b> for <b>OrganizationDivision</b> to multiple
         * <b>OrganizationDivisionText</b>.
         *
         * @param value
         *            The OrganizationDivisionTexts to build this OrganizationDivision with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public OrganizationDivision.OrganizationDivisionBuilder cnsldtnDivisionT( OrganizationDivisionText... value )
        {
            return toCnsldtnDivisionT(Lists.newArrayList(value));
        }

    }

}
