/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.OrganizationDivisionTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.OrganizationDivisionTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.OrganizationDivisionTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Division Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>OrganizationDivisionTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class OrganizationDivisionText extends VdmEntity<OrganizationDivisionText>
{

    /**
     * Selector for all available fields of OrganizationDivisionText.
     *
     */
    public final static OrganizationDivisionTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static OrganizationDivisionTextField<String> LANGUAGE =
        new OrganizationDivisionTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @return Division
     */
    @Key
    @SerializedName( "Division" )
    @JsonProperty( "Division" )
    @Nullable
    @ODataField( odataName = "Division" )
    private String division;
    /**
     * Use with available fluent helpers to apply the <b>Division</b> field to query operations.
     *
     */
    public final static OrganizationDivisionTextField<String> DIVISION =
        new OrganizationDivisionTextField<String>("Division");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationDivisionText</b>
     * </p>
     *
     * @return Division Description
     */
    @SerializedName( "OrganizationDivisionText" )
    @JsonProperty( "OrganizationDivisionText" )
    @Nullable
    @ODataField( odataName = "OrganizationDivisionText" )
    private String organizationDivisionText;
    /**
     * Use with available fluent helpers to apply the <b>OrganizationDivisionText</b> field to query operations.
     *
     */
    public final static OrganizationDivisionTextField<String> ORGANIZATION_DIVISION_TEXT =
        new OrganizationDivisionTextField<String>("OrganizationDivisionText");
    /**
     * Navigation property <b>to_CnsldtnDivision</b> for <b>OrganizationDivisionText</b> to single
     * <b>OrganizationDivision</b>.
     *
     */
    @SerializedName( "to_CnsldtnDivision" )
    @JsonProperty( "to_CnsldtnDivision" )
    @ODataField( odataName = "to_CnsldtnDivision" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private OrganizationDivision toCnsldtnDivision;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnDivision</b> navigation property to query operations.
     *
     */
    public final static OrganizationDivisionTextOneToOneLink<OrganizationDivision> TO_CNSLDTN_DIVISION =
        new OrganizationDivisionTextOneToOneLink<OrganizationDivision>("to_CnsldtnDivision");

    @Nonnull
    @Override
    public Class<OrganizationDivisionText> getType()
    {
        return OrganizationDivisionText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @param division
     *            Division
     */
    public void setDivision( @Nullable final String division )
    {
        rememberChangedField("Division", this.division);
        this.division = division;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationDivisionText</b>
     * </p>
     *
     * @param organizationDivisionText
     *            Division Description
     */
    public void setOrganizationDivisionText( @Nullable final String organizationDivisionText )
    {
        rememberChangedField("OrganizationDivisionText", this.organizationDivisionText);
        this.organizationDivisionText = organizationDivisionText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "OrganizationDivisionText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("Division", getDivision());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("Division", getDivision());
        values.put("OrganizationDivisionText", getOrganizationDivisionText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("Division") ) {
                final Object value = values.remove("Division");
                if( (value == null) || (!value.equals(getDivision())) ) {
                    setDivision(((String) value));
                }
            }
            if( values.containsKey("OrganizationDivisionText") ) {
                final Object value = values.remove("OrganizationDivisionText");
                if( (value == null) || (!value.equals(getOrganizationDivisionText())) ) {
                    setOrganizationDivisionText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnDivision") ) {
                final Object value = (values).remove("to_CnsldtnDivision");
                if( value instanceof Map ) {
                    if( toCnsldtnDivision == null ) {
                        toCnsldtnDivision = new OrganizationDivision();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnDivision.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> OrganizationDivisionTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new OrganizationDivisionTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> OrganizationDivisionTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new OrganizationDivisionTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnDivision != null ) {
            (values).put("to_CnsldtnDivision", toCnsldtnDivision);
        }
        return values;
    }

    /**
     * Fetches the <b>OrganizationDivision</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnDivision</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>OrganizationDivision</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public OrganizationDivision fetchCnsldtnDivision()
    {
        return fetchFieldAsSingle("to_CnsldtnDivision", OrganizationDivision.class);
    }

    /**
     * Retrieval of associated <b>OrganizationDivision</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnDivision</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnDivision</b> of a queried <b>OrganizationDivisionText</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>OrganizationDivision</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public OrganizationDivision getCnsldtnDivisionOrFetch()
    {
        if( toCnsldtnDivision == null ) {
            toCnsldtnDivision = fetchCnsldtnDivision();
        }
        return toCnsldtnDivision;
    }

    /**
     * Retrieval of associated <b>OrganizationDivision</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnDivision</b>.
     * <p>
     * If the navigation property for an entity <b>OrganizationDivisionText</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnDivision</b> is already loaded, the result will
     *         contain the <b>OrganizationDivision</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<OrganizationDivision> getCnsldtnDivisionIfPresent()
    {
        return Option.of(toCnsldtnDivision);
    }

    /**
     * Overwrites the associated <b>OrganizationDivision</b> entity for the loaded navigation property
     * <b>to_CnsldtnDivision</b>.
     *
     * @param value
     *            New <b>OrganizationDivision</b> entity.
     */
    public void setCnsldtnDivision( final OrganizationDivision value )
    {
        toCnsldtnDivision = value;
    }

    /**
     * Helper class to allow for fluent creation of OrganizationDivisionText instances.
     *
     */
    public final static class OrganizationDivisionTextBuilder
    {

        private OrganizationDivision toCnsldtnDivision;

        private OrganizationDivisionText.OrganizationDivisionTextBuilder toCnsldtnDivision(
            final OrganizationDivision value )
        {
            toCnsldtnDivision = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnDivision</b> for <b>OrganizationDivisionText</b> to single
         * <b>OrganizationDivision</b>.
         *
         * @param value
         *            The OrganizationDivision to build this OrganizationDivisionText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public OrganizationDivisionText.OrganizationDivisionTextBuilder cnsldtnDivision(
            final OrganizationDivision value )
        {
            return toCnsldtnDivision(value);
        }

    }

}
