/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.PartnerBusinessAreaField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.PartnerBusinessAreaLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.PartnerBusinessAreaSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Partner Business Area
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PartnerBusinessAreaType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PartnerBusinessArea extends VdmEntity<PartnerBusinessArea>
{

    /**
     * Selector for all available fields of PartnerBusinessArea.
     *
     */
    public final static PartnerBusinessAreaSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @return Consolidation Business Area
     */
    @Key
    @SerializedName( "BusinessArea" )
    @JsonProperty( "BusinessArea" )
    @Nullable
    @ODataField( odataName = "BusinessArea" )
    private String businessArea;
    /**
     * Use with available fluent helpers to apply the <b>BusinessArea</b> field to query operations.
     *
     */
    public final static PartnerBusinessAreaField<String> BUSINESS_AREA =
        new PartnerBusinessAreaField<String>("BusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea_Text</b>
     * </p>
     *
     * @return Partner Business Area Description
     */
    @SerializedName( "BusinessArea_Text" )
    @JsonProperty( "BusinessArea_Text" )
    @Nullable
    @ODataField( odataName = "BusinessArea_Text" )
    private String businessArea_Text;
    /**
     * Use with available fluent helpers to apply the <b>BusinessArea_Text</b> field to query operations.
     *
     */
    public final static PartnerBusinessAreaField<String> BUSINESS_AREA_TEXT =
        new PartnerBusinessAreaField<String>("BusinessArea_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @return Consolidation Additional Master Data Source
     */
    @SerializedName( "AdditionalMasterDataSource" )
    @JsonProperty( "AdditionalMasterDataSource" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataSource" )
    private String additionalMasterDataSource;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataSource</b> field to query operations.
     *
     */
    public final static PartnerBusinessAreaField<String> ADDITIONAL_MASTER_DATA_SOURCE =
        new PartnerBusinessAreaField<String>("AdditionalMasterDataSource");
    /**
     * Navigation property <b>to_CnsldtnPartnerBusAreaHier</b> for <b>PartnerBusinessArea</b> to multiple
     * <b>PartnerBusinessAreaHier</b>.
     *
     */
    @SerializedName( "to_CnsldtnPartnerBusAreaHier" )
    @JsonProperty( "to_CnsldtnPartnerBusAreaHier" )
    @ODataField( odataName = "to_CnsldtnPartnerBusAreaHier" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PartnerBusinessAreaHier> toCnsldtnPartnerBusAreaHier;
    /**
     * Navigation property <b>to_CnsldtnPartnerBusAreaT</b> for <b>PartnerBusinessArea</b> to multiple
     * <b>PartnerBusinessAreaText</b>.
     *
     */
    @SerializedName( "to_CnsldtnPartnerBusAreaT" )
    @JsonProperty( "to_CnsldtnPartnerBusAreaT" )
    @ODataField( odataName = "to_CnsldtnPartnerBusAreaT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PartnerBusinessAreaText> toCnsldtnPartnerBusAreaT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnPartnerBusAreaHier</b> navigation property to query
     * operations.
     *
     */
    public final static PartnerBusinessAreaLink<PartnerBusinessAreaHier> TO_CNSLDTN_PARTNER_BUS_AREA_HIER =
        new PartnerBusinessAreaLink<PartnerBusinessAreaHier>("to_CnsldtnPartnerBusAreaHier");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnPartnerBusAreaT</b> navigation property to query
     * operations.
     *
     */
    public final static PartnerBusinessAreaLink<PartnerBusinessAreaText> TO_CNSLDTN_PARTNER_BUS_AREA_T =
        new PartnerBusinessAreaLink<PartnerBusinessAreaText>("to_CnsldtnPartnerBusAreaT");

    @Nonnull
    @Override
    public Class<PartnerBusinessArea> getType()
    {
        return PartnerBusinessArea.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @param businessArea
     *            Consolidation Business Area
     */
    public void setBusinessArea( @Nullable final String businessArea )
    {
        rememberChangedField("BusinessArea", this.businessArea);
        this.businessArea = businessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea_Text</b>
     * </p>
     *
     * @param businessArea_Text
     *            Partner Business Area Description
     */
    public void setBusinessArea_Text( @Nullable final String businessArea_Text )
    {
        rememberChangedField("BusinessArea_Text", this.businessArea_Text);
        this.businessArea_Text = businessArea_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @param additionalMasterDataSource
     *            Consolidation Additional Master Data Source
     */
    public void setAdditionalMasterDataSource( @Nullable final String additionalMasterDataSource )
    {
        rememberChangedField("AdditionalMasterDataSource", this.additionalMasterDataSource);
        this.additionalMasterDataSource = additionalMasterDataSource;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PartnerBusinessArea";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BusinessArea", getBusinessArea());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BusinessArea", getBusinessArea());
        values.put("BusinessArea_Text", getBusinessArea_Text());
        values.put("AdditionalMasterDataSource", getAdditionalMasterDataSource());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BusinessArea") ) {
                final Object value = values.remove("BusinessArea");
                if( (value == null) || (!value.equals(getBusinessArea())) ) {
                    setBusinessArea(((String) value));
                }
            }
            if( values.containsKey("BusinessArea_Text") ) {
                final Object value = values.remove("BusinessArea_Text");
                if( (value == null) || (!value.equals(getBusinessArea_Text())) ) {
                    setBusinessArea_Text(((String) value));
                }
            }
            if( values.containsKey("AdditionalMasterDataSource") ) {
                final Object value = values.remove("AdditionalMasterDataSource");
                if( (value == null) || (!value.equals(getAdditionalMasterDataSource())) ) {
                    setAdditionalMasterDataSource(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnPartnerBusAreaHier") ) {
                final Object value = (values).remove("to_CnsldtnPartnerBusAreaHier");
                if( value instanceof Iterable ) {
                    if( toCnsldtnPartnerBusAreaHier == null ) {
                        toCnsldtnPartnerBusAreaHier = Lists.newArrayList();
                    } else {
                        toCnsldtnPartnerBusAreaHier = Lists.newArrayList(toCnsldtnPartnerBusAreaHier);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PartnerBusinessAreaHier entity;
                        if( toCnsldtnPartnerBusAreaHier.size() > i ) {
                            entity = toCnsldtnPartnerBusAreaHier.get(i);
                        } else {
                            entity = new PartnerBusinessAreaHier();
                            toCnsldtnPartnerBusAreaHier.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CnsldtnPartnerBusAreaT") ) {
                final Object value = (values).remove("to_CnsldtnPartnerBusAreaT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnPartnerBusAreaT == null ) {
                        toCnsldtnPartnerBusAreaT = Lists.newArrayList();
                    } else {
                        toCnsldtnPartnerBusAreaT = Lists.newArrayList(toCnsldtnPartnerBusAreaT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PartnerBusinessAreaText entity;
                        if( toCnsldtnPartnerBusAreaT.size() > i ) {
                            entity = toCnsldtnPartnerBusAreaT.get(i);
                        } else {
                            entity = new PartnerBusinessAreaText();
                            toCnsldtnPartnerBusAreaT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PartnerBusinessAreaField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PartnerBusinessAreaField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PartnerBusinessAreaField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PartnerBusinessAreaField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnPartnerBusAreaHier != null ) {
            (values).put("to_CnsldtnPartnerBusAreaHier", toCnsldtnPartnerBusAreaHier);
        }
        if( toCnsldtnPartnerBusAreaT != null ) {
            (values).put("to_CnsldtnPartnerBusAreaT", toCnsldtnPartnerBusAreaT);
        }
        return values;
    }

    /**
     * Fetches the <b>PartnerBusinessAreaHier</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CnsldtnPartnerBusAreaHier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PartnerBusinessAreaHier</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PartnerBusinessAreaHier> fetchCnsldtnPartnerBusAreaHier()
    {
        return fetchFieldAsList("to_CnsldtnPartnerBusAreaHier", PartnerBusinessAreaHier.class);
    }

    /**
     * Retrieval of associated <b>PartnerBusinessAreaHier</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnPartnerBusAreaHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPartnerBusAreaHier</b> of a queried <b>PartnerBusinessArea</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PartnerBusinessAreaHier</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PartnerBusinessAreaHier> getCnsldtnPartnerBusAreaHierOrFetch()
    {
        if( toCnsldtnPartnerBusAreaHier == null ) {
            toCnsldtnPartnerBusAreaHier = fetchCnsldtnPartnerBusAreaHier();
        }
        return toCnsldtnPartnerBusAreaHier;
    }

    /**
     * Retrieval of associated <b>PartnerBusinessAreaHier</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnPartnerBusAreaHier</b>.
     * <p>
     * If the navigation property for an entity <b>PartnerBusinessArea</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnPartnerBusAreaHier</b> is already loaded, the
     *         result will contain the <b>PartnerBusinessAreaHier</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PartnerBusinessAreaHier>> getCnsldtnPartnerBusAreaHierIfPresent()
    {
        return Option.of(toCnsldtnPartnerBusAreaHier);
    }

    /**
     * Overwrites the list of associated <b>PartnerBusinessAreaHier</b> entities for the loaded navigation property
     * <b>to_CnsldtnPartnerBusAreaHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPartnerBusAreaHier</b> of a queried <b>PartnerBusinessArea</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PartnerBusinessAreaHier</b> entities.
     */
    public void setCnsldtnPartnerBusAreaHier( @Nonnull final List<PartnerBusinessAreaHier> value )
    {
        if( toCnsldtnPartnerBusAreaHier == null ) {
            toCnsldtnPartnerBusAreaHier = Lists.newArrayList();
        }
        toCnsldtnPartnerBusAreaHier.clear();
        toCnsldtnPartnerBusAreaHier.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PartnerBusinessAreaHier</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnPartnerBusAreaHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPartnerBusAreaHier</b> of a queried <b>PartnerBusinessArea</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PartnerBusinessAreaHier</b> entities.
     */
    public void addCnsldtnPartnerBusAreaHier( PartnerBusinessAreaHier... entity )
    {
        if( toCnsldtnPartnerBusAreaHier == null ) {
            toCnsldtnPartnerBusAreaHier = Lists.newArrayList();
        }
        toCnsldtnPartnerBusAreaHier.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>PartnerBusinessAreaText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CnsldtnPartnerBusAreaT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PartnerBusinessAreaText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PartnerBusinessAreaText> fetchCnsldtnPartnerBusAreaT()
    {
        return fetchFieldAsList("to_CnsldtnPartnerBusAreaT", PartnerBusinessAreaText.class);
    }

    /**
     * Retrieval of associated <b>PartnerBusinessAreaText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnPartnerBusAreaT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPartnerBusAreaT</b> of a queried <b>PartnerBusinessArea</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PartnerBusinessAreaText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PartnerBusinessAreaText> getCnsldtnPartnerBusAreaTOrFetch()
    {
        if( toCnsldtnPartnerBusAreaT == null ) {
            toCnsldtnPartnerBusAreaT = fetchCnsldtnPartnerBusAreaT();
        }
        return toCnsldtnPartnerBusAreaT;
    }

    /**
     * Retrieval of associated <b>PartnerBusinessAreaText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnPartnerBusAreaT</b>.
     * <p>
     * If the navigation property for an entity <b>PartnerBusinessArea</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnPartnerBusAreaT</b> is already loaded, the result
     *         will contain the <b>PartnerBusinessAreaText</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PartnerBusinessAreaText>> getCnsldtnPartnerBusAreaTIfPresent()
    {
        return Option.of(toCnsldtnPartnerBusAreaT);
    }

    /**
     * Overwrites the list of associated <b>PartnerBusinessAreaText</b> entities for the loaded navigation property
     * <b>to_CnsldtnPartnerBusAreaT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPartnerBusAreaT</b> of a queried <b>PartnerBusinessArea</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PartnerBusinessAreaText</b> entities.
     */
    public void setCnsldtnPartnerBusAreaT( @Nonnull final List<PartnerBusinessAreaText> value )
    {
        if( toCnsldtnPartnerBusAreaT == null ) {
            toCnsldtnPartnerBusAreaT = Lists.newArrayList();
        }
        toCnsldtnPartnerBusAreaT.clear();
        toCnsldtnPartnerBusAreaT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PartnerBusinessAreaText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnPartnerBusAreaT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPartnerBusAreaT</b> of a queried <b>PartnerBusinessArea</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PartnerBusinessAreaText</b> entities.
     */
    public void addCnsldtnPartnerBusAreaT( PartnerBusinessAreaText... entity )
    {
        if( toCnsldtnPartnerBusAreaT == null ) {
            toCnsldtnPartnerBusAreaT = Lists.newArrayList();
        }
        toCnsldtnPartnerBusAreaT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of PartnerBusinessArea instances.
     *
     */
    public final static class PartnerBusinessAreaBuilder
    {

        private List<PartnerBusinessAreaHier> toCnsldtnPartnerBusAreaHier = Lists.newArrayList();
        private List<PartnerBusinessAreaText> toCnsldtnPartnerBusAreaT = Lists.newArrayList();

        private PartnerBusinessArea.PartnerBusinessAreaBuilder toCnsldtnPartnerBusAreaHier(
            final List<PartnerBusinessAreaHier> value )
        {
            toCnsldtnPartnerBusAreaHier.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnPartnerBusAreaHier</b> for <b>PartnerBusinessArea</b> to multiple
         * <b>PartnerBusinessAreaHier</b>.
         *
         * @param value
         *            The PartnerBusinessAreaHiers to build this PartnerBusinessArea with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PartnerBusinessArea.PartnerBusinessAreaBuilder cnsldtnPartnerBusAreaHier(
            PartnerBusinessAreaHier... value )
        {
            return toCnsldtnPartnerBusAreaHier(Lists.newArrayList(value));
        }

        private PartnerBusinessArea.PartnerBusinessAreaBuilder toCnsldtnPartnerBusAreaT(
            final List<PartnerBusinessAreaText> value )
        {
            toCnsldtnPartnerBusAreaT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnPartnerBusAreaT</b> for <b>PartnerBusinessArea</b> to multiple
         * <b>PartnerBusinessAreaText</b>.
         *
         * @param value
         *            The PartnerBusinessAreaTexts to build this PartnerBusinessArea with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PartnerBusinessArea.PartnerBusinessAreaBuilder cnsldtnPartnerBusAreaT( PartnerBusinessAreaText... value )
        {
            return toCnsldtnPartnerBusAreaT(Lists.newArrayList(value));
        }

    }

}
