/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.PartnerBusinessAreaTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.PartnerBusinessAreaTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.PartnerBusinessAreaTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Partner Business Area - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PartnerBusinessAreaTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PartnerBusinessAreaText extends VdmEntity<PartnerBusinessAreaText>
{

    /**
     * Selector for all available fields of PartnerBusinessAreaText.
     *
     */
    public final static PartnerBusinessAreaTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static PartnerBusinessAreaTextField<String> LANGUAGE =
        new PartnerBusinessAreaTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @return Partner Business Area
     */
    @Key
    @SerializedName( "BusinessArea" )
    @JsonProperty( "BusinessArea" )
    @Nullable
    @ODataField( odataName = "BusinessArea" )
    private String businessArea;
    /**
     * Use with available fluent helpers to apply the <b>BusinessArea</b> field to query operations.
     *
     */
    public final static PartnerBusinessAreaTextField<String> BUSINESS_AREA =
        new PartnerBusinessAreaTextField<String>("BusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBusinessAreaText</b>
     * </p>
     *
     * @return Partner Business Area Description
     */
    @SerializedName( "PartnerBusinessAreaText" )
    @JsonProperty( "PartnerBusinessAreaText" )
    @Nullable
    @ODataField( odataName = "PartnerBusinessAreaText" )
    private String partnerBusinessAreaText;
    /**
     * Use with available fluent helpers to apply the <b>PartnerBusinessAreaText</b> field to query operations.
     *
     */
    public final static PartnerBusinessAreaTextField<String> PARTNER_BUSINESS_AREA_TEXT =
        new PartnerBusinessAreaTextField<String>("PartnerBusinessAreaText");
    /**
     * Navigation property <b>to_CnsldtnPartnerBusArea</b> for <b>PartnerBusinessAreaText</b> to single
     * <b>PartnerBusinessArea</b>.
     *
     */
    @SerializedName( "to_CnsldtnPartnerBusArea" )
    @JsonProperty( "to_CnsldtnPartnerBusArea" )
    @ODataField( odataName = "to_CnsldtnPartnerBusArea" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PartnerBusinessArea toCnsldtnPartnerBusArea;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnPartnerBusArea</b> navigation property to query
     * operations.
     *
     */
    public final static PartnerBusinessAreaTextOneToOneLink<PartnerBusinessArea> TO_CNSLDTN_PARTNER_BUS_AREA =
        new PartnerBusinessAreaTextOneToOneLink<PartnerBusinessArea>("to_CnsldtnPartnerBusArea");

    @Nonnull
    @Override
    public Class<PartnerBusinessAreaText> getType()
    {
        return PartnerBusinessAreaText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @param businessArea
     *            Partner Business Area
     */
    public void setBusinessArea( @Nullable final String businessArea )
    {
        rememberChangedField("BusinessArea", this.businessArea);
        this.businessArea = businessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBusinessAreaText</b>
     * </p>
     *
     * @param partnerBusinessAreaText
     *            Partner Business Area Description
     */
    public void setPartnerBusinessAreaText( @Nullable final String partnerBusinessAreaText )
    {
        rememberChangedField("PartnerBusinessAreaText", this.partnerBusinessAreaText);
        this.partnerBusinessAreaText = partnerBusinessAreaText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PartnerBusinessAreaText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("BusinessArea", getBusinessArea());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("BusinessArea", getBusinessArea());
        values.put("PartnerBusinessAreaText", getPartnerBusinessAreaText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("BusinessArea") ) {
                final Object value = values.remove("BusinessArea");
                if( (value == null) || (!value.equals(getBusinessArea())) ) {
                    setBusinessArea(((String) value));
                }
            }
            if( values.containsKey("PartnerBusinessAreaText") ) {
                final Object value = values.remove("PartnerBusinessAreaText");
                if( (value == null) || (!value.equals(getPartnerBusinessAreaText())) ) {
                    setPartnerBusinessAreaText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnPartnerBusArea") ) {
                final Object value = (values).remove("to_CnsldtnPartnerBusArea");
                if( value instanceof Map ) {
                    if( toCnsldtnPartnerBusArea == null ) {
                        toCnsldtnPartnerBusArea = new PartnerBusinessArea();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnPartnerBusArea.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PartnerBusinessAreaTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PartnerBusinessAreaTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PartnerBusinessAreaTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PartnerBusinessAreaTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnPartnerBusArea != null ) {
            (values).put("to_CnsldtnPartnerBusArea", toCnsldtnPartnerBusArea);
        }
        return values;
    }

    /**
     * Fetches the <b>PartnerBusinessArea</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnPartnerBusArea</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PartnerBusinessArea</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PartnerBusinessArea fetchCnsldtnPartnerBusArea()
    {
        return fetchFieldAsSingle("to_CnsldtnPartnerBusArea", PartnerBusinessArea.class);
    }

    /**
     * Retrieval of associated <b>PartnerBusinessArea</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnPartnerBusArea</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPartnerBusArea</b> of a queried <b>PartnerBusinessAreaText</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PartnerBusinessArea</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PartnerBusinessArea getCnsldtnPartnerBusAreaOrFetch()
    {
        if( toCnsldtnPartnerBusArea == null ) {
            toCnsldtnPartnerBusArea = fetchCnsldtnPartnerBusArea();
        }
        return toCnsldtnPartnerBusArea;
    }

    /**
     * Retrieval of associated <b>PartnerBusinessArea</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnPartnerBusArea</b>.
     * <p>
     * If the navigation property for an entity <b>PartnerBusinessAreaText</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnPartnerBusArea</b> is already loaded, the result
     *         will contain the <b>PartnerBusinessArea</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PartnerBusinessArea> getCnsldtnPartnerBusAreaIfPresent()
    {
        return Option.of(toCnsldtnPartnerBusArea);
    }

    /**
     * Overwrites the associated <b>PartnerBusinessArea</b> entity for the loaded navigation property
     * <b>to_CnsldtnPartnerBusArea</b>.
     *
     * @param value
     *            New <b>PartnerBusinessArea</b> entity.
     */
    public void setCnsldtnPartnerBusArea( final PartnerBusinessArea value )
    {
        toCnsldtnPartnerBusArea = value;
    }

    /**
     * Helper class to allow for fluent creation of PartnerBusinessAreaText instances.
     *
     */
    public final static class PartnerBusinessAreaTextBuilder
    {

        private PartnerBusinessArea toCnsldtnPartnerBusArea;

        private PartnerBusinessAreaText.PartnerBusinessAreaTextBuilder toCnsldtnPartnerBusArea(
            final PartnerBusinessArea value )
        {
            toCnsldtnPartnerBusArea = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnPartnerBusArea</b> for <b>PartnerBusinessAreaText</b> to single
         * <b>PartnerBusinessArea</b>.
         *
         * @param value
         *            The PartnerBusinessArea to build this PartnerBusinessAreaText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PartnerBusinessAreaText.PartnerBusinessAreaTextBuilder cnsldtnPartnerBusArea(
            final PartnerBusinessArea value )
        {
            return toCnsldtnPartnerBusArea(value);
        }

    }

}
