/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.PartnerCnsldtnUnitTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.PartnerCnsldtnUnitTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.PartnerCnsldtnUnitTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Partner Consolidation Unit - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PartnerCnsldtnUnitTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PartnerCnsldtnUnitText extends VdmEntity<PartnerCnsldtnUnitText>
{

    /**
     * Selector for all available fields of PartnerCnsldtnUnitText.
     *
     */
    public final static PartnerCnsldtnUnitTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnit</b>
     * </p>
     *
     * @return Partner Unit
     */
    @Key
    @SerializedName( "ConsolidationUnit" )
    @JsonProperty( "ConsolidationUnit" )
    @Nullable
    @ODataField( odataName = "ConsolidationUnit" )
    private String consolidationUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnit</b> field to query operations.
     *
     */
    public final static PartnerCnsldtnUnitTextField<String> CONSOLIDATION_UNIT =
        new PartnerCnsldtnUnitTextField<String>("ConsolidationUnit");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static PartnerCnsldtnUnitTextField<String> LANGUAGE =
        new PartnerCnsldtnUnitTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PartnerConsolidationUnitText</b>
     * </p>
     *
     * @return Partner Unit Description
     */
    @SerializedName( "PartnerConsolidationUnitText" )
    @JsonProperty( "PartnerConsolidationUnitText" )
    @Nullable
    @ODataField( odataName = "PartnerConsolidationUnitText" )
    private String partnerConsolidationUnitText;
    /**
     * Use with available fluent helpers to apply the <b>PartnerConsolidationUnitText</b> field to query operations.
     *
     */
    public final static PartnerCnsldtnUnitTextField<String> PARTNER_CONSOLIDATION_UNIT_TEXT =
        new PartnerCnsldtnUnitTextField<String>("PartnerConsolidationUnitText");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitLongText</b>
     * </p>
     *
     * @return Partner Unit Long Description
     */
    @SerializedName( "ConsolidationUnitLongText" )
    @JsonProperty( "ConsolidationUnitLongText" )
    @Nullable
    @ODataField( odataName = "ConsolidationUnitLongText" )
    private String consolidationUnitLongText;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnitLongText</b> field to query operations.
     *
     */
    public final static PartnerCnsldtnUnitTextField<String> CONSOLIDATION_UNIT_LONG_TEXT =
        new PartnerCnsldtnUnitTextField<String>("ConsolidationUnitLongText");
    /**
     * Navigation property <b>to_CnsldtnPartnerUnit</b> for <b>PartnerCnsldtnUnitText</b> to single
     * <b>PartnerCnsldtnUnit</b>.
     *
     */
    @SerializedName( "to_CnsldtnPartnerUnit" )
    @JsonProperty( "to_CnsldtnPartnerUnit" )
    @ODataField( odataName = "to_CnsldtnPartnerUnit" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PartnerCnsldtnUnit toCnsldtnPartnerUnit;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnPartnerUnit</b> navigation property to query
     * operations.
     *
     */
    public final static PartnerCnsldtnUnitTextOneToOneLink<PartnerCnsldtnUnit> TO_CNSLDTN_PARTNER_UNIT =
        new PartnerCnsldtnUnitTextOneToOneLink<PartnerCnsldtnUnit>("to_CnsldtnPartnerUnit");

    @Nonnull
    @Override
    public Class<PartnerCnsldtnUnitText> getType()
    {
        return PartnerCnsldtnUnitText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnit</b>
     * </p>
     *
     * @param consolidationUnit
     *            Partner Unit
     */
    public void setConsolidationUnit( @Nullable final String consolidationUnit )
    {
        rememberChangedField("ConsolidationUnit", this.consolidationUnit);
        this.consolidationUnit = consolidationUnit;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PartnerConsolidationUnitText</b>
     * </p>
     *
     * @param partnerConsolidationUnitText
     *            Partner Unit Description
     */
    public void setPartnerConsolidationUnitText( @Nullable final String partnerConsolidationUnitText )
    {
        rememberChangedField("PartnerConsolidationUnitText", this.partnerConsolidationUnitText);
        this.partnerConsolidationUnitText = partnerConsolidationUnitText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitLongText</b>
     * </p>
     *
     * @param consolidationUnitLongText
     *            Partner Unit Long Description
     */
    public void setConsolidationUnitLongText( @Nullable final String consolidationUnitLongText )
    {
        rememberChangedField("ConsolidationUnitLongText", this.consolidationUnitLongText);
        this.consolidationUnitLongText = consolidationUnitLongText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PartnerCnsldtnUnitText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConsolidationUnit", getConsolidationUnit());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConsolidationUnit", getConsolidationUnit());
        values.put("Language", getLanguage());
        values.put("PartnerConsolidationUnitText", getPartnerConsolidationUnitText());
        values.put("ConsolidationUnitLongText", getConsolidationUnitLongText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConsolidationUnit") ) {
                final Object value = values.remove("ConsolidationUnit");
                if( (value == null) || (!value.equals(getConsolidationUnit())) ) {
                    setConsolidationUnit(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("PartnerConsolidationUnitText") ) {
                final Object value = values.remove("PartnerConsolidationUnitText");
                if( (value == null) || (!value.equals(getPartnerConsolidationUnitText())) ) {
                    setPartnerConsolidationUnitText(((String) value));
                }
            }
            if( values.containsKey("ConsolidationUnitLongText") ) {
                final Object value = values.remove("ConsolidationUnitLongText");
                if( (value == null) || (!value.equals(getConsolidationUnitLongText())) ) {
                    setConsolidationUnitLongText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnPartnerUnit") ) {
                final Object value = (values).remove("to_CnsldtnPartnerUnit");
                if( value instanceof Map ) {
                    if( toCnsldtnPartnerUnit == null ) {
                        toCnsldtnPartnerUnit = new PartnerCnsldtnUnit();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnPartnerUnit.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PartnerCnsldtnUnitTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PartnerCnsldtnUnitTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PartnerCnsldtnUnitTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PartnerCnsldtnUnitTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnPartnerUnit != null ) {
            (values).put("to_CnsldtnPartnerUnit", toCnsldtnPartnerUnit);
        }
        return values;
    }

    /**
     * Fetches the <b>PartnerCnsldtnUnit</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnPartnerUnit</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PartnerCnsldtnUnit</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PartnerCnsldtnUnit fetchCnsldtnPartnerUnit()
    {
        return fetchFieldAsSingle("to_CnsldtnPartnerUnit", PartnerCnsldtnUnit.class);
    }

    /**
     * Retrieval of associated <b>PartnerCnsldtnUnit</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnPartnerUnit</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPartnerUnit</b> of a queried <b>PartnerCnsldtnUnitText</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PartnerCnsldtnUnit</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PartnerCnsldtnUnit getCnsldtnPartnerUnitOrFetch()
    {
        if( toCnsldtnPartnerUnit == null ) {
            toCnsldtnPartnerUnit = fetchCnsldtnPartnerUnit();
        }
        return toCnsldtnPartnerUnit;
    }

    /**
     * Retrieval of associated <b>PartnerCnsldtnUnit</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnPartnerUnit</b>.
     * <p>
     * If the navigation property for an entity <b>PartnerCnsldtnUnitText</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnPartnerUnit</b> is already loaded, the result
     *         will contain the <b>PartnerCnsldtnUnit</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PartnerCnsldtnUnit> getCnsldtnPartnerUnitIfPresent()
    {
        return Option.of(toCnsldtnPartnerUnit);
    }

    /**
     * Overwrites the associated <b>PartnerCnsldtnUnit</b> entity for the loaded navigation property
     * <b>to_CnsldtnPartnerUnit</b>.
     *
     * @param value
     *            New <b>PartnerCnsldtnUnit</b> entity.
     */
    public void setCnsldtnPartnerUnit( final PartnerCnsldtnUnit value )
    {
        toCnsldtnPartnerUnit = value;
    }

    /**
     * Helper class to allow for fluent creation of PartnerCnsldtnUnitText instances.
     *
     */
    public final static class PartnerCnsldtnUnitTextBuilder
    {

        private PartnerCnsldtnUnit toCnsldtnPartnerUnit;

        private PartnerCnsldtnUnitText.PartnerCnsldtnUnitTextBuilder toCnsldtnPartnerUnit(
            final PartnerCnsldtnUnit value )
        {
            toCnsldtnPartnerUnit = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnPartnerUnit</b> for <b>PartnerCnsldtnUnitText</b> to single
         * <b>PartnerCnsldtnUnit</b>.
         *
         * @param value
         *            The PartnerCnsldtnUnit to build this PartnerCnsldtnUnitText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PartnerCnsldtnUnitText.PartnerCnsldtnUnitTextBuilder cnsldtnPartnerUnit( final PartnerCnsldtnUnit value )
        {
            return toCnsldtnPartnerUnit(value);
        }

    }

}
