/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.PartnerCnsldtnUnitTextSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.PartnerCnsldtnUnitText
 * PartnerCnsldtnUnitText} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class PartnerCnsldtnUnitTextByKeyFluentHelper
    extends
    FluentHelperByKey<PartnerCnsldtnUnitTextByKeyFluentHelper, PartnerCnsldtnUnitText, PartnerCnsldtnUnitTextSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.PartnerCnsldtnUnitText
     * PartnerCnsldtnUnitText} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code PartnerCnsldtnUnitText}
     * @param servicePath
     *            Service path to be used to fetch a single {@code PartnerCnsldtnUnitText}
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param consolidationUnit
     *            Partner Unit
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     */
    public PartnerCnsldtnUnitTextByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String consolidationUnit,
        final String language )
    {
        super(servicePath, entityCollection);
        this.key.put("ConsolidationUnit", consolidationUnit);
        this.key.put("Language", language);
    }

    @Override
    @Nonnull
    protected Class<PartnerCnsldtnUnitText> getEntityClass()
    {
        return PartnerCnsldtnUnitText.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
