/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.PartnerCompanyField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.PartnerCompanyLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.PartnerCompanySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Partner Global Company
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PartnerCompanyType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PartnerCompany extends VdmEntity<PartnerCompany>
{

    /**
     * Selector for all available fields of PartnerCompany.
     *
     */
    public final static PartnerCompanySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>Company</b>
     * </p>
     *
     * @return Company
     */
    @Key
    @SerializedName( "Company" )
    @JsonProperty( "Company" )
    @Nullable
    @ODataField( odataName = "Company" )
    private String company;
    /**
     * Use with available fluent helpers to apply the <b>Company</b> field to query operations.
     *
     */
    public final static PartnerCompanyField<String> COMPANY = new PartnerCompanyField<String>("Company");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>Company_Text</b>
     * </p>
     *
     * @return Partner Company Description
     */
    @SerializedName( "Company_Text" )
    @JsonProperty( "Company_Text" )
    @Nullable
    @ODataField( odataName = "Company_Text" )
    private String company_Text;
    /**
     * Use with available fluent helpers to apply the <b>Company_Text</b> field to query operations.
     *
     */
    public final static PartnerCompanyField<String> COMPANY_TEXT = new PartnerCompanyField<String>("Company_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @return Master Data Source
     */
    @SerializedName( "AdditionalMasterDataSource" )
    @JsonProperty( "AdditionalMasterDataSource" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataSource" )
    private String additionalMasterDataSource;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataSource</b> field to query operations.
     *
     */
    public final static PartnerCompanyField<String> ADDITIONAL_MASTER_DATA_SOURCE =
        new PartnerCompanyField<String>("AdditionalMasterDataSource");
    /**
     * Navigation property <b>to_CnsldtnGlobalCompanyT</b> for <b>PartnerCompany</b> to multiple
     * <b>PartnerCompanyText</b>.
     *
     */
    @SerializedName( "to_CnsldtnGlobalCompanyT" )
    @JsonProperty( "to_CnsldtnGlobalCompanyT" )
    @ODataField( odataName = "to_CnsldtnGlobalCompanyT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PartnerCompanyText> toCnsldtnGlobalCompanyT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnGlobalCompanyT</b> navigation property to query
     * operations.
     *
     */
    public final static PartnerCompanyLink<PartnerCompanyText> TO_CNSLDTN_GLOBAL_COMPANY_T =
        new PartnerCompanyLink<PartnerCompanyText>("to_CnsldtnGlobalCompanyT");

    @Nonnull
    @Override
    public Class<PartnerCompany> getType()
    {
        return PartnerCompany.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>Company</b>
     * </p>
     *
     * @param company
     *            Company
     */
    public void setCompany( @Nullable final String company )
    {
        rememberChangedField("Company", this.company);
        this.company = company;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>Company_Text</b>
     * </p>
     *
     * @param company_Text
     *            Partner Company Description
     */
    public void setCompany_Text( @Nullable final String company_Text )
    {
        rememberChangedField("Company_Text", this.company_Text);
        this.company_Text = company_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @param additionalMasterDataSource
     *            Master Data Source
     */
    public void setAdditionalMasterDataSource( @Nullable final String additionalMasterDataSource )
    {
        rememberChangedField("AdditionalMasterDataSource", this.additionalMasterDataSource);
        this.additionalMasterDataSource = additionalMasterDataSource;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PartnerCompany";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Company", getCompany());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Company", getCompany());
        values.put("Company_Text", getCompany_Text());
        values.put("AdditionalMasterDataSource", getAdditionalMasterDataSource());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Company") ) {
                final Object value = values.remove("Company");
                if( (value == null) || (!value.equals(getCompany())) ) {
                    setCompany(((String) value));
                }
            }
            if( values.containsKey("Company_Text") ) {
                final Object value = values.remove("Company_Text");
                if( (value == null) || (!value.equals(getCompany_Text())) ) {
                    setCompany_Text(((String) value));
                }
            }
            if( values.containsKey("AdditionalMasterDataSource") ) {
                final Object value = values.remove("AdditionalMasterDataSource");
                if( (value == null) || (!value.equals(getAdditionalMasterDataSource())) ) {
                    setAdditionalMasterDataSource(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnGlobalCompanyT") ) {
                final Object value = (values).remove("to_CnsldtnGlobalCompanyT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnGlobalCompanyT == null ) {
                        toCnsldtnGlobalCompanyT = Lists.newArrayList();
                    } else {
                        toCnsldtnGlobalCompanyT = Lists.newArrayList(toCnsldtnGlobalCompanyT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PartnerCompanyText entity;
                        if( toCnsldtnGlobalCompanyT.size() > i ) {
                            entity = toCnsldtnGlobalCompanyT.get(i);
                        } else {
                            entity = new PartnerCompanyText();
                            toCnsldtnGlobalCompanyT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> PartnerCompanyField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PartnerCompanyField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PartnerCompanyField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PartnerCompanyField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnGlobalCompanyT != null ) {
            (values).put("to_CnsldtnGlobalCompanyT", toCnsldtnGlobalCompanyT);
        }
        return values;
    }

    /**
     * Fetches the <b>PartnerCompanyText</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnGlobalCompanyT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PartnerCompanyText</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PartnerCompanyText> fetchCnsldtnGlobalCompanyT()
    {
        return fetchFieldAsList("to_CnsldtnGlobalCompanyT", PartnerCompanyText.class);
    }

    /**
     * Retrieval of associated <b>PartnerCompanyText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnGlobalCompanyT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnGlobalCompanyT</b> of a queried <b>PartnerCompany</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PartnerCompanyText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PartnerCompanyText> getCnsldtnGlobalCompanyTOrFetch()
    {
        if( toCnsldtnGlobalCompanyT == null ) {
            toCnsldtnGlobalCompanyT = fetchCnsldtnGlobalCompanyT();
        }
        return toCnsldtnGlobalCompanyT;
    }

    /**
     * Retrieval of associated <b>PartnerCompanyText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnGlobalCompanyT</b>.
     * <p>
     * If the navigation property for an entity <b>PartnerCompany</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnGlobalCompanyT</b> is already loaded, the result
     *         will contain the <b>PartnerCompanyText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PartnerCompanyText>> getCnsldtnGlobalCompanyTIfPresent()
    {
        return Option.of(toCnsldtnGlobalCompanyT);
    }

    /**
     * Overwrites the list of associated <b>PartnerCompanyText</b> entities for the loaded navigation property
     * <b>to_CnsldtnGlobalCompanyT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnGlobalCompanyT</b> of a queried <b>PartnerCompany</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PartnerCompanyText</b> entities.
     */
    public void setCnsldtnGlobalCompanyT( @Nonnull final List<PartnerCompanyText> value )
    {
        if( toCnsldtnGlobalCompanyT == null ) {
            toCnsldtnGlobalCompanyT = Lists.newArrayList();
        }
        toCnsldtnGlobalCompanyT.clear();
        toCnsldtnGlobalCompanyT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PartnerCompanyText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnGlobalCompanyT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnGlobalCompanyT</b> of a queried <b>PartnerCompany</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PartnerCompanyText</b> entities.
     */
    public void addCnsldtnGlobalCompanyT( PartnerCompanyText... entity )
    {
        if( toCnsldtnGlobalCompanyT == null ) {
            toCnsldtnGlobalCompanyT = Lists.newArrayList();
        }
        toCnsldtnGlobalCompanyT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of PartnerCompany instances.
     *
     */
    public final static class PartnerCompanyBuilder
    {

        private List<PartnerCompanyText> toCnsldtnGlobalCompanyT = Lists.newArrayList();

        private PartnerCompany.PartnerCompanyBuilder toCnsldtnGlobalCompanyT( final List<PartnerCompanyText> value )
        {
            toCnsldtnGlobalCompanyT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnGlobalCompanyT</b> for <b>PartnerCompany</b> to multiple
         * <b>PartnerCompanyText</b>.
         *
         * @param value
         *            The PartnerCompanyTexts to build this PartnerCompany with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PartnerCompany.PartnerCompanyBuilder cnsldtnGlobalCompanyT( PartnerCompanyText... value )
        {
            return toCnsldtnGlobalCompanyT(Lists.newArrayList(value));
        }

    }

}
