/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.PartnerCompanyTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.PartnerCompanyTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.PartnerCompanyTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Global Company Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PartnerCompanyTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PartnerCompanyText extends VdmEntity<PartnerCompanyText>
{

    /**
     * Selector for all available fields of PartnerCompanyText.
     *
     */
    public final static PartnerCompanyTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return The language contained in this entity.
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static PartnerCompanyTextField<String> LANGUAGE = new PartnerCompanyTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>Company</b>
     * </p>
     *
     * @return Company
     */
    @Key
    @SerializedName( "Company" )
    @JsonProperty( "Company" )
    @Nullable
    @ODataField( odataName = "Company" )
    private String company;
    /**
     * Use with available fluent helpers to apply the <b>Company</b> field to query operations.
     *
     */
    public final static PartnerCompanyTextField<String> COMPANY = new PartnerCompanyTextField<String>("Company");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @return Master Data Source
     */
    @SerializedName( "AdditionalMasterDataSource" )
    @JsonProperty( "AdditionalMasterDataSource" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataSource" )
    private String additionalMasterDataSource;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataSource</b> field to query operations.
     *
     */
    public final static PartnerCompanyTextField<String> ADDITIONAL_MASTER_DATA_SOURCE =
        new PartnerCompanyTextField<String>("AdditionalMasterDataSource");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCompanyText</b>
     * </p>
     *
     * @return Partner Company Description
     */
    @SerializedName( "PartnerCompanyText" )
    @JsonProperty( "PartnerCompanyText" )
    @Nullable
    @ODataField( odataName = "PartnerCompanyText" )
    private String partnerCompanyText;
    /**
     * Use with available fluent helpers to apply the <b>PartnerCompanyText</b> field to query operations.
     *
     */
    public final static PartnerCompanyTextField<String> PARTNER_COMPANY_TEXT =
        new PartnerCompanyTextField<String>("PartnerCompanyText");
    /**
     * Navigation property <b>to_CnsldtnGlobalCompany</b> for <b>PartnerCompanyText</b> to single <b>PartnerCompany</b>.
     *
     */
    @SerializedName( "to_CnsldtnGlobalCompany" )
    @JsonProperty( "to_CnsldtnGlobalCompany" )
    @ODataField( odataName = "to_CnsldtnGlobalCompany" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PartnerCompany toCnsldtnGlobalCompany;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnGlobalCompany</b> navigation property to query
     * operations.
     *
     */
    public final static PartnerCompanyTextOneToOneLink<PartnerCompany> TO_CNSLDTN_GLOBAL_COMPANY =
        new PartnerCompanyTextOneToOneLink<PartnerCompany>("to_CnsldtnGlobalCompany");

    @Nonnull
    @Override
    public Class<PartnerCompanyText> getType()
    {
        return PartnerCompanyText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            The language to set.
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>Company</b>
     * </p>
     *
     * @param company
     *            Company
     */
    public void setCompany( @Nullable final String company )
    {
        rememberChangedField("Company", this.company);
        this.company = company;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @param additionalMasterDataSource
     *            Master Data Source
     */
    public void setAdditionalMasterDataSource( @Nullable final String additionalMasterDataSource )
    {
        rememberChangedField("AdditionalMasterDataSource", this.additionalMasterDataSource);
        this.additionalMasterDataSource = additionalMasterDataSource;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCompanyText</b>
     * </p>
     *
     * @param partnerCompanyText
     *            Partner Company Description
     */
    public void setPartnerCompanyText( @Nullable final String partnerCompanyText )
    {
        rememberChangedField("PartnerCompanyText", this.partnerCompanyText);
        this.partnerCompanyText = partnerCompanyText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PartnerCompanyText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("Company", getCompany());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("Company", getCompany());
        values.put("AdditionalMasterDataSource", getAdditionalMasterDataSource());
        values.put("PartnerCompanyText", getPartnerCompanyText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("Company") ) {
                final Object value = values.remove("Company");
                if( (value == null) || (!value.equals(getCompany())) ) {
                    setCompany(((String) value));
                }
            }
            if( values.containsKey("AdditionalMasterDataSource") ) {
                final Object value = values.remove("AdditionalMasterDataSource");
                if( (value == null) || (!value.equals(getAdditionalMasterDataSource())) ) {
                    setAdditionalMasterDataSource(((String) value));
                }
            }
            if( values.containsKey("PartnerCompanyText") ) {
                final Object value = values.remove("PartnerCompanyText");
                if( (value == null) || (!value.equals(getPartnerCompanyText())) ) {
                    setPartnerCompanyText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnGlobalCompany") ) {
                final Object value = (values).remove("to_CnsldtnGlobalCompany");
                if( value instanceof Map ) {
                    if( toCnsldtnGlobalCompany == null ) {
                        toCnsldtnGlobalCompany = new PartnerCompany();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnGlobalCompany.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PartnerCompanyTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PartnerCompanyTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PartnerCompanyTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PartnerCompanyTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnGlobalCompany != null ) {
            (values).put("to_CnsldtnGlobalCompany", toCnsldtnGlobalCompany);
        }
        return values;
    }

    /**
     * Fetches the <b>PartnerCompany</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnGlobalCompany</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PartnerCompany</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PartnerCompany fetchCnsldtnGlobalCompany()
    {
        return fetchFieldAsSingle("to_CnsldtnGlobalCompany", PartnerCompany.class);
    }

    /**
     * Retrieval of associated <b>PartnerCompany</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnGlobalCompany</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnGlobalCompany</b> of a queried <b>PartnerCompanyText</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PartnerCompany</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PartnerCompany getCnsldtnGlobalCompanyOrFetch()
    {
        if( toCnsldtnGlobalCompany == null ) {
            toCnsldtnGlobalCompany = fetchCnsldtnGlobalCompany();
        }
        return toCnsldtnGlobalCompany;
    }

    /**
     * Retrieval of associated <b>PartnerCompany</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnGlobalCompany</b>.
     * <p>
     * If the navigation property for an entity <b>PartnerCompanyText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnGlobalCompany</b> is already loaded, the result
     *         will contain the <b>PartnerCompany</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PartnerCompany> getCnsldtnGlobalCompanyIfPresent()
    {
        return Option.of(toCnsldtnGlobalCompany);
    }

    /**
     * Overwrites the associated <b>PartnerCompany</b> entity for the loaded navigation property
     * <b>to_CnsldtnGlobalCompany</b>.
     *
     * @param value
     *            New <b>PartnerCompany</b> entity.
     */
    public void setCnsldtnGlobalCompany( final PartnerCompany value )
    {
        toCnsldtnGlobalCompany = value;
    }

    /**
     * Helper class to allow for fluent creation of PartnerCompanyText instances.
     *
     */
    public final static class PartnerCompanyTextBuilder
    {

        private PartnerCompany toCnsldtnGlobalCompany;

        private PartnerCompanyText.PartnerCompanyTextBuilder toCnsldtnGlobalCompany( final PartnerCompany value )
        {
            toCnsldtnGlobalCompany = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnGlobalCompany</b> for <b>PartnerCompanyText</b> to single
         * <b>PartnerCompany</b>.
         *
         * @param value
         *            The PartnerCompany to build this PartnerCompanyText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PartnerCompanyText.PartnerCompanyTextBuilder cnsldtnGlobalCompany( final PartnerCompany value )
        {
            return toCnsldtnGlobalCompany(value);
        }

    }

}
