/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.PartnerCostCenterField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.PartnerCostCenterLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.PartnerCostCenterSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Partner Cost Center
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PartnerCostCenterType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PartnerCostCenter extends VdmEntity<PartnerCostCenter>
{

    /**
     * Selector for all available fields of PartnerCostCenter.
     *
     */
    public final static PartnerCostCenterSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Consolidation Cost Center
     */
    @Key
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static PartnerCostCenterField<String> COST_CENTER = new PartnerCostCenterField<String>("CostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter_Text</b>
     * </p>
     *
     * @return Partner Cost Center Description
     */
    @SerializedName( "CostCenter_Text" )
    @JsonProperty( "CostCenter_Text" )
    @Nullable
    @ODataField( odataName = "CostCenter_Text" )
    private String costCenter_Text;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter_Text</b> field to query operations.
     *
     */
    public final static PartnerCostCenterField<String> COST_CENTER_TEXT =
        new PartnerCostCenterField<String>("CostCenter_Text");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Consolidation Controlling Area
     */
    @Key
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static PartnerCostCenterField<String> CONTROLLING_AREA =
        new PartnerCostCenterField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @return Consolidation Additional Master Data Source
     */
    @SerializedName( "AdditionalMasterDataSource" )
    @JsonProperty( "AdditionalMasterDataSource" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataSource" )
    private String additionalMasterDataSource;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataSource</b> field to query operations.
     *
     */
    public final static PartnerCostCenterField<String> ADDITIONAL_MASTER_DATA_SOURCE =
        new PartnerCostCenterField<String>("AdditionalMasterDataSource");
    /**
     * Navigation property <b>to_CnsldtnPartnerCostCtrHier</b> for <b>PartnerCostCenter</b> to multiple
     * <b>PartnerCostCenterHier</b>.
     *
     */
    @SerializedName( "to_CnsldtnPartnerCostCtrHier" )
    @JsonProperty( "to_CnsldtnPartnerCostCtrHier" )
    @ODataField( odataName = "to_CnsldtnPartnerCostCtrHier" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PartnerCostCenterHier> toCnsldtnPartnerCostCtrHier;
    /**
     * Navigation property <b>to_CnsldtnPartnerCostCtrT</b> for <b>PartnerCostCenter</b> to multiple
     * <b>PartnerCostCenterText</b>.
     *
     */
    @SerializedName( "to_CnsldtnPartnerCostCtrT" )
    @JsonProperty( "to_CnsldtnPartnerCostCtrT" )
    @ODataField( odataName = "to_CnsldtnPartnerCostCtrT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PartnerCostCenterText> toCnsldtnPartnerCostCtrT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnPartnerCostCtrHier</b> navigation property to query
     * operations.
     *
     */
    public final static PartnerCostCenterLink<PartnerCostCenterHier> TO_CNSLDTN_PARTNER_COST_CTR_HIER =
        new PartnerCostCenterLink<PartnerCostCenterHier>("to_CnsldtnPartnerCostCtrHier");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnPartnerCostCtrT</b> navigation property to query
     * operations.
     *
     */
    public final static PartnerCostCenterLink<PartnerCostCenterText> TO_CNSLDTN_PARTNER_COST_CTR_T =
        new PartnerCostCenterLink<PartnerCostCenterText>("to_CnsldtnPartnerCostCtrT");

    @Nonnull
    @Override
    public Class<PartnerCostCenter> getType()
    {
        return PartnerCostCenter.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Consolidation Cost Center
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter_Text</b>
     * </p>
     *
     * @param costCenter_Text
     *            Partner Cost Center Description
     */
    public void setCostCenter_Text( @Nullable final String costCenter_Text )
    {
        rememberChangedField("CostCenter_Text", this.costCenter_Text);
        this.costCenter_Text = costCenter_Text;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Consolidation Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @param additionalMasterDataSource
     *            Consolidation Additional Master Data Source
     */
    public void setAdditionalMasterDataSource( @Nullable final String additionalMasterDataSource )
    {
        rememberChangedField("AdditionalMasterDataSource", this.additionalMasterDataSource);
        this.additionalMasterDataSource = additionalMasterDataSource;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PartnerCostCenter";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CostCenter", getCostCenter());
        result.put("ControllingArea", getControllingArea());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CostCenter", getCostCenter());
        values.put("CostCenter_Text", getCostCenter_Text());
        values.put("ControllingArea", getControllingArea());
        values.put("AdditionalMasterDataSource", getAdditionalMasterDataSource());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("CostCenter_Text") ) {
                final Object value = values.remove("CostCenter_Text");
                if( (value == null) || (!value.equals(getCostCenter_Text())) ) {
                    setCostCenter_Text(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("AdditionalMasterDataSource") ) {
                final Object value = values.remove("AdditionalMasterDataSource");
                if( (value == null) || (!value.equals(getAdditionalMasterDataSource())) ) {
                    setAdditionalMasterDataSource(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnPartnerCostCtrHier") ) {
                final Object value = (values).remove("to_CnsldtnPartnerCostCtrHier");
                if( value instanceof Iterable ) {
                    if( toCnsldtnPartnerCostCtrHier == null ) {
                        toCnsldtnPartnerCostCtrHier = Lists.newArrayList();
                    } else {
                        toCnsldtnPartnerCostCtrHier = Lists.newArrayList(toCnsldtnPartnerCostCtrHier);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PartnerCostCenterHier entity;
                        if( toCnsldtnPartnerCostCtrHier.size() > i ) {
                            entity = toCnsldtnPartnerCostCtrHier.get(i);
                        } else {
                            entity = new PartnerCostCenterHier();
                            toCnsldtnPartnerCostCtrHier.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CnsldtnPartnerCostCtrT") ) {
                final Object value = (values).remove("to_CnsldtnPartnerCostCtrT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnPartnerCostCtrT == null ) {
                        toCnsldtnPartnerCostCtrT = Lists.newArrayList();
                    } else {
                        toCnsldtnPartnerCostCtrT = Lists.newArrayList(toCnsldtnPartnerCostCtrT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PartnerCostCenterText entity;
                        if( toCnsldtnPartnerCostCtrT.size() > i ) {
                            entity = toCnsldtnPartnerCostCtrT.get(i);
                        } else {
                            entity = new PartnerCostCenterText();
                            toCnsldtnPartnerCostCtrT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PartnerCostCenterField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PartnerCostCenterField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PartnerCostCenterField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PartnerCostCenterField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnPartnerCostCtrHier != null ) {
            (values).put("to_CnsldtnPartnerCostCtrHier", toCnsldtnPartnerCostCtrHier);
        }
        if( toCnsldtnPartnerCostCtrT != null ) {
            (values).put("to_CnsldtnPartnerCostCtrT", toCnsldtnPartnerCostCtrT);
        }
        return values;
    }

    /**
     * Fetches the <b>PartnerCostCenterHier</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CnsldtnPartnerCostCtrHier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PartnerCostCenterHier</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PartnerCostCenterHier> fetchCnsldtnPartnerCostCtrHier()
    {
        return fetchFieldAsList("to_CnsldtnPartnerCostCtrHier", PartnerCostCenterHier.class);
    }

    /**
     * Retrieval of associated <b>PartnerCostCenterHier</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnPartnerCostCtrHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPartnerCostCtrHier</b> of a queried <b>PartnerCostCenter</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PartnerCostCenterHier</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PartnerCostCenterHier> getCnsldtnPartnerCostCtrHierOrFetch()
    {
        if( toCnsldtnPartnerCostCtrHier == null ) {
            toCnsldtnPartnerCostCtrHier = fetchCnsldtnPartnerCostCtrHier();
        }
        return toCnsldtnPartnerCostCtrHier;
    }

    /**
     * Retrieval of associated <b>PartnerCostCenterHier</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnPartnerCostCtrHier</b>.
     * <p>
     * If the navigation property for an entity <b>PartnerCostCenter</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnPartnerCostCtrHier</b> is already loaded, the
     *         result will contain the <b>PartnerCostCenterHier</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PartnerCostCenterHier>> getCnsldtnPartnerCostCtrHierIfPresent()
    {
        return Option.of(toCnsldtnPartnerCostCtrHier);
    }

    /**
     * Overwrites the list of associated <b>PartnerCostCenterHier</b> entities for the loaded navigation property
     * <b>to_CnsldtnPartnerCostCtrHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPartnerCostCtrHier</b> of a queried <b>PartnerCostCenter</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PartnerCostCenterHier</b> entities.
     */
    public void setCnsldtnPartnerCostCtrHier( @Nonnull final List<PartnerCostCenterHier> value )
    {
        if( toCnsldtnPartnerCostCtrHier == null ) {
            toCnsldtnPartnerCostCtrHier = Lists.newArrayList();
        }
        toCnsldtnPartnerCostCtrHier.clear();
        toCnsldtnPartnerCostCtrHier.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PartnerCostCenterHier</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnPartnerCostCtrHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPartnerCostCtrHier</b> of a queried <b>PartnerCostCenter</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PartnerCostCenterHier</b> entities.
     */
    public void addCnsldtnPartnerCostCtrHier( PartnerCostCenterHier... entity )
    {
        if( toCnsldtnPartnerCostCtrHier == null ) {
            toCnsldtnPartnerCostCtrHier = Lists.newArrayList();
        }
        toCnsldtnPartnerCostCtrHier.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>PartnerCostCenterText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CnsldtnPartnerCostCtrT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PartnerCostCenterText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PartnerCostCenterText> fetchCnsldtnPartnerCostCtrT()
    {
        return fetchFieldAsList("to_CnsldtnPartnerCostCtrT", PartnerCostCenterText.class);
    }

    /**
     * Retrieval of associated <b>PartnerCostCenterText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnPartnerCostCtrT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPartnerCostCtrT</b> of a queried <b>PartnerCostCenter</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PartnerCostCenterText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PartnerCostCenterText> getCnsldtnPartnerCostCtrTOrFetch()
    {
        if( toCnsldtnPartnerCostCtrT == null ) {
            toCnsldtnPartnerCostCtrT = fetchCnsldtnPartnerCostCtrT();
        }
        return toCnsldtnPartnerCostCtrT;
    }

    /**
     * Retrieval of associated <b>PartnerCostCenterText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnPartnerCostCtrT</b>.
     * <p>
     * If the navigation property for an entity <b>PartnerCostCenter</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnPartnerCostCtrT</b> is already loaded, the result
     *         will contain the <b>PartnerCostCenterText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PartnerCostCenterText>> getCnsldtnPartnerCostCtrTIfPresent()
    {
        return Option.of(toCnsldtnPartnerCostCtrT);
    }

    /**
     * Overwrites the list of associated <b>PartnerCostCenterText</b> entities for the loaded navigation property
     * <b>to_CnsldtnPartnerCostCtrT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPartnerCostCtrT</b> of a queried <b>PartnerCostCenter</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PartnerCostCenterText</b> entities.
     */
    public void setCnsldtnPartnerCostCtrT( @Nonnull final List<PartnerCostCenterText> value )
    {
        if( toCnsldtnPartnerCostCtrT == null ) {
            toCnsldtnPartnerCostCtrT = Lists.newArrayList();
        }
        toCnsldtnPartnerCostCtrT.clear();
        toCnsldtnPartnerCostCtrT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PartnerCostCenterText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnPartnerCostCtrT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPartnerCostCtrT</b> of a queried <b>PartnerCostCenter</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PartnerCostCenterText</b> entities.
     */
    public void addCnsldtnPartnerCostCtrT( PartnerCostCenterText... entity )
    {
        if( toCnsldtnPartnerCostCtrT == null ) {
            toCnsldtnPartnerCostCtrT = Lists.newArrayList();
        }
        toCnsldtnPartnerCostCtrT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of PartnerCostCenter instances.
     *
     */
    public final static class PartnerCostCenterBuilder
    {

        private List<PartnerCostCenterHier> toCnsldtnPartnerCostCtrHier = Lists.newArrayList();
        private List<PartnerCostCenterText> toCnsldtnPartnerCostCtrT = Lists.newArrayList();

        private PartnerCostCenter.PartnerCostCenterBuilder toCnsldtnPartnerCostCtrHier(
            final List<PartnerCostCenterHier> value )
        {
            toCnsldtnPartnerCostCtrHier.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnPartnerCostCtrHier</b> for <b>PartnerCostCenter</b> to multiple
         * <b>PartnerCostCenterHier</b>.
         *
         * @param value
         *            The PartnerCostCenterHiers to build this PartnerCostCenter with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PartnerCostCenter.PartnerCostCenterBuilder cnsldtnPartnerCostCtrHier( PartnerCostCenterHier... value )
        {
            return toCnsldtnPartnerCostCtrHier(Lists.newArrayList(value));
        }

        private PartnerCostCenter.PartnerCostCenterBuilder toCnsldtnPartnerCostCtrT(
            final List<PartnerCostCenterText> value )
        {
            toCnsldtnPartnerCostCtrT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnPartnerCostCtrT</b> for <b>PartnerCostCenter</b> to multiple
         * <b>PartnerCostCenterText</b>.
         *
         * @param value
         *            The PartnerCostCenterTexts to build this PartnerCostCenter with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PartnerCostCenter.PartnerCostCenterBuilder cnsldtnPartnerCostCtrT( PartnerCostCenterText... value )
        {
            return toCnsldtnPartnerCostCtrT(Lists.newArrayList(value));
        }

    }

}
