/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.PartnerCostCenterTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.PartnerCostCenterTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.PartnerCostCenterTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Partner Cost Center - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PartnerCostCenterTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PartnerCostCenterText extends VdmEntity<PartnerCostCenterText>
{

    /**
     * Selector for all available fields of PartnerCostCenterText.
     *
     */
    public final static PartnerCostCenterTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static PartnerCostCenterTextField<String> LANGUAGE =
        new PartnerCostCenterTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Partner Cost Center
     */
    @Key
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static PartnerCostCenterTextField<String> COST_CENTER =
        new PartnerCostCenterTextField<String>("CostCenter");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Consolidation Controlling Area
     */
    @Key
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static PartnerCostCenterTextField<String> CONTROLLING_AREA =
        new PartnerCostCenterTextField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCostCenterText</b>
     * </p>
     *
     * @return Partner Cost Center Description
     */
    @SerializedName( "PartnerCostCenterText" )
    @JsonProperty( "PartnerCostCenterText" )
    @Nullable
    @ODataField( odataName = "PartnerCostCenterText" )
    private String partnerCostCenterText;
    /**
     * Use with available fluent helpers to apply the <b>PartnerCostCenterText</b> field to query operations.
     *
     */
    public final static PartnerCostCenterTextField<String> PARTNER_COST_CENTER_TEXT =
        new PartnerCostCenterTextField<String>("PartnerCostCenterText");
    /**
     * Navigation property <b>to_CnsldtnPartnerCostCenter</b> for <b>PartnerCostCenterText</b> to single
     * <b>PartnerCostCenter</b>.
     *
     */
    @SerializedName( "to_CnsldtnPartnerCostCenter" )
    @JsonProperty( "to_CnsldtnPartnerCostCenter" )
    @ODataField( odataName = "to_CnsldtnPartnerCostCenter" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PartnerCostCenter toCnsldtnPartnerCostCenter;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnPartnerCostCenter</b> navigation property to query
     * operations.
     *
     */
    public final static PartnerCostCenterTextOneToOneLink<PartnerCostCenter> TO_CNSLDTN_PARTNER_COST_CENTER =
        new PartnerCostCenterTextOneToOneLink<PartnerCostCenter>("to_CnsldtnPartnerCostCenter");

    @Nonnull
    @Override
    public Class<PartnerCostCenterText> getType()
    {
        return PartnerCostCenterText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Partner Cost Center
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Consolidation Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCostCenterText</b>
     * </p>
     *
     * @param partnerCostCenterText
     *            Partner Cost Center Description
     */
    public void setPartnerCostCenterText( @Nullable final String partnerCostCenterText )
    {
        rememberChangedField("PartnerCostCenterText", this.partnerCostCenterText);
        this.partnerCostCenterText = partnerCostCenterText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PartnerCostCenterText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("CostCenter", getCostCenter());
        result.put("ControllingArea", getControllingArea());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("CostCenter", getCostCenter());
        values.put("ControllingArea", getControllingArea());
        values.put("PartnerCostCenterText", getPartnerCostCenterText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("PartnerCostCenterText") ) {
                final Object value = values.remove("PartnerCostCenterText");
                if( (value == null) || (!value.equals(getPartnerCostCenterText())) ) {
                    setPartnerCostCenterText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnPartnerCostCenter") ) {
                final Object value = (values).remove("to_CnsldtnPartnerCostCenter");
                if( value instanceof Map ) {
                    if( toCnsldtnPartnerCostCenter == null ) {
                        toCnsldtnPartnerCostCenter = new PartnerCostCenter();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnPartnerCostCenter.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PartnerCostCenterTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PartnerCostCenterTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PartnerCostCenterTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PartnerCostCenterTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnPartnerCostCenter != null ) {
            (values).put("to_CnsldtnPartnerCostCenter", toCnsldtnPartnerCostCenter);
        }
        return values;
    }

    /**
     * Fetches the <b>PartnerCostCenter</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnPartnerCostCenter</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PartnerCostCenter</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PartnerCostCenter fetchCnsldtnPartnerCostCenter()
    {
        return fetchFieldAsSingle("to_CnsldtnPartnerCostCenter", PartnerCostCenter.class);
    }

    /**
     * Retrieval of associated <b>PartnerCostCenter</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnPartnerCostCenter</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPartnerCostCenter</b> of a queried <b>PartnerCostCenterText</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PartnerCostCenter</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PartnerCostCenter getCnsldtnPartnerCostCenterOrFetch()
    {
        if( toCnsldtnPartnerCostCenter == null ) {
            toCnsldtnPartnerCostCenter = fetchCnsldtnPartnerCostCenter();
        }
        return toCnsldtnPartnerCostCenter;
    }

    /**
     * Retrieval of associated <b>PartnerCostCenter</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnPartnerCostCenter</b>.
     * <p>
     * If the navigation property for an entity <b>PartnerCostCenterText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnPartnerCostCenter</b> is already loaded, the
     *         result will contain the <b>PartnerCostCenter</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PartnerCostCenter> getCnsldtnPartnerCostCenterIfPresent()
    {
        return Option.of(toCnsldtnPartnerCostCenter);
    }

    /**
     * Overwrites the associated <b>PartnerCostCenter</b> entity for the loaded navigation property
     * <b>to_CnsldtnPartnerCostCenter</b>.
     *
     * @param value
     *            New <b>PartnerCostCenter</b> entity.
     */
    public void setCnsldtnPartnerCostCenter( final PartnerCostCenter value )
    {
        toCnsldtnPartnerCostCenter = value;
    }

    /**
     * Helper class to allow for fluent creation of PartnerCostCenterText instances.
     *
     */
    public final static class PartnerCostCenterTextBuilder
    {

        private PartnerCostCenter toCnsldtnPartnerCostCenter;

        private PartnerCostCenterText.PartnerCostCenterTextBuilder toCnsldtnPartnerCostCenter(
            final PartnerCostCenter value )
        {
            toCnsldtnPartnerCostCenter = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnPartnerCostCenter</b> for <b>PartnerCostCenterText</b> to single
         * <b>PartnerCostCenter</b>.
         *
         * @param value
         *            The PartnerCostCenter to build this PartnerCostCenterText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PartnerCostCenterText.PartnerCostCenterTextBuilder cnsldtnPartnerCostCenter(
            final PartnerCostCenter value )
        {
            return toCnsldtnPartnerCostCenter(value);
        }

    }

}
