/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.PartnerFunctionalAreaField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.PartnerFunctionalAreaLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.PartnerFunctionalAreaSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Partner Functional Area
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PartnerFunctionalAreaType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PartnerFunctionalArea extends VdmEntity<PartnerFunctionalArea>
{

    /**
     * Selector for all available fields of PartnerFunctionalArea.
     *
     */
    public final static PartnerFunctionalAreaSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @return Consolidation Functional Area
     */
    @Key
    @SerializedName( "FunctionalArea" )
    @JsonProperty( "FunctionalArea" )
    @Nullable
    @ODataField( odataName = "FunctionalArea" )
    private String functionalArea;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalArea</b> field to query operations.
     *
     */
    public final static PartnerFunctionalAreaField<String> FUNCTIONAL_AREA =
        new PartnerFunctionalAreaField<String>("FunctionalArea");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea_Text</b>
     * </p>
     *
     * @return Partner Functional Area Description
     */
    @SerializedName( "FunctionalArea_Text" )
    @JsonProperty( "FunctionalArea_Text" )
    @Nullable
    @ODataField( odataName = "FunctionalArea_Text" )
    private String functionalArea_Text;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalArea_Text</b> field to query operations.
     *
     */
    public final static PartnerFunctionalAreaField<String> FUNCTIONAL_AREA_TEXT =
        new PartnerFunctionalAreaField<String>("FunctionalArea_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @return Consolidation Additional Master Data Source
     */
    @SerializedName( "AdditionalMasterDataSource" )
    @JsonProperty( "AdditionalMasterDataSource" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataSource" )
    private String additionalMasterDataSource;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataSource</b> field to query operations.
     *
     */
    public final static PartnerFunctionalAreaField<String> ADDITIONAL_MASTER_DATA_SOURCE =
        new PartnerFunctionalAreaField<String>("AdditionalMasterDataSource");
    /**
     * Navigation property <b>to_CnsldtnPartFuncnlAreaHier</b> for <b>PartnerFunctionalArea</b> to multiple
     * <b>PartnerFunctionalAreaHier</b>.
     *
     */
    @SerializedName( "to_CnsldtnPartFuncnlAreaHier" )
    @JsonProperty( "to_CnsldtnPartFuncnlAreaHier" )
    @ODataField( odataName = "to_CnsldtnPartFuncnlAreaHier" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PartnerFunctionalAreaHier> toCnsldtnPartFuncnlAreaHier;
    /**
     * Navigation property <b>to_CnsldtnPartFuncnlAreaT</b> for <b>PartnerFunctionalArea</b> to multiple
     * <b>PartnerFunctionalAreaText</b>.
     *
     */
    @SerializedName( "to_CnsldtnPartFuncnlAreaT" )
    @JsonProperty( "to_CnsldtnPartFuncnlAreaT" )
    @ODataField( odataName = "to_CnsldtnPartFuncnlAreaT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PartnerFunctionalAreaText> toCnsldtnPartFuncnlAreaT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnPartFuncnlAreaHier</b> navigation property to query
     * operations.
     *
     */
    public final static PartnerFunctionalAreaLink<PartnerFunctionalAreaHier> TO_CNSLDTN_PART_FUNCNL_AREA_HIER =
        new PartnerFunctionalAreaLink<PartnerFunctionalAreaHier>("to_CnsldtnPartFuncnlAreaHier");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnPartFuncnlAreaT</b> navigation property to query
     * operations.
     *
     */
    public final static PartnerFunctionalAreaLink<PartnerFunctionalAreaText> TO_CNSLDTN_PART_FUNCNL_AREA_T =
        new PartnerFunctionalAreaLink<PartnerFunctionalAreaText>("to_CnsldtnPartFuncnlAreaT");

    @Nonnull
    @Override
    public Class<PartnerFunctionalArea> getType()
    {
        return PartnerFunctionalArea.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @param functionalArea
     *            Consolidation Functional Area
     */
    public void setFunctionalArea( @Nullable final String functionalArea )
    {
        rememberChangedField("FunctionalArea", this.functionalArea);
        this.functionalArea = functionalArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea_Text</b>
     * </p>
     *
     * @param functionalArea_Text
     *            Partner Functional Area Description
     */
    public void setFunctionalArea_Text( @Nullable final String functionalArea_Text )
    {
        rememberChangedField("FunctionalArea_Text", this.functionalArea_Text);
        this.functionalArea_Text = functionalArea_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @param additionalMasterDataSource
     *            Consolidation Additional Master Data Source
     */
    public void setAdditionalMasterDataSource( @Nullable final String additionalMasterDataSource )
    {
        rememberChangedField("AdditionalMasterDataSource", this.additionalMasterDataSource);
        this.additionalMasterDataSource = additionalMasterDataSource;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PartnerFunctionalArea";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("FunctionalArea", getFunctionalArea());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("FunctionalArea", getFunctionalArea());
        values.put("FunctionalArea_Text", getFunctionalArea_Text());
        values.put("AdditionalMasterDataSource", getAdditionalMasterDataSource());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("FunctionalArea") ) {
                final Object value = values.remove("FunctionalArea");
                if( (value == null) || (!value.equals(getFunctionalArea())) ) {
                    setFunctionalArea(((String) value));
                }
            }
            if( values.containsKey("FunctionalArea_Text") ) {
                final Object value = values.remove("FunctionalArea_Text");
                if( (value == null) || (!value.equals(getFunctionalArea_Text())) ) {
                    setFunctionalArea_Text(((String) value));
                }
            }
            if( values.containsKey("AdditionalMasterDataSource") ) {
                final Object value = values.remove("AdditionalMasterDataSource");
                if( (value == null) || (!value.equals(getAdditionalMasterDataSource())) ) {
                    setAdditionalMasterDataSource(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnPartFuncnlAreaHier") ) {
                final Object value = (values).remove("to_CnsldtnPartFuncnlAreaHier");
                if( value instanceof Iterable ) {
                    if( toCnsldtnPartFuncnlAreaHier == null ) {
                        toCnsldtnPartFuncnlAreaHier = Lists.newArrayList();
                    } else {
                        toCnsldtnPartFuncnlAreaHier = Lists.newArrayList(toCnsldtnPartFuncnlAreaHier);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PartnerFunctionalAreaHier entity;
                        if( toCnsldtnPartFuncnlAreaHier.size() > i ) {
                            entity = toCnsldtnPartFuncnlAreaHier.get(i);
                        } else {
                            entity = new PartnerFunctionalAreaHier();
                            toCnsldtnPartFuncnlAreaHier.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CnsldtnPartFuncnlAreaT") ) {
                final Object value = (values).remove("to_CnsldtnPartFuncnlAreaT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnPartFuncnlAreaT == null ) {
                        toCnsldtnPartFuncnlAreaT = Lists.newArrayList();
                    } else {
                        toCnsldtnPartFuncnlAreaT = Lists.newArrayList(toCnsldtnPartFuncnlAreaT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PartnerFunctionalAreaText entity;
                        if( toCnsldtnPartFuncnlAreaT.size() > i ) {
                            entity = toCnsldtnPartFuncnlAreaT.get(i);
                        } else {
                            entity = new PartnerFunctionalAreaText();
                            toCnsldtnPartFuncnlAreaT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PartnerFunctionalAreaField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PartnerFunctionalAreaField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PartnerFunctionalAreaField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PartnerFunctionalAreaField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnPartFuncnlAreaHier != null ) {
            (values).put("to_CnsldtnPartFuncnlAreaHier", toCnsldtnPartFuncnlAreaHier);
        }
        if( toCnsldtnPartFuncnlAreaT != null ) {
            (values).put("to_CnsldtnPartFuncnlAreaT", toCnsldtnPartFuncnlAreaT);
        }
        return values;
    }

    /**
     * Fetches the <b>PartnerFunctionalAreaHier</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CnsldtnPartFuncnlAreaHier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PartnerFunctionalAreaHier</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PartnerFunctionalAreaHier> fetchCnsldtnPartFuncnlAreaHier()
    {
        return fetchFieldAsList("to_CnsldtnPartFuncnlAreaHier", PartnerFunctionalAreaHier.class);
    }

    /**
     * Retrieval of associated <b>PartnerFunctionalAreaHier</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnPartFuncnlAreaHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPartFuncnlAreaHier</b> of a queried <b>PartnerFunctionalArea</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PartnerFunctionalAreaHier</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PartnerFunctionalAreaHier> getCnsldtnPartFuncnlAreaHierOrFetch()
    {
        if( toCnsldtnPartFuncnlAreaHier == null ) {
            toCnsldtnPartFuncnlAreaHier = fetchCnsldtnPartFuncnlAreaHier();
        }
        return toCnsldtnPartFuncnlAreaHier;
    }

    /**
     * Retrieval of associated <b>PartnerFunctionalAreaHier</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnPartFuncnlAreaHier</b>.
     * <p>
     * If the navigation property for an entity <b>PartnerFunctionalArea</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnPartFuncnlAreaHier</b> is already loaded, the
     *         result will contain the <b>PartnerFunctionalAreaHier</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PartnerFunctionalAreaHier>> getCnsldtnPartFuncnlAreaHierIfPresent()
    {
        return Option.of(toCnsldtnPartFuncnlAreaHier);
    }

    /**
     * Overwrites the list of associated <b>PartnerFunctionalAreaHier</b> entities for the loaded navigation property
     * <b>to_CnsldtnPartFuncnlAreaHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPartFuncnlAreaHier</b> of a queried <b>PartnerFunctionalArea</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PartnerFunctionalAreaHier</b> entities.
     */
    public void setCnsldtnPartFuncnlAreaHier( @Nonnull final List<PartnerFunctionalAreaHier> value )
    {
        if( toCnsldtnPartFuncnlAreaHier == null ) {
            toCnsldtnPartFuncnlAreaHier = Lists.newArrayList();
        }
        toCnsldtnPartFuncnlAreaHier.clear();
        toCnsldtnPartFuncnlAreaHier.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PartnerFunctionalAreaHier</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnPartFuncnlAreaHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPartFuncnlAreaHier</b> of a queried <b>PartnerFunctionalArea</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PartnerFunctionalAreaHier</b> entities.
     */
    public void addCnsldtnPartFuncnlAreaHier( PartnerFunctionalAreaHier... entity )
    {
        if( toCnsldtnPartFuncnlAreaHier == null ) {
            toCnsldtnPartFuncnlAreaHier = Lists.newArrayList();
        }
        toCnsldtnPartFuncnlAreaHier.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>PartnerFunctionalAreaText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CnsldtnPartFuncnlAreaT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PartnerFunctionalAreaText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PartnerFunctionalAreaText> fetchCnsldtnPartFuncnlAreaT()
    {
        return fetchFieldAsList("to_CnsldtnPartFuncnlAreaT", PartnerFunctionalAreaText.class);
    }

    /**
     * Retrieval of associated <b>PartnerFunctionalAreaText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnPartFuncnlAreaT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPartFuncnlAreaT</b> of a queried <b>PartnerFunctionalArea</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PartnerFunctionalAreaText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PartnerFunctionalAreaText> getCnsldtnPartFuncnlAreaTOrFetch()
    {
        if( toCnsldtnPartFuncnlAreaT == null ) {
            toCnsldtnPartFuncnlAreaT = fetchCnsldtnPartFuncnlAreaT();
        }
        return toCnsldtnPartFuncnlAreaT;
    }

    /**
     * Retrieval of associated <b>PartnerFunctionalAreaText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnPartFuncnlAreaT</b>.
     * <p>
     * If the navigation property for an entity <b>PartnerFunctionalArea</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnPartFuncnlAreaT</b> is already loaded, the result
     *         will contain the <b>PartnerFunctionalAreaText</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PartnerFunctionalAreaText>> getCnsldtnPartFuncnlAreaTIfPresent()
    {
        return Option.of(toCnsldtnPartFuncnlAreaT);
    }

    /**
     * Overwrites the list of associated <b>PartnerFunctionalAreaText</b> entities for the loaded navigation property
     * <b>to_CnsldtnPartFuncnlAreaT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPartFuncnlAreaT</b> of a queried <b>PartnerFunctionalArea</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PartnerFunctionalAreaText</b> entities.
     */
    public void setCnsldtnPartFuncnlAreaT( @Nonnull final List<PartnerFunctionalAreaText> value )
    {
        if( toCnsldtnPartFuncnlAreaT == null ) {
            toCnsldtnPartFuncnlAreaT = Lists.newArrayList();
        }
        toCnsldtnPartFuncnlAreaT.clear();
        toCnsldtnPartFuncnlAreaT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PartnerFunctionalAreaText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnPartFuncnlAreaT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPartFuncnlAreaT</b> of a queried <b>PartnerFunctionalArea</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PartnerFunctionalAreaText</b> entities.
     */
    public void addCnsldtnPartFuncnlAreaT( PartnerFunctionalAreaText... entity )
    {
        if( toCnsldtnPartFuncnlAreaT == null ) {
            toCnsldtnPartFuncnlAreaT = Lists.newArrayList();
        }
        toCnsldtnPartFuncnlAreaT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of PartnerFunctionalArea instances.
     *
     */
    public final static class PartnerFunctionalAreaBuilder
    {

        private List<PartnerFunctionalAreaHier> toCnsldtnPartFuncnlAreaHier = Lists.newArrayList();
        private List<PartnerFunctionalAreaText> toCnsldtnPartFuncnlAreaT = Lists.newArrayList();

        private PartnerFunctionalArea.PartnerFunctionalAreaBuilder toCnsldtnPartFuncnlAreaHier(
            final List<PartnerFunctionalAreaHier> value )
        {
            toCnsldtnPartFuncnlAreaHier.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnPartFuncnlAreaHier</b> for <b>PartnerFunctionalArea</b> to multiple
         * <b>PartnerFunctionalAreaHier</b>.
         *
         * @param value
         *            The PartnerFunctionalAreaHiers to build this PartnerFunctionalArea with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PartnerFunctionalArea.PartnerFunctionalAreaBuilder cnsldtnPartFuncnlAreaHier(
            PartnerFunctionalAreaHier... value )
        {
            return toCnsldtnPartFuncnlAreaHier(Lists.newArrayList(value));
        }

        private PartnerFunctionalArea.PartnerFunctionalAreaBuilder toCnsldtnPartFuncnlAreaT(
            final List<PartnerFunctionalAreaText> value )
        {
            toCnsldtnPartFuncnlAreaT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnPartFuncnlAreaT</b> for <b>PartnerFunctionalArea</b> to multiple
         * <b>PartnerFunctionalAreaText</b>.
         *
         * @param value
         *            The PartnerFunctionalAreaTexts to build this PartnerFunctionalArea with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PartnerFunctionalArea.PartnerFunctionalAreaBuilder cnsldtnPartFuncnlAreaT(
            PartnerFunctionalAreaText... value )
        {
            return toCnsldtnPartFuncnlAreaT(Lists.newArrayList(value));
        }

    }

}
