/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.PartnerFunctionalAreaTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.PartnerFunctionalAreaTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.PartnerFunctionalAreaTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Partner Functional Area Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PartnerFunctionalAreaTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PartnerFunctionalAreaText extends VdmEntity<PartnerFunctionalAreaText>
{

    /**
     * Selector for all available fields of PartnerFunctionalAreaText.
     *
     */
    public final static PartnerFunctionalAreaTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static PartnerFunctionalAreaTextField<String> LANGUAGE =
        new PartnerFunctionalAreaTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @return Partner Functional Area
     */
    @Key
    @SerializedName( "FunctionalArea" )
    @JsonProperty( "FunctionalArea" )
    @Nullable
    @ODataField( odataName = "FunctionalArea" )
    private String functionalArea;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalArea</b> field to query operations.
     *
     */
    public final static PartnerFunctionalAreaTextField<String> FUNCTIONAL_AREA =
        new PartnerFunctionalAreaTextField<String>("FunctionalArea");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunctionalAreaText</b>
     * </p>
     *
     * @return Partner Functional Area Description
     */
    @SerializedName( "PartnerFunctionalAreaText" )
    @JsonProperty( "PartnerFunctionalAreaText" )
    @Nullable
    @ODataField( odataName = "PartnerFunctionalAreaText" )
    private String partnerFunctionalAreaText;
    /**
     * Use with available fluent helpers to apply the <b>PartnerFunctionalAreaText</b> field to query operations.
     *
     */
    public final static PartnerFunctionalAreaTextField<String> PARTNER_FUNCTIONAL_AREA_TEXT =
        new PartnerFunctionalAreaTextField<String>("PartnerFunctionalAreaText");
    /**
     * Navigation property <b>to_CnsldtnPartnerFuncnlArea</b> for <b>PartnerFunctionalAreaText</b> to single
     * <b>PartnerFunctionalArea</b>.
     *
     */
    @SerializedName( "to_CnsldtnPartnerFuncnlArea" )
    @JsonProperty( "to_CnsldtnPartnerFuncnlArea" )
    @ODataField( odataName = "to_CnsldtnPartnerFuncnlArea" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PartnerFunctionalArea toCnsldtnPartnerFuncnlArea;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnPartnerFuncnlArea</b> navigation property to query
     * operations.
     *
     */
    public final static PartnerFunctionalAreaTextOneToOneLink<PartnerFunctionalArea> TO_CNSLDTN_PARTNER_FUNCNL_AREA =
        new PartnerFunctionalAreaTextOneToOneLink<PartnerFunctionalArea>("to_CnsldtnPartnerFuncnlArea");

    @Nonnull
    @Override
    public Class<PartnerFunctionalAreaText> getType()
    {
        return PartnerFunctionalAreaText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @param functionalArea
     *            Partner Functional Area
     */
    public void setFunctionalArea( @Nullable final String functionalArea )
    {
        rememberChangedField("FunctionalArea", this.functionalArea);
        this.functionalArea = functionalArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunctionalAreaText</b>
     * </p>
     *
     * @param partnerFunctionalAreaText
     *            Partner Functional Area Description
     */
    public void setPartnerFunctionalAreaText( @Nullable final String partnerFunctionalAreaText )
    {
        rememberChangedField("PartnerFunctionalAreaText", this.partnerFunctionalAreaText);
        this.partnerFunctionalAreaText = partnerFunctionalAreaText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PartnerFunctionalAreaText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("FunctionalArea", getFunctionalArea());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("FunctionalArea", getFunctionalArea());
        values.put("PartnerFunctionalAreaText", getPartnerFunctionalAreaText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("FunctionalArea") ) {
                final Object value = values.remove("FunctionalArea");
                if( (value == null) || (!value.equals(getFunctionalArea())) ) {
                    setFunctionalArea(((String) value));
                }
            }
            if( values.containsKey("PartnerFunctionalAreaText") ) {
                final Object value = values.remove("PartnerFunctionalAreaText");
                if( (value == null) || (!value.equals(getPartnerFunctionalAreaText())) ) {
                    setPartnerFunctionalAreaText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnPartnerFuncnlArea") ) {
                final Object value = (values).remove("to_CnsldtnPartnerFuncnlArea");
                if( value instanceof Map ) {
                    if( toCnsldtnPartnerFuncnlArea == null ) {
                        toCnsldtnPartnerFuncnlArea = new PartnerFunctionalArea();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnPartnerFuncnlArea.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PartnerFunctionalAreaTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PartnerFunctionalAreaTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PartnerFunctionalAreaTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PartnerFunctionalAreaTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnPartnerFuncnlArea != null ) {
            (values).put("to_CnsldtnPartnerFuncnlArea", toCnsldtnPartnerFuncnlArea);
        }
        return values;
    }

    /**
     * Fetches the <b>PartnerFunctionalArea</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnPartnerFuncnlArea</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PartnerFunctionalArea</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PartnerFunctionalArea fetchCnsldtnPartnerFuncnlArea()
    {
        return fetchFieldAsSingle("to_CnsldtnPartnerFuncnlArea", PartnerFunctionalArea.class);
    }

    /**
     * Retrieval of associated <b>PartnerFunctionalArea</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnPartnerFuncnlArea</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPartnerFuncnlArea</b> of a queried <b>PartnerFunctionalAreaText</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PartnerFunctionalArea</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PartnerFunctionalArea getCnsldtnPartnerFuncnlAreaOrFetch()
    {
        if( toCnsldtnPartnerFuncnlArea == null ) {
            toCnsldtnPartnerFuncnlArea = fetchCnsldtnPartnerFuncnlArea();
        }
        return toCnsldtnPartnerFuncnlArea;
    }

    /**
     * Retrieval of associated <b>PartnerFunctionalArea</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnPartnerFuncnlArea</b>.
     * <p>
     * If the navigation property for an entity <b>PartnerFunctionalAreaText</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnPartnerFuncnlArea</b> is already loaded, the
     *         result will contain the <b>PartnerFunctionalArea</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PartnerFunctionalArea> getCnsldtnPartnerFuncnlAreaIfPresent()
    {
        return Option.of(toCnsldtnPartnerFuncnlArea);
    }

    /**
     * Overwrites the associated <b>PartnerFunctionalArea</b> entity for the loaded navigation property
     * <b>to_CnsldtnPartnerFuncnlArea</b>.
     *
     * @param value
     *            New <b>PartnerFunctionalArea</b> entity.
     */
    public void setCnsldtnPartnerFuncnlArea( final PartnerFunctionalArea value )
    {
        toCnsldtnPartnerFuncnlArea = value;
    }

    /**
     * Helper class to allow for fluent creation of PartnerFunctionalAreaText instances.
     *
     */
    public final static class PartnerFunctionalAreaTextBuilder
    {

        private PartnerFunctionalArea toCnsldtnPartnerFuncnlArea;

        private PartnerFunctionalAreaText.PartnerFunctionalAreaTextBuilder toCnsldtnPartnerFuncnlArea(
            final PartnerFunctionalArea value )
        {
            toCnsldtnPartnerFuncnlArea = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnPartnerFuncnlArea</b> for <b>PartnerFunctionalAreaText</b> to single
         * <b>PartnerFunctionalArea</b>.
         *
         * @param value
         *            The PartnerFunctionalArea to build this PartnerFunctionalAreaText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PartnerFunctionalAreaText.PartnerFunctionalAreaTextBuilder cnsldtnPartnerFuncnlArea(
            final PartnerFunctionalArea value )
        {
            return toCnsldtnPartnerFuncnlArea(value);
        }

    }

}
