/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.PartnerProfitCenterField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.PartnerProfitCenterLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.PartnerProfitCenterSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Partner Profit Center
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PartnerProfitCenterType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PartnerProfitCenter extends VdmEntity<PartnerProfitCenter>
{

    /**
     * Selector for all available fields of PartnerProfitCenter.
     *
     */
    public final static PartnerProfitCenterSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Consolidation Profit Center
     */
    @Key
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static PartnerProfitCenterField<String> PROFIT_CENTER =
        new PartnerProfitCenterField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter_Text</b>
     * </p>
     *
     * @return Partner Profit Center Description
     */
    @SerializedName( "ProfitCenter_Text" )
    @JsonProperty( "ProfitCenter_Text" )
    @Nullable
    @ODataField( odataName = "ProfitCenter_Text" )
    private String profitCenter_Text;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter_Text</b> field to query operations.
     *
     */
    public final static PartnerProfitCenterField<String> PROFIT_CENTER_TEXT =
        new PartnerProfitCenterField<String>("ProfitCenter_Text");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Consolidation Controlling Area
     */
    @Key
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static PartnerProfitCenterField<String> CONTROLLING_AREA =
        new PartnerProfitCenterField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @return Consolidation Additional Master Data Source
     */
    @SerializedName( "AdditionalMasterDataSource" )
    @JsonProperty( "AdditionalMasterDataSource" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataSource" )
    private String additionalMasterDataSource;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataSource</b> field to query operations.
     *
     */
    public final static PartnerProfitCenterField<String> ADDITIONAL_MASTER_DATA_SOURCE =
        new PartnerProfitCenterField<String>("AdditionalMasterDataSource");
    /**
     * Navigation property <b>to_CnsldtnPartnerPrftCtrHier</b> for <b>PartnerProfitCenter</b> to multiple
     * <b>PartnerProfitCenterHier</b>.
     *
     */
    @SerializedName( "to_CnsldtnPartnerPrftCtrHier" )
    @JsonProperty( "to_CnsldtnPartnerPrftCtrHier" )
    @ODataField( odataName = "to_CnsldtnPartnerPrftCtrHier" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PartnerProfitCenterHier> toCnsldtnPartnerPrftCtrHier;
    /**
     * Navigation property <b>to_CnsldtnPartnerPrftCtrT</b> for <b>PartnerProfitCenter</b> to multiple
     * <b>PartnerProfitCenterText</b>.
     *
     */
    @SerializedName( "to_CnsldtnPartnerPrftCtrT" )
    @JsonProperty( "to_CnsldtnPartnerPrftCtrT" )
    @ODataField( odataName = "to_CnsldtnPartnerPrftCtrT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PartnerProfitCenterText> toCnsldtnPartnerPrftCtrT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnPartnerPrftCtrHier</b> navigation property to query
     * operations.
     *
     */
    public final static PartnerProfitCenterLink<PartnerProfitCenterHier> TO_CNSLDTN_PARTNER_PRFT_CTR_HIER =
        new PartnerProfitCenterLink<PartnerProfitCenterHier>("to_CnsldtnPartnerPrftCtrHier");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnPartnerPrftCtrT</b> navigation property to query
     * operations.
     *
     */
    public final static PartnerProfitCenterLink<PartnerProfitCenterText> TO_CNSLDTN_PARTNER_PRFT_CTR_T =
        new PartnerProfitCenterLink<PartnerProfitCenterText>("to_CnsldtnPartnerPrftCtrT");

    @Nonnull
    @Override
    public Class<PartnerProfitCenter> getType()
    {
        return PartnerProfitCenter.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Consolidation Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter_Text</b>
     * </p>
     *
     * @param profitCenter_Text
     *            Partner Profit Center Description
     */
    public void setProfitCenter_Text( @Nullable final String profitCenter_Text )
    {
        rememberChangedField("ProfitCenter_Text", this.profitCenter_Text);
        this.profitCenter_Text = profitCenter_Text;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Consolidation Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @param additionalMasterDataSource
     *            Consolidation Additional Master Data Source
     */
    public void setAdditionalMasterDataSource( @Nullable final String additionalMasterDataSource )
    {
        rememberChangedField("AdditionalMasterDataSource", this.additionalMasterDataSource);
        this.additionalMasterDataSource = additionalMasterDataSource;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PartnerProfitCenter";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProfitCenter", getProfitCenter());
        result.put("ControllingArea", getControllingArea());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ProfitCenter", getProfitCenter());
        values.put("ProfitCenter_Text", getProfitCenter_Text());
        values.put("ControllingArea", getControllingArea());
        values.put("AdditionalMasterDataSource", getAdditionalMasterDataSource());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter_Text") ) {
                final Object value = values.remove("ProfitCenter_Text");
                if( (value == null) || (!value.equals(getProfitCenter_Text())) ) {
                    setProfitCenter_Text(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("AdditionalMasterDataSource") ) {
                final Object value = values.remove("AdditionalMasterDataSource");
                if( (value == null) || (!value.equals(getAdditionalMasterDataSource())) ) {
                    setAdditionalMasterDataSource(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnPartnerPrftCtrHier") ) {
                final Object value = (values).remove("to_CnsldtnPartnerPrftCtrHier");
                if( value instanceof Iterable ) {
                    if( toCnsldtnPartnerPrftCtrHier == null ) {
                        toCnsldtnPartnerPrftCtrHier = Lists.newArrayList();
                    } else {
                        toCnsldtnPartnerPrftCtrHier = Lists.newArrayList(toCnsldtnPartnerPrftCtrHier);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PartnerProfitCenterHier entity;
                        if( toCnsldtnPartnerPrftCtrHier.size() > i ) {
                            entity = toCnsldtnPartnerPrftCtrHier.get(i);
                        } else {
                            entity = new PartnerProfitCenterHier();
                            toCnsldtnPartnerPrftCtrHier.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CnsldtnPartnerPrftCtrT") ) {
                final Object value = (values).remove("to_CnsldtnPartnerPrftCtrT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnPartnerPrftCtrT == null ) {
                        toCnsldtnPartnerPrftCtrT = Lists.newArrayList();
                    } else {
                        toCnsldtnPartnerPrftCtrT = Lists.newArrayList(toCnsldtnPartnerPrftCtrT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PartnerProfitCenterText entity;
                        if( toCnsldtnPartnerPrftCtrT.size() > i ) {
                            entity = toCnsldtnPartnerPrftCtrT.get(i);
                        } else {
                            entity = new PartnerProfitCenterText();
                            toCnsldtnPartnerPrftCtrT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PartnerProfitCenterField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PartnerProfitCenterField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PartnerProfitCenterField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PartnerProfitCenterField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnPartnerPrftCtrHier != null ) {
            (values).put("to_CnsldtnPartnerPrftCtrHier", toCnsldtnPartnerPrftCtrHier);
        }
        if( toCnsldtnPartnerPrftCtrT != null ) {
            (values).put("to_CnsldtnPartnerPrftCtrT", toCnsldtnPartnerPrftCtrT);
        }
        return values;
    }

    /**
     * Fetches the <b>PartnerProfitCenterHier</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CnsldtnPartnerPrftCtrHier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PartnerProfitCenterHier</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PartnerProfitCenterHier> fetchCnsldtnPartnerPrftCtrHier()
    {
        return fetchFieldAsList("to_CnsldtnPartnerPrftCtrHier", PartnerProfitCenterHier.class);
    }

    /**
     * Retrieval of associated <b>PartnerProfitCenterHier</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnPartnerPrftCtrHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPartnerPrftCtrHier</b> of a queried <b>PartnerProfitCenter</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PartnerProfitCenterHier</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PartnerProfitCenterHier> getCnsldtnPartnerPrftCtrHierOrFetch()
    {
        if( toCnsldtnPartnerPrftCtrHier == null ) {
            toCnsldtnPartnerPrftCtrHier = fetchCnsldtnPartnerPrftCtrHier();
        }
        return toCnsldtnPartnerPrftCtrHier;
    }

    /**
     * Retrieval of associated <b>PartnerProfitCenterHier</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnPartnerPrftCtrHier</b>.
     * <p>
     * If the navigation property for an entity <b>PartnerProfitCenter</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnPartnerPrftCtrHier</b> is already loaded, the
     *         result will contain the <b>PartnerProfitCenterHier</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PartnerProfitCenterHier>> getCnsldtnPartnerPrftCtrHierIfPresent()
    {
        return Option.of(toCnsldtnPartnerPrftCtrHier);
    }

    /**
     * Overwrites the list of associated <b>PartnerProfitCenterHier</b> entities for the loaded navigation property
     * <b>to_CnsldtnPartnerPrftCtrHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPartnerPrftCtrHier</b> of a queried <b>PartnerProfitCenter</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PartnerProfitCenterHier</b> entities.
     */
    public void setCnsldtnPartnerPrftCtrHier( @Nonnull final List<PartnerProfitCenterHier> value )
    {
        if( toCnsldtnPartnerPrftCtrHier == null ) {
            toCnsldtnPartnerPrftCtrHier = Lists.newArrayList();
        }
        toCnsldtnPartnerPrftCtrHier.clear();
        toCnsldtnPartnerPrftCtrHier.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PartnerProfitCenterHier</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnPartnerPrftCtrHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPartnerPrftCtrHier</b> of a queried <b>PartnerProfitCenter</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PartnerProfitCenterHier</b> entities.
     */
    public void addCnsldtnPartnerPrftCtrHier( PartnerProfitCenterHier... entity )
    {
        if( toCnsldtnPartnerPrftCtrHier == null ) {
            toCnsldtnPartnerPrftCtrHier = Lists.newArrayList();
        }
        toCnsldtnPartnerPrftCtrHier.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>PartnerProfitCenterText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CnsldtnPartnerPrftCtrT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PartnerProfitCenterText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PartnerProfitCenterText> fetchCnsldtnPartnerPrftCtrT()
    {
        return fetchFieldAsList("to_CnsldtnPartnerPrftCtrT", PartnerProfitCenterText.class);
    }

    /**
     * Retrieval of associated <b>PartnerProfitCenterText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnPartnerPrftCtrT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPartnerPrftCtrT</b> of a queried <b>PartnerProfitCenter</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PartnerProfitCenterText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PartnerProfitCenterText> getCnsldtnPartnerPrftCtrTOrFetch()
    {
        if( toCnsldtnPartnerPrftCtrT == null ) {
            toCnsldtnPartnerPrftCtrT = fetchCnsldtnPartnerPrftCtrT();
        }
        return toCnsldtnPartnerPrftCtrT;
    }

    /**
     * Retrieval of associated <b>PartnerProfitCenterText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnPartnerPrftCtrT</b>.
     * <p>
     * If the navigation property for an entity <b>PartnerProfitCenter</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnPartnerPrftCtrT</b> is already loaded, the result
     *         will contain the <b>PartnerProfitCenterText</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PartnerProfitCenterText>> getCnsldtnPartnerPrftCtrTIfPresent()
    {
        return Option.of(toCnsldtnPartnerPrftCtrT);
    }

    /**
     * Overwrites the list of associated <b>PartnerProfitCenterText</b> entities for the loaded navigation property
     * <b>to_CnsldtnPartnerPrftCtrT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPartnerPrftCtrT</b> of a queried <b>PartnerProfitCenter</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PartnerProfitCenterText</b> entities.
     */
    public void setCnsldtnPartnerPrftCtrT( @Nonnull final List<PartnerProfitCenterText> value )
    {
        if( toCnsldtnPartnerPrftCtrT == null ) {
            toCnsldtnPartnerPrftCtrT = Lists.newArrayList();
        }
        toCnsldtnPartnerPrftCtrT.clear();
        toCnsldtnPartnerPrftCtrT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PartnerProfitCenterText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnPartnerPrftCtrT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPartnerPrftCtrT</b> of a queried <b>PartnerProfitCenter</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PartnerProfitCenterText</b> entities.
     */
    public void addCnsldtnPartnerPrftCtrT( PartnerProfitCenterText... entity )
    {
        if( toCnsldtnPartnerPrftCtrT == null ) {
            toCnsldtnPartnerPrftCtrT = Lists.newArrayList();
        }
        toCnsldtnPartnerPrftCtrT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of PartnerProfitCenter instances.
     *
     */
    public final static class PartnerProfitCenterBuilder
    {

        private List<PartnerProfitCenterHier> toCnsldtnPartnerPrftCtrHier = Lists.newArrayList();
        private List<PartnerProfitCenterText> toCnsldtnPartnerPrftCtrT = Lists.newArrayList();

        private PartnerProfitCenter.PartnerProfitCenterBuilder toCnsldtnPartnerPrftCtrHier(
            final List<PartnerProfitCenterHier> value )
        {
            toCnsldtnPartnerPrftCtrHier.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnPartnerPrftCtrHier</b> for <b>PartnerProfitCenter</b> to multiple
         * <b>PartnerProfitCenterHier</b>.
         *
         * @param value
         *            The PartnerProfitCenterHiers to build this PartnerProfitCenter with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PartnerProfitCenter.PartnerProfitCenterBuilder cnsldtnPartnerPrftCtrHier(
            PartnerProfitCenterHier... value )
        {
            return toCnsldtnPartnerPrftCtrHier(Lists.newArrayList(value));
        }

        private PartnerProfitCenter.PartnerProfitCenterBuilder toCnsldtnPartnerPrftCtrT(
            final List<PartnerProfitCenterText> value )
        {
            toCnsldtnPartnerPrftCtrT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnPartnerPrftCtrT</b> for <b>PartnerProfitCenter</b> to multiple
         * <b>PartnerProfitCenterText</b>.
         *
         * @param value
         *            The PartnerProfitCenterTexts to build this PartnerProfitCenter with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PartnerProfitCenter.PartnerProfitCenterBuilder cnsldtnPartnerPrftCtrT( PartnerProfitCenterText... value )
        {
            return toCnsldtnPartnerPrftCtrT(Lists.newArrayList(value));
        }

    }

}
