/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.PartnerProfitCenterSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.PartnerProfitCenter
 * PartnerProfitCenter} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class PartnerProfitCenterByKeyFluentHelper
    extends
    FluentHelperByKey<PartnerProfitCenterByKeyFluentHelper, PartnerProfitCenter, PartnerProfitCenterSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.PartnerProfitCenter
     * PartnerProfitCenter} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code PartnerProfitCenter}
     * @param servicePath
     *            Service path to be used to fetch a single {@code PartnerProfitCenter}
     * @param profitCenter
     *            Consolidation Profit Center
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param controllingArea
     *            Consolidation Controlling Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     */
    public PartnerProfitCenterByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String profitCenter,
        final String controllingArea )
    {
        super(servicePath, entityCollection);
        this.key.put("ProfitCenter", profitCenter);
        this.key.put("ControllingArea", controllingArea);
    }

    @Override
    @Nonnull
    protected Class<PartnerProfitCenter> getEntityClass()
    {
        return PartnerProfitCenter.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
