/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.PartnerProfitCenterHierField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.PartnerProfitCenterHierLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.PartnerProfitCenterHierOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.PartnerProfitCenterHierSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Partner Profit Center Hierarchy
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PartnerProfitCenterHierType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PartnerProfitCenterHier extends VdmEntity<PartnerProfitCenterHier>
{

    /**
     * Selector for all available fields of PartnerProfitCenterHier.
     *
     */
    public final static PartnerProfitCenterHierSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Consolidation Controlling Area
     */
    @Key
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static PartnerProfitCenterHierField<String> CONTROLLING_AREA =
        new PartnerProfitCenterHierField<String>("ControllingArea");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataHierarchy</b>
     * </p>
     *
     * @return Profit Center Hierarchy
     */
    @Key
    @SerializedName( "AdditionalMasterDataHierarchy" )
    @JsonProperty( "AdditionalMasterDataHierarchy" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataHierarchy" )
    private String additionalMasterDataHierarchy;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataHierarchy</b> field to query operations.
     *
     */
    public final static PartnerProfitCenterHierField<String> ADDITIONAL_MASTER_DATA_HIERARCHY =
        new PartnerProfitCenterHierField<String>("AdditionalMasterDataHierarchy");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @return Consolidation Hierarchy Node
     */
    @Key
    @SerializedName( "HierarchyNode" )
    @JsonProperty( "HierarchyNode" )
    @Nullable
    @ODataField( odataName = "HierarchyNode" )
    private String hierarchyNode;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNode</b> field to query operations.
     *
     */
    public final static PartnerProfitCenterHierField<String> HIERARCHY_NODE =
        new PartnerProfitCenterHierField<String>("HierarchyNode");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode_Text</b>
     * </p>
     *
     * @return Consolidation Hierarchy Node Description
     */
    @SerializedName( "HierarchyNode_Text" )
    @JsonProperty( "HierarchyNode_Text" )
    @Nullable
    @ODataField( odataName = "HierarchyNode_Text" )
    private String hierarchyNode_Text;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNode_Text</b> field to query operations.
     *
     */
    public final static PartnerProfitCenterHierField<String> HIERARCHY_NODE_TEXT =
        new PartnerProfitCenterHierField<String>("HierarchyNode_Text");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Validity End Date
     */
    @Key
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static PartnerProfitCenterHierField<LocalDateTime> VALIDITY_END_DATE =
        new PartnerProfitCenterHierField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ParentNode</b>
     * </p>
     *
     * @return Consolidation Hierarchy Parent Node
     */
    @SerializedName( "ParentNode" )
    @JsonProperty( "ParentNode" )
    @Nullable
    @ODataField( odataName = "ParentNode" )
    private String parentNode;
    /**
     * Use with available fluent helpers to apply the <b>ParentNode</b> field to query operations.
     *
     */
    public final static PartnerProfitCenterHierField<String> PARENT_NODE =
        new PartnerProfitCenterHierField<String>("ParentNode");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyVersion</b>
     * </p>
     *
     * @return Consolidation Hierarchy Version
     */
    @SerializedName( "HierarchyVersion" )
    @JsonProperty( "HierarchyVersion" )
    @Nullable
    @ODataField( odataName = "HierarchyVersion" )
    private String hierarchyVersion;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyVersion</b> field to query operations.
     *
     */
    public final static PartnerProfitCenterHierField<String> HIERARCHY_VERSION =
        new PartnerProfitCenterHierField<String>("HierarchyVersion");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Validity Start Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static PartnerProfitCenterHierField<LocalDateTime> VALIDITY_START_DATE =
        new PartnerProfitCenterHierField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Consolidation Profit Center
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static PartnerProfitCenterHierField<String> PROFIT_CENTER =
        new PartnerProfitCenterHierField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter_Text</b>
     * </p>
     *
     * @return Partner Profit Center Description
     */
    @SerializedName( "ProfitCenter_Text" )
    @JsonProperty( "ProfitCenter_Text" )
    @Nullable
    @ODataField( odataName = "ProfitCenter_Text" )
    private String profitCenter_Text;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter_Text</b> field to query operations.
     *
     */
    public final static PartnerProfitCenterHierField<String> PROFIT_CENTER_TEXT =
        new PartnerProfitCenterHierField<String>("ProfitCenter_Text");
    /**
     * Constraints: Not nullable, Maximum length: 56
     * <p>
     * Original property name from the Odata EDM: <b>SequenceNumber</b>
     * </p>
     *
     * @return The sequenceNumber contained in this entity.
     */
    @SerializedName( "SequenceNumber" )
    @JsonProperty( "SequenceNumber" )
    @Nullable
    @ODataField( odataName = "SequenceNumber" )
    private String sequenceNumber;
    /**
     * Use with available fluent helpers to apply the <b>SequenceNumber</b> field to query operations.
     *
     */
    public final static PartnerProfitCenterHierField<String> SEQUENCE_NUMBER =
        new PartnerProfitCenterHierField<String>("SequenceNumber");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeSequence</b>
     * </p>
     *
     * @return Consolidation Hierarchy Sequence Number
     */
    @SerializedName( "HierarchyNodeSequence" )
    @JsonProperty( "HierarchyNodeSequence" )
    @Nullable
    @ODataField( odataName = "HierarchyNodeSequence" )
    private String hierarchyNodeSequence;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNodeSequence</b> field to query operations.
     *
     */
    public final static PartnerProfitCenterHierField<String> HIERARCHY_NODE_SEQUENCE =
        new PartnerProfitCenterHierField<String>("HierarchyNodeSequence");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeLevel</b>
     * </p>
     *
     * @return Consolidation Hierarchy Level
     */
    @SerializedName( "HierarchyNodeLevel" )
    @JsonProperty( "HierarchyNodeLevel" )
    @Nullable
    @ODataField( odataName = "HierarchyNodeLevel" )
    private String hierarchyNodeLevel;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNodeLevel</b> field to query operations.
     *
     */
    public final static PartnerProfitCenterHierField<String> HIERARCHY_NODE_LEVEL =
        new PartnerProfitCenterHierField<String>("HierarchyNodeLevel");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @return Consolidation Hierarchy Node Type
     */
    @SerializedName( "NodeType" )
    @JsonProperty( "NodeType" )
    @Nullable
    @ODataField( odataName = "NodeType" )
    private String nodeType;
    /**
     * Use with available fluent helpers to apply the <b>NodeType</b> field to query operations.
     *
     */
    public final static PartnerProfitCenterHierField<String> NODE_TYPE =
        new PartnerProfitCenterHierField<String>("NodeType");
    /**
     * Navigation property <b>to_CnsldtnPartnerPrftCtrHierT</b> for <b>PartnerProfitCenterHier</b> to multiple
     * <b>PartnerProfitCenterHierText</b>.
     *
     */
    @SerializedName( "to_CnsldtnPartnerPrftCtrHierT" )
    @JsonProperty( "to_CnsldtnPartnerPrftCtrHierT" )
    @ODataField( odataName = "to_CnsldtnPartnerPrftCtrHierT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PartnerProfitCenterHierText> toCnsldtnPartnerPrftCtrHierT;
    /**
     * Navigation property <b>to_CnsldtnPartnerProfitCenter</b> for <b>PartnerProfitCenterHier</b> to single
     * <b>PartnerProfitCenter</b>.
     *
     */
    @SerializedName( "to_CnsldtnPartnerProfitCenter" )
    @JsonProperty( "to_CnsldtnPartnerProfitCenter" )
    @ODataField( odataName = "to_CnsldtnPartnerProfitCenter" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PartnerProfitCenter toCnsldtnPartnerProfitCenter;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnPartnerPrftCtrHierT</b> navigation property to query
     * operations.
     *
     */
    public final static PartnerProfitCenterHierLink<PartnerProfitCenterHierText> TO_CNSLDTN_PARTNER_PRFT_CTR_HIER_T =
        new PartnerProfitCenterHierLink<PartnerProfitCenterHierText>("to_CnsldtnPartnerPrftCtrHierT");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnPartnerProfitCenter</b> navigation property to query
     * operations.
     *
     */
    public final static PartnerProfitCenterHierOneToOneLink<PartnerProfitCenter> TO_CNSLDTN_PARTNER_PROFIT_CENTER =
        new PartnerProfitCenterHierOneToOneLink<PartnerProfitCenter>("to_CnsldtnPartnerProfitCenter");

    @Nonnull
    @Override
    public Class<PartnerProfitCenterHier> getType()
    {
        return PartnerProfitCenterHier.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Consolidation Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataHierarchy</b>
     * </p>
     *
     * @param additionalMasterDataHierarchy
     *            Profit Center Hierarchy
     */
    public void setAdditionalMasterDataHierarchy( @Nullable final String additionalMasterDataHierarchy )
    {
        rememberChangedField("AdditionalMasterDataHierarchy", this.additionalMasterDataHierarchy);
        this.additionalMasterDataHierarchy = additionalMasterDataHierarchy;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @param hierarchyNode
     *            Consolidation Hierarchy Node
     */
    public void setHierarchyNode( @Nullable final String hierarchyNode )
    {
        rememberChangedField("HierarchyNode", this.hierarchyNode);
        this.hierarchyNode = hierarchyNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode_Text</b>
     * </p>
     *
     * @param hierarchyNode_Text
     *            Consolidation Hierarchy Node Description
     */
    public void setHierarchyNode_Text( @Nullable final String hierarchyNode_Text )
    {
        rememberChangedField("HierarchyNode_Text", this.hierarchyNode_Text);
        this.hierarchyNode_Text = hierarchyNode_Text;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Validity End Date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ParentNode</b>
     * </p>
     *
     * @param parentNode
     *            Consolidation Hierarchy Parent Node
     */
    public void setParentNode( @Nullable final String parentNode )
    {
        rememberChangedField("ParentNode", this.parentNode);
        this.parentNode = parentNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyVersion</b>
     * </p>
     *
     * @param hierarchyVersion
     *            Consolidation Hierarchy Version
     */
    public void setHierarchyVersion( @Nullable final String hierarchyVersion )
    {
        rememberChangedField("HierarchyVersion", this.hierarchyVersion);
        this.hierarchyVersion = hierarchyVersion;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Validity Start Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Consolidation Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter_Text</b>
     * </p>
     *
     * @param profitCenter_Text
     *            Partner Profit Center Description
     */
    public void setProfitCenter_Text( @Nullable final String profitCenter_Text )
    {
        rememberChangedField("ProfitCenter_Text", this.profitCenter_Text);
        this.profitCenter_Text = profitCenter_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 56
     * <p>
     * Original property name from the Odata EDM: <b>SequenceNumber</b>
     * </p>
     *
     * @param sequenceNumber
     *            The sequenceNumber to set.
     */
    public void setSequenceNumber( @Nullable final String sequenceNumber )
    {
        rememberChangedField("SequenceNumber", this.sequenceNumber);
        this.sequenceNumber = sequenceNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeSequence</b>
     * </p>
     *
     * @param hierarchyNodeSequence
     *            Consolidation Hierarchy Sequence Number
     */
    public void setHierarchyNodeSequence( @Nullable final String hierarchyNodeSequence )
    {
        rememberChangedField("HierarchyNodeSequence", this.hierarchyNodeSequence);
        this.hierarchyNodeSequence = hierarchyNodeSequence;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeLevel</b>
     * </p>
     *
     * @param hierarchyNodeLevel
     *            Consolidation Hierarchy Level
     */
    public void setHierarchyNodeLevel( @Nullable final String hierarchyNodeLevel )
    {
        rememberChangedField("HierarchyNodeLevel", this.hierarchyNodeLevel);
        this.hierarchyNodeLevel = hierarchyNodeLevel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @param nodeType
     *            Consolidation Hierarchy Node Type
     */
    public void setNodeType( @Nullable final String nodeType )
    {
        rememberChangedField("NodeType", this.nodeType);
        this.nodeType = nodeType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PartnerProfitCenterHier";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ControllingArea", getControllingArea());
        result.put("AdditionalMasterDataHierarchy", getAdditionalMasterDataHierarchy());
        result.put("HierarchyNode", getHierarchyNode());
        result.put("ValidityEndDate", getValidityEndDate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ControllingArea", getControllingArea());
        values.put("AdditionalMasterDataHierarchy", getAdditionalMasterDataHierarchy());
        values.put("HierarchyNode", getHierarchyNode());
        values.put("HierarchyNode_Text", getHierarchyNode_Text());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ParentNode", getParentNode());
        values.put("HierarchyVersion", getHierarchyVersion());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ProfitCenter", getProfitCenter());
        values.put("ProfitCenter_Text", getProfitCenter_Text());
        values.put("SequenceNumber", getSequenceNumber());
        values.put("HierarchyNodeSequence", getHierarchyNodeSequence());
        values.put("HierarchyNodeLevel", getHierarchyNodeLevel());
        values.put("NodeType", getNodeType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("AdditionalMasterDataHierarchy") ) {
                final Object value = values.remove("AdditionalMasterDataHierarchy");
                if( (value == null) || (!value.equals(getAdditionalMasterDataHierarchy())) ) {
                    setAdditionalMasterDataHierarchy(((String) value));
                }
            }
            if( values.containsKey("HierarchyNode") ) {
                final Object value = values.remove("HierarchyNode");
                if( (value == null) || (!value.equals(getHierarchyNode())) ) {
                    setHierarchyNode(((String) value));
                }
            }
            if( values.containsKey("HierarchyNode_Text") ) {
                final Object value = values.remove("HierarchyNode_Text");
                if( (value == null) || (!value.equals(getHierarchyNode_Text())) ) {
                    setHierarchyNode_Text(((String) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ParentNode") ) {
                final Object value = values.remove("ParentNode");
                if( (value == null) || (!value.equals(getParentNode())) ) {
                    setParentNode(((String) value));
                }
            }
            if( values.containsKey("HierarchyVersion") ) {
                final Object value = values.remove("HierarchyVersion");
                if( (value == null) || (!value.equals(getHierarchyVersion())) ) {
                    setHierarchyVersion(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter_Text") ) {
                final Object value = values.remove("ProfitCenter_Text");
                if( (value == null) || (!value.equals(getProfitCenter_Text())) ) {
                    setProfitCenter_Text(((String) value));
                }
            }
            if( values.containsKey("SequenceNumber") ) {
                final Object value = values.remove("SequenceNumber");
                if( (value == null) || (!value.equals(getSequenceNumber())) ) {
                    setSequenceNumber(((String) value));
                }
            }
            if( values.containsKey("HierarchyNodeSequence") ) {
                final Object value = values.remove("HierarchyNodeSequence");
                if( (value == null) || (!value.equals(getHierarchyNodeSequence())) ) {
                    setHierarchyNodeSequence(((String) value));
                }
            }
            if( values.containsKey("HierarchyNodeLevel") ) {
                final Object value = values.remove("HierarchyNodeLevel");
                if( (value == null) || (!value.equals(getHierarchyNodeLevel())) ) {
                    setHierarchyNodeLevel(((String) value));
                }
            }
            if( values.containsKey("NodeType") ) {
                final Object value = values.remove("NodeType");
                if( (value == null) || (!value.equals(getNodeType())) ) {
                    setNodeType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnPartnerPrftCtrHierT") ) {
                final Object value = (values).remove("to_CnsldtnPartnerPrftCtrHierT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnPartnerPrftCtrHierT == null ) {
                        toCnsldtnPartnerPrftCtrHierT = Lists.newArrayList();
                    } else {
                        toCnsldtnPartnerPrftCtrHierT = Lists.newArrayList(toCnsldtnPartnerPrftCtrHierT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PartnerProfitCenterHierText entity;
                        if( toCnsldtnPartnerPrftCtrHierT.size() > i ) {
                            entity = toCnsldtnPartnerPrftCtrHierT.get(i);
                        } else {
                            entity = new PartnerProfitCenterHierText();
                            toCnsldtnPartnerPrftCtrHierT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CnsldtnPartnerProfitCenter") ) {
                final Object value = (values).remove("to_CnsldtnPartnerProfitCenter");
                if( value instanceof Map ) {
                    if( toCnsldtnPartnerProfitCenter == null ) {
                        toCnsldtnPartnerProfitCenter = new PartnerProfitCenter();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnPartnerProfitCenter.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PartnerProfitCenterHierField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PartnerProfitCenterHierField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PartnerProfitCenterHierField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PartnerProfitCenterHierField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnPartnerPrftCtrHierT != null ) {
            (values).put("to_CnsldtnPartnerPrftCtrHierT", toCnsldtnPartnerPrftCtrHierT);
        }
        if( toCnsldtnPartnerProfitCenter != null ) {
            (values).put("to_CnsldtnPartnerProfitCenter", toCnsldtnPartnerProfitCenter);
        }
        return values;
    }

    /**
     * Fetches the <b>PartnerProfitCenterHierText</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_CnsldtnPartnerPrftCtrHierT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PartnerProfitCenterHierText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PartnerProfitCenterHierText> fetchCnsldtnPartnerPrftCtrHierT()
    {
        return fetchFieldAsList("to_CnsldtnPartnerPrftCtrHierT", PartnerProfitCenterHierText.class);
    }

    /**
     * Retrieval of associated <b>PartnerProfitCenterHierText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnPartnerPrftCtrHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPartnerPrftCtrHierT</b> of a queried <b>PartnerProfitCenterHier</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PartnerProfitCenterHierText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PartnerProfitCenterHierText> getCnsldtnPartnerPrftCtrHierTOrFetch()
    {
        if( toCnsldtnPartnerPrftCtrHierT == null ) {
            toCnsldtnPartnerPrftCtrHierT = fetchCnsldtnPartnerPrftCtrHierT();
        }
        return toCnsldtnPartnerPrftCtrHierT;
    }

    /**
     * Retrieval of associated <b>PartnerProfitCenterHierText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnPartnerPrftCtrHierT</b>.
     * <p>
     * If the navigation property for an entity <b>PartnerProfitCenterHier</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnPartnerPrftCtrHierT</b> is already loaded, the
     *         result will contain the <b>PartnerProfitCenterHierText</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PartnerProfitCenterHierText>> getCnsldtnPartnerPrftCtrHierTIfPresent()
    {
        return Option.of(toCnsldtnPartnerPrftCtrHierT);
    }

    /**
     * Overwrites the list of associated <b>PartnerProfitCenterHierText</b> entities for the loaded navigation property
     * <b>to_CnsldtnPartnerPrftCtrHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPartnerPrftCtrHierT</b> of a queried <b>PartnerProfitCenterHier</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PartnerProfitCenterHierText</b> entities.
     */
    public void setCnsldtnPartnerPrftCtrHierT( @Nonnull final List<PartnerProfitCenterHierText> value )
    {
        if( toCnsldtnPartnerPrftCtrHierT == null ) {
            toCnsldtnPartnerPrftCtrHierT = Lists.newArrayList();
        }
        toCnsldtnPartnerPrftCtrHierT.clear();
        toCnsldtnPartnerPrftCtrHierT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PartnerProfitCenterHierText</b> entities. This corresponds to the
     * OData navigation property <b>to_CnsldtnPartnerPrftCtrHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPartnerPrftCtrHierT</b> of a queried <b>PartnerProfitCenterHier</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PartnerProfitCenterHierText</b> entities.
     */
    public void addCnsldtnPartnerPrftCtrHierT( PartnerProfitCenterHierText... entity )
    {
        if( toCnsldtnPartnerPrftCtrHierT == null ) {
            toCnsldtnPartnerPrftCtrHierT = Lists.newArrayList();
        }
        toCnsldtnPartnerPrftCtrHierT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>PartnerProfitCenter</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnPartnerProfitCenter</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PartnerProfitCenter</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PartnerProfitCenter fetchCnsldtnPartnerProfitCenter()
    {
        return fetchFieldAsSingle("to_CnsldtnPartnerProfitCenter", PartnerProfitCenter.class);
    }

    /**
     * Retrieval of associated <b>PartnerProfitCenter</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnPartnerProfitCenter</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPartnerProfitCenter</b> of a queried <b>PartnerProfitCenterHier</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PartnerProfitCenter</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PartnerProfitCenter getCnsldtnPartnerProfitCenterOrFetch()
    {
        if( toCnsldtnPartnerProfitCenter == null ) {
            toCnsldtnPartnerProfitCenter = fetchCnsldtnPartnerProfitCenter();
        }
        return toCnsldtnPartnerProfitCenter;
    }

    /**
     * Retrieval of associated <b>PartnerProfitCenter</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnPartnerProfitCenter</b>.
     * <p>
     * If the navigation property for an entity <b>PartnerProfitCenterHier</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnPartnerProfitCenter</b> is already loaded, the
     *         result will contain the <b>PartnerProfitCenter</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PartnerProfitCenter> getCnsldtnPartnerProfitCenterIfPresent()
    {
        return Option.of(toCnsldtnPartnerProfitCenter);
    }

    /**
     * Overwrites the associated <b>PartnerProfitCenter</b> entity for the loaded navigation property
     * <b>to_CnsldtnPartnerProfitCenter</b>.
     *
     * @param value
     *            New <b>PartnerProfitCenter</b> entity.
     */
    public void setCnsldtnPartnerProfitCenter( final PartnerProfitCenter value )
    {
        toCnsldtnPartnerProfitCenter = value;
    }

    /**
     * Helper class to allow for fluent creation of PartnerProfitCenterHier instances.
     *
     */
    public final static class PartnerProfitCenterHierBuilder
    {

        private List<PartnerProfitCenterHierText> toCnsldtnPartnerPrftCtrHierT = Lists.newArrayList();
        private PartnerProfitCenter toCnsldtnPartnerProfitCenter;

        private PartnerProfitCenterHier.PartnerProfitCenterHierBuilder toCnsldtnPartnerPrftCtrHierT(
            final List<PartnerProfitCenterHierText> value )
        {
            toCnsldtnPartnerPrftCtrHierT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnPartnerPrftCtrHierT</b> for <b>PartnerProfitCenterHier</b> to multiple
         * <b>PartnerProfitCenterHierText</b>.
         *
         * @param value
         *            The PartnerProfitCenterHierTexts to build this PartnerProfitCenterHier with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PartnerProfitCenterHier.PartnerProfitCenterHierBuilder cnsldtnPartnerPrftCtrHierT(
            PartnerProfitCenterHierText... value )
        {
            return toCnsldtnPartnerPrftCtrHierT(Lists.newArrayList(value));
        }

        private PartnerProfitCenterHier.PartnerProfitCenterHierBuilder toCnsldtnPartnerProfitCenter(
            final PartnerProfitCenter value )
        {
            toCnsldtnPartnerProfitCenter = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnPartnerProfitCenter</b> for <b>PartnerProfitCenterHier</b> to single
         * <b>PartnerProfitCenter</b>.
         *
         * @param value
         *            The PartnerProfitCenter to build this PartnerProfitCenterHier with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PartnerProfitCenterHier.PartnerProfitCenterHierBuilder cnsldtnPartnerProfitCenter(
            final PartnerProfitCenter value )
        {
            return toCnsldtnPartnerProfitCenter(value);
        }

    }

}
