/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.PartnerProfitCenterTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.PartnerProfitCenterTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.PartnerProfitCenterTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Partner Profit Center - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PartnerProfitCenterTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PartnerProfitCenterText extends VdmEntity<PartnerProfitCenterText>
{

    /**
     * Selector for all available fields of PartnerProfitCenterText.
     *
     */
    public final static PartnerProfitCenterTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static PartnerProfitCenterTextField<String> LANGUAGE =
        new PartnerProfitCenterTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Partner Profit Center
     */
    @Key
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static PartnerProfitCenterTextField<String> PROFIT_CENTER =
        new PartnerProfitCenterTextField<String>("ProfitCenter");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Consolidation Controlling Area
     */
    @Key
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static PartnerProfitCenterTextField<String> CONTROLLING_AREA =
        new PartnerProfitCenterTextField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProfitCenterText</b>
     * </p>
     *
     * @return Partner Profit Center Description
     */
    @SerializedName( "PartnerProfitCenterText" )
    @JsonProperty( "PartnerProfitCenterText" )
    @Nullable
    @ODataField( odataName = "PartnerProfitCenterText" )
    private String partnerProfitCenterText;
    /**
     * Use with available fluent helpers to apply the <b>PartnerProfitCenterText</b> field to query operations.
     *
     */
    public final static PartnerProfitCenterTextField<String> PARTNER_PROFIT_CENTER_TEXT =
        new PartnerProfitCenterTextField<String>("PartnerProfitCenterText");
    /**
     * Navigation property <b>to_CnsldtnPartnerProfitCenter</b> for <b>PartnerProfitCenterText</b> to single
     * <b>PartnerProfitCenter</b>.
     *
     */
    @SerializedName( "to_CnsldtnPartnerProfitCenter" )
    @JsonProperty( "to_CnsldtnPartnerProfitCenter" )
    @ODataField( odataName = "to_CnsldtnPartnerProfitCenter" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PartnerProfitCenter toCnsldtnPartnerProfitCenter;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnPartnerProfitCenter</b> navigation property to query
     * operations.
     *
     */
    public final static PartnerProfitCenterTextOneToOneLink<PartnerProfitCenter> TO_CNSLDTN_PARTNER_PROFIT_CENTER =
        new PartnerProfitCenterTextOneToOneLink<PartnerProfitCenter>("to_CnsldtnPartnerProfitCenter");

    @Nonnull
    @Override
    public Class<PartnerProfitCenterText> getType()
    {
        return PartnerProfitCenterText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Partner Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Consolidation Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProfitCenterText</b>
     * </p>
     *
     * @param partnerProfitCenterText
     *            Partner Profit Center Description
     */
    public void setPartnerProfitCenterText( @Nullable final String partnerProfitCenterText )
    {
        rememberChangedField("PartnerProfitCenterText", this.partnerProfitCenterText);
        this.partnerProfitCenterText = partnerProfitCenterText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PartnerProfitCenterText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("ProfitCenter", getProfitCenter());
        result.put("ControllingArea", getControllingArea());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("ProfitCenter", getProfitCenter());
        values.put("ControllingArea", getControllingArea());
        values.put("PartnerProfitCenterText", getPartnerProfitCenterText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("PartnerProfitCenterText") ) {
                final Object value = values.remove("PartnerProfitCenterText");
                if( (value == null) || (!value.equals(getPartnerProfitCenterText())) ) {
                    setPartnerProfitCenterText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnPartnerProfitCenter") ) {
                final Object value = (values).remove("to_CnsldtnPartnerProfitCenter");
                if( value instanceof Map ) {
                    if( toCnsldtnPartnerProfitCenter == null ) {
                        toCnsldtnPartnerProfitCenter = new PartnerProfitCenter();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnPartnerProfitCenter.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PartnerProfitCenterTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PartnerProfitCenterTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PartnerProfitCenterTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PartnerProfitCenterTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnPartnerProfitCenter != null ) {
            (values).put("to_CnsldtnPartnerProfitCenter", toCnsldtnPartnerProfitCenter);
        }
        return values;
    }

    /**
     * Fetches the <b>PartnerProfitCenter</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnPartnerProfitCenter</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PartnerProfitCenter</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PartnerProfitCenter fetchCnsldtnPartnerProfitCenter()
    {
        return fetchFieldAsSingle("to_CnsldtnPartnerProfitCenter", PartnerProfitCenter.class);
    }

    /**
     * Retrieval of associated <b>PartnerProfitCenter</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnPartnerProfitCenter</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPartnerProfitCenter</b> of a queried <b>PartnerProfitCenterText</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PartnerProfitCenter</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PartnerProfitCenter getCnsldtnPartnerProfitCenterOrFetch()
    {
        if( toCnsldtnPartnerProfitCenter == null ) {
            toCnsldtnPartnerProfitCenter = fetchCnsldtnPartnerProfitCenter();
        }
        return toCnsldtnPartnerProfitCenter;
    }

    /**
     * Retrieval of associated <b>PartnerProfitCenter</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnPartnerProfitCenter</b>.
     * <p>
     * If the navigation property for an entity <b>PartnerProfitCenterText</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnPartnerProfitCenter</b> is already loaded, the
     *         result will contain the <b>PartnerProfitCenter</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PartnerProfitCenter> getCnsldtnPartnerProfitCenterIfPresent()
    {
        return Option.of(toCnsldtnPartnerProfitCenter);
    }

    /**
     * Overwrites the associated <b>PartnerProfitCenter</b> entity for the loaded navigation property
     * <b>to_CnsldtnPartnerProfitCenter</b>.
     *
     * @param value
     *            New <b>PartnerProfitCenter</b> entity.
     */
    public void setCnsldtnPartnerProfitCenter( final PartnerProfitCenter value )
    {
        toCnsldtnPartnerProfitCenter = value;
    }

    /**
     * Helper class to allow for fluent creation of PartnerProfitCenterText instances.
     *
     */
    public final static class PartnerProfitCenterTextBuilder
    {

        private PartnerProfitCenter toCnsldtnPartnerProfitCenter;

        private PartnerProfitCenterText.PartnerProfitCenterTextBuilder toCnsldtnPartnerProfitCenter(
            final PartnerProfitCenter value )
        {
            toCnsldtnPartnerProfitCenter = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnPartnerProfitCenter</b> for <b>PartnerProfitCenterText</b> to single
         * <b>PartnerProfitCenter</b>.
         *
         * @param value
         *            The PartnerProfitCenter to build this PartnerProfitCenterText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PartnerProfitCenterText.PartnerProfitCenterTextBuilder cnsldtnPartnerProfitCenter(
            final PartnerProfitCenter value )
        {
            return toCnsldtnPartnerProfitCenter(value);
        }

    }

}
